/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.model;

import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javafx.collections.ObservableList;

public class TabSummary {
    private static TabSummary tabSummary;
    private HashSet<SectionDef> sectionViolations = new HashSet();

    public static void append(DPXFileInformationViewModel fivm, HashSet<ValidationRuleSetEnum> ruleSets) {
        for (DPXColumn column : DPXColumn.values()) {
            HashMap<ValidationRuleSetEnum, List<IValidationRule>> ruleViolations;
            if (tabSummary.hasSectionViolation(column.getSection()) || (ruleViolations = fivm.getRuleViolations(column)) == null || ruleViolations.isEmpty()) continue;
            for (ValidationRuleSetEnum rule : ruleSets) {
                if (!ruleViolations.containsKey((Object)rule)) continue;
                tabSummary.addSectionViolation(column.getSection());
            }
        }
    }

    public static TabSummary create(ObservableList<DPXFileInformationViewModel> files, HashSet<ValidationRuleSetEnum> ruleSets) {
        TabSummary ts = new TabSummary();
        if (files == null || files.size() == 0) {
            return ts;
        }
        for (DPXFileInformationViewModel fivm : files) {
            for (DPXColumn column : DPXColumn.values()) {
                HashMap<ValidationRuleSetEnum, List<IValidationRule>> ruleViolations;
                if (ts.hasSectionViolation(column.getSection()) || (ruleViolations = fivm.getRuleViolations(column)) == null || ruleViolations.isEmpty()) continue;
                for (ValidationRuleSetEnum rule : ruleSets) {
                    if (!ruleViolations.containsKey((Object)rule)) continue;
                    ts.addSectionViolation(column.getSection());
                }
            }
        }
        return ts;
    }

    public static TabSummary getTabSummary() {
        return tabSummary;
    }

    public static void start() {
        tabSummary = new TabSummary();
    }

    private void addSectionViolation(SectionDef section) {
        this.sectionViolations.add(section);
    }

    public boolean hasSectionViolation(SectionDef section) {
        return this.sectionViolations.contains(section);
    }
}

