/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.ValidationWarningHelper;
import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.validation.DPXColumnValidationRules;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import org.controlsfx.control.textfield.CustomTextField;

public class ValidationChangeListener
implements ChangeListener<String> {
    private CustomTextField textField;
    private TextArea textArea;
    private HBox validationInfo;
    ColumnDef column;

    public ValidationChangeListener(CustomTextField textField, ColumnDef column, HBox validationInfo) {
        this.textField = textField;
        this.column = column;
        this.validationInfo = validationInfo;
    }

    public ValidationChangeListener(TextArea textArea, ColumnDef column, HBox validationInfo) {
        this.column = column;
        this.textArea = textArea;
        this.validationInfo = validationInfo;
    }

    public void changed(ObservableValue<? extends String> ov, String oldValue, String newValue) {
        if (newValue == null) {
            return;
        }
        HashMap<ValidationRuleSetEnum, List<IValidationRule>> validationRules = DPXColumnValidationRules.getInstance().getRules(this.column);
        HashSet<ValidationRuleSetEnum> activeRuleSets = ControllerMediatorDPX.getInstance().getCurrentRuleSets();
        if (validationRules.size() > 0) {
            HashSet<ValidationRuleSetEnum> violatedRules = new HashSet<ValidationRuleSetEnum>();
            block0: for (ValidationRuleSetEnum ruleSet : validationRules.keySet()) {
                if (!activeRuleSets.contains((Object)ruleSet)) continue;
                for (IValidationRule rule : validationRules.get((Object)ruleSet)) {
                    if (rule.isValid(newValue)) continue;
                    violatedRules.add(ruleSet);
                    continue block0;
                }
            }
            if (this.textArea != null) {
                this.setInvalidRuleSets(violatedRules, this.textArea);
            }
            if (this.textField != null) {
                this.setInvalidRuleSets(violatedRules, this.textField);
            }
        }
    }

    public void setInvalidRuleSets(Set<ValidationRuleSetEnum> invalidRuleSet, CustomTextField textField) {
        boolean hasErrors = ValidationWarningHelper.getInvalidRuleSetsAndUpdateErrorIcons(this.validationInfo, invalidRuleSet, this.column);
        String validationWarning = hasErrors ? "; Contains errors" : "";
        textField.setAccessibleText(textField.getText() + validationWarning);
    }

    public void setInvalidRuleSets(Set<ValidationRuleSetEnum> invalidRuleSet, TextArea textArea) {
        boolean hasErrors = ValidationWarningHelper.getInvalidRuleSetsAndUpdateErrorIcons(this.validationInfo, invalidRuleSet, this.column);
        String validationWarning = hasErrors ? "; Contains errors" : "";
        textArea.setAccessibleText(textArea.getText() + validationWarning);
    }
}

