/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import com.portalmedia.embarc.gui.Main;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.Border;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class AboutModalController {
    @FXML
    private Button closeAboutButton;
    @FXML
    private Button aboutButton;
    @FXML
    private Button licenseButton;
    @FXML
    private Pane aboutPane;
    @FXML
    private Pane licensePane;
    @FXML
    private Hyperlink fadgiLink;
    @FXML
    private Label versionLabel;

    public static AboutModalController getInstance() {
        return ControllerHolder.INSTANCE;
    }

    private AboutModalController() {
    }

    public void showAboutModal(Stage stage) {
        final Stage aboutStage = new Stage();
        aboutStage.initOwner((Window)stage);
        aboutStage.setHeight(450.0);
        aboutStage.setWidth(670.0);
        aboutStage.initStyle(StageStyle.UTILITY);
        aboutStage.setResizable(false);
        aboutStage.setTitle("About embARC");
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("AboutModal.fxml"));
        fxmlLoader.setController((Object)this);
        try {
            Scene scene = new Scene((Parent)fxmlLoader.load());
            aboutStage.setScene(scene);
            aboutStage.show();
            this.versionLabel.setText(Main.embARCVersion);
            this.fadgiLink.setBorder(Border.EMPTY);
            this.fadgiLink.setPadding(new Insets(4.0, 0.0, 4.0, 0.0));
            this.fadgiLink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    try {
                        URI uri = new URI(AboutModalController.this.fadgiLink.getText());
                        AboutModalController.this.openUrl(uri);
                    }
                    catch (URISyntaxException e) {
                        System.out.println("URI Syntax Error");
                    }
                }
            });
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.closeAboutButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                aboutStage.close();
            }
        });
        this.aboutButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                AboutModalController.this.aboutPane.setVisible(true);
                AboutModalController.this.aboutPane.setPrefHeight(350.0);
                AboutModalController.this.licensePane.setVisible(false);
                AboutModalController.this.licensePane.setPrefHeight(0.0);
            }
        });
        this.licenseButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                AboutModalController.this.aboutPane.setVisible(false);
                AboutModalController.this.aboutPane.setPrefHeight(0.0);
                AboutModalController.this.licensePane.setVisible(true);
                AboutModalController.this.licensePane.setPrefHeight(350.0);
            }
        });
    }

    private void openUrl(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            System.out.println("URI IO Error");
        }
    }

    private static class ControllerHolder {
        private static final AboutModalController INSTANCE = new AboutModalController();

        private ControllerHolder() {
        }
    }
}

