/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleBase;
import org.dizitart.no2.Document;
import org.dizitart.no2.mapper.Mappable;
import org.dizitart.no2.mapper.NitriteMapper;

public class IsValidByteListRule
extends ValidationRuleBase
implements IValidationRule,
Mappable {
    private static final long serialVersionUID = 1L;
    String rule = "Generic ByteList Rule";
    int[] validValuesList;

    public IsValidByteListRule(byte[] validValues) {
        this.validValuesList = new int[validValues.length];
        for (int i = 0; i < validValues.length; ++i) {
            this.validValuesList[i] = validValues[i] & 0xFF;
        }
    }

    public int[] getValidValuesList() {
        return this.validValuesList;
    }

    @Override
    public boolean isValid(String value) {
        try {
            byte v = Byte.parseByte(value);
            int[] nArray = this.validValuesList;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int vValue = v & 0xFF;
                int i2 = nArray[i];
                if (vValue != i2) continue;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void read(NitriteMapper mapper, Document document) {
        if (document != null) {
            this.setRule((String)document.get("rule"));
            this.setValidValuesList((int[])document.get("validValuesList"));
        }
    }

    public void setValidValuesList(int[] validValuesList) {
        this.validValuesList = validValuesList;
    }

    @Override
    public Document write(NitriteMapper mapper) {
        Document document = new Document();
        document.put("rule", (Object)this.getRule());
        document.put("validValuesList", (Object)this.getValidValuesList());
        return document;
    }
}

