/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.ICustomValidationRule;
import com.portalmedia.embarc.validation.Operator;

public class Equals
implements ICustomValidationRule {
    private String expectedValue = null;
    private DPXColumn column = null;
    private Operator operator = Operator.EQUALS;

    public Equals(DPXColumn column, String expectedValue) {
        this.expectedValue = expectedValue;
        this.column = column;
    }

    @Override
    public boolean isValid(String actualValue) {
        if (this.column.getType() == Integer.TYPE) {
            Integer i = new Integer(actualValue);
            Integer expectedInt = new Integer(this.expectedValue);
            return expectedInt.equals(i);
        }
        return actualValue.equals(this.expectedValue);
    }

    @Override
    public DPXColumn getColumn() {
        return this.column;
    }

    @Override
    public Operator getOperator() {
        return this.operator;
    }

    @Override
    public String getExpectedValue() {
        return this.expectedValue;
    }
}

