/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.IFileValidationRule;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.IsRequired;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;

public class DPXImageOffsetToImageDataRule
implements IFileValidationRule {
    DPXColumn targetColumn;
    boolean isValid;
    int imageElement = 1;
    private final String imgEl = "Must be present for each image element; must be valid u32bit integer";
    private final String smc = "SMPTE-C \n\n";

    public DPXImageOffsetToImageDataRule(DPXColumn column, int imageElement) {
        this.targetColumn = column;
        this.imageElement = imageElement;
    }

    @Override
    public String getRule() {
        return "SMPTE-C \n\nMust be present for each image element; must be valid u32bit integer";
    }

    @Override
    public ValidationRuleSetEnum getRuleSet() {
        return ValidationRuleSetEnum.SMPTE_C;
    }

    @Override
    public DPXColumn getTargetColumn() {
        return this.targetColumn;
    }

    @Override
    public IValidationRule getValidationRule() {
        return new IsRequired();
    }

    @Override
    public boolean isValid(DPXFileInformationViewModel file) {
        String imageElements = file.getProp(DPXColumn.NUMBER_OF_IMAGE_ELEMENTS);
        if (imageElements.isEmpty()) {
            return true;
        }
        try {
            if (Integer.parseInt(imageElements) < this.imageElement) {
                return true;
            }
        }
        catch (NumberFormatException ex) {
            return true;
        }
        String value = file.getProp(this.targetColumn);
        IValidationRule rule = this.getValidationRule();
        return rule.isValid(value);
    }
}

