/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.GenericValidationRule;
import com.portalmedia.embarc.validation.IFileValidationRule;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;

public class DPXFileNameMatchesRule
implements IFileValidationRule {
    DPXColumn targetColumn = DPXColumn.IMAGE_FILE_NAME;
    boolean isValid;

    @Override
    public String getRule() {
        return "Must match the filename of the file as stored in the file system.";
    }

    @Override
    public ValidationRuleSetEnum getRuleSet() {
        return ValidationRuleSetEnum.FADGI_SR;
    }

    @Override
    public DPXColumn getTargetColumn() {
        return this.targetColumn;
    }

    @Override
    public IValidationRule getValidationRule() {
        return new GenericValidationRule(this.getRule(), this.isValid);
    }

    @Override
    public boolean isValid(DPXFileInformationViewModel file) {
        String imageFileName = file.getProp(DPXColumn.IMAGE_FILE_NAME).trim();
        String fileName = file.getProp("name");
        this.isValid = imageFileName.equals(fileName.trim());
        return this.isValid;
    }
}

