/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.IsRequired;
import com.portalmedia.embarc.validation.IsValidAsciiValidationRule;
import com.portalmedia.embarc.validation.IsValidByteRule;
import com.portalmedia.embarc.validation.IsValidFloatRule;
import com.portalmedia.embarc.validation.IsValidIntRangeRule;
import com.portalmedia.embarc.validation.IsValidIntRule;
import com.portalmedia.embarc.validation.IsValidMatchesTextRule;
import com.portalmedia.embarc.validation.IsValidProjectNameRule;
import com.portalmedia.embarc.validation.IsValidRegexRule;
import com.portalmedia.embarc.validation.IsValidShortRangeRule;
import com.portalmedia.embarc.validation.IsValidShortRule;
import com.portalmedia.embarc.validation.IsValidUDDRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class DPXColumnValidationRules {
    private static DPXColumnValidationRules instance = null;
    private HashMap<DPXColumn, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> ruleSet;
    private final String valid32 = "Must be valid unsigned 32bit integer";
    private final String valid16 = "Must be valid unsigned 16bit integer";
    private final String valid8 = "Must be valid unsigned 8bit integer";
    private final String FsIfNull = "should be x.FFFFFFFF if null";
    private final String haveValIfNull = "Should have value; should be x.FFFFFFFF if null";
    private final String validASCII = "Must be valid ASCII characters";
    private final String validReal = "Must be a valid real 32bit integer";
    private final String zerosIfNull = "should be all 0s if null";
    private final String partUndefWarn = "= warning that a non-defined value is in use; ";
    private final String fullUndefWarn = "= warning that a non-defined value is in use;  cannot = 255";
    private final String gen = "General \n\n";
    private final String str = "FADGI Strongly Recommended \n\n";
    private final String rec = "FADGI Recommended \n\n";
    private final String opt = "FADGI Optional \n\n";
    private final String smc = "SMPTE-C \n\n";

    public static DPXColumnValidationRules getInstance() {
        if (instance == null) {
            instance = new DPXColumnValidationRules();
        }
        return instance;
    }

    private DPXColumnValidationRules() {
        this.BuildRuleSet();
    }

    private void AddRule(DPXColumn column, ValidationRuleSetEnum ruleType, IValidationRule rule) {
        HashMap<Object, Object> ruleSetHashMap = new HashMap();
        List<IValidationRule> ruleList = new LinkedList<IValidationRule>();
        if (this.ruleSet.containsKey(column) && (ruleSetHashMap = this.ruleSet.get(column)).containsKey((Object)ruleType)) {
            ruleList = (List)ruleSetHashMap.get((Object)ruleType);
        }
        ruleList.add(rule);
        ruleSetHashMap.put((Object)ruleType, ruleList);
        this.ruleSet.put(column, ruleSetHashMap);
    }

    private void AddRule(DPXColumn column, ValidationRuleSetEnum ruleType, IValidationRule rule, String ruleText) {
        HashMap<Object, Object> ruleSetHashMap = new HashMap();
        List<IValidationRule> ruleList = new LinkedList<IValidationRule>();
        if (this.ruleSet.containsKey(column) && (ruleSetHashMap = this.ruleSet.get(column)).containsKey((Object)ruleType)) {
            ruleList = (List)ruleSetHashMap.get((Object)ruleType);
        }
        rule.setRule(ruleText);
        ruleList.add(rule);
        ruleSetHashMap.put((Object)ruleType, ruleList);
        this.ruleSet.put(column, ruleSetHashMap);
    }

    private void BuildRuleSet() {
        this.ruleSet = new HashMap();
        this.AddRule(DPXColumn.MAGIC_NUMBER, ValidationRuleSetEnum.SMPTE_C, new IsValidMatchesTextRule(new String[]{"SDPX", "XPDS"}), "SMPTE-C \n\nMust be ASCII form of either SDPX (0x53445058) or XPDS (0x58504453)");
        this.AddRule(DPXColumn.OFFSET_TO_IMAGE_DATA, ValidationRuleSetEnum.SMPTE_C, new IsValidIntRule(), "SMPTE-C \n\nMust be valid unsigned 32bit integer");
        this.AddRule(DPXColumn.VERSION_NUMBER_OF_HEADER_FORMAT, ValidationRuleSetEnum.SMPTE_C, new IsValidRegexRule("[vV][1-9][.][0-9]"), "SMPTE-C \n\nMust contain 'V' character; currently can be 'V1.0' or 'V2.0'");
        this.AddRule(DPXColumn.TOTAL_IMAGE_FILE_SIZE, ValidationRuleSetEnum.SMPTE_C, new IsValidIntRule(), "SMPTE-C \n\nMust be valid unsigned 32bit integer; must match number of bytes on disk for this file.");
        this.AddRule(DPXColumn.DITTO_KEY, ValidationRuleSetEnum.GENERAL, new IsValidIntRangeRule(0, 1), "General \n\nShould have value; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.GENERIC_SECTION_HEADER_LENGTH, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nShould have value that equals the total bytes in the Generic Section Header");
        this.AddRule(DPXColumn.INDUSTRY_SPECIFIC_HEADER_LENGTH, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nShould have value that equals the total bytes in the Industry Specific Header");
        this.AddRule(DPXColumn.USER_DEFINED_HEADER_LENGTH, ValidationRuleSetEnum.FADGI_O, new IsValidIntRule(), "General \n\nShould have value that equals the total bytes in the Industry Specific Header");
        this.AddRule(DPXColumn.IMAGE_FILE_NAME, ValidationRuleSetEnum.FADGI_SR, new IsValidAsciiValidationRule(), "FADGI Strongly Recommended \n\nMust match the filename of the file as stored in the file system.");
        this.AddRule(DPXColumn.CREATION_DATETIME, ValidationRuleSetEnum.FADGI_SR, new IsValidRegexRule("^([\\+-]?\\d{4}(?!\\d{2}\\b))((-?)((0[1-9]|1[0-2])(\\3([12]\\d|0[1-9]|3[01]))?|W([0-4]\\d|5[0-2])(-?[1-7])?|(00[1-9]|0[1-9]\\d|[12]\\d{2}|3([0-5]\\d|6[1-6])))([T\\s]((([01]\\d|2[0-3])((:?)[0-5]\\d)?|24\\:?00)([\\.,]\\d+(?!:))?)?(\\17[0-5]\\d([\\.,]\\d+)?)?([Z]|([\\+-])([01]\\d|2[0-3]):?([0-5]\\d)?)?)?)?$"), "FADGI Strongly Recommended \n\nMust conform to the following format: YYYY-MM-DDTHH:MM:SSZ, or any smaller version, e.g., YYYY, YYYY-MM, or YYYY-MM-DD.");
        this.AddRule(DPXColumn.CREATOR, ValidationRuleSetEnum.FADGI_SR, new IsValidRegexRule("[A-Za-z]*[,][ ].*"), "FADGI Strongly Recommended \n\nMust conform to the following format: [Country code]comma space[Entity name]");
        this.AddRule(DPXColumn.PROJECT_NAME, ValidationRuleSetEnum.FADGI_SR, new IsRequired());
        this.AddRule(DPXColumn.PROJECT_NAME, ValidationRuleSetEnum.FADGI_SR, new IsValidAsciiValidationRule());
        this.AddRule(DPXColumn.PROJECT_NAME, ValidationRuleSetEnum.FADGI_SR, new IsValidProjectNameRule(), "FADGI Strongly Recommended \n\nMust have value. If labeled: Identifier [comma space] type [comma space] comment [semicolon-space if more than one identifier]. If no labeling: Identifier");
        this.AddRule(DPXColumn.COPYRIGHT_STATEMENT, ValidationRuleSetEnum.FADGI_R, new IsRequired());
        this.AddRule(DPXColumn.COPYRIGHT_STATEMENT, ValidationRuleSetEnum.FADGI_R, new IsValidAsciiValidationRule(), "FADGI Recommended \n\nMust have value; if there are multiple copyrights or other restriction statements, separate them by a semicolon followed by a space.");
        this.AddRule(DPXColumn.ENCRYPTION_KEY, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nShould have value; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.IMAGE_ORIENTATION, ValidationRuleSetEnum.SMPTE_C, new IsValidShortRule());
        this.AddRule(DPXColumn.IMAGE_ORIENTATION, ValidationRuleSetEnum.SMPTE_C, new IsValidShortRangeRule(0, 7), "SMPTE-C \n\nMust be valid unsigned 16bit integer; can be values of 0-7; values 8-254 = warning that a non-defined value is in use;  cannot = 255");
        this.AddRule(DPXColumn.NUMBER_OF_IMAGE_ELEMENTS, ValidationRuleSetEnum.SMPTE_C, new IsValidShortRule());
        this.AddRule(DPXColumn.NUMBER_OF_IMAGE_ELEMENTS, ValidationRuleSetEnum.SMPTE_C, new IsValidShortRangeRule(0, 7), "SMPTE-C \n\nMust be valid unsigned 16bit integer; can be values of 0-7; values 8-254 = warning that a non-defined value is in use;  cannot = 255 there must be as many 'Image Element Structures' in the file as this number designates");
        this.AddRule(DPXColumn.PIXELS_PER_LINE, ValidationRuleSetEnum.SMPTE_C, new IsValidIntRule(), "SMPTE-C \n\nMust be valid unsigned 32bit integer; cannot = 255");
        this.AddRule(DPXColumn.LINES_PER_IMAGE_ELEMENT, ValidationRuleSetEnum.SMPTE_C, new IsValidIntRule(), "SMPTE-C \n\nMust be valid unsigned 32bit integer; cannot = 255");
        this.AddRule(DPXColumn.X_OFFSET, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nMust be valid unsigned 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.Y_OFFSET, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nMust be valid unsigned 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.X_CENTER, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be valid unsigned 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.Y_CENTER, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be valid unsigned 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.X_ORIGINAL_SIZE, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nMust be valid unsigned 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.Y_ORIGINAL_SIZE, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nMust be valid unsigned 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.SOURCE_IMAGE_FILENAME, ValidationRuleSetEnum.GENERAL, new IsValidAsciiValidationRule(), "General \n\nShould be all 0s if null");
        this.AddRule(DPXColumn.SOURCE_IMAGE_DATETIME, ValidationRuleSetEnum.FADGI_R, new IsValidRegexRule("^([\\+-]?\\d{4}(?!\\d{2}\\b))((-?)((0[1-9]|1[0-2])(\\3([12]\\d|0[1-9]|3[01]))?|W([0-4]\\d|5[0-2])(-?[1-7])?|(00[1-9]|0[1-9]\\d|[12]\\d{2}|3([0-5]\\d|6[1-6])))([T\\s]((([01]\\d|2[0-3])((:?)[0-5]\\d)?|24\\:?00)([\\.,]\\d+(?!:))?)?(\\17[0-5]\\d([\\.,]\\d+)?)?([Z]|([\\+-])([01]\\d|2[0-3]):?([0-5]\\d)?)?)?)?$"), "FADGI Recommended \n\nMust conform to the following format: YYYY-MM-DDTHH:MM:SSZ, or any smaller version, e.g., YYYY, YYYY-MM, or YYYY-MM-DD.");
        this.AddRule(DPXColumn.INPUT_DEVICE_NAME, ValidationRuleSetEnum.FADGI_R, new IsRequired());
        this.AddRule(DPXColumn.INPUT_DEVICE_NAME, ValidationRuleSetEnum.FADGI_R, new IsValidAsciiValidationRule(), "FADGI Recommended \n\nMust be valid ASCII characters; must have value");
        this.AddRule(DPXColumn.INPUT_DEVICE_SERIAL_NUMBER, ValidationRuleSetEnum.FADGI_R, new IsRequired());
        this.AddRule(DPXColumn.INPUT_DEVICE_SERIAL_NUMBER, ValidationRuleSetEnum.FADGI_R, new IsValidAsciiValidationRule(), "FADGI Recommended \n\nMust be valid ASCII characters; must have value");
        this.AddRule(DPXColumn.X_SCANNED_SIZE, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be valid unsigned 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.Y_SCANNED_SIZE, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be valid unsigned 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.FILM_MFG_ID_CODE, ValidationRuleSetEnum.FADGI_O, new IsRequired());
        this.AddRule(DPXColumn.FILM_MFG_ID_CODE, ValidationRuleSetEnum.FADGI_O, new IsValidAsciiValidationRule(), "FADGI Optional \n\nMust be valid ASCII characters; must have value");
        this.AddRule(DPXColumn.FILM_TYPE, ValidationRuleSetEnum.FADGI_O, new IsRequired());
        this.AddRule(DPXColumn.FILM_TYPE, ValidationRuleSetEnum.FADGI_O, new IsValidAsciiValidationRule(), "FADGI Optional \n\nMust be valid ASCII characters; must have value");
        this.AddRule(DPXColumn.OFFSET_IN_PERFS, ValidationRuleSetEnum.GENERAL, new IsValidAsciiValidationRule(), "General \n\nshould be all 0s if null");
        this.AddRule(DPXColumn.PREFIX, ValidationRuleSetEnum.GENERAL, new IsValidAsciiValidationRule(), "General \n\nshould be all 0s if null");
        this.AddRule(DPXColumn.COUNT, ValidationRuleSetEnum.GENERAL, new IsValidAsciiValidationRule(), "General \n\nshould be all 0s if null");
        this.AddRule(DPXColumn.FORMAT, ValidationRuleSetEnum.GENERAL, new IsValidAsciiValidationRule(), "General \n\nshould be all 0s if null");
        this.AddRule(DPXColumn.FRAME_POSITION_IN_SEQUENCE, ValidationRuleSetEnum.FADGI_R, new IsValidIntRule(), "FADGI Recommended \n\nMust be valid unsigned 32bit integer");
        this.AddRule(DPXColumn.SEQUENCE_LENGTH, ValidationRuleSetEnum.FADGI_R, new IsValidIntRule(), "FADGI Recommended \n\nMust be valid unsigned 32bit integer");
        this.AddRule(DPXColumn.HELD_COUNT, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nMust be valid unsigned 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.FRAME_RATE_OF_ORIGINAL, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.SHUTTER_ANGLE_OF_CAMERA, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.FRAME_IDENTIFICATION, ValidationRuleSetEnum.GENERAL, new IsValidAsciiValidationRule(), "General \n\nshould be all 0s if null");
        this.AddRule(DPXColumn.SLATE_IDENTIFICATION, ValidationRuleSetEnum.GENERAL, new IsValidAsciiValidationRule(), "General \n\nshould be all 0s if null");
        this.AddRule(DPXColumn.SMTPE_TIMECODE, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nshould be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.SMTPE_USERBITS, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nshould be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.INTERLACE, ValidationRuleSetEnum.GENERAL, new IsValidIntRule(), "General \n\nMust be valid unsigned 8bit integer; should be FF if null");
        this.AddRule(DPXColumn.FIELD_NUMBER, ValidationRuleSetEnum.GENERAL, new IsValidByteRule(), "General \n\nMust be valid unsigned 8bit integer; should be FF if null");
        this.AddRule(DPXColumn.VIDEO_SIGNAL_STANDARD, ValidationRuleSetEnum.GENERAL, new IsValidByteRule(), "General \n\nMust be valid unsigned 8bit integer; should be FF if null");
        this.AddRule(DPXColumn.HORIZONTAL_SAMPLING_RATE, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.VERTICAL_SAMPLING_RATE, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.TEMPORAL_SAMPLING_RATE, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.TIME_OFFSET, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.GAMMA, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.BLACK_LEVEL, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.BREAKPOINT, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.REFERENCE_WHITE_LEVEL, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.INTEGRATION_TIME, ValidationRuleSetEnum.GENERAL, new IsValidFloatRule(), "General \n\nMust be a valid real 32bit integer; should be x.FFFFFFFF if null");
        this.AddRule(DPXColumn.USER_IDENTIFICATION, ValidationRuleSetEnum.FADGI_O, new IsValidAsciiValidationRule());
        this.AddRule(DPXColumn.USER_IDENTIFICATION, ValidationRuleSetEnum.FADGI_O, new IsValidRegexRule("(?i)\\bFADGI process history\\b"), "FADGI Optional \n\nMust read: 'FADGI process history'");
        this.AddRule(DPXColumn.USER_DEFINED_DATA, ValidationRuleSetEnum.FADGI_O, new IsValidUDDRule(), "Based on the \u2018Coding History\u2019 element defined by EBU R98-1999: \nFormat for the <CodingHistory> field in Broadcast Wave Format files for the constrained space within the Broadcast Wave \u2018bext\u2019 chunk, \nthis field employs a defined string variable for each parameter of the digitization process.\n\nEach new line with text should start with 'O='");
    }

    public HashMap<ValidationRuleSetEnum, List<IValidationRule>> getRules(ColumnDef column) {
        HashMap<ValidationRuleSetEnum, List<IValidationRule>> rules = new HashMap<ValidationRuleSetEnum, List<IValidationRule>>();
        if (this.ruleSet.containsKey(column)) {
            HashMap<ValidationRuleSetEnum, List<IValidationRule>> rulesList = this.ruleSet.get(column);
            for (ValidationRuleSetEnum ruleType : ValidationRuleSetEnum.values()) {
                if (!rulesList.containsKey((Object)ruleType)) continue;
                rules.put(ruleType, rulesList.get((Object)ruleType));
            }
        }
        return rules;
    }

    public HashMap<ValidationRuleSetEnum, List<IValidationRule>> getRuleSet(ColumnDef column) {
        if (this.ruleSet.containsKey(column)) {
            HashMap<ValidationRuleSetEnum, List<IValidationRule>> rulesList = this.ruleSet.get(column);
            return rulesList;
        }
        return new HashMap<ValidationRuleSetEnum, List<IValidationRule>>();
    }
}

