/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.report;

import com.portalmedia.embarc.parser.dpx.DPXSequenceError;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.io.ICsvMapWriter;
import org.supercsv.prefs.CsvPreference;

public class DPXSequenceAnalysisReportCSVWriter {
    private static String[] headers = null;

    public static void writeSequenceAnalysisReportCSV(String outputPath, List<DPXSequenceError> sequenceErrors) throws IOException {
        try (FileWriter fileWriter = new FileWriter(outputPath);
             CsvMapWriter csvWriter = new CsvMapWriter((Writer)fileWriter, CsvPreference.STANDARD_PREFERENCE);){
            csvWriter.writeHeader(DPXSequenceAnalysisReportCSVWriter.getHeaderColumns());
            for (DPXSequenceError seqError : sequenceErrors) {
                DPXSequenceAnalysisReportCSVWriter.writeSequenceErrorCsv(seqError, (ICsvMapWriter)csvWriter);
            }
        }
    }

    private static void setHeaderColumns() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add("Filename");
        headerList.add("Column");
        headerList.add("Error");
        headerList.add("Error Description");
        headers = headerList.toArray(new String[0]);
    }

    private static String[] getHeaderColumns() {
        if (headers == null) {
            DPXSequenceAnalysisReportCSVWriter.setHeaderColumns();
        }
        return headers;
    }

    private static void writeSequenceErrorCsv(DPXSequenceError sequenceError, ICsvMapWriter csvWriter) throws IOException {
        HashMap<String, String> seqErrorItem = new HashMap<String, String>();
        seqErrorItem.put("Filename", sequenceError.getFilename());
        seqErrorItem.put("Column", sequenceError.getColumn());
        seqErrorItem.put("Error", sequenceError.getError());
        seqErrorItem.put("Error Description", sequenceError.getErrorDescription());
        csvWriter.write(seqErrorItem, DPXSequenceAnalysisReportCSVWriter.getHeaderColumns());
    }
}

