/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.model.MXFFileInformationViewModel;
import com.portalmedia.embarc.gui.model.MXFMetadataColumnViewModel;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import org.apache.commons.lang.StringUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class ValidationCellFactoryMXF
extends TableCell<MXFFileInformationViewModel, String> {
    private TableColumn<MXFFileInformationViewModel, String> columnData;
    private MXFMetadataColumnViewModel mcvmData;

    public ValidationCellFactoryMXF(TableColumn<MXFFileInformationViewModel, String> column, MXFMetadataColumnViewModel mcvm) {
        this.columnData = column;
        this.mcvmData = mcvm;
    }

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.setStyle(null);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            TableRow row;
            if (this.mcvmData != null && (row = this.getTableRow()) != null) {
                MXFFileInformationViewModel fivm = (MXFFileInformationViewModel)row.getItem();
                String cellData = (String)this.columnData.getCellData((Object)fivm);
                if (this.mcvmData.getMXFColumn().isRequired() && StringUtils.isBlank((String)cellData)) {
                    FontIcon icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_OCTAGON);
                    icon.setAccessibleText("Missing Required Value");
                    icon.getStyleClass().add((Object)"fadgi-sr-warning");
                    VBox iconsBox = new VBox(new Node[]{icon});
                    iconsBox.setAlignment(Pos.CENTER_RIGHT);
                    Label valueLabel = new Label();
                    valueLabel.setText(item);
                    VBox valueLabelBox = new VBox(new Node[]{valueLabel});
                    valueLabelBox.setAlignment(Pos.CENTER_LEFT);
                    valueLabelBox.setFillWidth(true);
                    HBox box = new HBox(new Node[]{valueLabelBox, iconsBox});
                    HBox.setHgrow((Node)iconsBox, (Priority)Priority.SOMETIMES);
                    HBox.setHgrow((Node)valueLabelBox, (Priority)Priority.ALWAYS);
                    this.setText(null);
                    this.setGraphic((Node)box);
                    return;
                }
            }
            this.setText(item);
            this.setGraphic(null);
        }
    }
}

