/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.model.MXFSelectedFilesSummary;
import com.portalmedia.embarc.gui.mxf.ControllerMediatorMXF;
import com.portalmedia.embarc.parser.mxf.MXFFileInfo;
import java.io.IOException;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;

public class FileInfoController
extends AnchorPane {
    @FXML
    private Label sectionLabel;
    @FXML
    private Label selectedFilesLabel;
    @FXML
    private Label fileNameLabel;
    @FXML
    private Label filePathLabel;
    @FXML
    private Label formatLabel;
    @FXML
    private Label versionLabel;
    @FXML
    private Label profileLabel;
    @FXML
    private Label fileSizeLabel;
    @FXML
    private Label pictureTrackCountLabel;
    @FXML
    private Label soundTrackCountLabel;
    @FXML
    private Label otherTrackCountLabel;
    @FXML
    private Label tdCountLabel;
    @FXML
    private Label bdCountLabel;

    public FileInfoController() {
        ControllerMediatorMXF.getInstance().registerFileInfoController(this);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("FileInfoView.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setContent() {
        this.sectionLabel.setText("File Information");
        MXFSelectedFilesSummary summary = ControllerMediatorMXF.getInstance().getSelectedFilesSummary();
        this.fileNameLabel.setText(summary.getFileName());
        this.fileNameLabel.setFocusTraversable(true);
        this.fileNameLabel.setAccessibleText("Filename is " + summary.getFileName());
        this.filePathLabel.setText(summary.getFilePath());
        this.filePathLabel.setFocusTraversable(true);
        this.filePathLabel.setAccessibleText("File path is " + summary.getFilePath());
        this.formatLabel.setText(summary.getFileInfoDisplayValues(MXFFileInfo.FORMAT));
        this.formatLabel.setFocusTraversable(true);
        this.formatLabel.setAccessibleText("Format is " + summary.getFileInfoDisplayValues(MXFFileInfo.FORMAT));
        this.versionLabel.setText(summary.getFileInfoDisplayValues(MXFFileInfo.VERSION));
        this.versionLabel.setFocusTraversable(true);
        this.versionLabel.setAccessibleText("Version is " + summary.getFileInfoDisplayValues(MXFFileInfo.VERSION));
        this.profileLabel.setText(summary.getFileInfoDisplayValues(MXFFileInfo.PROFILE));
        this.profileLabel.setFocusTraversable(true);
        this.profileLabel.setAccessibleText("Profile is " + summary.getFileInfoDisplayValues(MXFFileInfo.PROFILE));
        this.fileSizeLabel.setText(summary.getFileInfoDisplayValues(MXFFileInfo.FILE_SIZE));
        this.fileSizeLabel.setFocusTraversable(true);
        this.fileSizeLabel.setAccessibleText("File size is " + summary.getFileInfoDisplayValues(MXFFileInfo.FILE_SIZE));
        this.pictureTrackCountLabel.setText(summary.getFileInfoDisplayValues(MXFFileInfo.PICTURE_TRACK_COUNT));
        this.pictureTrackCountLabel.setFocusTraversable(true);
        this.pictureTrackCountLabel.setAccessibleText("Picture track count " + summary.getFileInfoDisplayValues(MXFFileInfo.PICTURE_TRACK_COUNT));
        this.soundTrackCountLabel.setText(summary.getFileInfoDisplayValues(MXFFileInfo.SOUND_TRACK_COUNT));
        this.soundTrackCountLabel.setFocusTraversable(true);
        this.soundTrackCountLabel.setAccessibleText("Sound track count " + summary.getFileInfoDisplayValues(MXFFileInfo.SOUND_TRACK_COUNT));
        this.otherTrackCountLabel.setText(summary.getFileInfoDisplayValues(MXFFileInfo.OTHER_TRACK_COUNT));
        this.otherTrackCountLabel.setFocusTraversable(true);
        this.otherTrackCountLabel.setAccessibleText("Other track count " + summary.getFileInfoDisplayValues(MXFFileInfo.OTHER_TRACK_COUNT));
        this.tdCountLabel.setText(summary.getFileInfoDisplayValues(MXFFileInfo.TD_COUNT));
        this.tdCountLabel.setFocusTraversable(true);
        this.tdCountLabel.setAccessibleText("Text data count " + summary.getFileInfoDisplayValues(MXFFileInfo.TD_COUNT));
        this.bdCountLabel.setText(summary.getFileInfoDisplayValues(MXFFileInfo.BD_COUNT));
        this.bdCountLabel.setFocusTraversable(true);
        this.bdCountLabel.setAccessibleText("Binary data count " + summary.getFileInfoDisplayValues(MXFFileInfo.BD_COUNT));
        this.setNumberOfSelectedFiles(summary.getFileCount());
    }

    private void setNumberOfSelectedFiles(int num) {
        this.selectedFilesLabel.setText(Integer.toString(num) + " file" + (num > 1 ? "s " : " ") + "selected");
    }
}

