/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.model;

import com.portalmedia.embarc.gui.model.MXFFileInformationViewModel;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import com.portalmedia.embarc.parser.StringMetadataColumn;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import com.portalmedia.embarc.parser.mxf.MXFFileDescriptorResult;
import com.portalmedia.embarc.parser.mxf.MXFFileInfo;
import com.portalmedia.embarc.parser.mxf.MXFSection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MXFSelectedFilesSummary {
    private static MXFSelectedFilesSummary summary;
    int fileCount = 0;
    String fileName;
    String filePath;
    HashMap<MXFColumn, String> columnDisplayValues;
    HashMap<MXFFileInfo, String> fileInfoDisplayValues;
    HashSet<MXFColumn> possibleColumns = new HashSet();
    HashSet<MXFFileInfo> possibleFileInfoProps = new HashSet();
    HashSet<String> possibleTextColumns = new HashSet();
    MXFFileDescriptorResult fileDescriptors;
    private HashMap<MXFColumn, MetadataColumnDef> coreData;
    HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> tdElements;
    HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> bdElements;
    boolean filesAreMissingAS07CoreDMSFramework;

    public MXFSelectedFilesSummary() {
        this.columnDisplayValues = new HashMap();
        this.fileInfoDisplayValues = new HashMap();
        this.possibleTextColumns.add("fileName");
        this.possibleTextColumns.add("filePath");
        for (MXFColumn mXFColumn : MXFColumn.values()) {
            this.possibleColumns.add(mXFColumn);
        }
        for (Enum enum_ : MXFFileInfo.values()) {
            this.possibleFileInfoProps.add((MXFFileInfo)enum_);
        }
    }

    public String getDisplayValues(ColumnDef column) {
        return this.columnDisplayValues.get(column);
    }

    public void setDisplayValue(MXFColumn column, String value) {
        if (value == null) {
            value = "";
        }
        if (this.columnDisplayValues.containsKey(column) && !this.columnDisplayValues.get(column).equals(value)) {
            this.columnDisplayValues.put(column, "{multiple values}");
            this.possibleColumns.remove(column);
        } else {
            this.columnDisplayValues.put(column, value);
        }
    }

    public String getFileInfoDisplayValues(MXFFileInfo fileInfoProp) {
        return this.fileInfoDisplayValues.get((Object)fileInfoProp);
    }

    public void setFileInfoDisplayValue(MXFFileInfo fileInfoProp, String value) {
        if (value == null) {
            value = "";
        }
        if (this.fileInfoDisplayValues.containsKey((Object)fileInfoProp) && !this.fileInfoDisplayValues.get((Object)fileInfoProp).equals(value)) {
            this.fileInfoDisplayValues.put(fileInfoProp, "{multiple values}");
            this.possibleFileInfoProps.remove((Object)fileInfoProp);
        } else {
            this.fileInfoDisplayValues.put(fileInfoProp, value);
        }
    }

    public MXFFileDescriptorResult getFileDescriptors() {
        return this.fileDescriptors;
    }

    public void setFileDescriptors(MXFFileDescriptorResult fileDescriptorResult) {
        this.fileDescriptors = this.getFileCount() == 1 ? fileDescriptorResult : null;
    }

    public HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> getAllTDElements() {
        return this.tdElements;
    }

    public LinkedHashMap<MXFColumn, MetadataColumnDef> getTDElement(String key) {
        return this.tdElements.get(key);
    }

    public void setTDElements(HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> tdElementsResult) {
        this.tdElements = this.getFileCount() == 1 ? tdElementsResult : null;
    }

    public HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> getAllBDElements() {
        return this.bdElements;
    }

    public LinkedHashMap<MXFColumn, MetadataColumnDef> getBDElement(String key) {
        return this.bdElements.get(key);
    }

    public void setBDElements(HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> bdElementsResult) {
        this.bdElements = this.getFileCount() == 1 ? bdElementsResult : null;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (this.fileName == null || this.fileName.isEmpty() || this.fileName.equals(fileName)) {
            this.fileName = fileName;
        } else {
            this.fileName = "{multiple values}";
            this.possibleTextColumns.remove("fileName");
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        if (this.filePath == null || this.filePath.isEmpty() || this.filePath.equals(filePath)) {
            this.filePath = filePath;
        } else {
            this.filePath = "{multiple values}";
            this.possibleTextColumns.remove("filePath");
        }
    }

    public HashMap<MXFColumn, MetadataColumnDef> getCoreData() {
        return this.coreData;
    }

    public void setCoreData(HashMap<MXFColumn, MetadataColumnDef> newCoreData) {
        if (this.getFileCount() == 1) {
            this.coreData = newCoreData;
            return;
        }
        HashMap<MXFColumn, MetadataColumnDef> currentData = this.getCoreData();
        if (currentData == null || currentData.isEmpty()) {
            this.coreData = newCoreData;
            return;
        }
        LinkedHashMap<MXFColumn, MetadataColumnDef> combinedData = new LinkedHashMap<MXFColumn, MetadataColumnDef>();
        for (Map.Entry<MXFColumn, MetadataColumnDef> entry : currentData.entrySet()) {
            if (newCoreData == null) continue;
            MXFColumn key = entry.getKey();
            MetadataColumnDef value = entry.getValue();
            if (newCoreData.get(key) == null) continue;
            String newValue = newCoreData.get(key).getCurrentValue();
            if (key == MXFColumn.AS_07_Core_DMS_Devices || key == MXFColumn.AS_07_Core_DMS_Identifiers) {
                System.out.println("skipping devices/identifiers");
                combinedData.put(key, new StringMetadataColumn(key, newValue));
                continue;
            }
            if (newValue == null || value.getCurrentValue() == null) continue;
            if (!newValue.equals(value.getCurrentValue())) {
                combinedData.put(key, new StringMetadataColumn(key, "{multiple values}"));
                continue;
            }
            combinedData.put(key, new StringMetadataColumn(key, value.getCurrentValue()));
        }
        this.coreData = combinedData;
    }

    public boolean getFilesAreMissingAS07CoreDMSFramework() {
        return this.filesAreMissingAS07CoreDMSFramework;
    }

    public void setFilesAreMissingAS07CoreDMSFramework(boolean filesAreMissingAS07CoreDMSFramework) {
        this.filesAreMissingAS07CoreDMSFramework = filesAreMissingAS07CoreDMSFramework;
    }

    public static MXFSelectedFilesSummary create(List<MXFFileInformationViewModel> files) {
        summary = new MXFSelectedFilesSummary();
        summary.setFileCount(files.size());
        if (files == null || files.size() == 0) {
            return summary;
        }
        boolean missingAS07CoreDMSFramework = false;
        for (MXFFileInformationViewModel vm : files) {
            summary.setCoreData(vm.getCoreData());
            summary.setFileDescriptors(vm.getFileDescriptors());
            summary.setTDElements(vm.getAllTDElements());
            summary.setBDElements(vm.getAllBDElements());
            summary.setFileName(vm.getProp("name"));
            summary.setFilePath(vm.getProp("path"));
            if (vm.getProp("hasAS07CoreDMSFramework").equals("false")) {
                missingAS07CoreDMSFramework = true;
            }
            HashSet columnsLeft = (HashSet)summary.getPossibleColumnsLeft().clone();
            for (MXFColumn column : columnsLeft) {
                if (column.getSection() == MXFSection.CORE) continue;
                String value = vm.getProp(column.getDisplayName());
                if (value == null) {
                    value = "";
                }
                summary.setDisplayValue(column, value);
            }
            HashSet fileInfoPropsLeft = (HashSet)summary.getPossibleFileInfoPropsLeft().clone();
            for (MXFFileInfo fileInfo : fileInfoPropsLeft) {
                String value = vm.getProp(fileInfo.getIdentifier());
                if (value == null) {
                    value = "";
                }
                summary.setFileInfoDisplayValue(fileInfo, value);
            }
            if (summary.hasPossibleColumnsLeft()) continue;
            break;
        }
        summary.setFilesAreMissingAS07CoreDMSFramework(missingAS07CoreDMSFramework);
        System.currentTimeMillis();
        return summary;
    }

    public static MXFSelectedFilesSummary append(MXFFileInformationViewModel vm) {
        summary.setFileCount(summary.getFileCount() + 1);
        summary.setFileName(vm.getProp("name"));
        summary.setFilePath(vm.getProp("path"));
        HashSet columnsLeft = (HashSet)summary.getPossibleColumnsLeft().clone();
        for (MXFColumn column : columnsLeft) {
            String value = vm.getProp(column);
            if (value == null) {
                value = "";
            }
            summary.setDisplayValue(column, value);
        }
        HashSet fileInfoPropsLeft = (HashSet)summary.getPossibleFileInfoPropsLeft().clone();
        for (MXFFileInfo fileInfo : fileInfoPropsLeft) {
            String value = vm.getProp(fileInfo.getDisplayName());
            if (value == null) {
                value = "";
            }
            summary.setFileInfoDisplayValue(fileInfo, value);
        }
        return summary;
    }

    public HashSet<MXFColumn> getPossibleColumnsLeft() {
        return this.possibleColumns;
    }

    public boolean hasPossibleColumnsLeft() {
        return this.possibleColumns.size() > 0 || this.possibleTextColumns.size() > 0;
    }

    public HashSet<MXFFileInfo> getPossibleFileInfoPropsLeft() {
        return this.possibleFileInfoProps;
    }

    public boolean hasPossibleFileInfoPropsLeft() {
        return this.possibleFileInfoProps.size() > 0 || this.possibleTextColumns.size() > 0;
    }
}

