/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.helper;

import com.google.cloud.Crc32c;
import com.portalmedia.embarc.database.DBService;
import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.gui.model.DatabaseSummary;
import com.portalmedia.embarc.gui.model.SelectedFilesSummary;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.MetadataColumn;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.dpx.DPXFileInformation;
import com.portalmedia.embarc.parser.dpx.DPXMetadata;
import com.portalmedia.embarc.parser.dpx.DPXService;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.dizitart.no2.objects.Cursor;

public class DPXFileListHelper {
    static DBService<DPXFileInformationViewModel> dbService = new DBService<DPXFileInformationViewModel>(DPXFileInformationViewModel.class);
    private static int current_id = 0;
    private static boolean selectAll = false;

    private static void AddFileInformationViewModel(DPXFileInformation f) {
        DPXFileInformationViewModel fivm = DPXFileListHelper.toFileInformationViewModel(f);
        DatabaseSummary.addFile(fivm);
        dbService.add(fivm);
    }

    public static <T> Boolean addFileToDatabase(String file) {
        if (file != null) {
            DPXFileListHelper.AddFileInformationViewModel(DPXFileListHelper.createDPXFileInformation(file));
        }
        return true;
    }

    public static <T> DPXFileInformation createDPXFileInformation(String filePath) {
        File file = new File(filePath);
        String name = file.getName();
        String path = file.getPath();
        DPXFileInformation fileInfo = new DPXFileInformation();
        fileInfo.setName(name);
        fileInfo.setPath(path);
        fileInfo.setId(++current_id);
        try {
            DPXService service = new DPXService(file.getPath());
            fileInfo.setFileData(service.readFile());
        }
        catch (Exception e) {
            System.out.println("Failed to parse file metadata");
        }
        return fileInfo;
    }

    public static SelectedFilesSummary createSelectedFilesSummary(List<DPXFileInformationViewModel> selectedRows) {
        if (selectAll) {
            DPXFileInformationViewModel fi;
            Cursor<DPXFileInformationViewModel> files = dbService.getAllCursors();
            SelectedFilesSummary selectedFilesSummary = SelectedFilesSummary.create(new ArrayList<DPXFileInformationViewModel>());
            Iterator iterator = files.iterator();
            while (iterator.hasNext() && (selectedFilesSummary = SelectedFilesSummary.append(fi = (DPXFileInformationViewModel)iterator.next())).hasPossibleColumnsLeft()) {
            }
            return selectedFilesSummary;
        }
        return SelectedFilesSummary.create(selectedRows);
    }

    public static SelectedFilesSummary createSelectedFilesSummaryAll() {
        DPXFileInformationViewModel fi;
        SelectedFilesSummary selectedFilesSummary = SelectedFilesSummary.create(new ArrayList<DPXFileInformationViewModel>());
        Iterator iterator = dbService.getAllCursors().iterator();
        while (iterator.hasNext() && (selectedFilesSummary = SelectedFilesSummary.append(fi = (DPXFileInformationViewModel)iterator.next())).hasPossibleColumnsLeft()) {
        }
        return selectedFilesSummary;
    }

    public static <T> Boolean deleteFileFromDB(int id) {
        System.out.println("Deleting file: " + id);
        try {
            dbService.delete(id);
        }
        catch (Exception e) {
            System.out.println("Failed to delete file");
            return false;
        }
        return true;
    }

    public static void deleteSelectedRows(List<DPXFileInformationViewModel> selectedRows) {
        if (selectAll) {
            System.out.println("Select all delete");
            dbService.deleteAll();
            DatabaseSummary.deleteAll();
        } else {
            for (DPXFileInformationViewModel fivm : selectedRows) {
                dbService.delete(Integer.parseInt(fivm.getProp("id")));
                DatabaseSummary.removeFile(fivm);
            }
        }
    }

    public static Cursor<DPXFileInformationViewModel> getAllFiles(boolean editedOnly) {
        return editedOnly ? dbService.getEditedCursors() : dbService.getAllCursors();
    }

    public static List<DPXFileInformationViewModel> getAllFilesToWrite(boolean editedOnly) {
        Cursor<DPXFileInformationViewModel> fileList = editedOnly ? dbService.getEditedCursors() : dbService.getAllCursors();
        ArrayList<DPXFileInformationViewModel> finalFileList = new ArrayList<DPXFileInformationViewModel>();
        for (DPXFileInformationViewModel fivm : fileList) {
            boolean fileShouldBeWritten = fivm.getFileShouldBeWritten();
            if (!fileShouldBeWritten) continue;
            finalFileList.add(fivm);
        }
        return finalFileList;
    }

    public static byte[] getBytesFromFile(String filePath, int start) throws IOException {
        File f = new File(filePath);
        byte[] allBytes = Files.readAllBytes(f.toPath());
        byte[] imageData = Arrays.copyOfRange(allBytes, start, allBytes.length);
        return imageData;
    }

    public static String getCrc32Hash(byte[] bytes) {
        try {
            Crc32c c = new Crc32c();
            c.update(bytes, 0, bytes.length);
            return String.format("%02x", c.getValue());
        }
        catch (Exception e) {
            System.out.println("Error getting crc32");
            return "";
        }
    }

    private static int getErrorCount(Set<ValidationRuleSetEnum> rules) {
        long startTime = System.currentTimeMillis();
        int size = dbService.getErrorCount(rules);
        System.out.println("Baseline getting error count " + (System.currentTimeMillis() - startTime) + "ms " + size);
        return size;
    }

    public static ObservableList<DPXFileInformationViewModel> getObservableFileList() {
        return FXCollections.observableArrayList(dbService.getAll());
    }

    public static long getSelectedFileCount(ObservableList<DPXFileInformationViewModel> selectedRows, Set<ValidationRuleSetEnum> rules, boolean filteredByErrors) {
        if (selectAll && filteredByErrors) {
            return DPXFileListHelper.getErrorCount(rules);
        }
        if (selectAll) {
            return dbService.getSize();
        }
        return selectedRows.size();
    }

    public static int getTotalFiles() {
        return (int)dbService.getSize();
    }

    public static boolean selectAllSelected() {
        return selectAll;
    }

    public static void setSelectAll(boolean value) {
        selectAll = value;
    }

    public static DPXFileInformationViewModel toFileInformationViewModel(DPXFileInformation f) {
        DPXFileInformationViewModel fivm = new DPXFileInformationViewModel();
        fivm.setProp("name", f.getName());
        fivm.setProp("path", f.getPath());
        fivm.setId(f.getId());
        DPXMetadata dpx = f.getFileData();
        LinkedHashMap<ColumnDef, MetadataColumn> columns = dpx.getMetadataHashMap();
        for (ColumnDef key : columns.keySet()) {
            MetadataColumnDef c = columns.get(key);
            fivm.setProp(key, c.toString());
        }
        return fivm;
    }

    public static void updateName(DPXFileInformationViewModel fivm) {
        fivm.autoPopulateName();
        dbService.update(fivm);
        DatabaseSummary.updateFile(fivm);
    }

    public static void updateValues(HashMap<DPXColumn, String> changedValues, DPXFileInformationViewModel file) {
        for (DPXColumn column : changedValues.keySet()) {
            file.setProp(column, changedValues.get(column));
        }
        file.setEdited(true);
        DPXFileListHelper.setFileShouldBeWritten(file, true, false);
        dbService.update(file);
        DatabaseSummary.updateFile(file);
    }

    public static void setFileShouldBeWritten(DPXFileInformationViewModel file, boolean shouldBeWritten, boolean shouldUpdateDb) {
        file.setFileShouldBeWritten(shouldBeWritten);
        if (shouldUpdateDb) {
            dbService.update(file);
            DatabaseSummary.updateFile(file);
        }
    }
}

