/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.ASCIIArea;
import com.portalmedia.embarc.gui.ASCIIField;
import com.portalmedia.embarc.gui.AccessibleAlertHelper;
import com.portalmedia.embarc.gui.BorderValidityField;
import com.portalmedia.embarc.gui.DatePickerField;
import com.portalmedia.embarc.gui.DropDownField;
import com.portalmedia.embarc.gui.FloatField;
import com.portalmedia.embarc.gui.IEditorField;
import com.portalmedia.embarc.gui.IntegerField;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.PixelAspectRatioField;
import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.model.SelectedFilesSummary;
import com.portalmedia.embarc.parser.DisplayType;
import com.portalmedia.embarc.parser.ImageElementDef;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.dpx.DPXColumnHelpText;
import com.portalmedia.embarc.parser.dpx.DPXImageElement;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Window;

public class EditorForm
extends AnchorPane {
    @FXML
    private Label sectionLabel;
    @FXML
    private Label selectedFilesLabel;
    @FXML
    private VBox sectionEditableFields;
    @FXML
    private VBox sectionNotEditableFields;
    @FXML
    private ScrollPane sectionEditableFieldsContainer;
    @FXML
    private ScrollPane sectionNotEditableFieldsContainer;
    @FXML
    private TitledPane editableFieldsAccordion;
    @FXML
    private TitledPane notEditableFieldsAccordion;
    @FXML
    private Accordion editorAccordion;
    @FXML
    private ComboBox subsectionDropDown;
    @FXML
    private HBox subsectionBox;
    @FXML
    private Button applyChangesButton;
    @FXML
    private Button discardChangesButton;
    @FXML
    private Label editingSummary;
    private SectionDef section;
    private ImageElementDef selectedSubsection;
    private HashSet<IEditorField> textFields;
    private IntegerProperty editedFieldsCount = new SimpleIntegerProperty(0);

    public EditorForm() {
        ControllerMediatorDPX.getInstance().registerEditorForm(this);
        this.textFields = new HashSet();
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("EditorForm.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.selectedSubsection = DPXImageElement.IMAGE_ELEMENT_1;
        this.subsectionDropDown.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue ov, String t, String t1) {
                if (t != null && !t.equals(t1)) {
                    EditorForm.this.setVisibility(t1);
                }
            }
        });
        this.applyChangesButton.setOnAction(event -> {
            if (this.editedFieldsCount.get() == 0) {
                this.showAlert("", "There are no edits to apply.");
                return;
            }
            HashMap<DPXColumn, String> changedValues = new HashMap<DPXColumn, String>();
            for (IEditorField field : this.textFields) {
                if (!field.getColumn().getEditable() || !field.valueChanged()) continue;
                changedValues.put(field.getColumn(), field.getValue());
            }
            ControllerMediatorDPX.getInstance().updateChangedValues(changedValues);
        });
        this.discardChangesButton.setOnAction(event -> {
            if (this.editedFieldsCount.get() == 0) {
                this.showAlert("", "There are no edits to discard.");
            } else {
                this.showConfirmation("Are you sure?", "Press OK to discard current changes. Press cancel to keep changes.");
            }
        });
        this.editedFieldsCount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> obs, Number ov, Number nv) {
                String[] numFiles = EditorForm.this.selectedFilesLabel.getText().split(" ");
                String filesString = " files";
                if ("1".equals(numFiles[0])) {
                    filesString = " file";
                }
                if (nv.intValue() == 0) {
                    EditorForm.this.editingSummary.setText("0 edited fields");
                } else if (nv.intValue() == 1) {
                    EditorForm.this.editingSummary.setText(String.valueOf(nv) + " edit in " + numFiles[0] + filesString);
                } else {
                    EditorForm.this.editingSummary.setText(String.valueOf(nv) + " edits in " + numFiles[0] + filesString);
                }
            }
        });
        this.notEditableFieldsAccordion.setAccessibleText("List of non editable fields");
        this.editableFieldsAccordion.setAccessibleText("List of editable fields");
        this.editingSummary.setFocusTraversable(true);
    }

    private void calculateEditedFields() {
        int count = 0;
        for (IEditorField field : this.textFields) {
            if (!field.valueChanged() || !field.getColumn().getEditable()) continue;
            ++count;
        }
        this.editedFieldsCount.set(count);
    }

    public int getEditedFieldsCount() {
        return this.editedFieldsCount.get();
    }

    public void refreshValidation() {
        SelectedFilesSummary summary = ControllerMediatorDPX.getInstance().getSelectedFilesSummary();
        for (IEditorField tf : this.textFields) {
            if (summary == null) {
                tf.setInvalidRuleSets(null);
            }
            Set<ValidationRuleSetEnum> invalidRules = summary.getRuleSetViolations(tf.getColumn());
            tf.setInvalidRuleSets(invalidRules);
        }
    }

    public void setEditedFieldsCount(int count) {
        if (this.editedFieldsCount != null) {
            this.editedFieldsCount.set(count);
        }
    }

    private void setNumberOfEditableFields(int num) {
        this.editableFieldsAccordion.setText(Integer.toString(num) + " Editable Field" + (num != 1 ? "s" : ""));
    }

    private void setNumberOfNotEditableFields(int num) {
        this.notEditableFieldsAccordion.setText(Integer.toString(num) + " Not Editable Field" + (num != 1 ? "s" : ""));
    }

    private void setNumberOfSelectedFiles(int num) {
        this.selectedFilesLabel.setText(Integer.toString(num) + " file" + (num != 1 ? "s " : " ") + "selected");
        this.selectedFilesLabel.setFocusTraversable(true);
    }

    public void setSection(SectionDef section, boolean resetValues) {
        if (resetValues) {
            for (IEditorField field : this.textFields) {
                field.resetValueChanged();
            }
        }
        this.calculateEditedFields();
        this.section = section;
        SelectedFilesSummary summary = ControllerMediatorDPX.getInstance().getSelectedFilesSummary();
        int editableCount = 0;
        int notEditableCount = 0;
        LinkedList<String> subsections = new LinkedList<String>();
        this.sectionNotEditableFields.getChildren().clear();
        this.sectionEditableFields.getChildren().clear();
        for (DPXColumn c : DPXColumn.values()) {
            if (c.getSection() != this.section) continue;
            if (c.hasSubsection() && !subsections.contains(c.getSubsection().getDisplayName())) {
                subsections.add(c.getSubsection().getDisplayName());
            }
            boolean subsectionVisible = true;
            if (c.hasSubsection() && !this.selectedSubsection.getDisplayName().equals(c.getSubsection().getDisplayName())) continue;
            if (c.getDisplayType() == DisplayType.ASCII || c.getDisplayType() == DisplayType.DATEPICKER) {
                if (c.getDisplayName().equals("User Defined Data")) {
                    ASCIIArea area = new ASCIIArea();
                    area.setColumn(c);
                    area.setVisible(subsectionVisible);
                    area.setValue(summary.getDisplayValues(c));
                    area.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                    area.setEditable(c.getEditable());
                    area.setInvalidRuleSets(summary.getRuleSetViolations(c));
                    area.managedProperty().bind((ObservableValue)area.visibleProperty());
                    area.setPopoutIcon();
                    area.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                        public void changed(ObservableValue<? extends String> obs, String ov, String nv) {
                            EditorForm.this.calculateEditedFields();
                        }
                    });
                    this.textFields.add(area);
                    AnchorPane.setLeftAnchor((Node)area, (Double)0.0);
                    AnchorPane.setRightAnchor((Node)area, (Double)0.0);
                    if (c.getEditable()) {
                        this.sectionEditableFields.getChildren().add((Object)area);
                        ++editableCount;
                    } else {
                        this.sectionNotEditableFields.getChildren().add((Object)area);
                        ++notEditableCount;
                    }
                } else {
                    field = new ASCIIField();
                    field.setColumn(c);
                    field.setVisible(subsectionVisible);
                    field.setValue(summary.getDisplayValues(c));
                    field.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                    field.setEditable(c.getEditable());
                    field.setInvalidRuleSets(summary.getRuleSetViolations(c));
                    field.managedProperty().bind((ObservableValue)field.visibleProperty());
                    if (c.getLength() >= 20) {
                        field.setPopoutIcon();
                    }
                    field.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                        public void changed(ObservableValue<? extends String> obs, String ov, String nv) {
                            EditorForm.this.calculateEditedFields();
                        }
                    });
                    this.textFields.add((IEditorField)field);
                    AnchorPane.setLeftAnchor((Node)field, (Double)0.0);
                    AnchorPane.setRightAnchor((Node)field, (Double)0.0);
                    if (c.getEditable()) {
                        this.sectionEditableFields.getChildren().add((Object)field);
                        ++editableCount;
                    } else {
                        this.sectionNotEditableFields.getChildren().add((Object)field);
                        ++notEditableCount;
                    }
                }
            } else if (c.getDisplayType() == DisplayType.INTEGER) {
                field = new IntegerField();
                field.setColumn(c);
                field.setVisible(subsectionVisible);
                field.setValue(summary.getDisplayValues(c));
                field.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                field.setEditable(c.getEditable());
                field.setInvalidRuleSets(summary.getRuleSetViolations(c));
                field.managedProperty().bind((ObservableValue)field.visibleProperty());
                field.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> obs, String ov, String nv) {
                        EditorForm.this.calculateEditedFields();
                    }
                });
                this.textFields.add((IEditorField)field);
                AnchorPane.setLeftAnchor((Node)field, (Double)0.0);
                AnchorPane.setRightAnchor((Node)field, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)field);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)field);
                    ++notEditableCount;
                }
            } else if (c.getDisplayType() == DisplayType.FLOAT) {
                textField = new FloatField();
                textField.setColumn(c);
                textField.setValue(summary.getDisplayValues(c));
                textField.setVisible(subsectionVisible);
                textField.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                textField.setEditable(c.getEditable());
                textField.setInvalidRuleSets(summary.getRuleSetViolations(c));
                textField.managedProperty().bind((ObservableValue)textField.visibleProperty());
                textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                    public void changed(ObservableValue<? extends String> obs, String ov, String nv) {
                        EditorForm.this.calculateEditedFields();
                    }
                });
                this.textFields.add((IEditorField)textField);
                AnchorPane.setLeftAnchor((Node)textField, (Double)0.0);
                AnchorPane.setRightAnchor((Node)textField, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)textField);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)textField);
                    ++notEditableCount;
                }
            } else if (c.getDisplayType() == DisplayType.BORDER_VALIDITY) {
                textField = new BorderValidityField();
                textField.setColumn(c);
                textField.setVisible(subsectionVisible);
                textField.setValue(summary.getDisplayValues(c));
                textField.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                textField.setEditable(c.getEditable());
                textField.setInvalidRuleSets(summary.getRuleSetViolations(c));
                textField.managedProperty().bind((ObservableValue)textField.visibleProperty());
                this.textFields.add((IEditorField)textField);
                AnchorPane.setLeftAnchor((Node)textField, (Double)0.0);
                AnchorPane.setRightAnchor((Node)textField, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)textField);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)textField);
                    ++notEditableCount;
                }
            } else if (c.getDisplayType() == DisplayType.PIXEL_ASPECT_RATIO) {
                textField = new PixelAspectRatioField();
                textField.setColumn(c);
                textField.setVisible(subsectionVisible);
                textField.setValue(summary.getDisplayValues(c));
                textField.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                textField.setEditable(c.getEditable());
                textField.setInvalidRuleSets(summary.getRuleSetViolations(c));
                textField.managedProperty().bind((ObservableValue)textField.visibleProperty());
                this.textFields.add((IEditorField)textField);
                AnchorPane.setLeftAnchor((Node)textField, (Double)0.0);
                AnchorPane.setRightAnchor((Node)textField, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)textField);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)textField);
                    ++notEditableCount;
                }
            }
            this.sectionNotEditableFieldsContainer.setFitToWidth(true);
            this.sectionEditableFieldsContainer.setFitToWidth(true);
        }
        this.editorAccordion.setExpandedPane(this.editableFieldsAccordion);
        this.editableFieldsAccordion.setDisable(false);
        if (notEditableCount == 0) {
            this.notEditableFieldsAccordion.setVisible(false);
        } else if (editableCount == 0) {
            this.editableFieldsAccordion.setVisible(true);
            this.editorAccordion.setExpandedPane(this.notEditableFieldsAccordion);
        }
        if (subsections.size() > 0) {
            for (String s : subsections) {
                this.subsectionDropDown.getItems().add((Object)s);
            }
            this.subsectionDropDown.getSelectionModel().selectFirst();
        } else {
            this.subsectionBox.setVisible(false);
            this.subsectionBox.managedProperty().bind((ObservableValue)this.subsectionBox.visibleProperty());
        }
        this.setNumberOfSelectedFiles(summary.getFileCount());
        this.setNumberOfEditableFields(editableCount);
        this.setNumberOfNotEditableFields(notEditableCount);
    }

    public void setSectionSecond(SectionDef section) {
        this.section = section;
        SelectedFilesSummary summary = ControllerMediatorDPX.getInstance().getSelectedFilesSummary();
        int editableCount = 0;
        int notEditableCount = 0;
        this.sectionNotEditableFields.getChildren().clear();
        this.sectionEditableFields.getChildren().clear();
        for (DPXColumn c : DPXColumn.values()) {
            if (c.getSection() != this.section) continue;
            boolean subsectionVisible = true;
            if (!this.selectedSubsection.getDisplayName().equals(c.getSubsection().getDisplayName())) continue;
            if (c.getDisplayType() == DisplayType.ASCII) {
                field = new ASCIIField();
                field.setColumn(c);
                field.setVisible(subsectionVisible);
                field.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                field.setValue(summary.getDisplayValues(c));
                field.setEditable(c.getEditable());
                field.setInvalidRuleSets(summary.getRuleSetViolations(c));
                field.managedProperty().bind((ObservableValue)field.visibleProperty());
                this.textFields.add((IEditorField)field);
                AnchorPane.setLeftAnchor((Node)field, (Double)0.0);
                AnchorPane.setRightAnchor((Node)field, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)field);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)field);
                    ++notEditableCount;
                }
            } else if (c.getDisplayType() == DisplayType.INTEGER) {
                field = new IntegerField();
                field.setColumn(c);
                field.setVisible(subsectionVisible);
                field.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                field.setValue(summary.getDisplayValues(c));
                field.setEditable(c.getEditable());
                field.setInvalidRuleSets(summary.getRuleSetViolations(c));
                field.managedProperty().bind((ObservableValue)field.visibleProperty());
                this.textFields.add((IEditorField)field);
                AnchorPane.setLeftAnchor((Node)field, (Double)0.0);
                AnchorPane.setRightAnchor((Node)field, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)field);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)field);
                    ++notEditableCount;
                }
            } else if (c.getDisplayType() == DisplayType.DROPDOWN) {
                textField = new DropDownField();
                textField.setColumn(c);
                textField.setVisible(subsectionVisible);
                textField.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                textField.setValue(summary.getDisplayValues(c));
                textField.setEditable(c.getEditable());
                textField.setInvalidRuleSets(summary.getRuleSetViolations(c));
                textField.managedProperty().bind((ObservableValue)textField.visibleProperty());
                this.textFields.add((IEditorField)textField);
                AnchorPane.setLeftAnchor((Node)textField, (Double)0.0);
                AnchorPane.setRightAnchor((Node)textField, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)textField);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)textField);
                    ++notEditableCount;
                }
            } else if (c.getDisplayType() == DisplayType.DATEPICKER) {
                textField = new DatePickerField();
                textField.setColumn(c);
                textField.setVisible(subsectionVisible);
                textField.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                textField.setValue(summary.getDisplayValues(c));
                textField.setEditable(c.getEditable());
                textField.setInvalidRuleSets(summary.getRuleSetViolations(c));
                textField.managedProperty().bind((ObservableValue)textField.visibleProperty());
                this.textFields.add((IEditorField)textField);
                AnchorPane.setLeftAnchor((Node)textField, (Double)0.0);
                AnchorPane.setRightAnchor((Node)textField, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)textField);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)textField);
                    ++notEditableCount;
                }
            } else if (c.getDisplayType() == DisplayType.FLOAT) {
                textField = new FloatField();
                textField.setColumn(c);
                textField.setVisible(subsectionVisible);
                textField.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                textField.setValue(summary.getDisplayValues(c));
                textField.setEditable(c.getEditable());
                textField.setInvalidRuleSets(summary.getRuleSetViolations(c));
                textField.managedProperty().bind((ObservableValue)textField.visibleProperty());
                this.textFields.add((IEditorField)textField);
                AnchorPane.setLeftAnchor((Node)textField, (Double)0.0);
                AnchorPane.setRightAnchor((Node)textField, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)textField);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)textField);
                    ++notEditableCount;
                }
            } else if (c.getDisplayType() == DisplayType.BORDER_VALIDITY) {
                textField = new BorderValidityField();
                textField.setColumn(c);
                textField.setVisible(subsectionVisible);
                textField.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                textField.setValue(summary.getDisplayValues(c));
                textField.setEditable(c.getEditable());
                textField.setInvalidRuleSets(summary.getRuleSetViolations(c));
                textField.managedProperty().bind((ObservableValue)textField.visibleProperty());
                this.textFields.add((IEditorField)textField);
                AnchorPane.setLeftAnchor((Node)textField, (Double)0.0);
                AnchorPane.setRightAnchor((Node)textField, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)textField);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)textField);
                    ++notEditableCount;
                }
            } else if (c.getDisplayType() == DisplayType.PIXEL_ASPECT_RATIO) {
                textField = new PixelAspectRatioField();
                textField.setColumn(c);
                textField.setVisible(subsectionVisible);
                textField.setLabel(c.getDisplayName(), DPXColumnHelpText.getInstance().getHelpText(c), "#000000");
                textField.setValue(summary.getDisplayValues(c));
                textField.setEditable(c.getEditable());
                textField.setInvalidRuleSets(summary.getRuleSetViolations(c));
                textField.managedProperty().bind((ObservableValue)textField.visibleProperty());
                this.textFields.add((IEditorField)textField);
                AnchorPane.setLeftAnchor((Node)textField, (Double)0.0);
                AnchorPane.setRightAnchor((Node)textField, (Double)0.0);
                if (c.getEditable()) {
                    this.sectionEditableFields.getChildren().add((Object)textField);
                    ++editableCount;
                } else {
                    this.sectionNotEditableFields.getChildren().add((Object)textField);
                    ++notEditableCount;
                }
            }
            this.sectionNotEditableFieldsContainer.setFitToWidth(true);
            this.sectionEditableFieldsContainer.setFitToWidth(true);
        }
        this.editorAccordion.setExpandedPane(this.editableFieldsAccordion);
        if (notEditableCount == 0) {
            this.notEditableFieldsAccordion.setVisible(false);
        } else if (editableCount == 0) {
            this.editableFieldsAccordion.setVisible(false);
            this.editorAccordion.setExpandedPane(this.notEditableFieldsAccordion);
        }
        this.setNumberOfSelectedFiles(summary.getFileCount());
        this.setNumberOfEditableFields(editableCount);
        this.setNumberOfNotEditableFields(notEditableCount);
    }

    public void setTitle(String title) {
        this.sectionLabel.setText(title);
        this.sectionLabel.setAccessibleText(title);
        this.sectionLabel.setFocusTraversable(true);
    }

    public void setVisibility(String subsectionDisplayName) {
        for (DPXImageElement ss : DPXImageElement.values()) {
            if (!subsectionDisplayName.equals(ss.getDisplayName())) continue;
            this.selectedSubsection = ss;
            this.setSectionSecond(this.section);
            break;
        }
    }

    private void showAlert(String modalTitle, String alertText) {
        Alert alert = AccessibleAlertHelper.CreateAccessibleAlert(modalTitle, Alert.AlertType.NONE, alertText, ButtonType.CLOSE);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.lookupButton(ButtonType.CLOSE).setAccessibleHelp(alertText);
        dialogPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"alertDialog");
        alert.showAndWait();
        if (alert.getResult() == ButtonType.CLOSE) {
            alert.close();
        }
    }

    private void showConfirmation(String modalTitle, String confirmationText) {
        Alert alert = AccessibleAlertHelper.CreateAccessibleAlert(modalTitle, Alert.AlertType.NONE, confirmationText, ButtonType.CANCEL, ButtonType.OK);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.lookupButton(ButtonType.OK).setAccessibleHelp(confirmationText);
        dialogPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"alertDialog");
        alert.showAndWait();
        if (alert.getResult() == ButtonType.CANCEL) {
            alert.close();
        } else if (alert.getResult() == ButtonType.OK) {
            this.setSection(this.section, true);
        }
    }
}

