/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import com.portalmedia.embarc.gui.AccessibleAlertHelper;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.validation.DPXColumnValidationRules;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javafx.geometry.Pos;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class ValidationWarningHelper {
    public static HBox setInvalidRuleSets(Set<ValidationRuleSetEnum> invalidRuleSet) {
        HBox warningIcons = new HBox();
        if (invalidRuleSet == null) {
            return warningIcons;
        }
        for (ValidationRuleSetEnum rule : invalidRuleSet) {
            FontIcon icon;
            if (rule == ValidationRuleSetEnum.FADGI_O) {
                icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_CIRCLE);
                icon.getStyleClass().add((Object)"fadgi-o-warning");
                icon.setIconSize(18);
                warningIcons.getChildren().add((Object)icon);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_R) {
                icon = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION_TRIANGLE);
                icon.getStyleClass().add((Object)"fadgi-r-warning");
                icon.setIconSize(16);
                warningIcons.getChildren().add((Object)icon);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_SR) {
                icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_OCTAGON);
                icon.getStyleClass().add((Object)"fadgi-sr-warning");
                icon.setIconSize(18);
                warningIcons.getChildren().add((Object)icon);
                continue;
            }
            if (rule != ValidationRuleSetEnum.SMPTE_C) continue;
            icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_BOX);
            icon.getStyleClass().add((Object)"smpte-c-warning");
            icon.setIconSize(18);
            warningIcons.getChildren().add((Object)icon);
        }
        return warningIcons;
    }

    public static boolean getInvalidRuleSetsAndUpdateErrorIcons(HBox warningIcons, Set<ValidationRuleSetEnum> invalidRuleSet, ColumnDef fieldName) {
        if (warningIcons == null) {
            return false;
        }
        warningIcons.getChildren().clear();
        boolean hasInvalidRules = false;
        HashMap<ValidationRuleSetEnum, List<IValidationRule>> validationRuleSet = DPXColumnValidationRules.getInstance().getRuleSet(fieldName);
        String ruleText = "No rule set";
        for (ValidationRuleSetEnum rule : invalidRuleSet) {
            HBox iconHbox;
            FontIcon icon;
            if (rule == ValidationRuleSetEnum.FADGI_O) {
                for (ValidationRuleSetEnum key : validationRuleSet.keySet()) {
                    if (key != rule) continue;
                    for (IValidationRule vRule : validationRuleSet.get((Object)key)) {
                        ruleText = vRule.getRule();
                    }
                }
                hasInvalidRules = true;
                icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_CIRCLE);
                icon.setAccessibleText(ruleText);
                icon.getStyleClass().add((Object)"fadgi-o-warning-clickable");
                iconHbox = ValidationWarningHelper.CreateValidationIcon("FADGI-O", ruleText);
                iconHbox.getChildren().add((Object)icon);
                warningIcons.getChildren().add((Object)iconHbox);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_R) {
                for (ValidationRuleSetEnum key : validationRuleSet.keySet()) {
                    if (key != rule) continue;
                    for (IValidationRule vRule : validationRuleSet.get((Object)key)) {
                        ruleText = vRule.getRule();
                    }
                }
                hasInvalidRules = true;
                icon = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION_TRIANGLE);
                icon.setAccessibleText(ruleText);
                icon.getStyleClass().add((Object)"fadgi-r-warning-clickable");
                iconHbox = ValidationWarningHelper.CreateValidationIcon("FADGI-R", ruleText);
                iconHbox.getChildren().add((Object)icon);
                warningIcons.getChildren().add((Object)iconHbox);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_SR) {
                for (ValidationRuleSetEnum key : validationRuleSet.keySet()) {
                    if (key != rule) continue;
                    for (IValidationRule vRule : validationRuleSet.get((Object)key)) {
                        ruleText = vRule.getRule();
                    }
                }
                hasInvalidRules = true;
                icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_OCTAGON);
                icon.setAccessibleText(ruleText);
                icon.getStyleClass().add((Object)"fadgi-sr-warning-clickable");
                iconHbox = ValidationWarningHelper.CreateValidationIcon("FADGI-SR", ruleText);
                iconHbox.getChildren().add((Object)icon);
                warningIcons.getChildren().add((Object)iconHbox);
                continue;
            }
            if (rule != ValidationRuleSetEnum.SMPTE_C) continue;
            for (ValidationRuleSetEnum key : validationRuleSet.keySet()) {
                if (key != rule) continue;
                for (IValidationRule vRule : validationRuleSet.get((Object)key)) {
                    ruleText = vRule.getRule();
                }
            }
            hasInvalidRules = true;
            icon = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_BOX);
            icon.setAccessibleText(ruleText);
            icon.getStyleClass().add((Object)"smpte-c-warning-clickable");
            iconHbox = ValidationWarningHelper.CreateValidationIcon("SMPTE-C", ruleText);
            iconHbox.getChildren().add((Object)icon);
            warningIcons.getChildren().add((Object)iconHbox);
        }
        return hasInvalidRules;
    }

    public static HBox CreateValidationIcon(String titleText, String ruleText) {
        HBox iconHbox = new HBox();
        iconHbox.setFocusTraversable(true);
        iconHbox.getStyleClass().add((Object)"hbox");
        iconHbox.setAlignment(Pos.CENTER_RIGHT);
        iconHbox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.SPACE) {
                ValidationWarningHelper.showValidationErrorAlert(titleText, ruleText);
            }
        });
        iconHbox.setOnMouseClicked(event -> ValidationWarningHelper.showValidationErrorAlert(titleText, ruleText));
        iconHbox.setAccessibleRole(AccessibleRole.BUTTON);
        iconHbox.setAccessibleText(titleText + " Open modal for details.");
        return iconHbox;
    }

    public static void showValidationErrorAlert(String ruleLabelText, String errorText) {
        Alert alert = AccessibleAlertHelper.CreateAccessibleAlert(ruleLabelText, Alert.AlertType.NONE, errorText, ButtonType.CLOSE);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        DialogPane dialogPane = alert.getDialogPane();
        dialogPane.lookupButton(ButtonType.CLOSE).setAccessibleHelp(errorText);
        dialogPane.getStylesheets().add((Object)ValidationWarningHelper.class.getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"alertDialog");
        alert.showAndWait();
        if (alert.getResult() == ButtonType.CLOSE) {
            alert.close();
        }
    }
}

