/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import com.portalmedia.embarc.gui.DataFieldInfoAlert;
import com.portalmedia.embarc.gui.IEditorField;
import com.portalmedia.embarc.gui.IntegerInputControl;
import com.portalmedia.embarc.gui.ValidationWarningHelper;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.StringProperty;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class IntegerField
extends AnchorPane
implements IEditorField {
    @FXML
    private HBox editorTextFieldContainer;
    @FXML
    private Label editorTextFieldLabel;
    @FXML
    private HBox editorTextFieldLabelInfoIcon;
    @FXML
    private IntegerInputControl editorTextField;
    @FXML
    private HBox editorTextFieldValidationInfo;
    private DPXColumn column;
    private String originalValue;
    private MXFColumn mxfColumn;

    public IntegerField() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("IntegerField.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void clearValidation() {
        this.setInvalidRuleSets(new HashSet<ValidationRuleSetEnum>());
    }

    @Override
    public DPXColumn getColumn() {
        return this.column;
    }

    @Override
    public String getValue() {
        return this.editorTextField.getText();
    }

    @Override
    public void resetValueChanged() {
        this.originalValue = null;
    }

    @Override
    public void setColumn(DPXColumn column) {
        this.column = column;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editorTextField.setEditable(editable);
    }

    @Override
    public void setInvalidRuleSets(Set<ValidationRuleSetEnum> invalidRuleSet) {
        boolean hasErrors = ValidationWarningHelper.getInvalidRuleSetsAndUpdateErrorIcons(this.editorTextFieldValidationInfo, invalidRuleSet, this.getColumn());
        String validationWarning = hasErrors ? "Contains errors" : "";
        this.editorTextField.setAccessibleHelp(validationWarning);
    }

    @Override
    public void setLabel(String text) {
        this.editorTextFieldLabel.setText(text);
        this.editorTextFieldLabel.setLabelFor((Node)this.editorTextField);
    }

    @Override
    public void setLabel(String labelText, String helpText) {
        this.editorTextFieldLabelInfoIcon.setOnKeyPressed(event -> {
            if (event.getCode() != KeyCode.SPACE) {
                return;
            }
            DataFieldInfoAlert.showFieldInfoAlert(labelText, helpText);
        });
        this.editorTextFieldLabelInfoIcon.setOnMouseClicked(event -> DataFieldInfoAlert.showFieldInfoAlert(labelText, helpText));
        this.setLabel(labelText);
        this.editorTextFieldLabelInfoIcon.setAccessibleRole(AccessibleRole.BUTTON);
        this.editorTextFieldLabelInfoIcon.setAccessibleText("Open modal with field specification.");
    }

    @Override
    public void setLabel(String labelText, String helpText, String labelColor) {
        this.editorTextFieldLabel.setTextFill((Paint)Color.web((String)labelColor));
        this.setLabel(labelText, helpText);
    }

    @Override
    public void setPopoutIcon() {
    }

    @Override
    public void setValue(String value) {
        if (this.originalValue == null) {
            this.originalValue = value;
        }
        this.editorTextField.setText(value);
    }

    public StringProperty textProperty() {
        return this.editorTextField.textProperty();
    }

    @Override
    public boolean valueChanged() {
        if (this.originalValue == null) {
            return false;
        }
        return !this.originalValue.equals(this.editorTextField.getText());
    }

    public void setMXFColumn(MXFColumn col) {
        this.mxfColumn = col;
    }

    @Override
    public MXFColumn getMXFColumn() {
        return this.mxfColumn;
    }
}

