/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import com.portalmedia.embarc.gui.DataFieldInfoAlert;
import com.portalmedia.embarc.gui.IEditorField;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.MaxLengthChangeListener;
import com.portalmedia.embarc.gui.ValidationWarningHelper;
import com.portalmedia.embarc.gui.dpx.ValidationChangeListener;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.kordamp.ikonli.javafx.FontIcon;

public class ASCIIArea
extends AnchorPane
implements IEditorField {
    @FXML
    private HBox editorTextAreaContainer;
    @FXML
    private Label editorTextAreaLabel;
    @FXML
    private HBox editorTextAreaLabelInfoIcon;
    @FXML
    private TextArea editorTextArea;
    @FXML
    private FontIcon popoutIcon;
    @FXML
    private HBox popoutIconContainer;
    @FXML
    private HBox editorTextAreaValidationInfo;
    private DPXColumn column;
    private String originalValue;
    private MXFColumn mxfColumn;

    public ASCIIArea() {
        FXMLLoader fxmlLoader = new FXMLLoader(this.getClass().getResource("ASCIIArea.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void clearValidation() {
        this.setInvalidRuleSets(new HashSet<ValidationRuleSetEnum>());
    }

    @Override
    public DPXColumn getColumn() {
        return this.column;
    }

    @Override
    public String getValue() {
        return this.editorTextArea.getText();
    }

    @Override
    public void resetValueChanged() {
        this.originalValue = null;
    }

    @Override
    public void setColumn(DPXColumn column) {
        if (this.column == null) {
            this.editorTextArea.textProperty().addListener((ChangeListener)new MaxLengthChangeListener(this.editorTextArea, column.getLength()));
            this.editorTextArea.textProperty().addListener((ChangeListener)new ValidationChangeListener(this.editorTextArea, (ColumnDef)column, this.editorTextAreaValidationInfo));
        }
        this.column = column;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editorTextArea.setEditable(editable);
    }

    @Override
    public void setInvalidRuleSets(Set<ValidationRuleSetEnum> invalidRuleSet) {
        boolean hasErrors = ValidationWarningHelper.getInvalidRuleSetsAndUpdateErrorIcons(this.editorTextAreaValidationInfo, invalidRuleSet, this.getColumn());
        String validationWarning = hasErrors ? "Contains errors" : "";
        this.editorTextArea.setAccessibleHelp(validationWarning);
    }

    @Override
    public void setLabel(String text) {
        this.editorTextAreaLabel.setText(text);
        this.editorTextAreaLabel.setLabelFor((Node)this.editorTextArea);
    }

    @Override
    public void setLabel(String labelText, String helpText, String labelColor) {
        this.editorTextAreaLabel.setTextFill((Paint)Color.web((String)labelColor));
        this.setLabel(labelText, helpText);
    }

    @Override
    public void setLabel(String labelText, String helpText) {
        this.editorTextAreaLabelInfoIcon.setOnKeyPressed(event -> {
            if (event.getCode() != KeyCode.SPACE) {
                return;
            }
            DataFieldInfoAlert.showFieldInfoAlert(labelText, helpText);
        });
        this.editorTextAreaLabelInfoIcon.setOnMouseClicked(event -> DataFieldInfoAlert.showFieldInfoAlert(labelText, helpText));
        this.setLabel(labelText);
        this.editorTextAreaLabelInfoIcon.setAccessibleRole(AccessibleRole.BUTTON);
        this.editorTextAreaLabelInfoIcon.setAccessibleText("Open modal with " + labelText + " specification.");
    }

    @Override
    public void setPopoutIcon() {
        if (!this.editorTextArea.isEditable()) {
            return;
        }
        this.popoutIconContainer.setVisible(true);
        this.popoutIconContainer.setOnKeyPressed(event -> {
            if (event.getCode() != KeyCode.SPACE) {
                return;
            }
            this.showPopoutAlert();
        });
        this.popoutIconContainer.setOnMouseClicked(event -> this.showPopoutAlert());
        this.popoutIconContainer.setAccessibleRole(AccessibleRole.BUTTON);
        this.popoutIconContainer.setAccessibleText("Open modal to edit " + this.editorTextAreaLabel.getText());
    }

    @Override
    public void setValue(String value) {
        this.editorTextArea.setText(value);
        if (this.originalValue == null) {
            this.originalValue = this.editorTextArea.getText();
        }
    }

    public StringProperty textProperty() {
        return this.editorTextArea.textProperty();
    }

    @Override
    public boolean valueChanged() {
        if (this.originalValue == null) {
            return false;
        }
        return !this.originalValue.equals(this.editorTextArea.getText());
    }

    public void setMXFColumn(MXFColumn col) {
        if (this.mxfColumn == null) {
            this.mxfColumn = col;
        }
    }

    @Override
    public MXFColumn getMXFColumn() {
        return this.mxfColumn;
    }

    private void showPopoutAlert() {
        Alert alert = new Alert(Alert.AlertType.NONE);
        alert.setTitle("Edit " + this.editorTextAreaLabel.getText());
        alert.setHeaderText(null);
        alert.setContentText(null);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        Object[] buttonList = new ButtonType[2];
        if (this.column != null) {
            if (this.column.getEditable()) {
                buttonList[0] = ButtonType.APPLY;
                buttonList[1] = ButtonType.CLOSE;
            } else {
                buttonList[0] = ButtonType.CLOSE;
            }
        } else if (this.mxfColumn != null) {
            if (this.mxfColumn.getEditable()) {
                buttonList[0] = ButtonType.APPLY;
                buttonList[1] = ButtonType.CLOSE;
            } else {
                buttonList[0] = ButtonType.CLOSE;
            }
        }
        alert.getButtonTypes().setAll(buttonList);
        Label label = new Label(this.editorTextAreaLabel.getText());
        TextArea textArea = new TextArea(this.editorTextArea.getText());
        textArea.setEditable(true);
        textArea.setWrapText(true);
        textArea.setMaxWidth(Double.MAX_VALUE);
        textArea.setMaxHeight(Double.MAX_VALUE);
        GridPane.setVgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)textArea, (Priority)Priority.ALWAYS);
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)label, 0, 0);
        expContent.add((Node)textArea, 0, 1);
        alert.getDialogPane().setContent((Node)expContent);
        alert.showAndWait();
        if (alert.getResult() == ButtonType.APPLY) {
            String value = textArea.getText();
            this.editorTextArea.setText(value);
            alert.close();
        } else if (alert.getResult() == ButtonType.CLOSE) {
            alert.close();
        }
    }
}

