/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.cli;

import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.MetadataColumn;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.dpx.DPXFileInformation;
import com.portalmedia.embarc.parser.dpx.DPXMetadata;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javafx.collections.ObservableList;
import org.supercsv.io.CsvMapWriter;
import org.supercsv.io.ICsvMapWriter;
import org.supercsv.prefs.CsvPreference;

public class CsvWriterDpx {
    private static String[] headers = null;

    public static void writeCsvDPXFiles(String outputPath, TreeMap<String, DPXFileInformation> dpxFileList) throws IOException {
        try (FileWriter fileWriter = new FileWriter(outputPath);
             CsvMapWriter csvWriter = new CsvMapWriter((Writer)fileWriter, CsvPreference.STANDARD_PREFERENCE);){
            csvWriter.writeHeader(CsvWriterDpx.getHeaderColumns());
            for (DPXFileInformation fileInfo : dpxFileList.values()) {
                CsvWriterDpx.csvDPXMetadata(fileInfo, (ICsvMapWriter)csvWriter);
            }
        }
    }

    public static void writeCsvDPXFilesFromViewModel(String outputPath, ObservableList<DPXFileInformationViewModel> dpxFileList) throws IOException {
        try (FileWriter fileWriter = new FileWriter(outputPath);
             CsvMapWriter csvWriter = new CsvMapWriter((Writer)fileWriter, CsvPreference.STANDARD_PREFERENCE);){
            csvWriter.writeHeader(CsvWriterDpx.getHeaderColumns());
            for (DPXFileInformationViewModel fileInfo : dpxFileList) {
                CsvWriterDpx.csvDPXMetadataFromViewModel(fileInfo, (ICsvMapWriter)csvWriter);
            }
        }
    }

    private static void csvDPXMetadataFromViewModel(DPXFileInformationViewModel dpxFileInfoVM, ICsvMapWriter csvWriter) throws IOException {
        HashMap<String, Object> dpxItem = new HashMap<String, Object>();
        String filePath = dpxFileInfoVM.getProp("path");
        String fileName = dpxFileInfoVM.getProp("name");
        File file = new File(filePath);
        dpxItem.put("FileName", fileName);
        dpxItem.put("FilePath", filePath);
        dpxItem.put("FileSize", file.length());
        DPXColumn[] dPXColumnArray = DPXColumn.values();
        int n = dPXColumnArray.length;
        for (int i = 0; i < n; ++i) {
            DPXColumn c;
            DPXColumn cdef = c = dPXColumnArray[i];
            String value = dpxFileInfoVM.getProp(cdef);
            dpxItem.put(cdef.getDisplayName(), value);
        }
        csvWriter.write(dpxItem, CsvWriterDpx.getHeaderColumns());
    }

    private static void setHeaderColumns() {
        ArrayList<String> headerList = new ArrayList<String>();
        headerList.add("FileName");
        headerList.add("FilePath");
        headerList.add("FileSize");
        for (DPXColumn c : DPXColumn.values()) {
            Object subsection;
            Object printName = c.getDisplayName();
            String currentSection = "";
            if (!currentSection.equals(c.getSectionDisplayName())) {
                currentSection = c.getSectionDisplayName();
            }
            if ("Image Information".equals(currentSection) && (subsection = c.getSubsection().getDisplayName()) != "") {
                printName = subsection = (String)subsection + " - " + (String)printName;
            }
            headerList.add((String)printName);
        }
        headers = headerList.toArray(new String[0]);
    }

    private static String[] getHeaderColumns() {
        if (headers == null) {
            CsvWriterDpx.setHeaderColumns();
        }
        return headers;
    }

    private static void csvDPXMetadata(DPXFileInformation dpxFileInfo, ICsvMapWriter csvWriter) throws IOException {
        System.out.println("\n" + dpxFileInfo.getName());
        DPXMetadata data = dpxFileInfo.getFileData();
        LinkedHashMap<ColumnDef, MetadataColumn> metadata = data.getMetadataHashMap();
        HashMap<String, Object> dpxItem = new HashMap<String, Object>();
        File file = new File(dpxFileInfo.getPath());
        dpxItem.put("FileName", dpxFileInfo.getName());
        dpxItem.put("FilePath", dpxFileInfo.getPath());
        dpxItem.put("FileSize", file.length());
        for (Map.Entry<ColumnDef, MetadataColumn> entry : metadata.entrySet()) {
            ColumnDef key = entry.getKey();
            MetadataColumn value = entry.getValue();
            dpxItem.put(key.getDisplayName(), value.getStandardizedValue());
        }
        csvWriter.write(dpxItem, CsvWriterDpx.getHeaderColumns());
    }
}

