/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser;

import com.portalmedia.embarc.parser.ByteOrderEnum;
import com.portalmedia.embarc.parser.BytesToStringHelper;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MetadataColumn
implements Serializable,
MetadataColumnDef {
    private static final long serialVersionUID = 1L;
    ColumnDef columnDef;
    Class<?> type;
    String name;
    public ByteOrderEnum byteOrder;
    protected byte[] currentValue;

    public MetadataColumn() {
    }

    public MetadataColumn(ColumnDef columnDef, String value) {
        this.columnDef = columnDef;
        this.name = columnDef.getDisplayName();
        this.type = columnDef.getType();
    }

    public MetadataColumn(ColumnDef columnDef, ByteOrderEnum byteOrder) {
        this.columnDef = columnDef;
        this.name = columnDef.getDisplayName();
        this.type = columnDef.getType();
        this.setByteOrder(byteOrder);
    }

    public ByteOrder getByteOrder() {
        if (this.byteOrder == ByteOrderEnum.BIG) {
            return ByteOrder.BIG_ENDIAN;
        }
        return ByteOrder.LITTLE_ENDIAN;
    }

    @Override
    public ColumnDef getColumnDef() {
        return this.columnDef;
    }

    public int getInt() {
        return ByteBuffer.wrap(this.currentValue).order(this.getByteOrder()).getInt();
    }

    public boolean isNull() {
        for (byte b : this.currentValue) {
            if (b == -1) continue;
            return false;
        }
        return true;
    }

    private void setByteOrder(ByteOrderEnum bo) {
        this.byteOrder = bo;
    }

    public void setValue(byte[] newValue) {
        this.currentValue = newValue;
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return "";
        }
        return BytesToStringHelper.toTypedString(this.type, this.currentValue, this.getByteOrder());
    }

    @Override
    public String getCurrentValue() {
        return BytesToStringHelper.toTypedString(this.type, this.currentValue, this.getByteOrder());
    }

    public String getStandardizedValue() {
        return BytesToStringHelper.toStandardizedTypedString(this.type, this.currentValue, this.getByteOrder());
    }
}

