/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.ProgressDialog;
import com.portalmedia.embarc.gui.helper.MXFFileList;
import com.portalmedia.embarc.parser.FileInformation;
import com.portalmedia.embarc.parser.mxf.MXFFileWriteResult;
import com.portalmedia.embarc.parser.mxf.MXFMetadata;
import com.portalmedia.embarc.parser.mxf.MXFServiceImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogEvent;
import javafx.scene.text.Text;

public class WriteFilesDialogMXF
extends Dialog {
    private boolean writeEditedOnly = false;
    private int success = 0;
    private int failures = 0;
    private Map<String, Exception> exceptions = new LinkedHashMap<String, Exception>();
    private List<FileInformation<MXFMetadata>> fileListCopy = new ArrayList<FileInformation<MXFMetadata>>();
    private static final Logger LOGGER = Logger.getLogger(Main.class.getClass().getName());

    public WriteFilesDialogMXF(String filePath, boolean writeEditedOnly) throws FileNotFoundException {
        this.writeEditedOnly = writeEditedOnly;
        this.writeFiles(filePath);
    }

    private void writeFiles(final String filePath) throws FileNotFoundException {
        List<FileInformation<MXFMetadata>> originalFileList = MXFFileList.getList();
        if (!this.writeEditedOnly) {
            this.fileListCopy = new ArrayList<FileInformation<MXFMetadata>>(originalFileList);
        } else {
            for (FileInformation<MXFMetadata> file : originalFileList) {
                if (!file.isEdited() || !file.getFileShouldBeWritten()) continue;
                this.fileListCopy.add(file);
            }
        }
        Task<Void> task = new Task<Void>(){

            public Void call() {
                System.currentTimeMillis();
                if (WriteFilesDialogMXF.this.fileListCopy.isEmpty()) {
                    this.updateProgress(100L, 100L);
                    this.cancel();
                }
                int count = 0;
                int fileCount = WriteFilesDialogMXF.this.fileListCopy.size();
                double processed = 0.0;
                for (FileInformation<MXFMetadata> file : WriteFilesDialogMXF.this.fileListCopy) {
                    block8: {
                        try {
                            if (WriteFilesDialogMXF.this.writeEditedOnly && !file.isEdited()) continue;
                            String inputPath = file.getPath();
                            Object outputPath = inputPath;
                            if (!filePath.isEmpty()) {
                                outputPath = filePath + File.separator + file.getName();
                            }
                            LOGGER.info("Writing " + inputPath + " to " + (String)outputPath);
                            try {
                                MXFServiceImpl mxfService = new MXFServiceImpl(inputPath);
                                MXFFileWriteResult result = mxfService.writeFile((String)outputPath, file.getFileData().getCoreColumns());
                                if (result.isSuccess()) {
                                    ++WriteFilesDialogMXF.this.success;
                                    file.setFileShouldBeWritten(false);
                                    break block8;
                                }
                                ++WriteFilesDialogMXF.this.failures;
                                WriteFilesDialogMXF.this.exceptions.put(WriteFilesDialogMXF.this.exceptions.size() + 1 + ". " + file.getName(), result.getException());
                            }
                            catch (IOException e) {
                                LOGGER.log(Level.SEVERE, e.toString(), e);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.SEVERE, e.toString(), e);
                        }
                    }
                    processed = ++count * 100 / fileCount;
                    this.updateProgress(processed, 100.0);
                }
                return null;
            }
        };
        ProgressDialog progressDialog = new ProgressDialog();
        progressDialog.activateProgressBar(task);
        progressDialog.getDialogAlert().show();
        Text filesToProcess = new Text("Files to Write: " + Integer.toString(this.fileListCopy.size()));
        progressDialog.setCountLabel((Node)filesToProcess);
        progressDialog.getDialogAlert().setOnCloseRequest(arg_0 -> WriteFilesDialogMXF.lambda$writeFiles$0((Task)task, arg_0));
        new Thread((Runnable)task).start();
        task.setOnSucceeded(e -> {
            Text filesWritten = new Text("File Writing Complete!");
            progressDialog.setCountLabel((Node)filesWritten);
            ArrayList<Text> labels = new ArrayList<Text>();
            labels.add(new Text("Total Files Written: " + this.success));
            labels.add(new Text("Total Failures: " + this.failures));
            progressDialog.showLabels(labels);
            progressDialog.showExceptions(this.exceptions);
            progressDialog.showCloseButton();
        });
        task.setOnCancelled(e -> {
            Text filesWritten = new Text("WRITE FILES CANCELLED");
            progressDialog.setCountLabel((Node)filesWritten);
            ArrayList<Text> labels = new ArrayList<Text>();
            labels.add(new Text("No edited files were found."));
            progressDialog.showLabels(labels);
            progressDialog.cancelProgressBar();
            progressDialog.showCloseButton();
        });
    }

    private static /* synthetic */ void lambda$writeFiles$0(Task task, DialogEvent e) {
        if (task.isRunning()) {
            System.out.println("WRITE FILES CANCELLED BY USER");
            task.cancel();
        }
    }
}

