/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.system;

import com.portalmedia.embarc.parser.dpx.DPXDataTemplate;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dizitart.no2.objects.Id;

public class UserPreferences {
    @Id
    int id;
    List<ValidationRuleSetEnum> ruleSets = new ArrayList<ValidationRuleSetEnum>();
    List<String> hiddenDPXColumns = new ArrayList<String>();
    boolean saveImageChecksums;
    String imageChecksumReportPath;
    String imageChecksumValidationReportPath;
    String saveToPath;
    String validationReportPath;
    boolean saveToSeparateDirectory;
    boolean writeOnlyEditedFiles;
    HashMap<String, DPXDataTemplate> dpxDataTemplates = new HashMap();

    public UserPreferences() {
        this.ruleSets.add(ValidationRuleSetEnum.SMPTE_C);
        this.id = 1;
        this.saveImageChecksums = true;
        this.writeOnlyEditedFiles = true;
    }

    public void addHiddenDPXColumn(String column) {
        if (!this.hiddenDPXColumns.contains(column)) {
            this.hiddenDPXColumns.add(column);
        }
    }

    public HashMap<String, DPXDataTemplate> getDPXDataTemplates() {
        return this.dpxDataTemplates;
    }

    public void addOrUpdateDPXDataTemplate(DPXDataTemplate template) {
        this.dpxDataTemplates.put(template.getName(), template);
    }

    public void addRuleSet(ValidationRuleSetEnum ruleSet) {
        if (!this.ruleSets.contains((Object)ruleSet)) {
            this.ruleSets.add(ruleSet);
        }
    }

    public List<String> getHiddenDPXColumns() {
        return this.hiddenDPXColumns;
    }

    public String getImageChecksumReportPath() {
        return this.imageChecksumReportPath;
    }

    public String getImageChecksumValidationReportPath() {
        return this.imageChecksumValidationReportPath;
    }

    public List<ValidationRuleSetEnum> getRuleSets() {
        return this.ruleSets;
    }

    public String getSaveToPath() {
        return this.saveToPath;
    }

    public boolean getSaveToSeparateDirectory() {
        return this.saveToSeparateDirectory;
    }

    public String getValidationReportPath() {
        return this.validationReportPath;
    }

    public boolean isRuleSetSelected(ValidationRuleSetEnum rule) {
        return this.ruleSets.contains((Object)rule);
    }

    public boolean isSaveImageChecksums() {
        return this.saveImageChecksums;
    }

    public boolean isWriteOnlyEditedFiles() {
        return this.writeOnlyEditedFiles;
    }

    public void removeDPXDataTemplate(String templateName) {
        this.dpxDataTemplates.remove(templateName);
    }

    public void removeHiddenDPXColumn(String column) {
        this.hiddenDPXColumns.remove(column);
    }

    public void removeRuleSet(ValidationRuleSetEnum ruleSet) {
        this.ruleSets.remove((Object)ruleSet);
    }

    public void setImageChecksumReportPath(String imageChecksumReportPath) {
        this.imageChecksumReportPath = imageChecksumReportPath;
    }

    public void setImageChecksumValidationReportPath(String imageChecksumValidationReportPath) {
        this.imageChecksumValidationReportPath = imageChecksumValidationReportPath;
    }

    public void setRuleSets(List<ValidationRuleSetEnum> ruleSets) {
        this.ruleSets = ruleSets;
    }

    public void setSaveImageChecksums(boolean saveImageChecksums) {
        this.saveImageChecksums = saveImageChecksums;
    }

    public void setSaveToPath(String saveToPath) {
        this.saveToPath = saveToPath;
    }

    public void setSaveToSeparateDirectory(boolean saveToSeparateDirectory) {
        this.saveToSeparateDirectory = saveToSeparateDirectory;
    }

    public void setValidationReportPath(String path) {
        this.validationReportPath = path;
    }

    public void setWriteOnlyEditedFiles(boolean writeOnlyEditedFiles) {
        this.writeOnlyEditedFiles = writeOnlyEditedFiles;
    }
}

