/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.mxf;

import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.parser.FileInformation;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import com.portalmedia.embarc.parser.StringMetadataColumn;
import com.portalmedia.embarc.parser.mxf.AudioTrackLayoutValues;
import com.portalmedia.embarc.parser.mxf.DeviceSetHelper;
import com.portalmedia.embarc.parser.mxf.EmbARCIdentification;
import com.portalmedia.embarc.parser.mxf.IdentifierSetHelper;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import com.portalmedia.embarc.parser.mxf.MXFFileDescriptorResult;
import com.portalmedia.embarc.parser.mxf.MXFFileWriteResult;
import com.portalmedia.embarc.parser.mxf.MXFMetadata;
import com.portalmedia.embarc.parser.mxf.MXFService;
import com.portalmedia.embarc.parser.mxf.ManifestParserImpl;
import com.portalmedia.embarc.parser.mxf.ManifestType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.io.mxf.BodyPartition;
import tv.amwa.maj.io.mxf.BodyPartitionPack;
import tv.amwa.maj.io.mxf.EssencePartition;
import tv.amwa.maj.io.mxf.FooterPartition;
import tv.amwa.maj.io.mxf.FooterPartitionPack;
import tv.amwa.maj.io.mxf.HeaderMetadata;
import tv.amwa.maj.io.mxf.HeaderPartitionPack;
import tv.amwa.maj.io.mxf.IndexTableSegment;
import tv.amwa.maj.io.mxf.MXFFactory;
import tv.amwa.maj.io.mxf.MXFFile;
import tv.amwa.maj.io.mxf.MXFStream;
import tv.amwa.maj.io.mxf.PartitionPack;
import tv.amwa.maj.io.mxf.RandomIndexItem;
import tv.amwa.maj.io.mxf.RandomIndexPack;
import tv.amwa.maj.io.mxf.UL;
import tv.amwa.maj.io.mxf.impl.EssenceElementImpl;
import tv.amwa.maj.io.mxf.impl.FooterPartitionImpl;
import tv.amwa.maj.io.mxf.impl.GenericStreamPartitionPackImpl;
import tv.amwa.maj.io.mxf.impl.HeaderPartitionImpl;
import tv.amwa.maj.io.mxf.impl.RandomIndexItemImpl;
import tv.amwa.maj.io.mxf.impl.RandomIndexPackImpl;
import tv.amwa.maj.model.AAFFileDescriptor;
import tv.amwa.maj.model.AS07CoreDMSFramework;
import tv.amwa.maj.model.AS07DMSIdentifierSet;
import tv.amwa.maj.model.AS07GSPDMSObject;
import tv.amwa.maj.model.Component;
import tv.amwa.maj.model.ContentStorage;
import tv.amwa.maj.model.DataDefinition;
import tv.amwa.maj.model.DescriptiveFramework;
import tv.amwa.maj.model.DescriptiveMarker;
import tv.amwa.maj.model.EssenceDescriptor;
import tv.amwa.maj.model.MaterialPackage;
import tv.amwa.maj.model.MultipleDescriptor;
import tv.amwa.maj.model.Package;
import tv.amwa.maj.model.Preface;
import tv.amwa.maj.model.Segment;
import tv.amwa.maj.model.Sequence;
import tv.amwa.maj.model.SourcePackage;
import tv.amwa.maj.model.StaticTrack;
import tv.amwa.maj.model.TimelineTrack;
import tv.amwa.maj.model.Track;
import tv.amwa.maj.model.impl.AS07CoreDMSFrameworkImpl;
import tv.amwa.maj.model.impl.AS07DateTimeDescriptorImpl;
import tv.amwa.maj.model.impl.AS07GspBdDMSFrameworkImpl;
import tv.amwa.maj.model.impl.AS07GspTdDMSFrameworkImpl;
import tv.amwa.maj.model.impl.AncillaryPacketsDescriptorImpl;
import tv.amwa.maj.model.impl.CDCIDescriptorImpl;
import tv.amwa.maj.model.impl.DescriptiveMarkerImpl;
import tv.amwa.maj.model.impl.PictureDescriptorImpl;
import tv.amwa.maj.model.impl.RGBADescriptorImpl;
import tv.amwa.maj.model.impl.STLDescriptorImpl;
import tv.amwa.maj.model.impl.SoundDescriptorImpl;
import tv.amwa.maj.model.impl.TimedTextDescriptorImpl;
import tv.amwa.maj.model.impl.VBIDescriptorImpl;
import tv.amwa.maj.model.impl.WAVEPCMDescriptorImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.impl.AUIDImpl;

public class MXFServiceImpl
implements MXFService {
    MXFFile file = null;
    String filePath = null;
    String formatVersion = "";
    private static final Logger LOGGER = Logger.getLogger(Main.class.getClass().getName());
    List<AAFFileDescriptor> fileDescriptors = new ArrayList<AAFFileDescriptor>();

    public MXFServiceImpl(String filePath) throws FileNotFoundException {
        if (!new File(filePath).exists()) {
            throw new FileNotFoundException(String.format("File %s not found", filePath));
        }
        this.filePath = filePath;
    }

    public EmbARCIdentification getIdentification() {
        EmbARCIdentification identificationSingleton = EmbARCIdentification.getInstance();
        return identificationSingleton;
    }

    @Override
    public void readFile() {
        this.file = MXFFactory.readPartitions((String)this.filePath);
    }

    @Override
    public MXFFile getFile() {
        if (this.file == null) {
            this.readFile();
        }
        return this.file;
    }

    private long getFooterOffset(AS07CoreDMSFramework updatedCore) throws IOException {
        int headerSize;
        MXFFile mxfFile = this.getFile();
        EmbARCIdentification embarcIdent = this.getIdentification();
        long totalBytes = 0L;
        long thisPartition = 0L;
        long previousPartition = 0L;
        long klvFillLength = 8192L;
        ArrayList<RandomIndexItemImpl> ripItems = new ArrayList<RandomIndexItemImpl>();
        if (!mxfFile.isOpen()) {
            throw new IOException("Cannot dump file " + this.filePath + " as the file could not be opened.");
        }
        HeaderPartitionPack headerPartitionPack = mxfFile.getHeaderPartition().getPartitionPack();
        HeaderMetadata headerMetadata = mxfFile.getHeaderPartition().readHeaderMetadata();
        headerPartitionPack.setThisPartition(thisPartition);
        headerPartitionPack.setPreviousPartition(previousPartition);
        headerPartitionPack.setFooterPartition(0L);
        Preface preface = headerMetadata.getPreface();
        if (updatedCore != null) {
            updatedCore.setLinkedGenerationID(embarcIdent.getIdentification().getLinkedGenerationID());
        }
        if (updatedCore != null) {
            ContentStorage contentStorage = preface.getContentStorageObject();
            Set packages = contentStorage.getPackages();
            for (Package p : packages) {
                if (!(p instanceof MaterialPackage)) continue;
                for (Track t : p.getPackageTracks()) {
                    StaticTrack st;
                    Segment ts;
                    if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                    Sequence seq = (Sequence)ts;
                    List components = seq.getComponentObjects();
                    for (Component c : components) {
                        if (!(c instanceof DescriptiveMarkerImpl)) continue;
                        DescriptiveMarker m = (DescriptiveMarker)c;
                        try {
                            DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                            if (df == null || !(df instanceof AS07CoreDMSFramework)) continue;
                            m.setDescriptiveFrameworkObject((DescriptiveFramework)updatedCore);
                        }
                        catch (PropertyNotPresentException pnp) {
                            LOGGER.log(Level.INFO, pnp.toString());
                        }
                    }
                }
            }
        }
        headerSize = (headerSize = headerPartitionPack.getEncodedSize()) < 65536 ? 65546 : headerSize;
        try (ByteArrayOutputStream headerBytes = new ByteArrayOutputStream(headerSize);
             ByteArrayOutputStream metadataBytes = new ByteArrayOutputStream(headerSize);){
            MXFStream.writeHeaderMetadata((OutputStream)metadataBytes, (Preface)preface);
            headerPartitionPack.setHeaderByteCount((long)metadataBytes.size() + klvFillLength);
            MXFStream.writeFill((OutputStream)metadataBytes, (long)klvFillLength);
            MXFStream.writePartitionPack((OutputStream)headerBytes, (PartitionPack)headerPartitionPack);
            totalBytes += (long)headerBytes.size();
            totalBytes += (long)metadataBytes.size();
        }
        RandomIndexItemImpl hRipItem = new RandomIndexItemImpl(headerPartitionPack.getBodySID(), thisPartition);
        ripItems.add(hRipItem);
        EssencePartition hContainerPartition = (EssencePartition)mxfFile.getPartitionAt(0);
        if (hContainerPartition != null) {
            EssenceElementImpl element = (EssenceElementImpl)hContainerPartition.readEssenceElement();
            while (element != null) {
                ByteBuffer bb = element.getData();
                byte[] elementByteArray = bb.array();
                try (ByteArrayOutputStream elementBytes = new ByteArrayOutputStream(elementByteArray.length);){
                    MXFStream.writeEssenceElement((OutputStream)elementBytes, (int)element.getEssenceTrackIdentifier(), (byte[])bb.array());
                    totalBytes += (long)elementBytes.size();
                }
                element = (EssenceElementImpl)hContainerPartition.readEssenceElement();
            }
        }
        for (int x = 1; x < mxfFile.countPartitions() - 1; ++x) {
            BodyPartition originalPartition = (BodyPartition)mxfFile.getPartitionAt(x);
            BodyPartition partition = originalPartition.clone();
            if (partition == null || partition instanceof FooterPartitionImpl || partition instanceof HeaderPartitionImpl) continue;
            previousPartition = thisPartition;
            thisPartition = totalBytes;
            BodyPartitionPack opp = originalPartition.getPartitionPack().clone();
            BodyPartitionPack partitionPack = partition.getPartitionPack().clone();
            if (partitionPack instanceof GenericStreamPartitionPackImpl) {
                GenericStreamPartitionPackImpl gsp = (GenericStreamPartitionPackImpl)partitionPack;
                gsp.setThisPartition(thisPartition);
                gsp.setPreviousPartition(previousPartition);
                gsp.setFooterPartition(0L);
                RandomIndexItemImpl ripItem = new RandomIndexItemImpl(gsp.getBodySID(), thisPartition);
                ripItems.add(ripItem);
                int partitionSize = gsp.getEncodedSize();
                partitionSize = partitionSize < 65536 ? 65546 : partitionSize;
                try (ByteArrayOutputStream partitionBytes = new ByteArrayOutputStream(partitionSize);){
                    MXFStream.writePartitionPack((OutputStream)partitionBytes, (PartitionPack)gsp);
                    IndexTableSegment it = partition.readIndexTableSegment();
                    if (it != null) {
                        MXFStream.writeIndexTableSegment((OutputStream)partitionBytes, (IndexTableSegment)it);
                    }
                    totalBytes += (long)partitionBytes.size();
                    long l = this.ReadGenericStream(opp.getThisPartition() + (long)opp.getEncodedSize() + 20L, partitionBytes);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.toString(), ex);
                }
            } else {
                partitionPack.setThisPartition(thisPartition);
                partitionPack.setPreviousPartition(previousPartition);
                partitionPack.setFooterPartition(0L);
                RandomIndexItemImpl ripItem = new RandomIndexItemImpl(partitionPack.getBodySID(), thisPartition);
                ripItems.add(ripItem);
                int partitionSize = partitionPack.getEncodedSize();
                partitionSize = partitionSize < 65536 ? 65546 : partitionSize;
                try (ByteArrayOutputStream partitionBytes = new ByteArrayOutputStream(partitionSize);){
                    MXFStream.writePartitionPack((OutputStream)partitionBytes, (PartitionPack)partitionPack);
                    IndexTableSegment it = partition.readIndexTableSegment();
                    if (it != null) {
                        MXFStream.writeIndexTableSegment((OutputStream)partitionBytes, (IndexTableSegment)it);
                    }
                    totalBytes += (long)partitionBytes.size();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, ex.toString(), ex);
                }
            }
            BodyPartition containerPartition = originalPartition;
            if (containerPartition == null) continue;
            EssenceElementImpl element = (EssenceElementImpl)containerPartition.readEssenceElement();
            while (element != null) {
                ByteBuffer bb = element.getData();
                byte[] elementByteArray = bb.array();
                ByteArrayOutputStream elementBytes = new ByteArrayOutputStream(elementByteArray.length);
                MXFStream.writeEssenceElement((OutputStream)elementBytes, (int)element.getEssenceTrackIdentifier(), (byte[])bb.array());
                totalBytes += (long)elementBytes.size();
                element = (EssenceElementImpl)containerPartition.readEssenceElement();
            }
        }
        return totalBytes;
    }

    @Override
    public Preface getPreface() {
        MXFFile mxfFile = this.getFile();
        HeaderMetadata headerMetadata = mxfFile.getHeaderPartition().readHeaderMetadata();
        return headerMetadata.getPreface();
    }

    @Override
    public MXFFileWriteResult writeFile(String outputFilePath, HashMap<MXFColumn, MetadataColumnDef> coreColumns) throws IOException {
        MXFFileWriteResult result = new MXFFileWriteResult();
        try {
            AS07CoreDMSFrameworkImpl dms = new AS07CoreDMSFrameworkImpl();
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_ShimName)) {
                dms.setShimName(coreColumns.get(MXFColumn.AS_07_Core_DMS_ShimName).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_ResponsibleOrganizationName)) {
                dms.setResponsibleOrganizationName(coreColumns.get(MXFColumn.AS_07_Core_DMS_ResponsibleOrganizationName).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_ResponsibleOrganizationCode)) {
                dms.setResponsibleOrganizationCode(coreColumns.get(MXFColumn.AS_07_Core_DMS_ResponsibleOrganizationCode).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_PictureFormat)) {
                dms.setPictureFormat(coreColumns.get(MXFColumn.AS_07_Core_DMS_PictureFormat).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_Captions)) {
                dms.setCaptions(coreColumns.get(MXFColumn.AS_07_Core_DMS_Captions).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_IntendedAFD)) {
                dms.setIntendedAFD(coreColumns.get(MXFColumn.AS_07_Core_DMS_IntendedAFD).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_AudioTrackLayout)) {
                String value = coreColumns.get(MXFColumn.AS_07_Core_DMS_AudioTrackLayout).toString();
                AudioTrackLayoutValues atlv = new AudioTrackLayoutValues();
                AUIDImpl i = AUIDImpl.parseFactory((String)atlv.getUl(value));
                dms.setAudioTrackLayout((AUID)i);
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_AudioTrackLayoutComment)) {
                dms.setAudioTrackLayoutComment(coreColumns.get(MXFColumn.AS_07_Core_DMS_AudioTrackLayoutComment).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_AudioTrackSecondaryLanguage)) {
                dms.setAudioTrackSecondaryLanguage(coreColumns.get(MXFColumn.AS_07_Core_DMS_AudioTrackSecondaryLanguage).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_AudioTrackPrimaryLanguage)) {
                dms.setAudioTrackPrimaryLanguage(coreColumns.get(MXFColumn.AS_07_Core_DMS_AudioTrackPrimaryLanguage).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_NatureOfOrganization)) {
                dms.setNatureOfOrganization(coreColumns.get(MXFColumn.AS_07_Core_DMS_NatureOfOrganization).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_SecondaryTitle)) {
                dms.setSecondaryTitle(coreColumns.get(MXFColumn.AS_07_Core_DMS_SecondaryTitle).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_WorkingTitle)) {
                dms.setWorkingTitle(coreColumns.get(MXFColumn.AS_07_Core_DMS_WorkingTitle).toString());
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_Identifiers)) {
                IdentifierSetHelper idSetHelper = new IdentifierSetHelper();
                dms.setIdentifiers(idSetHelper.createIdentifierListFromString(coreColumns.get(MXFColumn.AS_07_Core_DMS_Identifiers).toString()));
            }
            if (coreColumns.containsKey(MXFColumn.AS_07_Core_DMS_Devices)) {
                DeviceSetHelper deviceSetHelper = new DeviceSetHelper();
                dms.setDevices(deviceSetHelper.createDeviceListFromString(coreColumns.get(MXFColumn.AS_07_Core_DMS_Devices).toString()));
            }
            return this.writeFile(outputFilePath, (AS07CoreDMSFramework)dms);
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.toString(), ex);
            result.setException(ex);
            result.setSuccess(false);
            return result;
        }
    }

    @Override
    public MXFFileWriteResult writeFile(String outputFilePath, AS07CoreDMSFramework updatedCore) throws IOException {
        MXFFileWriteResult result = new MXFFileWriteResult();
        this.getFile();
        AS07CoreDMSFramework coreFrameworkHeader = this.getAS07CoreDMSFrameworkHeader();
        AS07CoreDMSFramework coreFrameworkFooter = this.getAS07CoreDMSFrameworkFooter();
        try {
            long footerOffset = this.getFooterOffset(updatedCore);
            EmbARCIdentification embarcIdent = this.getIdentification();
            MXFFile mxfFile = MXFFactory.readPartitions((String)this.filePath);
            long totalBytes = 0L;
            long thisPartition = 0L;
            long previousPartition = 0L;
            long klvFillLength = 8192L;
            ArrayList<RandomIndexItemImpl> ripItems = new ArrayList<RandomIndexItemImpl>();
            String tempFilePath = outputFilePath + ".tmp";
            try (FileOutputStream outputStream = new FileOutputStream(tempFilePath);){
                if (!mxfFile.isOpen()) {
                    throw new IOException("Cannot dump file " + this.filePath + " as the file could not be opened.");
                }
                if (updatedCore != null) {
                    updatedCore.setLinkedGenerationID(embarcIdent.getIdentification().getLinkedGenerationID());
                }
                HeaderPartitionPack headerPartitionPack = mxfFile.getHeaderPartition().getPartitionPack();
                HeaderMetadata headerMetadata = mxfFile.getHeaderPartition().readHeaderMetadata();
                headerPartitionPack.setThisPartition(thisPartition);
                headerPartitionPack.setPreviousPartition(previousPartition);
                headerPartitionPack.setFooterPartition(footerOffset);
                Preface preface = headerMetadata.getPreface();
                int headerSize = headerPartitionPack.getEncodedSize();
                int n = headerSize = headerSize < 65536 ? 65546 : headerSize;
                if (updatedCore != null && coreFrameworkHeader != null) {
                    ContentStorage contentStorage = preface.getContentStorageObject();
                    Set packages = contentStorage.getPackages();
                    for (Package p : packages) {
                        if (!(p instanceof MaterialPackage)) continue;
                        for (Track t : p.getPackageTracks()) {
                            StaticTrack st;
                            Segment ts;
                            if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                            Sequence seq = (Sequence)ts;
                            List components = seq.getComponentObjects();
                            for (Component c : components) {
                                if (!(c instanceof DescriptiveMarkerImpl)) continue;
                                DescriptiveMarker m = (DescriptiveMarker)c;
                                try {
                                    DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                                    if (df == null || !(df instanceof AS07CoreDMSFramework)) continue;
                                    m.setDescriptiveFrameworkObject((DescriptiveFramework)updatedCore);
                                }
                                catch (PropertyNotPresentException pnp) {
                                    LOGGER.log(Level.INFO, pnp.toString());
                                }
                            }
                        }
                    }
                }
                try (ByteArrayOutputStream headerBytes = new ByteArrayOutputStream(headerSize);
                     ByteArrayOutputStream metadataBytes = new ByteArrayOutputStream(headerSize);){
                    MXFStream.writeHeaderMetadata((OutputStream)metadataBytes, (Preface)preface);
                    headerPartitionPack.setHeaderByteCount((long)metadataBytes.size() + klvFillLength);
                    MXFStream.writeFill((OutputStream)metadataBytes, (long)klvFillLength);
                    MXFStream.writePartitionPack((OutputStream)headerBytes, (PartitionPack)headerPartitionPack);
                    headerBytes.writeTo(outputStream);
                    metadataBytes.writeTo(outputStream);
                    totalBytes += (long)headerBytes.size();
                    totalBytes += (long)metadataBytes.size();
                }
                RandomIndexItemImpl hRipItem = new RandomIndexItemImpl(headerPartitionPack.getBodySID(), thisPartition);
                ripItems.add(hRipItem);
                EssencePartition hContainerPartition = (EssencePartition)mxfFile.getPartitionAt(0);
                if (hContainerPartition != null) {
                    EssenceElementImpl element = (EssenceElementImpl)hContainerPartition.readEssenceElement();
                    while (element != null) {
                        ByteBuffer bb = element.getData();
                        byte[] elementByteArray = bb.array();
                        ByteArrayOutputStream elementBytes = new ByteArrayOutputStream(elementByteArray.length);
                        MXFStream.writeEssenceElement((OutputStream)elementBytes, (int)element.getEssenceTrackIdentifier(), (byte[])bb.array());
                        elementBytes.writeTo(outputStream);
                        totalBytes += (long)elementBytes.size();
                        element = (EssenceElementImpl)hContainerPartition.readEssenceElement();
                    }
                }
                int essenceCount = 0;
                for (int x = 1; x < mxfFile.countPartitions() - 1; ++x) {
                    BodyPartition originalPartition = (BodyPartition)mxfFile.getPartitionAt(x);
                    BodyPartition partition = originalPartition.clone();
                    if (partition == null || partition instanceof FooterPartitionImpl || partition instanceof HeaderPartitionImpl) continue;
                    previousPartition = thisPartition;
                    thisPartition = totalBytes;
                    BodyPartitionPack opp = originalPartition.getPartitionPack().clone();
                    BodyPartitionPack partitionPack = partition.getPartitionPack().clone();
                    if (partitionPack instanceof GenericStreamPartitionPackImpl) {
                        GenericStreamPartitionPackImpl gsp = (GenericStreamPartitionPackImpl)partitionPack;
                        gsp.setThisPartition(thisPartition);
                        gsp.setPreviousPartition(previousPartition);
                        gsp.setFooterPartition(footerOffset);
                        RandomIndexItemImpl ripItem = new RandomIndexItemImpl(gsp.getBodySID(), thisPartition);
                        ripItems.add(ripItem);
                        int partitionSize = gsp.getEncodedSize();
                        partitionSize = partitionSize < 65536 ? 65546 : partitionSize;
                        try (ByteArrayOutputStream partitionBytes = new ByteArrayOutputStream(partitionSize);){
                            MXFStream.writePartitionPack((OutputStream)partitionBytes, (PartitionPack)gsp);
                            long bytesAdded = this.ReadGenericStream(opp.getThisPartition() + (long)opp.getEncodedSize() + 20L, partitionBytes);
                            partitionBytes.writeTo(outputStream);
                            totalBytes += (long)partitionBytes.size();
                        }
                    }
                    partitionPack.setThisPartition(thisPartition);
                    partitionPack.setPreviousPartition(previousPartition);
                    partitionPack.setFooterPartition(footerOffset);
                    RandomIndexItemImpl ripItem = new RandomIndexItemImpl(partitionPack.getBodySID(), thisPartition);
                    ripItems.add(ripItem);
                    int partitionSize = partitionPack.getEncodedSize();
                    partitionSize = partitionSize < 65536 ? 65546 : partitionSize;
                    try (ByteArrayOutputStream partitionBytes = new ByteArrayOutputStream(partitionSize);){
                        MXFStream.writePartitionPack((OutputStream)partitionBytes, (PartitionPack)partitionPack);
                        IndexTableSegment it = partition.readIndexTableSegment();
                        if (it != null) {
                            MXFStream.writeIndexTableSegment((OutputStream)partitionBytes, (IndexTableSegment)it);
                        }
                        partitionBytes.writeTo(outputStream);
                        totalBytes += (long)partitionBytes.size();
                    }
                    BodyPartition containerPartition = originalPartition;
                    if (containerPartition == null) continue;
                    ++essenceCount;
                    EssenceElementImpl element = (EssenceElementImpl)containerPartition.readEssenceElement();
                    while (element != null) {
                        ByteBuffer bb = element.getData();
                        byte[] elementByteArray = bb.array();
                        ByteArrayOutputStream elementBytes = new ByteArrayOutputStream(elementByteArray.length);
                        MXFStream.writeEssenceElement((OutputStream)elementBytes, (int)element.getEssenceTrackIdentifier(), (byte[])bb.array());
                        elementBytes.writeTo(outputStream);
                        totalBytes += (long)elementBytes.size();
                        element = (EssenceElementImpl)containerPartition.readEssenceElement();
                    }
                }
                System.out.println("Essence Count: " + essenceCount);
                FooterPartition footerPartition = mxfFile.getFooterPartition();
                if (footerPartition != null) {
                    HeaderMetadata footerMetadata = footerPartition.readHeaderMetadata();
                    FooterPartitionPack footerPartitionPack = footerPartition.getPartitionPack();
                    Preface footerPreface = null;
                    if (footerMetadata != null) {
                        footerPreface = footerMetadata.getPreface();
                        if (updatedCore != null && coreFrameworkFooter != null) {
                            ContentStorage contentStorage = footerPreface.getContentStorageObject();
                            Set packages = contentStorage.getPackages();
                            for (Package p : packages) {
                                if (!(p instanceof MaterialPackage)) continue;
                                for (Track t : p.getPackageTracks()) {
                                    StaticTrack st;
                                    Segment ts;
                                    if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                                    Sequence seq = (Sequence)ts;
                                    List components = seq.getComponentObjects();
                                    for (Component c : components) {
                                        if (!(c instanceof DescriptiveMarkerImpl)) continue;
                                        DescriptiveMarker m = (DescriptiveMarker)c;
                                        try {
                                            DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                                            if (df == null || !(df instanceof AS07CoreDMSFramework)) continue;
                                            m.setDescriptiveFrameworkObject((DescriptiveFramework)updatedCore);
                                        }
                                        catch (PropertyNotPresentException pnp) {
                                            LOGGER.log(Level.INFO, pnp.toString());
                                        }
                                    }
                                }
                            }
                        }
                    }
                    previousPartition = thisPartition;
                    thisPartition = totalBytes;
                    RandomIndexItemImpl ripItem = new RandomIndexItemImpl(footerPartitionPack.getBodySID(), thisPartition);
                    ripItems.add(ripItem);
                    footerPartitionPack.setThisPartition(thisPartition);
                    footerPartitionPack.setPreviousPartition(previousPartition);
                    footerPartitionPack.setFooterPartition(thisPartition);
                    int footerSize = footerPartitionPack.getEncodedSize();
                    footerSize = footerSize < 65536 ? 65546 : footerSize;
                    try (ByteArrayOutputStream footerBytes = new ByteArrayOutputStream(footerSize);
                         ByteArrayOutputStream metadataBytes = new ByteArrayOutputStream(footerSize);){
                        if (footerPreface != null) {
                            MXFStream.writeHeaderMetadata((OutputStream)metadataBytes, (Preface)footerPreface);
                            footerPartitionPack.setHeaderByteCount((long)metadataBytes.size() + klvFillLength);
                            MXFStream.writeFill((OutputStream)metadataBytes, (long)klvFillLength);
                        }
                        MXFStream.writePartitionPack((OutputStream)footerBytes, (PartitionPack)footerPartitionPack);
                        footerBytes.writeTo(outputStream);
                        metadataBytes.writeTo(outputStream);
                    }
                }
                RandomIndexPackImpl ripOriginal = (RandomIndexPackImpl)mxfFile.getRandomIndexPack();
                System.out.println(ripOriginal);
                System.out.println("********************************");
                ripOriginal.clear();
                RandomIndexItem[] list2 = new RandomIndexItem[ripItems.size()];
                ripOriginal.setPartitionIndex(ripItems.toArray(list2));
                System.out.println(ripOriginal);
                if (ripOriginal != null) {
                    MXFStream.writeRandomIndexPack((OutputStream)outputStream, (RandomIndexPack)ripOriginal);
                }
                ((OutputStream)outputStream).close();
                Path p = Paths.get(outputFilePath, new String[0]);
                Path p2 = Paths.get(tempFilePath, new String[0]);
                if (Files.exists(p, new LinkOption[0])) {
                    Files.delete(p);
                }
                Files.copy(p2, Paths.get(outputFilePath, new String[0]), new CopyOption[0]);
                if (Files.exists(p2, new LinkOption[0])) {
                    Files.delete(p2);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, ex.toString(), ex);
                Path p = Paths.get(tempFilePath, new String[0]);
                if (Files.exists(p, new LinkOption[0])) {
                    Files.delete(p);
                }
                result.setException(ex);
                result.setSuccess(false);
                return result;
            }
            mxfFile.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, ex.toString(), ex);
            result.setException(ex);
            result.setSuccess(false);
            return result;
        }
        result.setSuccess(true);
        return result;
    }

    public long ReadGenericStream(long offset, OutputStream outputStream) {
        block8: {
            long l;
            FileInputStream is = new FileInputStream(this.filePath);
            try {
                MXFStream.skipForward((InputStream)is, (long)offset);
                MXFStream.KeyAndConsumed key = MXFStream.readKey((InputStream)is);
                MXFStream.LengthAndConsumed length = MXFStream.readBERLength((InputStream)is);
                ByteBuffer bb = MXFStream.readValue((InputStream)is, (long)length.getLength());
                ((InputStream)is).close();
                MXFStream.writeKey((OutputStream)outputStream, (UL)key.getKey());
                MXFStream.writeBERLength((OutputStream)outputStream, (long)length.getLength(), (int)((int)length.getConsumed()));
                MXFStream.writeValue((OutputStream)outputStream, (ByteBuffer)bb);
                l = key.getConsumed() + length.getConsumed() + length.getLength();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.WARNING, e.toString(), e);
                    break block8;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.toString(), e);
                }
            }
            ((InputStream)is).close();
            return l;
        }
        return 0L;
    }

    @Override
    public boolean DownloadGenericStream(int streamId, String outputFile) {
        ByteBuffer bb = this.GetGenericStream(streamId);
        Assert.assertNotNull((Object)bb);
        try {
            File file = new File(outputFile);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file, false);){
                FileChannel channel = fileOutputStream.getChannel();
                channel.write(bb);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.toString(), e);
            return false;
        }
    }

    @Override
    public ByteBuffer GetGenericStream(int streamId) {
        MXFFile mxfFile = MXFFactory.readPartitions((String)this.filePath);
        for (int x = 1; x < mxfFile.countPartitions() - 1; ++x) {
            BodyPartitionPack opp;
            BodyPartition originalPartition = (BodyPartition)mxfFile.getPartitionAt(x);
            BodyPartition partition = originalPartition.clone();
            if (partition == null || partition instanceof FooterPartitionImpl || partition instanceof HeaderPartitionImpl || (opp = originalPartition.getPartitionPack().clone()).getBodySID() != streamId) continue;
            ByteBuffer bb = this.GetGenericStream(opp.getThisPartition() + (long)opp.getEncodedSize() + 20L);
            return bb;
        }
        return null;
    }

    private ByteBuffer GetGenericStream(long offset) {
        block8: {
            ByteBuffer byteBuffer;
            FileInputStream is = new FileInputStream(this.filePath);
            try {
                ByteBuffer bb;
                MXFStream.skipForward((InputStream)is, (long)offset);
                MXFStream.KeyAndConsumed key = MXFStream.readKey((InputStream)is);
                MXFStream.LengthAndConsumed length = MXFStream.readBERLength((InputStream)is);
                byteBuffer = bb = MXFStream.readValue((InputStream)is, (long)length.getLength());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.WARNING, e.toString(), e);
                    break block8;
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, e.toString(), e);
                }
            }
            ((InputStream)is).close();
            return byteBuffer;
        }
        return null;
    }

    private void addContainersForDescriptor(AAFFileDescriptor descriptor) {
        if (descriptor instanceof MultipleDescriptor) {
            for (AAFFileDescriptor nestedDescriptor : ((MultipleDescriptor)descriptor).getFileDescriptors()) {
                this.addContainersForDescriptor(nestedDescriptor);
            }
        } else {
            this.fileDescriptors.add(descriptor);
        }
    }

    @Override
    public MXFFileDescriptorResult getDescriptors() {
        MXFFileDescriptorResult result = new MXFFileDescriptorResult();
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        Set packages = preface.getPackages();
        for (Package packageItem : packages) {
            EssenceDescriptor packageDescriptor;
            if (!(packageItem instanceof SourcePackage) || !((packageDescriptor = ((SourcePackage)packageItem).getEssenceDescription()) instanceof AAFFileDescriptor)) continue;
            this.addContainersForDescriptor((AAFFileDescriptor)packageDescriptor);
        }
        for (AAFFileDescriptor fd : this.fileDescriptors) {
            TimedTextDescriptorImpl desc;
            if (fd instanceof CDCIDescriptorImpl) {
                CDCIDescriptorImpl cdci = (CDCIDescriptorImpl)fd;
                result.addCDCIDescriptor(cdci);
                continue;
            }
            if (fd instanceof WAVEPCMDescriptorImpl) {
                WAVEPCMDescriptorImpl wave = (WAVEPCMDescriptorImpl)fd;
                result.addWavePCMDescriptors(wave);
                continue;
            }
            if (fd instanceof TimedTextDescriptorImpl) {
                desc = (TimedTextDescriptorImpl)fd;
                result.addTimedTextDescriptor(desc);
                continue;
            }
            if (fd instanceof AncillaryPacketsDescriptorImpl) {
                desc = (AncillaryPacketsDescriptorImpl)fd;
                result.addAncillaryPacketsDescriptors((AncillaryPacketsDescriptorImpl)desc);
                continue;
            }
            if (fd instanceof AS07DateTimeDescriptorImpl) {
                desc = (AS07DateTimeDescriptorImpl)fd;
                result.addAS07DateTimeDescriptor((AS07DateTimeDescriptorImpl)desc);
                continue;
            }
            if (fd instanceof RGBADescriptorImpl) {
                desc = (RGBADescriptorImpl)fd;
                result.addRGBADescriptor((RGBADescriptorImpl)desc);
                continue;
            }
            if (fd instanceof STLDescriptorImpl) {
                desc = (STLDescriptorImpl)fd;
                result.addSTLDescriptor((STLDescriptorImpl)desc);
                continue;
            }
            if (fd instanceof VBIDescriptorImpl) {
                desc = (VBIDescriptorImpl)fd;
                result.addVBIDescriptor((VBIDescriptorImpl)desc);
                continue;
            }
            if (fd instanceof PictureDescriptorImpl) {
                desc = (PictureDescriptorImpl)fd;
                result.addPictureDescriptor((PictureDescriptorImpl)desc);
                continue;
            }
            if (!(fd instanceof SoundDescriptorImpl)) continue;
            desc = (SoundDescriptorImpl)fd;
            result.addSoundDescriptor((SoundDescriptorImpl)desc);
        }
        return result;
    }

    @Override
    public List<AS07GspTdDMSFrameworkImpl> getAS07GspTdDMSFramework() {
        ArrayList<AS07GspTdDMSFrameworkImpl> toReturn = new ArrayList<AS07GspTdDMSFrameworkImpl>();
        if (this.file == null) {
            this.file = MXFFactory.readPartitions((String)this.filePath);
        }
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        ContentStorage contentStorage = preface.getContentStorageObject();
        Set packages = contentStorage.getPackages();
        for (Package p : packages) {
            if (!(p instanceof MaterialPackage)) continue;
            for (Track t : p.getPackageTracks()) {
                StaticTrack st;
                Segment ts;
                if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                Sequence seq = (Sequence)ts;
                List components = seq.getComponentObjects();
                for (Component c : components) {
                    if (!(c instanceof DescriptiveMarkerImpl)) continue;
                    DescriptiveMarker m = (DescriptiveMarker)c;
                    try {
                        DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                        if (df == null || !(df instanceof AS07GspTdDMSFrameworkImpl)) continue;
                        toReturn.add((AS07GspTdDMSFrameworkImpl)df);
                    }
                    catch (PropertyNotPresentException pnp) {
                        LOGGER.log(Level.INFO, pnp.toString());
                    }
                }
            }
        }
        return toReturn;
    }

    @Override
    public List<AS07GSPDMSObject> getAS07GSPDMSObjects() {
        ArrayList<AS07GSPDMSObject> toReturn = new ArrayList<AS07GSPDMSObject>();
        if (this.file == null) {
            this.file = MXFFactory.readPartitions((String)this.filePath);
        }
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        ContentStorage contentStorage = preface.getContentStorageObject();
        Set packages = contentStorage.getPackages();
        for (Package p : packages) {
            if (!(p instanceof MaterialPackage)) continue;
            for (Track t : p.getPackageTracks()) {
                StaticTrack st;
                Segment ts;
                if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                Sequence seq = (Sequence)ts;
                List components = seq.getComponentObjects();
                for (Component c : components) {
                    if (!(c instanceof DescriptiveMarkerImpl)) continue;
                    DescriptiveMarker m = (DescriptiveMarker)c;
                    try {
                        DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                        if (df == null || !(df instanceof AS07GspTdDMSFrameworkImpl)) continue;
                        AS07GSPDMSObject obj = ((AS07GspTdDMSFrameworkImpl)df).getTextBasedObject();
                        toReturn.add(obj);
                    }
                    catch (PropertyNotPresentException pnp) {
                        LOGGER.log(Level.INFO, pnp.toString());
                    }
                }
            }
        }
        return toReturn;
    }

    @Override
    public List<AS07GspBdDMSFrameworkImpl> getAS07GspBdDMSFramework() {
        ArrayList<AS07GspBdDMSFrameworkImpl> toReturn = new ArrayList<AS07GspBdDMSFrameworkImpl>();
        if (this.file == null) {
            this.file = MXFFactory.readPartitions((String)this.filePath);
        }
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        ContentStorage contentStorage = preface.getContentStorageObject();
        Set packages = contentStorage.getPackages();
        for (Package p : packages) {
            if (!(p instanceof MaterialPackage)) continue;
            for (Track t : p.getPackageTracks()) {
                StaticTrack st;
                Segment ts;
                if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                Sequence seq = (Sequence)ts;
                List components = seq.getComponentObjects();
                for (Component c : components) {
                    if (!(c instanceof DescriptiveMarkerImpl)) continue;
                    DescriptiveMarker m = (DescriptiveMarker)c;
                    try {
                        DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                        if (df == null || !(df instanceof AS07GspBdDMSFrameworkImpl)) continue;
                        toReturn.add((AS07GspBdDMSFrameworkImpl)df);
                    }
                    catch (PropertyNotPresentException pnp) {
                        LOGGER.log(Level.INFO, pnp.toString());
                    }
                }
            }
        }
        return toReturn;
    }

    private AS07CoreDMSFramework getAS07CoreDMSFrameworkHeader() {
        if (this.file == null) {
            System.out.println("File is null");
        }
        if (this.file.getHeaderPartition() == null) {
            System.out.println("Header partition is null");
        }
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        ContentStorage contentStorage = preface.getContentStorageObject();
        Set packages = contentStorage.getPackages();
        AS07CoreDMSFramework coreFramework = null;
        int count = 1;
        for (Package p : packages) {
            if (!(p instanceof MaterialPackage)) continue;
            for (Track t : p.getPackageTracks()) {
                StaticTrack st;
                Segment ts;
                if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                Sequence seq = (Sequence)ts;
                List components = seq.getComponentObjects();
                for (Component c : components) {
                    if (!(c instanceof DescriptiveMarkerImpl)) continue;
                    DescriptiveMarker m = (DescriptiveMarker)c;
                    try {
                        DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                        if (df == null || !(df instanceof AS07CoreDMSFramework)) continue;
                        coreFramework = (AS07CoreDMSFramework)df;
                        System.out.println("Found  framework" + count);
                        ++count;
                    }
                    catch (PropertyNotPresentException pnp) {
                        LOGGER.log(Level.INFO, pnp.toString());
                    }
                }
            }
        }
        return coreFramework;
    }

    private AS07CoreDMSFramework getAS07CoreDMSFrameworkFooter() {
        AS07CoreDMSFramework coreFramework = null;
        HeaderMetadata fromTheFooter = this.file.getFooterPartition().readHeaderMetadata();
        if (fromTheFooter == null) {
            return coreFramework;
        }
        Preface prefaceF = fromTheFooter.getPreface();
        ContentStorage contentStorageF = prefaceF.getContentStorageObject();
        Set packagesF = contentStorageF.getPackages();
        for (Package p : packagesF) {
            if (!(p instanceof MaterialPackage)) continue;
            for (Track t : p.getPackageTracks()) {
                StaticTrack st;
                Segment ts;
                if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                Sequence seq = (Sequence)ts;
                List components = seq.getComponentObjects();
                for (Component c : components) {
                    if (!(c instanceof DescriptiveMarkerImpl)) continue;
                    DescriptiveMarker m = (DescriptiveMarker)c;
                    try {
                        DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                        if (df == null || !(df instanceof AS07CoreDMSFramework)) continue;
                        coreFramework = (AS07CoreDMSFramework)df;
                    }
                    catch (PropertyNotPresentException pnp) {
                        LOGGER.log(Level.INFO, pnp.toString());
                    }
                }
            }
        }
        return coreFramework;
    }

    @Override
    public AS07CoreDMSFramework getAS07CoreDMSFramework() {
        this.getFile();
        AS07CoreDMSFramework coreFramework = this.getAS07CoreDMSFrameworkFooter();
        if (coreFramework == null) {
            coreFramework = this.getAS07CoreDMSFrameworkHeader();
        }
        return coreFramework;
    }

    @Override
    public void setAS07CoreDMSFramework(AS07CoreDMSFramework dms) {
        DescriptiveFramework df;
        DescriptiveMarker m;
        List components;
        Sequence seq;
        StaticTrack st;
        Segment ts;
        Set packages;
        ContentStorage contentStorage;
        Preface preface;
        AS07CoreDMSFramework coreFrameworkHeader = this.getAS07CoreDMSFrameworkHeader();
        AS07CoreDMSFramework coreFrameworkFooter = this.getAS07CoreDMSFrameworkFooter();
        EmbARCIdentification embarcIdent = this.getIdentification();
        if (coreFrameworkHeader != null) {
            HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
            preface = fromTheHeader.getPreface();
            preface.appendIdentification(embarcIdent.getIdentification());
            contentStorage = preface.getContentStorageObject();
            packages = contentStorage.getPackages();
            for (Package p : packages) {
                if (!(p instanceof MaterialPackage)) continue;
                for (Track t : p.getPackageTracks()) {
                    if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                    seq = (Sequence)ts;
                    components = seq.getComponentObjects();
                    for (Component c : components) {
                        if (!(c instanceof DescriptiveMarkerImpl)) continue;
                        m = (DescriptiveMarker)c;
                        try {
                            df = m.getDescriptiveFrameworkObject();
                            if (df == null || !(df instanceof AS07CoreDMSFramework)) continue;
                            m.setDescriptiveFrameworkObject((DescriptiveFramework)dms);
                        }
                        catch (PropertyNotPresentException pnp) {
                            LOGGER.log(Level.INFO, pnp.toString());
                        }
                    }
                }
            }
        }
        if (coreFrameworkFooter != null) {
            HeaderMetadata fromTheFooter = this.file.getFooterPartition().readHeaderMetadata();
            preface = fromTheFooter.getPreface();
            preface.appendIdentification(embarcIdent.getIdentification());
            contentStorage = preface.getContentStorageObject();
            packages = contentStorage.getPackages();
            for (Package p : packages) {
                if (!(p instanceof MaterialPackage)) continue;
                for (Track t : p.getPackageTracks()) {
                    if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                    seq = (Sequence)ts;
                    components = seq.getComponentObjects();
                    for (Component c : components) {
                        if (!(c instanceof DescriptiveMarkerImpl)) continue;
                        m = (DescriptiveMarker)c;
                        try {
                            df = m.getDescriptiveFrameworkObject();
                            if (df == null || !(df instanceof AS07CoreDMSFramework)) continue;
                            m.setDescriptiveFrameworkObject((DescriptiveFramework)dms);
                        }
                        catch (PropertyNotPresentException pnp) {
                            LOGGER.log(Level.INFO, pnp.toString());
                        }
                    }
                }
            }
        }
    }

    @Override
    public boolean hasAS07CoreDMSFramework() {
        if (this.file == null) {
            this.file = MXFFactory.readPartitions((String)this.filePath);
        }
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        ContentStorage contentStorage = preface.getContentStorageObject();
        Set packages = contentStorage.getPackages();
        for (Package p : packages) {
            if (!(p instanceof MaterialPackage)) continue;
            for (Track t : p.getPackageTracks()) {
                StaticTrack st;
                Segment ts;
                if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                Sequence seq = (Sequence)ts;
                List components = seq.getComponentObjects();
                for (Component c : components) {
                    if (!(c instanceof DescriptiveMarkerImpl)) continue;
                    DescriptiveMarker m = (DescriptiveMarker)c;
                    try {
                        DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                        if (df == null || !(df instanceof AS07CoreDMSFramework)) continue;
                        return true;
                    }
                    catch (PropertyNotPresentException pnp) {
                        LOGGER.log(Level.INFO, pnp.toString());
                    }
                }
            }
        }
        return false;
    }

    @Override
    public FileInformation<MXFMetadata> getMetadata() {
        File tf = new File(this.filePath);
        if (this.file == null) {
            this.file = MXFFactory.readPartitions((String)this.filePath);
        }
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        MXFMetadata metadata = new MXFMetadata();
        MXFFileDescriptorResult descriptors = this.getDescriptors();
        metadata.setFileDescriptors(descriptors);
        int otherTrackCount = 0;
        otherTrackCount += descriptors.getAncillaryPacketsDescriptors().size();
        otherTrackCount += descriptors.getTimedTextDescriptor().size();
        metadata.setOtherTrackCount(otherTrackCount += descriptors.getAS07DateTimeDescriptor().size());
        metadata.setSoundTrackCount(this.getSoundCount());
        metadata.setPictureTrackCount(this.getPictureCount());
        metadata.setFileSize(tf.length());
        metadata.setFormat("MXF");
        metadata.setProfile(preface.getOperationalPattern().toString());
        metadata.setVersion(preface.getFormatVersion().toString());
        LinkedHashMap<MXFColumn, MetadataColumnDef> columns = new LinkedHashMap<MXFColumn, MetadataColumnDef>();
        AS07CoreDMSFramework core = this.getAS07CoreDMSFramework();
        if (core == null) {
            core = new AS07CoreDMSFrameworkImpl();
        }
        IdentifierSetHelper idSetHelper = new IdentifierSetHelper();
        String identifiers = idSetHelper.identifiersToString(core.getIdentifiers());
        String devices = "";
        try {
            DeviceSetHelper deviceSetHelper = new DeviceSetHelper();
            List devicesList = core.getDevices();
            if (devicesList != null) {
                devices = deviceSetHelper.devicesToString(devicesList);
            }
        }
        catch (PropertyNotPresentException ex) {
            LOGGER.log(Level.WARNING, ex.toString(), ex);
        }
        String atlValue = "";
        if (core.getAudioTrackLayout() != null) {
            AUID audioTrackLayout = core.getAudioTrackLayout();
            String atl = audioTrackLayout.toString().replace("urn:smpte:ul:", "");
            AudioTrackLayoutValues atlv = new AudioTrackLayoutValues();
            atlValue = atlv.getDescription(atl);
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_AudioTrackLayout, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_AudioTrackLayout, atlValue));
        }
        catch (Exception ex) {
            LOGGER.log(Level.INFO, "AS_07_Core_DMS_AudioTrackLayout Property Not Present");
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_AudioTrackLayoutComment, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_AudioTrackLayoutComment, core.getAudioTrackLayoutComment()));
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_AudioTrackPrimaryLanguage, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_AudioTrackPrimaryLanguage, core.getAudioTrackPrimaryLanguage()));
        }
        catch (PropertyNotPresentException ex) {
            // empty catch block
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_AudioTrackSecondaryLanguage, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_AudioTrackSecondaryLanguage, core.getAudioTrackSecondaryLanguage()));
        }
        catch (PropertyNotPresentException ex) {
            // empty catch block
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_Captions, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_Captions, core.getCaptions()));
        }
        catch (PropertyNotPresentException ex) {
            LOGGER.log(Level.INFO, "AS_07_Core_DMS_Captions Property Not Present");
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_Devices, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_Devices, devices));
        }
        catch (PropertyNotPresentException ex) {
            // empty catch block
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_Identifiers, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_Identifiers, identifiers));
        }
        catch (PropertyNotPresentException ex) {
            LOGGER.log(Level.INFO, "AS_07_Core_DMS_Identifiers Property Not Present");
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_IntendedAFD, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_IntendedAFD, core.getIntendedAFD()));
        }
        catch (PropertyNotPresentException ex) {
            LOGGER.log(Level.INFO, "AS_07_Core_DMS_IntendedAFD Property Not Present");
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_NatureOfOrganization, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_NatureOfOrganization, core.getNatureOfOrganization()));
        }
        catch (PropertyNotPresentException ex) {
            // empty catch block
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_PictureFormat, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_PictureFormat, core.getPictureFormat()));
        }
        catch (PropertyNotPresentException ex) {
            LOGGER.log(Level.INFO, "AS_07_Core_DMS_PictureFormat Property Not Present");
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_ResponsibleOrganizationCode, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_ResponsibleOrganizationCode, core.getResponsibleOrganizationCode()));
        }
        catch (PropertyNotPresentException ex) {
            // empty catch block
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_ResponsibleOrganizationName, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_ResponsibleOrganizationName, core.getResponsibleOrganizationName()));
        }
        catch (PropertyNotPresentException ex) {
            LOGGER.log(Level.INFO, "AS_07_Core_DMS_ResponsibleOrganizationName Property Not Present");
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_SecondaryTitle, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_SecondaryTitle, core.getSecondaryTitle()));
        }
        catch (PropertyNotPresentException ex) {
            // empty catch block
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_ShimName, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_ShimName, core.getShimName()));
        }
        catch (PropertyNotPresentException ex) {
            LOGGER.log(Level.INFO, "AS_07_Core_DMS_ShimName Property Not Present");
        }
        try {
            columns.put(MXFColumn.AS_07_Core_DMS_WorkingTitle, new StringMetadataColumn(MXFColumn.AS_07_Core_DMS_WorkingTitle, core.getWorkingTitle()));
        }
        catch (PropertyNotPresentException ex) {
            // empty catch block
        }
        metadata.setCoreColumns(columns);
        List<AS07GspBdDMSFrameworkImpl> bds = this.getAS07GspBdDMSFramework();
        HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> bdColumns = new HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>>();
        for (AS07GspBdDMSFrameworkImpl bd : bds) {
            LinkedHashMap<MXFColumn, StringMetadataColumn> cols = new LinkedHashMap<MXFColumn, StringMetadataColumn>();
            AS07GSPDMSObject binaryObject = bd.getTextBasedObject();
            try {
                cols.put(MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier, new StringMetadataColumn(MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier, binaryObject.getTextBasedMetadataPayloadSchemeID().toString()));
            }
            catch (PropertyNotPresentException ex) {
                cols.put(MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier, new StringMetadataColumn(MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier, "PROPERTY NOT PRESENT"));
            }
            try {
                cols.put(MXFColumn.AS_07_Object_RFC5646TextLanguageCode, new StringMetadataColumn(MXFColumn.AS_07_Object_RFC5646TextLanguageCode, binaryObject.getRfc5646TextLanguageCode()));
            }
            catch (PropertyNotPresentException ex) {
                cols.put(MXFColumn.AS_07_Object_RFC5646TextLanguageCode, new StringMetadataColumn(MXFColumn.AS_07_Object_RFC5646TextLanguageCode, "PROPERTY NOT PRESENT"));
            }
            try {
                cols.put(MXFColumn.AS_07_Object_MIMEMediaType, new StringMetadataColumn(MXFColumn.AS_07_Object_MIMEMediaType, binaryObject.getMimeMediaType()));
            }
            catch (PropertyNotPresentException ex) {
                cols.put(MXFColumn.AS_07_Object_MIMEMediaType, new StringMetadataColumn(MXFColumn.AS_07_Object_MIMEMediaType, "PROPERTY NOT PRESENT"));
            }
            try {
                cols.put(MXFColumn.AS_07_Object_TextMIMEMediaType, new StringMetadataColumn(MXFColumn.AS_07_Object_TextMIMEMediaType, binaryObject.getTextMimeMediaType()));
            }
            catch (PropertyNotPresentException ex) {
                cols.put(MXFColumn.AS_07_Object_TextMIMEMediaType, new StringMetadataColumn(MXFColumn.AS_07_Object_TextMIMEMediaType, "PROPERTY NOT PRESENT"));
            }
            try {
                cols.put(MXFColumn.AS_07_Object_DataDescription, new StringMetadataColumn(MXFColumn.AS_07_Object_DataDescription, binaryObject.getDataDescriptions()));
            }
            catch (PropertyNotPresentException ex) {
                cols.put(MXFColumn.AS_07_Object_DataDescription, new StringMetadataColumn(MXFColumn.AS_07_Object_DataDescription, "PROPERTY NOT PRESENT"));
            }
            try {
                cols.put(MXFColumn.AS_07_Object_TextDataDescription, new StringMetadataColumn(MXFColumn.AS_07_Object_TextDataDescription, binaryObject.getTextDataDescriptions()));
            }
            catch (PropertyNotPresentException ex) {
                cols.put(MXFColumn.AS_07_Object_TextDataDescription, new StringMetadataColumn(MXFColumn.AS_07_Object_TextDataDescription, "PROPERTY NOT PRESENT"));
            }
            try {
                cols.put(MXFColumn.AS_07_Object_Note, new StringMetadataColumn(MXFColumn.AS_07_Object_Note, binaryObject.getNote()));
            }
            catch (PropertyNotPresentException ex) {
                cols.put(MXFColumn.AS_07_Object_Note, new StringMetadataColumn(MXFColumn.AS_07_Object_Note, "PROPERTY NOT PRESENT"));
            }
            try {
                cols.put(MXFColumn.AS_07_Object_GenericStreamID, new StringMetadataColumn(MXFColumn.AS_07_Object_GenericStreamID, Integer.toString(binaryObject.getGenericStreamId())));
            }
            catch (PropertyNotPresentException ex) {
                cols.put(MXFColumn.AS_07_Object_GenericStreamID, new StringMetadataColumn(MXFColumn.AS_07_Object_GenericStreamID, "PROPERTY NOT PRESENT"));
            }
            List identSet = binaryObject.getIdentifiers();
            String objIdentifiers = idSetHelper.identifiersToString(identSet);
            cols.put(MXFColumn.AS_07_Object_Identifiers, new StringMetadataColumn(MXFColumn.AS_07_Object_Identifiers, objIdentifiers));
            try {
                bdColumns.put(Integer.toString(binaryObject.getGenericStreamId()), cols);
            }
            catch (PropertyNotPresentException propertyNotPresentException) {}
        }
        metadata.setBDCount(bdColumns.size());
        metadata.setBDColumns(bdColumns);
        try {
            List<AS07GspTdDMSFrameworkImpl> tds = this.getAS07GspTdDMSFramework();
            HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> tdColumns = new HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>>();
            for (AS07GspTdDMSFrameworkImpl td : tds) {
                LinkedHashMap<MXFColumn, StringMetadataColumn> cols = new LinkedHashMap<MXFColumn, StringMetadataColumn>();
                try {
                    cols.put(MXFColumn.AS_07_TD_DMS_PrimaryRFC5646LanguageCode, new StringMetadataColumn(MXFColumn.AS_07_TD_DMS_PrimaryRFC5646LanguageCode, td.getPrimaryRFC5646LanguageCode()));
                }
                catch (PropertyNotPresentException ex) {
                    cols.put(MXFColumn.AS_07_TD_DMS_PrimaryRFC5646LanguageCode, new StringMetadataColumn(MXFColumn.AS_07_TD_DMS_PrimaryRFC5646LanguageCode, "PROPERTY NOT PRESENT"));
                }
                AS07GSPDMSObject textBasedObject = td.getTextBasedObject();
                List identSet = textBasedObject.getIdentifiers();
                String objIdentifiers = idSetHelper.identifiersToString(identSet);
                try {
                    cols.put(MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier, new StringMetadataColumn(MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier, textBasedObject.getTextBasedMetadataPayloadSchemeID().toString()));
                }
                catch (PropertyNotPresentException ex) {
                    cols.put(MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier, new StringMetadataColumn(MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier, "PROPERTY NOT PRESENT"));
                }
                try {
                    cols.put(MXFColumn.AS_07_Object_RFC5646TextLanguageCode, new StringMetadataColumn(MXFColumn.AS_07_Object_RFC5646TextLanguageCode, textBasedObject.getRfc5646TextLanguageCode()));
                }
                catch (PropertyNotPresentException ex) {
                    cols.put(MXFColumn.AS_07_Object_RFC5646TextLanguageCode, new StringMetadataColumn(MXFColumn.AS_07_Object_RFC5646TextLanguageCode, "PROPERTY NOT PRESENT"));
                }
                try {
                    String mimeType = textBasedObject.getMimeMediaType();
                    cols.put(MXFColumn.AS_07_Object_MIMEMediaType, new StringMetadataColumn(MXFColumn.AS_07_Object_MIMEMediaType, textBasedObject.getMimeMediaType()));
                    if (mimeType.equals("text/xml")) {
                        ManifestParserImpl mfParser = new ManifestParserImpl();
                        ByteBuffer bb = this.GetGenericStream(textBasedObject.getGenericStreamId());
                        if (bb != null) {
                            ManifestType mfType = mfParser.isManifest(bb);
                            cols.put(MXFColumn.AS_07_Manifest, new StringMetadataColumn(MXFColumn.AS_07_Manifest, mfType == ManifestType.NOT_MANIFEST ? "false" : "true"));
                            cols.put(MXFColumn.AS_07_Manifest_Valid, new StringMetadataColumn(MXFColumn.AS_07_Manifest_Valid, mfType == ManifestType.VALID_MANIFEST ? "true" : "false"));
                        } else {
                            cols.put(MXFColumn.AS_07_Manifest, new StringMetadataColumn(MXFColumn.AS_07_Manifest, "false"));
                            cols.put(MXFColumn.AS_07_Manifest_Valid, new StringMetadataColumn(MXFColumn.AS_07_Manifest_Valid, "false"));
                        }
                    }
                }
                catch (PropertyNotPresentException mimeType) {
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.WARNING, e.toString(), e);
                }
                try {
                    cols.put(MXFColumn.AS_07_Object_TextMIMEMediaType, new StringMetadataColumn(MXFColumn.AS_07_Object_TextMIMEMediaType, textBasedObject.getTextMimeMediaType()));
                }
                catch (PropertyNotPresentException ex) {
                    cols.put(MXFColumn.AS_07_Object_TextMIMEMediaType, new StringMetadataColumn(MXFColumn.AS_07_Object_TextMIMEMediaType, "PROPERTY NOT PRESENT"));
                }
                try {
                    cols.put(MXFColumn.AS_07_Object_DataDescription, new StringMetadataColumn(MXFColumn.AS_07_Object_DataDescription, textBasedObject.getDataDescriptions()));
                }
                catch (PropertyNotPresentException ex) {
                    cols.put(MXFColumn.AS_07_Object_DataDescription, new StringMetadataColumn(MXFColumn.AS_07_Object_DataDescription, "PROPERTY NOT PRESENT"));
                }
                try {
                    cols.put(MXFColumn.AS_07_Object_TextDataDescription, new StringMetadataColumn(MXFColumn.AS_07_Object_TextDataDescription, textBasedObject.getTextDataDescriptions()));
                }
                catch (PropertyNotPresentException ex) {
                    cols.put(MXFColumn.AS_07_Object_TextDataDescription, new StringMetadataColumn(MXFColumn.AS_07_Object_TextDataDescription, "PROPERTY NOT PRESENT"));
                }
                try {
                    cols.put(MXFColumn.AS_07_Object_Note, new StringMetadataColumn(MXFColumn.AS_07_Object_Note, textBasedObject.getNote()));
                }
                catch (PropertyNotPresentException ex) {
                    cols.put(MXFColumn.AS_07_Object_Note, new StringMetadataColumn(MXFColumn.AS_07_Object_Note, "PROPERTY NOT PRESENT"));
                }
                try {
                    cols.put(MXFColumn.AS_07_Object_GenericStreamID, new StringMetadataColumn(MXFColumn.AS_07_Object_GenericStreamID, Integer.toString(textBasedObject.getGenericStreamId())));
                }
                catch (PropertyNotPresentException ex) {
                    cols.put(MXFColumn.AS_07_Object_GenericStreamID, new StringMetadataColumn(MXFColumn.AS_07_Object_GenericStreamID, "PROPERTY NOT PRESENT"));
                }
                try {
                    cols.put(MXFColumn.AS_07_Object_Identifiers, new StringMetadataColumn(MXFColumn.AS_07_Object_Identifiers, objIdentifiers));
                }
                catch (PropertyNotPresentException ex) {
                    cols.put(MXFColumn.AS_07_Object_Identifiers, new StringMetadataColumn(MXFColumn.AS_07_Object_Identifiers, "PROPERTY NOT PRESENT"));
                }
                try {
                    tdColumns.put(Integer.toString(textBasedObject.getGenericStreamId()), cols);
                }
                catch (PropertyNotPresentException propertyNotPresentException) {}
            }
            metadata.setTDCount(tdColumns.size());
            metadata.setTDColumns(tdColumns);
        }
        catch (PropertyNotPresentException ex) {
            LOGGER.log(Level.WARNING, ex.toString(), ex);
        }
        FileInformation<MXFMetadata> fileInformation = new FileInformation<MXFMetadata>();
        fileInformation.setName(tf.getName());
        fileInformation.setPath(this.filePath);
        metadata.setHasAS07CoreDMSFramework(this.hasAS07CoreDMSFramework());
        fileInformation.setFileData(metadata);
        return fileInformation;
    }

    public int getPictureCount() {
        int count = 0;
        if (this.file == null) {
            this.file = MXFFactory.readPartitions((String)this.filePath);
        }
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        ContentStorage contentStorage = preface.getContentStorageObject();
        Set packages = contentStorage.getPackages();
        for (Package p : packages) {
            if (!(p instanceof MaterialPackage)) continue;
            for (Track t : p.getPackageTracks()) {
                TimelineTrack st;
                Segment ts;
                DataDefinition d;
                if (!(t instanceof TimelineTrack) || !(d = (ts = (st = (TimelineTrack)t).getTrackSegment()).getComponentDataDefinition()).isPictureKind()) continue;
                ++count;
            }
        }
        return count;
    }

    public int getSoundCount() {
        int count = 0;
        if (this.file == null) {
            this.file = MXFFactory.readPartitions((String)this.filePath);
        }
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        ContentStorage contentStorage = preface.getContentStorageObject();
        Set packages = contentStorage.getPackages();
        for (Package p : packages) {
            if (!(p instanceof MaterialPackage)) continue;
            for (Track t : p.getPackageTracks()) {
                TimelineTrack st;
                Segment ts;
                DataDefinition d;
                if (!(t instanceof TimelineTrack) || !(d = (ts = (st = (TimelineTrack)t).getTrackSegment()).getComponentDataDefinition()).isSoundKind()) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    public boolean hasAS07DMSIdentifierSet() {
        if (this.file == null) {
            this.file = MXFFactory.readPartitions((String)this.filePath);
        }
        HeaderMetadata fromTheHeader = this.file.getHeaderPartition().readHeaderMetadata();
        Preface preface = fromTheHeader.getPreface();
        ContentStorage contentStorage = preface.getContentStorageObject();
        Set packages = contentStorage.getPackages();
        for (Package p : packages) {
            if (!(p instanceof MaterialPackage)) continue;
            for (Track t : p.getPackageTracks()) {
                StaticTrack st;
                Segment ts;
                if (!(t instanceof StaticTrack) || !((ts = (st = (StaticTrack)t).getTrackSegment()) instanceof Sequence)) continue;
                Sequence seq = (Sequence)ts;
                List components = seq.getComponentObjects();
                for (Component c : components) {
                    if (!(c instanceof DescriptiveMarkerImpl)) continue;
                    DescriptiveMarker m = (DescriptiveMarker)c;
                    try {
                        DescriptiveFramework df = m.getDescriptiveFrameworkObject();
                        if (df == null || !(df instanceof AS07DMSIdentifierSet)) continue;
                        return true;
                    }
                    catch (PropertyNotPresentException pnp) {
                        LOGGER.log(Level.WARNING, pnp.toString(), pnp);
                    }
                }
            }
        }
        return false;
    }
}

