/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser;

import com.portalmedia.embarc.parser.ColumnDef;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;

public class ValueToBytesHelper {
    public static byte[] ToByte(String value, int length, ByteOrder byteOrder) {
        byte i = -1;
        if (value.length() != 0) {
            i = Byte.parseByte(value);
        }
        return ByteBuffer.allocate(length).put(i).array();
    }

    public static byte[] ToDate(String value, int length, ByteOrder byteOrder) {
        return ByteBuffer.allocate(length).put(value.getBytes()).array();
    }

    public static byte[] ToFloat(String value, int length, ByteOrder byteOrder) {
        float i = -32768.0f;
        if (value.length() == 0) {
            int v = (int)Long.parseLong("ffffffff", 16);
            ByteBuffer buffer = ByteBuffer.allocate(length);
            buffer.order(byteOrder);
            buffer.putInt(v);
            byte[] bytes = buffer.array();
            return bytes;
        }
        i = Float.parseFloat(value);
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.order(byteOrder);
        buffer.putFloat(i);
        byte[] bytes = buffer.array();
        return bytes;
    }

    public static byte[] ToInt(String value, int length, ByteOrder byteOrder) {
        Long i = value.length() == 0 ? Long.valueOf(Long.parseLong("ffffffff", 16)) : Long.valueOf(Long.parseLong(value));
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.order(byteOrder);
        buffer.putInt((int)(i & 0xFFFFFFFFL));
        byte[] bytes = buffer.array();
        return bytes;
    }

    public static byte[] ToIntArray(String value, int valueLength, int arrayLength, ByteOrder byteOrder) {
        int[] intValues = new int[arrayLength / 4];
        if (value.length() == 0) {
            byte[] bytes = new byte[arrayLength];
            int b = -1;
            for (int x = 0; x < valueLength; ++x) {
                bytes[x] = -1;
            }
            return bytes;
        }
        String[] values = value.replace("[", "").replace("]", "").split(",");
        Object i = 0;
        while ((Integer)i < arrayLength / 4) {
            int v;
            intValues[((Integer)i).intValue()] = (Integer)i >= values.length ? (v = (int)Long.parseLong("ffffffff", 16)) : (values[(Integer)i].length() == 0 ? (v = (int)Long.parseLong("ffffffff", 16)) : Integer.parseInt(values[(Integer)i]));
            Object object = i;
            i = (Integer)i + 1;
        }
        ByteBuffer byteBuff = ByteBuffer.allocate(arrayLength);
        byteBuff.order(byteOrder);
        for (Object i2 : (Object)intValues) {
            byteBuff.putInt((int)i2);
        }
        byte[] bytes = byteBuff.array();
        if (byteOrder == ByteOrder.nativeOrder()) {
            return ByteBuffer.allocate(arrayLength).put(bytes).array();
        }
        return ByteBuffer.allocate(arrayLength).order(byteOrder).put(bytes).array();
    }

    public static byte[] ToShort(String value, int length, ByteOrder byteOrder) {
        if (value.length() == 0) {
            int v = (int)Long.parseLong("ffffffff", 16);
            ByteBuffer buffer = ByteBuffer.allocate(length);
            buffer.order(byteOrder);
            buffer.putShort((short)v);
            byte[] bytes = buffer.array();
            return bytes;
        }
        int i = Integer.parseInt(value);
        ByteBuffer buffer = ByteBuffer.allocate(length);
        buffer.order(byteOrder);
        buffer.putShort((short)(i & 0xFFFF));
        byte[] bytes = buffer.array();
        return bytes;
    }

    public static byte[] ToShortArray(String value, int valueLength, int arrayLength, ByteOrder byteOrder) {
        short[] shortValues = new short[arrayLength / 2];
        if (value.length() == 0) {
            byte[] bytes = new byte[arrayLength];
            int b = -1;
            for (int x = 0; x < valueLength; ++x) {
                bytes[x] = -1;
            }
            return bytes;
        }
        String[] values = value.replace("[", "").replace("]", "").split(",");
        for (int i = 0; i < arrayLength / 2; i = (int)((short)(i + 1))) {
            shortValues[i] = values.length <= i ? -1 : (values[i].length() == 0 ? -1 : Short.parseShort(values[i]));
        }
        ByteBuffer byteBuff = ByteBuffer.allocate(arrayLength);
        byteBuff.order(byteOrder);
        for (short i : shortValues) {
            byteBuff.putShort(i);
        }
        byte[] bytes = byteBuff.array();
        if (byteOrder == ByteOrder.nativeOrder()) {
            return ByteBuffer.allocate(arrayLength).put(bytes).array();
        }
        return ByteBuffer.allocate(arrayLength).order(byteOrder).put(bytes).array();
    }

    public static byte[] ToString(String value, int length, ByteOrder byteOrder) {
        byte[] bytes = Arrays.copyOfRange(value.getBytes(), 0, Math.min(length, value.length()));
        return ByteBuffer.allocate(length).put(bytes).array();
    }

    public static byte[] ToTypedValue(ColumnDef column, String value, int length, ByteOrder byteOrder) throws Exception {
        if (column.getType() == Integer.TYPE) {
            return ValueToBytesHelper.ToInt(value, length, byteOrder);
        }
        if (column.getType() == String.class) {
            return ValueToBytesHelper.ToString(value, length, byteOrder);
        }
        if (column.getType() == Short.TYPE) {
            return ValueToBytesHelper.ToShort(value, length, byteOrder);
        }
        if (column.getType() == Float.TYPE) {
            return ValueToBytesHelper.ToFloat(value, length, byteOrder);
        }
        if (column.getType() == Byte.TYPE) {
            return ValueToBytesHelper.ToByte(value, length, byteOrder);
        }
        if (column.getType() == Date.class) {
            return ValueToBytesHelper.ToDate(value, length, byteOrder);
        }
        if (column.getType() == int[].class) {
            return ValueToBytesHelper.ToIntArray(value, column.getLength(), length, byteOrder);
        }
        if (column.getType() == short[].class) {
            return ValueToBytesHelper.ToShortArray(value, column.getLength(), length, byteOrder);
        }
        throw new Exception("Invalid data type " + String.valueOf(column.getType()));
    }
}

