/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.AccessibleAlertHelper;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.ProgressSpinner;
import com.portalmedia.embarc.gui.helper.MXFFileList;
import com.portalmedia.embarc.gui.helper.RowNumberManager;
import com.portalmedia.embarc.gui.model.MXFFileInformationViewModel;
import com.portalmedia.embarc.gui.model.MXFMetadataColumnViewModel;
import com.portalmedia.embarc.gui.model.MXFSelectedFilesSummary;
import com.portalmedia.embarc.gui.mxf.ControllerMediatorMXF;
import com.portalmedia.embarc.gui.mxf.ValidationCellFactoryMXF;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.parser.mxf.DeviceSetHelper;
import com.portalmedia.embarc.parser.mxf.IdentifierSetHelper;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import com.portalmedia.embarc.parser.mxf.MXFColumnHelpText;
import com.portalmedia.embarc.parser.mxf.MXFFileInfo;
import com.portalmedia.embarc.parser.mxf.MXFMetadataColumnViewModelList;
import com.portalmedia.embarc.parser.mxf.MXFSection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Window;
import javafx.util.Callback;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.model.impl.AS07CoreDMSDeviceObjectsImpl;
import tv.amwa.maj.model.impl.AS07DMSIdentifierSetImpl;

public class TabAreaMXFController
implements Initializable {
    @FXML
    private TabPane mxfTabPane;
    @FXML
    private TableView<MXFFileInformationViewModel> mxfTable;
    private TableView.TableViewSelectionModel<MXFFileInformationViewModel> tableSelectionModel;
    private SectionDef selectedSection;
    private MXFSelectedFilesSummary selectedFilesSummary;
    private final String TAB_VALIDATION_WARNING = " Contains validation error";

    public void initialize(URL location, ResourceBundle resources) {
        ControllerMediatorMXF.getInstance().registerTabAreaController(this);
        this.setTabClickListener();
        this.setDescriptorColumns();
        this.setFileInfoColumns();
        this.mxfTable.setFocusTraversable(true);
        this.mxfTable.addEventHandler(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode().equals((Object)KeyCode.ENTER)) {
                    TableColumn focusedColumn = TabAreaMXFController.this.mxfTable.getFocusModel().getFocusedCell().getTableColumn();
                    if (focusedColumn != null && focusedColumn.isSortable()) {
                        if (focusedColumn.getSortType() == TableColumn.SortType.ASCENDING) {
                            focusedColumn.setSortType(TableColumn.SortType.DESCENDING);
                        } else {
                            focusedColumn.setSortType(TableColumn.SortType.ASCENDING);
                        }
                        TabAreaMXFController.this.mxfTable.getSortOrder().clear();
                        TabAreaMXFController.this.mxfTable.getSortOrder().add((Object)focusedColumn);
                    }
                    event.consume();
                }
            }
        });
        this.tableSelectionModel = this.mxfTable.getSelectionModel();
        this.tableSelectionModel.setSelectionMode(SelectionMode.MULTIPLE);
        this.tableSelectionModel.getSelectedItems().addListener(change -> {
            this.selectedFilesSummary = MXFSelectedFilesSummary.create((List<MXFFileInformationViewModel>)this.tableSelectionModel.getSelectedItems());
            ControllerMediatorMXF.getInstance().setSelectedFileList(this.selectedFilesSummary);
            this.refreshEditor(false);
        });
        MXFFileList.getInstance().hasCoreRequiredFieldsErrorProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> o, Boolean ov, Boolean nv) {
                TabAreaMXFController.this.setTabWarnings();
            }
        });
        this.setTabWarnings();
        this.refreshEditor(false);
        this.setColumnVisibility("FileInfo");
        this.mxfTable.scrollToColumnIndex(0);
        this.selectSection(MXFSection.FILEINFO);
    }

    public ObservableList<MXFFileInformationViewModel> getSelectedFiles() {
        return this.mxfTable.getSelectionModel().getSelectedItems();
    }

    public void deleteSelectedFiles() {
        ObservableList filesToDelete = this.tableSelectionModel.getSelectedItems();
        MXFFileList.deleteSelectedRows((List<MXFFileInformationViewModel>)filesToDelete);
        this.setFiles();
    }

    public void selectAllFiles() {
        this.tableSelectionModel.selectAll();
        this.refreshEditor(false);
    }

    public void deselectAllFiles() {
        this.tableSelectionModel.clearSelection();
        this.refreshEditor(false);
    }

    public TableView<MXFFileInformationViewModel> getTable() {
        return this.mxfTable;
    }

    public int getTableSize() {
        return this.mxfTable.getItems().size();
    }

    public MXFSelectedFilesSummary getSelectedFilesSummary() {
        return this.selectedFilesSummary;
    }

    public void setFiles() {
        this.mxfTable.setItems(MXFFileList.getInstance().getObservableList());
        this.setDataColumns();
    }

    public void refreshEditor(boolean updateSummary) {
        int selectedRowCount;
        if (updateSummary) {
            this.selectedFilesSummary = MXFSelectedFilesSummary.create((List<MXFFileInformationViewModel>)this.tableSelectionModel.getSelectedItems());
        }
        if ((selectedRowCount = this.tableSelectionModel.getSelectedItems().size()) == 0) {
            ControllerMediatorMXF.getInstance().resetEditArea();
            ControllerMediatorMXF.getInstance().setWriter();
        }
        if (selectedRowCount > 0 && this.selectedSection == null) {
            ControllerMediatorMXF.getInstance().resetEditArea();
            ControllerMediatorMXF.getInstance().setDescriptor();
        }
        if (selectedRowCount > 0 && this.selectedSection != null) {
            if (this.selectedSection == MXFSection.TD || this.selectedSection == MXFSection.BD) {
                ControllerMediatorMXF.getInstance().setTDBD(this.selectedSection);
            } else if (this.selectedSection == MXFSection.FILEINFO) {
                ControllerMediatorMXF.getInstance().setFileInfo();
            } else if (this.selectedSection == MXFSection.CORE) {
                ControllerMediatorMXF.getInstance().setCore();
            } else {
                ControllerMediatorMXF.getInstance().resetEditArea();
                ControllerMediatorMXF.getInstance().setFileInfo();
            }
        }
    }

    public void setTabClickListener() {
        this.mxfTabPane.getSelectionModel().selectedItemProperty().addListener((ov, oldTab, newTab) -> {
            if (this.mxfTable.getItems().size() > 0) {
                this.mxfTabPane.requestFocus();
                switch (newTab.getId()) {
                    case "fileInfoTab": {
                        this.setColumnVisibility("FileInfo");
                        this.mxfTable.scrollToColumnIndex(0);
                        this.selectSection(MXFSection.FILEINFO);
                        break;
                    }
                    case "descriptorsTab": {
                        this.setColumnVisibility("Descriptors");
                        this.mxfTable.scrollToColumnIndex(0);
                        this.selectedSection = null;
                        this.selectSection(this.selectedSection);
                        break;
                    }
                    case "coreTab": {
                        this.setColumnVisibility("CORE");
                        this.mxfTable.scrollToColumnIndex(0);
                        this.selectSection(MXFSection.CORE);
                        break;
                    }
                    case "tdTab": {
                        this.setColumnVisibility("TD");
                        this.mxfTable.scrollToColumnIndex(0);
                        this.selectSection(MXFSection.TD);
                        break;
                    }
                    case "bdTab": {
                        this.setColumnVisibility("BD");
                        this.mxfTable.scrollToColumnIndex(0);
                        this.selectSection(MXFSection.BD);
                        break;
                    }
                }
            }
        });
    }

    private void setColumnVisibility(String tabName) {
        for (TableColumn col : this.mxfTable.getColumns()) {
            if (!col.getUserData().toString().equals(tabName) && !col.getUserData().toString().equals("Descriptors")) {
                col.setVisible(false);
                continue;
            }
            col.setVisible(true);
        }
    }

    public void selectSection(SectionDef section) {
        this.selectedSection = section;
        this.refreshEditor(false);
    }

    private void setDescriptorColumns() {
        TableColumn idCol = new TableColumn("Row");
        idCol.setId("Row");
        idCol.setUserData((Object)"Descriptors");
        idCol.getStyleClass().add((Object)"general-section");
        idCol.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MXFFileInformationViewModel, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TableColumn.CellDataFeatures<MXFFileInformationViewModel, String> p) {
                int id = ((MXFFileInformationViewModel)p.getValue()).getId();
                int rowNumber = TabAreaMXFController.this.mxfTable.getItems().indexOf(p.getValue()) + 1;
                RowNumberManager.addRow(id, rowNumber);
                return new ReadOnlyObjectWrapper((Object)("" + rowNumber));
            }
        });
        idCol.setSortable(false);
        idCol.setPrefWidth(50.0);
        this.setColumnToolTip((TableColumn<MXFFileInformationViewModel, String>)idCol, "");
        TableColumn<MXFFileInformationViewModel, String> nameCol = this.createFileInfoCol("Filename", "name", "Descriptors");
        nameCol.getStyleClass().add((Object)"general-section");
        TableColumn<MXFFileInformationViewModel, String> pathCol = this.createFileInfoCol("File Path", "path", "Descriptors");
        pathCol.getStyleClass().add((Object)"general-section");
        this.mxfTable.getColumns().add(nameCol);
        this.mxfTable.getColumns().add(pathCol);
    }

    private void setFileInfoColumns() {
        for (MXFFileInfo fi : MXFFileInfo.values()) {
            TableColumn<MXFFileInformationViewModel, String> col = this.createFileInfoCol(fi.getDisplayName(), fi.getIdentifier(), "FileInfo");
            this.mxfTable.getColumns().add(col);
        }
    }

    private void setDataColumns() {
        if (this.mxfTable.getItems().size() != 0) {
            MXFMetadataColumnViewModelList columnList = MXFMetadataColumnViewModelList.getInstance();
            String section = "";
            for (final MXFMetadataColumnViewModel mcvm : columnList.getColumns()) {
                if (mcvm.getMXFColumn() == MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier || mcvm.getMXFColumn() == MXFColumn.AS_07_TD_DMS_PrimaryRFC5646LanguageCode || mcvm.getMXFColumn() == MXFColumn.AS_07_BD_DMS_PrimaryRFC5646LanguageCode || mcvm.getMXFColumn() == MXFColumn.AS_07_Manifest || mcvm.getMXFColumn() == MXFColumn.AS_07_Manifest_Valid) continue;
                section = mcvm.getColumn().getSection().toString();
                String colName = mcvm.getDisplayName();
                TableColumn col = new TableColumn(colName);
                if ("Identifiers".equals(colName)) {
                    col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MXFFileInformationViewModel, String>, ObservableValue<String>>(){

                        public ObservableValue<String> call(TableColumn.CellDataFeatures<MXFFileInformationViewModel, String> c) {
                            MXFColumn currentCol = mcvm.getMXFColumn();
                            IdentifierSetHelper idSetHelper = new IdentifierSetHelper();
                            ArrayList<AS07DMSIdentifierSetImpl> identifiers = idSetHelper.createIdentifierListFromString(((MXFFileInformationViewModel)c.getValue()).getCoreData().get(currentCol).getCurrentValue());
                            return TabAreaMXFController.this.getIdentifierString(identifiers);
                        }
                    });
                } else if ("Devices".equals(colName)) {
                    col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MXFFileInformationViewModel, String>, ObservableValue<String>>(){

                        public ObservableValue<String> call(TableColumn.CellDataFeatures<MXFFileInformationViewModel, String> c) {
                            MXFColumn currentCol = mcvm.getMXFColumn();
                            DeviceSetHelper deviceSetHelper = new DeviceSetHelper();
                            ArrayList<AS07CoreDMSDeviceObjectsImpl> devices = deviceSetHelper.createDeviceListFromString(((MXFFileInformationViewModel)c.getValue()).getCoreData().get(currentCol).getCurrentValue());
                            if (devices != null && devices.size() > 0) {
                                if (devices.size() > 1) {
                                    return new ReadOnlyStringWrapper("Multiple devices");
                                }
                                String manu = "";
                                String type = "";
                                try {
                                    manu = devices.get(0).getManufacturer();
                                }
                                catch (PropertyNotPresentException propertyNotPresentException) {
                                    // empty catch block
                                }
                                try {
                                    type = devices.get(0).getDeviceType();
                                }
                                catch (PropertyNotPresentException propertyNotPresentException) {
                                    // empty catch block
                                }
                                return new ReadOnlyStringWrapper(manu + " " + type);
                            }
                            return new ReadOnlyStringWrapper("No Devices");
                        }
                    });
                } else if ("CORE".equals(section)) {
                    col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MXFFileInformationViewModel, String>, ObservableValue<String>>(){

                        public ObservableValue<String> call(TableColumn.CellDataFeatures<MXFFileInformationViewModel, String> c) {
                            MetadataColumnDef currentValue;
                            HashMap<MXFColumn, MetadataColumnDef> coreData;
                            MXFFileInformationViewModel fivm;
                            MXFColumn currentCol = mcvm.getMXFColumn();
                            if (c != null && (fivm = (MXFFileInformationViewModel)c.getValue()) != null && (coreData = fivm.getCoreData()) != null && (currentValue = coreData.get(currentCol)) != null) {
                                return new ReadOnlyStringWrapper(currentValue.getCurrentValue());
                            }
                            return new ReadOnlyStringWrapper("");
                        }
                    });
                    col.setCellFactory(column -> new ValidationCellFactoryMXF((TableColumn<MXFFileInformationViewModel, String>)column, mcvm));
                } else {
                    col.setCellValueFactory(c -> new ReadOnlyStringWrapper(((MXFFileInformationViewModel)c.getValue()).getProp(colName)));
                }
                col.setUserData((Object)section);
                col.setVisible(false);
                this.setColumnWidth((TableColumn<MXFFileInformationViewModel, String>)col);
                col.setSortable(true);
                col.setId(mcvm.getDisplayName());
                this.setColumnStyles((TableColumn<MXFFileInformationViewModel, String>)col, mcvm);
                this.setColumnToolTip((TableColumn<MXFFileInformationViewModel, String>)col, MXFColumnHelpText.getInstance().getHelpText(mcvm.getColumn()));
                if (mcvm.getColumn().hasSubsection()) {
                    this.setNestedDataColumns((TableColumn<MXFFileInformationViewModel, String>)col);
                    continue;
                }
                this.mxfTable.getColumns().add((Object)col);
            }
        }
    }

    private void setNestedDataColumns(TableColumn<MXFFileInformationViewModel, String> headerCol) {
        if (this.mxfTable.getItems().size() != 0) {
            MXFMetadataColumnViewModelList columnList = MXFMetadataColumnViewModelList.getInstance();
            for (MXFMetadataColumnViewModel mcvm : columnList.getColumns()) {
                int index;
                TableColumn col;
                MXFColumn mxfCol;
                String colName;
                int i;
                SectionDef sectionDef = mcvm.getColumn().getSection();
                if (sectionDef != MXFSection.OBJECT) continue;
                if ("TD".equals(headerCol.getUserData().toString())) {
                    for (i = 0; i < MXFFileList.getInstance().getMaxTD(); ++i) {
                        colName = Integer.toString(i + 1).concat(" ").concat(mcvm.getDisplayName());
                        mxfCol = mcvm.getMXFColumn();
                        col = new TableColumn(colName);
                        index = i;
                        if (mcvm.getDisplayName() == "Identifiers") {
                            col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MXFFileInformationViewModel, String>, ObservableValue<String>>(){

                                public ObservableValue<String> call(TableColumn.CellDataFeatures<MXFFileInformationViewModel, String> c) {
                                    IdentifierSetHelper idSetHelper = new IdentifierSetHelper();
                                    ArrayList<AS07DMSIdentifierSetImpl> identifiers = idSetHelper.createIdentifierListFromString(((MXFFileInformationViewModel)c.getValue()).getTDElementProperty(index, mxfCol));
                                    return TabAreaMXFController.this.getIdentifierString(identifiers);
                                }
                            });
                        } else {
                            col.setCellValueFactory(c -> new ReadOnlyStringWrapper(((MXFFileInformationViewModel)c.getValue()).getTDElementProperty(index, mxfCol)));
                        }
                        col.setUserData(headerCol.getUserData());
                        col.setVisible(false);
                        this.setColumnWidth((TableColumn<MXFFileInformationViewModel, String>)col);
                        col.setSortable(true);
                        col.setId(mcvm.getDisplayName());
                        this.setColumnToolTip((TableColumn<MXFFileInformationViewModel, String>)col, "");
                        this.setColumnStyles((TableColumn<MXFFileInformationViewModel, String>)col, mcvm);
                        this.mxfTable.getColumns().add((Object)col);
                    }
                }
                if (!"BD".equals(headerCol.getUserData().toString())) continue;
                for (i = 0; i < MXFFileList.getInstance().getMaxBD(); ++i) {
                    colName = Integer.toString(i + 1).concat(" ").concat(mcvm.getDisplayName());
                    mxfCol = mcvm.getMXFColumn();
                    col = new TableColumn(colName);
                    index = i;
                    if (mcvm.getDisplayName() == "Identifiers") {
                        col.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<MXFFileInformationViewModel, String>, ObservableValue<String>>(){

                            public ObservableValue<String> call(TableColumn.CellDataFeatures<MXFFileInformationViewModel, String> c) {
                                IdentifierSetHelper idSetHelper = new IdentifierSetHelper();
                                ArrayList<AS07DMSIdentifierSetImpl> identifiers = idSetHelper.createIdentifierListFromString(((MXFFileInformationViewModel)c.getValue()).getBDElementProperty(index, mxfCol));
                                return TabAreaMXFController.this.getIdentifierString(identifiers);
                            }
                        });
                    } else {
                        col.setCellValueFactory(c -> new ReadOnlyStringWrapper(((MXFFileInformationViewModel)c.getValue()).getBDElementProperty(index, mxfCol)));
                    }
                    col.setUserData(headerCol.getUserData());
                    col.setVisible(false);
                    this.setColumnWidth((TableColumn<MXFFileInformationViewModel, String>)col);
                    col.setSortable(true);
                    col.setId(mcvm.getDisplayName());
                    this.setColumnToolTip((TableColumn<MXFFileInformationViewModel, String>)col, "");
                    this.setColumnStyles((TableColumn<MXFFileInformationViewModel, String>)col, mcvm);
                    this.mxfTable.getColumns().add((Object)col);
                }
            }
        }
    }

    private ReadOnlyStringWrapper getIdentifierString(ArrayList<AS07DMSIdentifierSetImpl> identifiers) {
        if (identifiers != null && identifiers.size() > 0 && identifiers.get(0) != null) {
            if (identifiers.size() > 1) {
                return new ReadOnlyStringWrapper("Multiple identifiers");
            }
            try {
                String idValue = identifiers.get(0).getIdentifierValue();
                try {
                    String idRole = identifiers.get(0).getIdentifierRole();
                    return new ReadOnlyStringWrapper(idValue + " (" + idRole + ")");
                }
                catch (PropertyNotPresentException e) {
                    return new ReadOnlyStringWrapper(idValue);
                }
            }
            catch (PropertyNotPresentException e) {
                return new ReadOnlyStringWrapper("");
            }
        }
        return new ReadOnlyStringWrapper("No Identifiers");
    }

    private TableColumn<MXFFileInformationViewModel, String> createFileInfoCol(String name, String propName, String userData) {
        TableColumn col = new TableColumn(name);
        col.setCellValueFactory(cellData -> new ReadOnlyStringWrapper(((MXFFileInformationViewModel)cellData.getValue()).getProp(propName)));
        col.setId(name);
        col.setUserData((Object)userData);
        if ("FileInfo".equals(userData)) {
            col.setVisible(false);
        } else {
            col.setVisible(true);
        }
        this.setColumnWidth((TableColumn<MXFFileInformationViewModel, String>)col);
        this.setColumnToolTip((TableColumn<MXFFileInformationViewModel, String>)col, "");
        return col;
    }

    private void setColumnWidth(TableColumn<MXFFileInformationViewModel, String> col) {
        col.setPrefWidth(120.0);
    }

    private void setColumnStyles(TableColumn<MXFFileInformationViewModel, String> col, MXFMetadataColumnViewModel mcvm) {
        if (mcvm.isEditable()) {
            col.getStyleClass().add((Object)"editable-column");
        } else {
            col.getStyleClass().add((Object)"uneditable-column");
        }
    }

    private void setColumnToolTip(TableColumn<MXFFileInformationViewModel, String> col, String helpText) {
        String headerName = (String)col.textProperty().get();
        Label title = new Label(headerName);
        if (!helpText.isEmpty()) {
            Tooltip tt = new Tooltip(headerName + "\n\n" + helpText);
            tt.setStyle("-fx-font-size: 12px");
            tt.setPrefWidth(500.0);
            tt.setWrapText(true);
            tt.setAutoHide(false);
            title.setTooltip(tt);
        }
        title.setStyle("-fx-font-size: 12px");
        col.setGraphic((Node)title);
        col.setText("");
    }

    public void updateChangedValues(final HashMap<MXFColumn, MetadataColumnDef> changedValues) {
        ProgressSpinner spinner = new ProgressSpinner();
        final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Task<Void> task = new Task<Void>(){

            public Void call() throws InterruptedException {
                ObservableList selectedIndices = TabAreaMXFController.this.mxfTable.getSelectionModel().getSelectedIndices();
                ArrayList<Callable<Object>> futures = new ArrayList<Callable<Object>>(selectedIndices.size());
                for (Integer i : selectedIndices) {
                    futures.add(Executors.callable(() -> {
                        try {
                            MXFFileInformationViewModel fivm = (MXFFileInformationViewModel)TabAreaMXFController.this.mxfTable.getItems().get(i.intValue());
                            MXFFileList.updateValues(changedValues, fivm);
                        }
                        catch (Exception e) {
                            System.out.println("Update changed values error");
                        }
                    }));
                }
                try {
                    executor.invokeAll(futures);
                }
                catch (InterruptedException e) {
                    System.out.println("Update changed values thread error");
                }
                TabAreaMXFController.this.selectedFilesSummary = MXFSelectedFilesSummary.create((List<MXFFileInformationViewModel>)TabAreaMXFController.this.tableSelectionModel.getSelectedItems());
                return null;
            }
        };
        task.setOnSucceeded(event -> {
            this.mxfTable.refresh();
            this.refreshEditor(false);
            spinner.getDialogStage().hide();
            Platform.runLater(() -> this.showEditsAlert(changedValues.size()));
            executor.shutdown();
        });
        Thread thread = new Thread((Runnable)task);
        thread.start();
        spinner.getDialogStage().show();
    }

    private void showEditsAlert(int editedCount) {
        String info = String.format("%s total fields changed.", editedCount);
        if (editedCount == 1) {
            info = String.format("%s field changed.", editedCount);
        }
        Alert alert = AccessibleAlertHelper.CreateAccessibleAlert("Changes Applied", Alert.AlertType.NONE, info, ButtonType.OK);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        DialogPane dialogPane = alert.getDialogPane();
        alert.getDialogPane().lookupButton(ButtonType.OK).setAccessibleHelp(info);
        dialogPane.getStylesheets().add((Object)this.getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"alertDialog");
        alert.showAndWait();
        if (alert.getResult() == ButtonType.OK) {
            alert.close();
        }
    }

    private void setTabWarnings() {
        ObservableList tabs = this.mxfTabPane.getTabs();
        for (Tab tab : tabs) {
            FontIcon icon = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION);
            icon.getStyleClass().add((Object)"fadgi-sr-warning");
            switch (tab.getId()) {
                case "coreTab": {
                    if (MXFFileList.getInstance().hasCoreRequiredFieldsErrorProperty().get()) {
                        Platform.runLater(() -> this.setAccessibleTabWarning(tab, "Core DMS"));
                        break;
                    }
                    Platform.runLater(() -> this.removeAccessibleTabWarning(tab, "Core DMS"));
                    break;
                }
                case "fileInfoTab": {
                    Platform.runLater(() -> this.removeAccessibleTabWarning(tab, "File Info"));
                    break;
                }
                case "descriptorsTab": {
                    Platform.runLater(() -> this.removeAccessibleTabWarning(tab, "Descriptors"));
                    break;
                }
                case "tdTab": {
                    Platform.runLater(() -> this.removeAccessibleTabWarning(tab, "Text DMS"));
                    break;
                }
                case "bdTab": {
                    Platform.runLater(() -> this.removeAccessibleTabWarning(tab, "Binary DMS"));
                    break;
                }
            }
        }
    }

    private void setAccessibleTabWarning(Tab tab, String titleText) {
        String accessibleText = titleText + " Contains validation error";
        HBox hbox = new HBox();
        String defaultStyle = "-fx-font-size: 12px";
        Label title = new Label(titleText);
        title.setStyle("-fx-padding: 0 0 0 5; -fx-font-size: 12px");
        FontIcon icon = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION);
        icon.getStyleClass().add((Object)"fadgi-sr-warning");
        hbox.getChildren().add((Object)icon);
        hbox.getChildren().add((Object)title);
        hbox.setAlignment(Pos.CENTER);
        hbox.setStyle("-fx-font-size: 12px");
        tab.setGraphic((Node)hbox);
        tab.setText(accessibleText);
        tab.setStyle("-fx-padding: 0 0 0 5;");
    }

    private void removeAccessibleTabWarning(Tab tab, String titleText) {
        HBox hbox = new HBox();
        String defaultStyle = "-fx-font-size: 12px";
        Label title = new Label(titleText);
        title.setStyle("-fx-padding: 0 0 0 5; -fx-font-size: 12px");
        hbox.getChildren().add((Object)title);
        hbox.setAlignment(Pos.CENTER);
        hbox.setStyle("-fx-font-size: 12px");
        tab.setGraphic((Node)hbox);
        tab.setText(titleText);
        tab.setStyle("-fx-padding: 0 0 0 5;");
    }
}

