/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.helper.CleanInputPathHelper;
import com.portalmedia.embarc.gui.model.MXFSelectedFilesSummary;
import com.portalmedia.embarc.gui.mxf.ControllerMediatorMXF;
import com.portalmedia.embarc.parser.FileFormatDetection;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import com.portalmedia.embarc.parser.SectionDef;
import com.portalmedia.embarc.parser.mxf.IdentifierSetHelper;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import com.portalmedia.embarc.parser.mxf.MXFSection;
import com.portalmedia.embarc.parser.mxf.MXFServiceImpl;
import com.portalmedia.embarc.parser.mxf.ManifestParserImpl;
import com.portalmedia.embarc.parser.mxf.ManifestType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextFlow;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;
import tv.amwa.maj.model.impl.AS07DMSIdentifierSetImpl;

public class TDBDController
extends AnchorPane {
    private static final Logger LOGGER = Logger.getLogger(Main.class.getClass().getName());
    @FXML
    private Label sectionLabel;
    @FXML
    private Label selectedFilesLabel;
    @FXML
    private VBox tdbdVBox;

    public TDBDController() {
        ControllerMediatorMXF.getInstance().registerTDBDController(this);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("TDBDView.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    public void setContent(SectionDef section) {
        if (section == MXFSection.TD) {
            this.sectionLabel.setText("Text DMS");
        } else {
            this.sectionLabel.setText("Binary DMS");
        }
        try {
            this.setContent(section == MXFSection.TD);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found error");
        }
    }

    private void setContent(boolean isTD) throws FileNotFoundException {
        MXFSelectedFilesSummary summary = ControllerMediatorMXF.getInstance().getSelectedFilesSummary();
        HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> elements = isTD ? summary.getAllTDElements() : summary.getAllBDElements();
        String message = "";
        if (summary.getFileCount() > 1 || elements == null || elements.size() == 0) {
            BorderPane bp = new BorderPane();
            bp.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            message = summary.getFileCount() > 1 ? "Multiple files selected, please select only one file." : (isTD ? "No text data present" : "No binary data present");
            Label messageLabel = new Label(message);
            messageLabel.setStyle("-fx-text-fill: black;");
            bp.setTop((Node)messageLabel);
            this.tdbdVBox.getChildren().add((Object)bp);
            return;
        }
        int index = 1;
        TreeSet<String> keys = new TreeSet<String>(elements.keySet());
        for (String key : keys) {
            LinkedHashMap<MXFColumn, MetadataColumnDef> element = elements.get(key);
            VBox vbox = this.createElementCards(element, isTD, index, summary.getFilePath(), summary.getFileName());
            this.tdbdVBox.getChildren().add((Object)vbox);
            ++index;
        }
        this.setNumberOfSelectedFiles(summary.getFileCount());
    }

    private void setNumberOfSelectedFiles(int num) {
        this.selectedFilesLabel.setText(Integer.toString(num) + " file" + (num > 1 ? "s " : " ") + "selected");
    }

    private VBox createElementCards(LinkedHashMap<MXFColumn, MetadataColumnDef> element, boolean isTD, int index, String filePath, String fileName) throws FileNotFoundException {
        String streamId = element.get(MXFColumn.AS_07_Object_GenericStreamID).getCurrentValue();
        int streamIdInt = Integer.parseInt(streamId);
        ManifestType mfType = this.getMfType(streamIdInt, filePath);
        boolean isManifest = mfType == ManifestType.VALID_MANIFEST || mfType == ManifestType.INVALID_MANIFEST;
        GridPane centerGrid = new GridPane();
        centerGrid.setPadding(new Insets(0.0, 10.0, 10.0, 10.0));
        ColumnConstraints cc = new ColumnConstraints();
        cc.setPrefWidth(205.0);
        centerGrid.getColumnConstraints().add((Object)cc);
        int identifierCount = 0;
        int lastIndex = 0;
        String isManifestValid = "";
        for (MXFColumn key : element.keySet()) {
            if (isManifest && key == MXFColumn.AS_07_Manifest_Valid) {
                isManifestValid = element.get(key).toString();
            }
            if (key == MXFColumn.AS_07_Object_TextBasedMetadataPayloadSchemeIdentifier || key == MXFColumn.AS_07_TD_DMS_PrimaryRFC5646LanguageCode || key == MXFColumn.AS_07_BD_DMS_PrimaryRFC5646LanguageCode || key == MXFColumn.AS_07_Manifest || key == MXFColumn.AS_07_Manifest_Valid) continue;
            int sortOrder = element.get(key).getColumnDef().getSortOrder();
            if (key == MXFColumn.AS_07_Object_Identifiers) {
                IdentifierSetHelper idSetHelper = new IdentifierSetHelper();
                ArrayList<AS07DMSIdentifierSetImpl> identifiers = idSetHelper.createIdentifierListFromString(element.get(key).toString());
                for (int i = 0; i < identifiers.size(); ++i) {
                    AS07DMSIdentifierSetImpl id = identifiers.get(i);
                    int row = identifierCount + sortOrder;
                    centerGrid.add((Node)this.getDescriptorLabel("Identifier " + (i + 1), "Identifier", false), 0, row);
                    String idValue = id.getIdentifierValue().replace("urn:uuid:", "");
                    centerGrid.add((Node)this.getDescriptorLabel("Value: " + idValue, "Identifier " + (i + 1) + " Value is " + idValue, true), 1, row);
                    centerGrid.add((Node)this.getDescriptorLabel("Role: " + id.getIdentifierRole(), "Identifier " + (i + 1) + " Role is " + id.getIdentifierRole(), true), 1, ++row);
                    centerGrid.add((Node)this.getDescriptorLabel("Type: " + id.getIdentifierType(), "Identifier " + (i + 1) + " Type is " + id.getIdentifierType(), true), 1, ++row);
                    centerGrid.add((Node)this.getDescriptorLabel("Comment: " + id.getIdentifierComment(), "Identifier " + (i + 1) + " Comment is " + id.getIdentifierComment(), true), 1, ++row);
                    ++row;
                }
                ++identifierCount;
                continue;
            }
            String val = element.get(key).toString();
            centerGrid.add((Node)this.getDescriptorLabel(key.getDisplayName(), "", false), 0, sortOrder);
            centerGrid.add((Node)this.getDescriptorLabel(val, key.getDisplayName() + " is " + val, true), 1, sortOrder);
            if (sortOrder <= lastIndex) continue;
            lastIndex = sortOrder;
        }
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        HBox header = this.getHeader(isTD, isManifest, isManifestValid, index, filePath, fileName, streamIdInt, streamId);
        vbox.getChildren().add((Object)header);
        vbox.getChildren().add((Object)centerGrid);
        return vbox;
    }

    private HBox getHeader(boolean isTD, boolean isManifest, String isManifestValid, int index, String filePath, String fileName, int streamIdInt, String streamId) throws FileNotFoundException {
        Object titlePrefix;
        HBox header = new HBox();
        header.setAlignment(Pos.CENTER);
        header.setSpacing(20.0);
        header.setStyle("-fx-padding: 0 0 10 0;");
        Object object = titlePrefix = isManifest ? "RDD 48 Manifest" : "";
        if (isManifest) {
            titlePrefix = isManifestValid.equals("true") ? (String)titlePrefix + " [VALID] - " : (isManifestValid.equals("false") ? (String)titlePrefix + " [INVALID] - " : (String)titlePrefix + " - ");
        }
        String title = isTD ? String.format("%sText Data Element #%s", titlePrefix, index) : String.format("Binary Data Element #%s", index);
        Label label = new Label(title);
        label.setStyle("-fx-font-size: 13; -fx-font-weight: bold; -fx-text-fill: black;");
        label.setFocusTraversable(true);
        header.getChildren().add((Object)label);
        MXFServiceImpl mxfService = new MXFServiceImpl(filePath);
        ByteBuffer bb = mxfService.GetGenericStream(streamIdInt);
        if (bb != null) {
            Button downloadIcon = this.getDownloadButton(streamId, filePath, fileName, isTD, title);
            header.getChildren().add((Object)downloadIcon);
        }
        return header;
    }

    private Label getDescriptorLabel(String title, String accessibleText, boolean isTraversable) {
        Label label = new Label(title);
        label.setPadding(new Insets(2.0, 0.0, 2.0, 5.0));
        label.setFocusTraversable(isTraversable);
        label.setAccessibleText(accessibleText);
        label.setStyle("-fx-text-fill: black;");
        return label;
    }

    private Button getDownloadButton(String streamId, String filePath, String fileName, Boolean isTD, String title) {
        FontIcon icon = new FontIcon((Ikon)FontAwesomeSolid.DOWNLOAD);
        icon.setIconCode((Ikon)FontAwesomeSolid.DOWNLOAD);
        icon.setAccessibleText("Select to download data for " + title);
        Button button = new Button();
        button.setGraphic((Node)icon);
        button.getStyleClass().add((Object)"light-element-base");
        button.setOnAction(event -> this.showDownloadDataDialog(streamId, filePath, fileName, isTD));
        return button;
    }

    private ManifestType getMfType(int streamInt, String filePath) {
        ManifestType mfType = ManifestType.NOT_MANIFEST;
        try {
            MXFServiceImpl mxfService = new MXFServiceImpl(filePath);
            ManifestParserImpl mfParser = new ManifestParserImpl();
            ByteBuffer bb = mxfService.GetGenericStream(streamInt);
            mfType = mfParser.isManifest(bb);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found error thrown in TDBDController.getMfType");
        }
        return mfType;
    }

    private String getFileExt(int streamInt, String filePath) {
        String fileExt = "";
        try {
            MXFServiceImpl mxfService = new MXFServiceImpl(filePath);
            ByteBuffer bb = mxfService.GetGenericStream(streamInt);
            fileExt = FileFormatDetection.getExtension(bb);
        }
        catch (Exception e) {
            System.out.println("Exception thrown in TDBDController.getFileExt");
        }
        return fileExt;
    }

    private void showDownloadDataDialog(String streamId, String filePath, String fileName, Boolean isTD) {
        int streamInt = Integer.parseInt(streamId);
        ManifestType mfType = this.getMfType(streamInt, filePath);
        String fileExt = this.getFileExt(streamInt, filePath);
        final String cleanHomePath = CleanInputPathHelper.cleanString(System.getProperty("user.home"));
        final String defaultOutputFileNameNonManifest = String.format("%s_%s_%s", fileName, streamId, "DATA_DOWNLOAD" + fileExt);
        String defaultOutputFileNameManifest = "manifest.xml";
        String fullPath = "";
        fullPath = mfType == ManifestType.NOT_MANIFEST ? String.format("%s%s%s", cleanHomePath, File.separator, defaultOutputFileNameNonManifest) : String.format("%s%s%s", cleanHomePath, File.separator, defaultOutputFileNameManifest);
        final Label writeFilesPathLabel = new Label(fullPath);
        writeFilesPathLabel.setStyle("-fx-text-fill: black;");
        ChoiceDialog dialog = new ChoiceDialog();
        FontIcon icon = new FontIcon((Ikon)FontAwesomeSolid.DOWNLOAD);
        icon.getStyleClass().add((Object)"write-files-icon");
        icon.setIconSize(20);
        dialog.setGraphic((Node)icon);
        dialog.getDialogPane().setPrefSize(525.0, 150.0);
        String tdbd = isTD != false ? "Text Data" : "Binary Data";
        dialog.setTitle("Download " + tdbd);
        dialog.setHeaderText("Write " + tdbd + " File to Disk");
        dialog.initOwner((Window)Main.getPrimaryStage());
        ButtonType closeButtonType = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType writeFilesButtonType = new ButtonType("Download " + tdbd, ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{closeButtonType, writeFilesButtonType});
        dialog.setResultConverter(type -> {
            ButtonBar.ButtonData data = type == null ? null : type.getButtonData();
            return data;
        });
        Button chooseOutputDirButton = new Button();
        chooseOutputDirButton.setText("Save File To...");
        chooseOutputDirButton.setPrefWidth(125.0);
        if (mfType == ManifestType.NOT_MANIFEST) {
            chooseOutputDirButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    FileChooser fileChooser = new FileChooser();
                    fileChooser.setInitialDirectory(new File(cleanHomePath));
                    fileChooser.setInitialFileName(defaultOutputFileNameNonManifest);
                    fileChooser.setTitle("Save");
                    File file = fileChooser.showSaveDialog(null);
                    if (file != null) {
                        writeFilesPathLabel.setText(file.getAbsolutePath());
                    }
                }
            });
        } else {
            chooseOutputDirButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    DirectoryChooser dirChooser = new DirectoryChooser();
                    dirChooser.setInitialDirectory(new File(cleanHomePath));
                    dirChooser.setTitle("Select a directory");
                    File dir = dirChooser.showDialog(null);
                    if (dir != null) {
                        writeFilesPathLabel.setText(String.format("%s%s%s", dir.getAbsolutePath(), File.separator, "manifest.xml"));
                    }
                }
            });
        }
        TextFlow textFlow = new TextFlow();
        VBox vbox = new VBox(2.0);
        vbox.setPadding(new Insets(10.0));
        textFlow.getChildren().add((Object)writeFilesPathLabel);
        writeFilesPathLabel.setWrapText(true);
        writeFilesPathLabel.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        writeFilesPathLabel.setPrefWidth(500.0);
        chooseOutputDirButton.setPrefWidth(150.0);
        vbox.getChildren().add((Object)chooseOutputDirButton);
        vbox.getChildren().add((Object)textFlow);
        dialog.getDialogPane().setContent((Node)vbox);
        Optional result = dialog.showAndWait();
        if (result.isPresent() && result.get() == ButtonBar.ButtonData.OK_DONE) {
            try {
                MXFServiceImpl mxfService = new MXFServiceImpl(filePath);
                mxfService.DownloadGenericStream(streamInt, writeFilesPathLabel.getText());
            }
            catch (FileNotFoundException e) {
                System.out.println("File not found error thrown in TDBDController.showDownloadDataDialog");
            }
        }
    }
}

