/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import com.fasterxml.jackson.core.util.VersionUtil;
import com.portalmedia.embarc.database.DBService;
import com.portalmedia.embarc.gui.AccessibleAlertHelper;
import com.portalmedia.embarc.gui.DragBoard;
import com.portalmedia.embarc.gui.SplashMenuBar;
import com.portalmedia.embarc.gui.dpx.TopMenuBarDPX;
import com.portalmedia.embarc.gui.helper.CleanInputPathHelper;
import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.gui.mxf.TopMenuBarMXF;
import com.portalmedia.embarc.system.UserPreferences;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.MenuBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class Main
extends Application {
    private static Stage splashStage;
    private static BorderPane splashLayout;
    private static Stage primaryStage;
    private static BorderPane rootLayout;
    private static MenuBar menuBarDPX;
    private static MenuBar menuBarMXF;
    private static MenuBar splashMenuBar;
    private static String programType;
    static Handler fileHandler;
    private static final Logger LOGGER;
    public static String embARCVersion;

    public static void main(String[] args) throws Exception {
        try {
            String os = System.getProperty("os.name");
            if (os != null && os.startsWith("Mac")) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("apple.awt.application.name", "embARC");
            }
            RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
            List<String> arguments = runtimeMxBean.getInputArguments();
            for (String a : arguments) {
                LOGGER.info(a);
            }
            Main.setupLogger();
            embARCVersion = Main.getVersion();
            LOGGER.info("Starting embARC " + embARCVersion);
            Main.launch((String[])args);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Exception in Main.  Rethrowing", ex);
            throw ex;
        }
    }

    public void init() {
        try {
            splashLayout = new DragBoard();
            splashLayout.setFocusTraversable(false);
            splashLayout.setAccessibleText("embARC " + embARCVersion + ". embARC stands for: Metadata Embedded for Archival Content.");
            splashLayout.setAccessibleHelp("Start the app by dragging and dropping DPX or MXF files here or use the file menu to import files");
            StackPane stack = new StackPane();
            stack.setFocusTraversable(false);
            ImageView splashImage = new ImageView(((Object)((Object)this)).getClass().getResource("embARC.png").toURI().toString());
            splashImage.setFitHeight(600.0);
            splashImage.setFitWidth(600.0);
            splashImage.setFocusTraversable(false);
            VBox labelVBox = new VBox();
            labelVBox.setAlignment(Pos.CENTER);
            labelVBox.setFocusTraversable(false);
            Pane emptyPane = new Pane();
            emptyPane.setPrefHeight(200.0);
            emptyPane.setFocusTraversable(false);
            labelVBox.getChildren().add((Object)emptyPane);
            Pane embarcLabelPane = new Pane();
            embarcLabelPane.setPrefHeight(200.0);
            embarcLabelPane.setPrefWidth(600.0);
            embarcLabelPane.setFocusTraversable(false);
            Label embarcLabel = new Label("embARC " + embARCVersion);
            embarcLabel.setFocusTraversable(true);
            embarcLabel.setFont(Font.font((String)"Verdana", (double)14.0));
            embarcLabel.setLayoutX(430.0);
            embarcLabel.setLayoutY(160.0);
            embarcLabelPane.getChildren().add((Object)embarcLabel);
            labelVBox.getChildren().add((Object)embarcLabelPane);
            Pane dropFilesLabelPane = new Pane();
            dropFilesLabelPane.setPrefHeight(200.0);
            dropFilesLabelPane.setPrefWidth(600.0);
            Label dropFilesLabel = new Label("Drag and drop DPX or MXF files here");
            dropFilesLabel.setFocusTraversable(true);
            dropFilesLabel.setAccessibleHelp("Or use the file menu to import files.");
            dropFilesLabel.setFont(Font.font((String)"Verdana", (double)20.0));
            dropFilesLabel.setTextFill((Paint)Color.rgb((int)0, (int)71, (int)110));
            dropFilesLabel.setTextAlignment(TextAlignment.CENTER);
            dropFilesLabel.setLayoutX(120.0);
            dropFilesLabel.setLayoutY(80.0);
            dropFilesLabelPane.getChildren().add((Object)dropFilesLabel);
            labelVBox.getChildren().add((Object)dropFilesLabelPane);
            stack.getChildren().addAll((Object[])new Node[]{splashImage, labelVBox});
            splashLayout.setCenter((Node)stack);
            splashLayout.setStyle("-fx-background-color: transparent;");
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.SEVERE, "Exception in init", e);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in init", e);
        }
    }

    public void start(Stage initStage) throws Exception {
        this.showSplash(initStage);
        primaryStage = new Stage(StageStyle.DECORATED);
        primaryStage.setTitle("embARC primary stage title");
        URL splashScreenUrl = ((Object)((Object)this)).getClass().getResource("embARC.png");
        primaryStage.getIcons().add((Object)new Image(splashScreenUrl.toURI().toString()));
        this.setPrimaryStageCloseEvent();
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(Main.class.getResource("/com/portalmedia/embarc/gui/Root.fxml"));
        rootLayout = (BorderPane)loader.load();
        rootLayout.setAccessibleText("embARC Application ally text");
        rootLayout.setAccessibleHelp("embARC Application ally help");
        Scene scene = new Scene((Parent)rootLayout);
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("application.css").toExternalForm());
        primaryStage.setScene(scene);
    }

    private void showSplash(Stage initStage) {
        Main.setSplashMenuBar();
        Scene splashScene = new Scene((Parent)splashLayout);
        splashScene.setFill((Paint)Color.TRANSPARENT);
        initStage.initStyle(StageStyle.TRANSPARENT);
        initStage.setScene(splashScene);
        initStage.show();
        splashStage = initStage;
        this.setSplashScreenCloseRequest();
    }

    public static void setupLogger() {
        try {
            Object logFileDir = "";
            String os = System.getProperty("os.name");
            String cleanHomePath = CleanInputPathHelper.cleanString(System.getProperty("user.home"));
            logFileDir = os != null && os.startsWith("Mac") ? cleanHomePath + "/Library/Application Support/embARC" : cleanHomePath + "/AppData/Local/embARC";
            File directory = new File((String)logFileDir);
            if (!directory.exists()) {
                directory.mkdir();
            }
            Path fullPath = Paths.get((String)logFileDir, "embARC.log");
            fileHandler = new FileHandler(fullPath.toString());
            System.out.println("log file location: " + String.valueOf(fullPath));
            SimpleFormatter simple = new SimpleFormatter();
            fileHandler.setFormatter(simple);
            LOGGER.addHandler(fileHandler);
        }
        catch (IOException e) {
            System.out.println("IO Exception Error");
        }
    }

    public static void showMainStageDPX(Boolean refresh) {
        LOGGER.info("Begin DPX GUI");
        programType = "DPX";
        DBService<DPXFileInformationViewModel> dbService = new DBService<DPXFileInformationViewModel>(DPXFileInformationViewModel.class);
        Main.setMenuBarDPX(refresh);
        if (splashStage.isShowing()) {
            splashStage.close();
        }
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("/com/portalmedia/embarc/gui/dpx/MainViewDPX.fxml"));
            AnchorPane mainWindow = (AnchorPane)loader.load();
            rootLayout.setCenter((Node)mainWindow);
            dbService.getSize();
            dbService.dropCollection();
            dbService.closeDB();
            primaryStage.show();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Exception in showMainStageDPX", ex);
        }
    }

    public static void showMainStageMXF(Boolean refresh) {
        LOGGER.info("Begin MXF GUI");
        programType = "MXF";
        Main.setMenuBarMXF(refresh);
        if (splashStage.isShowing()) {
            splashStage.close();
        }
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(Main.class.getResource("/com/portalmedia/embarc/gui/mxf/MainViewMXF.fxml"));
            AnchorPane mainWindow = (AnchorPane)loader.load();
            rootLayout.setCenter((Node)mainWindow);
            primaryStage.show();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Exception in showMainStageMXF", e);
        }
    }

    private void setPrimaryStageCloseEvent() {
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(this){

            public void handle(WindowEvent e) {
                String message = "Are you sure you want to quit embARC?";
                Alert alert = AccessibleAlertHelper.CreateAccessibleAlert("Quit embARC", Alert.AlertType.CONFIRMATION, "Are you sure you want to quit embARC?", new ButtonType[0]);
                alert.initModality(Modality.APPLICATION_MODAL);
                alert.initOwner((Window)primaryStage);
                alert.setGraphic(null);
                alert.setHeaderText(null);
                DialogPane dialogPane = alert.getDialogPane();
                alert.getDialogPane().lookupButton(ButtonType.OK).setAccessibleHelp("Are you sure you want to quit embARC?");
                dialogPane.getStylesheets().add((Object)this.getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
                dialogPane.getStyleClass().add((Object)"alertDialog");
                Optional result = alert.showAndWait();
                if (result.get() == ButtonType.OK) {
                    LOGGER.info("Closing embARC");
                    System.exit(0);
                } else {
                    e.consume();
                }
            }
        });
    }

    private void setSplashScreenCloseRequest() {
        splashStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(this){

            public void handle(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private void closeDpxFileInformationDatabase() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
        try {
            CompletableFuture.supplyAsync(() -> {
                DBService<DPXFileInformationViewModel> dbService = new DBService<DPXFileInformationViewModel>(DPXFileInformationViewModel.class);
                dbService.getSize();
                dbService.dropCollection();
                dbService.closeDB();
                System.out.println("Database closed");
                return null;
            }, executor).get(60L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error closing database", ex);
        }
        executor.shutdown();
    }

    private void closeUserPreferenceDatabase() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
        try {
            CompletableFuture.supplyAsync(() -> {
                DBService<UserPreferences> dbService = new DBService<UserPreferences>(UserPreferences.class);
                dbService.getSize();
                dbService.closeDB();
                System.out.println("Database UserPreferences closed");
                return null;
            }, executor).get(60L, TimeUnit.SECONDS);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error closing database", ex);
        }
        executor.shutdown();
    }

    public static Stage getPrimaryStage() {
        return primaryStage;
    }

    public static Stage getSplashStage() {
        return splashStage;
    }

    public static MenuBar getMXFMenuBar() {
        return menuBarMXF;
    }

    public static void setMenuBarDPX(Boolean refresh) {
        String os;
        if (refresh.booleanValue()) {
            rootLayout.getChildren().remove((Object)menuBarDPX);
            menuBarDPX = null;
            menuBarDPX = TopMenuBarDPX.createMenuBar();
        }
        if ((os = System.getProperty("os.name")) != null && os.startsWith("Mac")) {
            menuBarDPX.useSystemMenuBarProperty().set(true);
            rootLayout.getChildren().add((Object)menuBarDPX);
        } else {
            rootLayout.setTop((Node)menuBarDPX);
        }
    }

    public static void setMenuBarMXF(Boolean refresh) {
        String os;
        if (refresh.booleanValue()) {
            rootLayout.getChildren().remove((Object)menuBarMXF);
            menuBarMXF = null;
            menuBarMXF = TopMenuBarMXF.createMenuBar();
        }
        if ((os = System.getProperty("os.name")) != null && os.startsWith("Mac")) {
            menuBarMXF.useSystemMenuBarProperty().set(true);
            rootLayout.getChildren().add((Object)menuBarMXF);
        } else {
            rootLayout.setTop((Node)menuBarMXF);
        }
    }

    public static void setSplashMenuBar() {
        String os = System.getProperty("os.name");
        if (os != null && os.startsWith("Mac")) {
            splashMenuBar.useSystemMenuBarProperty().set(true);
            splashLayout.getChildren().add((Object)splashMenuBar);
        } else {
            splashLayout.setTop((Node)splashMenuBar);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersion() {
        Properties properties = new Properties();
        try (InputStream input = VersionUtil.class.getResourceAsStream("/resources/version.properties");){
            if (input == null) {
                String string2 = "unknown";
                return string2;
            }
            properties.load(input);
            String string = properties.getProperty("version");
            return string;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Exception in Main getVersion.", ex);
            return "unknown";
        }
    }

    static {
        menuBarDPX = TopMenuBarDPX.createMenuBar();
        menuBarMXF = TopMenuBarMXF.createMenuBar();
        splashMenuBar = SplashMenuBar.createMenuBar();
        programType = "";
        fileHandler = null;
        LOGGER = Logger.getLogger(Main.class.getClass().getName());
        embARCVersion = "";
    }
}

