/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleBase;
import org.dizitart.no2.Document;
import org.dizitart.no2.mapper.Mappable;
import org.dizitart.no2.mapper.NitriteMapper;

public class IsValidShortListRule
extends ValidationRuleBase
implements IValidationRule,
Mappable {
    private static final long serialVersionUID = 1L;
    String rule = "Generic ShortList Rule";
    short[] validValuesList;

    public IsValidShortListRule(short[] validValues) {
        this.validValuesList = validValues;
    }

    public short[] getValidValuesList() {
        return this.validValuesList;
    }

    @Override
    public boolean isValid(String value) {
        try {
            short v = Short.parseShort(value);
            for (short i : this.validValuesList) {
                if (v != i) continue;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void read(NitriteMapper mapper, Document document) {
        if (document != null) {
            this.setRule((String)document.get("rule"));
            this.setValidValuesList((short[])document.get("validValuesList"));
        }
    }

    public void setValidValuesList(short[] validValuesList) {
        this.validValuesList = validValuesList;
    }

    @Override
    public Document write(NitriteMapper mapper) {
        Document document = new Document();
        document.put("rule", (Object)this.getRule());
        document.put("validValuesList", (Object)this.getValidValuesList());
        return document;
    }
}

