/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.AboutModalController;
import com.portalmedia.embarc.gui.AccessibleAlertHelper;
import com.portalmedia.embarc.gui.FileProcessController;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.dpx.DataTemplatesModalController;
import com.portalmedia.embarc.gui.dpx.RuleSetModalController;
import com.portalmedia.embarc.gui.dpx.WriteFilesModalController;
import com.portalmedia.embarc.parser.dpx.DPXDataTemplate;
import com.portalmedia.embarc.system.UserPreferencesService;
import java.util.HashMap;
import java.util.Optional;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class TopMenuBarDPX {
    public static MenuBar createMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu fileMenu = new Menu("File");
        Menu optionsMenu = new Menu("Options");
        Menu dataTemplates = new Menu("Data Templates");
        Menu reportsMenu = new Menu("Reports");
        MenuItem importFilesItem = new MenuItem("Import Files");
        MenuItem importDirectoryItem = new MenuItem("Import Folder");
        MenuItem writeFilesItem = new MenuItem("Write Files");
        MenuItem aboutItem = new MenuItem("About embARC");
        MenuItem exitItem = new MenuItem("Exit");
        MenuItem toggleColumns = new MenuItem("Toggle Column Visibility");
        MenuItem ruleSets = new MenuItem("Rule Sets");
        MenuItem createReport = new MenuItem("Download Rule Violations");
        MenuItem createImageChecksumReport = new MenuItem("Download Image Data Checksums");
        MenuItem createSequenceGapAnalysisReport = new MenuItem("Download Sequence Gap Analysis Report (Simple)");
        MenuItem createSequenceGapAnalysisReportVerbose = new MenuItem("Download Sequence Gap Analysis Report (Full)");
        MenuItem createCSVExport = new MenuItem("Download Metadata as CSV");
        importFilesItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                FileProcessController.getInstance().chooseFile(Main.getPrimaryStage());
            }
        });
        importDirectoryItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                FileProcessController.getInstance().chooseDirectory(Main.getPrimaryStage());
            }
        });
        writeFilesItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                WriteFilesModalController.getInstance().showWriteFilesDialog();
            }
        });
        aboutItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                AboutModalController.getInstance().showAboutModal(Main.getPrimaryStage());
            }
        });
        exitItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                Stage primaryStage = Main.getPrimaryStage();
                primaryStage.fireEvent((Event)new WindowEvent((Window)primaryStage, WindowEvent.WINDOW_CLOSE_REQUEST));
            }
        });
        toggleColumns.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ControllerMediatorDPX.getInstance().showColumnVisibilityDialogue();
            }
        });
        ruleSets.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                RuleSetModalController.getInstance().showRuleSetsDialog();
            }
        });
        createReport.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ControllerMediatorDPX.getInstance().createReport();
            }
        });
        createImageChecksumReport.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ControllerMediatorDPX.getInstance().createImageChecksumReport();
            }
        });
        createSequenceGapAnalysisReport.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ControllerMediatorDPX.getInstance().createSequenceGapAnalysisReport(false);
            }
        });
        createSequenceGapAnalysisReportVerbose.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ControllerMediatorDPX.getInstance().createSequenceGapAnalysisReport(true);
            }
        });
        createCSVExport.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                ControllerMediatorDPX.getInstance().createCSVMetadataExport();
            }
        });
        fileMenu.getItems().addAll((Object[])new MenuItem[]{importFilesItem, importDirectoryItem, writeFilesItem, aboutItem, exitItem});
        TopMenuBarDPX.populateSavedDataTemplates(dataTemplates);
        optionsMenu.getItems().addAll((Object[])new MenuItem[]{ruleSets, toggleColumns, dataTemplates});
        reportsMenu.getItems().addAll((Object[])new MenuItem[]{createReport, createImageChecksumReport, createSequenceGapAnalysisReport, createSequenceGapAnalysisReportVerbose, createCSVExport});
        menuBar.getMenus().addAll((Object[])new Menu[]{fileMenu, optionsMenu, reportsMenu});
        menuBar.setStyle("-fx-background-color: #eceff1;");
        return menuBar;
    }

    public static void populateSavedDataTemplates(Menu dataTemplateMenu) {
        UserPreferencesService userPreferences = new UserPreferencesService();
        HashMap<String, DPXDataTemplate> templates = userPreferences.getDPXDataTemplates();
        templates.forEach((name, template) -> {
            Menu templateMenu = new Menu(name);
            MenuItem editTemplate = new MenuItem("Edit");
            MenuItem applyTemplate = new MenuItem("Apply");
            editTemplate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    DataTemplatesModalController.getInstance().showDataTemplatesDialogue(template);
                }
            });
            applyTemplate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    ControllerMediatorDPX cm = ControllerMediatorDPX.getInstance();
                    int count = cm.getSelectedFilesSummary().getFileCount();
                    Object contentText = "Are you sure you want to apply this template to ";
                    contentText = count == 0 ? (String)contentText + "all files?" : (count == 1 ? (String)contentText + count + " file?" : (String)contentText + count + " files?");
                    Alert alert = AccessibleAlertHelper.CreateAccessibleAlert("Apply Data Template", Alert.AlertType.CONFIRMATION, (String)contentText, new ButtonType[0]);
                    alert.initModality(Modality.APPLICATION_MODAL);
                    alert.initOwner((Window)Main.getPrimaryStage());
                    alert.setGraphic(null);
                    alert.setHeaderText(null);
                    DialogPane dialogPane = alert.getDialogPane();
                    alert.getDialogPane().lookupButton(ButtonType.OK).setAccessibleHelp((String)contentText);
                    dialogPane.getStylesheets().add((Object)this.getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
                    dialogPane.getStyleClass().add((Object)"alertDialog");
                    Optional result = alert.showAndWait();
                    if (result.get() == ButtonType.OK) {
                        if (count == 0) {
                            cm.updateChangedValuesAllFiles(template.getValues());
                        }
                        cm.updateChangedValues(template.getValues());
                    } else {
                        t.consume();
                    }
                }
            });
            templateMenu.getItems().addAll((Object[])new MenuItem[]{editTemplate, applyTemplate});
            dataTemplateMenu.getItems().add((Object)templateMenu);
        });
        MenuItem newDataTemplate = new MenuItem("New Data Template");
        newDataTemplate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                DataTemplatesModalController.getInstance().showDataTemplatesDialogue();
            }
        });
        dataTemplateMenu.getItems().add((Object)newDataTemplate);
    }
}

