/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class BytesToStringHelper {
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    private static String[] getStringIntArray(byte[] value, ByteOrder byteOrder) {
        String[] toReturn = new String[value.length / 4];
        int returnIndex = 0;
        for (int i = 0; i < value.length; i += 4) {
            toReturn[returnIndex] = Long.toString((long)ByteBuffer.wrap(value).order(byteOrder).getInt() & 0xFFFFFFFFL);
            ++returnIndex;
        }
        return toReturn;
    }

    private static Long[] getIntArray(byte[] value, ByteOrder byteOrder) {
        Long[] toReturn = new Long[value.length / 4];
        int returnIndex = 0;
        for (int i = 0; i < value.length; i += 4) {
            toReturn[returnIndex] = BytesToStringHelper.getLong(value, byteOrder);
            ++returnIndex;
        }
        return toReturn;
    }

    private static String[] getStringShortArray(byte[] value, ByteOrder byteOrder) {
        String[] toReturn = new String[value.length / 2];
        int returnIndex = 0;
        for (int i = 0; i < value.length; i += 2) {
            toReturn[returnIndex] = Integer.toString(ByteBuffer.wrap(value).order(byteOrder).getShort() & 0xFFFF);
            ++returnIndex;
        }
        return toReturn;
    }

    private static Integer[] getShortArray(byte[] value, ByteOrder byteOrder) {
        Integer[] toReturn = new Integer[value.length / 2];
        int returnIndex = 0;
        for (int i = 0; i < value.length; i += 2) {
            toReturn[returnIndex] = ByteBuffer.wrap(value).order(byteOrder).getShort() & 0xFFFF1;
            ++returnIndex;
        }
        return toReturn;
    }

    private static String toByteArrayString(byte[] value) {
        Object toReturn = "[";
        byte[] valueArray = value;
        for (int i = 0; i < valueArray.length; ++i) {
            toReturn = (String)toReturn + Byte.toString(valueArray[i]);
            if (i == valueArray.length - 1) continue;
            toReturn = (String)toReturn + ",";
        }
        toReturn = (String)toReturn + "]";
        return toReturn;
    }

    public static String toByteString(byte[] value) {
        return Byte.toString(value[0]);
    }

    public static String toFloatString(byte[] value, ByteOrder byteOrder) {
        return Float.toString(BytesToStringHelper.getFloat(value, byteOrder).floatValue());
    }

    private static Float getFloat(byte[] value, ByteOrder byteOrder) {
        return Float.valueOf(ByteBuffer.wrap(value).order(byteOrder).getFloat());
    }

    public static String toIntArrayString(byte[] value, ByteOrder byteOrder) {
        Object toReturn = "[";
        String[] valueArray = BytesToStringHelper.getStringIntArray(value, byteOrder);
        for (int i = 0; i < valueArray.length; ++i) {
            toReturn = (String)toReturn + valueArray[i];
            if (i == valueArray.length - 1) continue;
            toReturn = (String)toReturn + ",";
        }
        toReturn = (String)toReturn + "]";
        return toReturn;
    }

    public static String toIntString(byte[] value, ByteOrder byteOrder) {
        return Long.toString(BytesToStringHelper.getLong(value, byteOrder));
    }

    public static Long getLong(byte[] value, ByteOrder byteOrder) {
        return (long)ByteBuffer.wrap(value).order(byteOrder).getInt() & 0xFFFFFFFFL;
    }

    public static String toLongString(byte[] value, ByteOrder byteOrder) {
        return Long.toString(ByteBuffer.wrap(value).order(byteOrder).getLong());
    }

    public static String toShortArrayString(byte[] value, ByteOrder byteOrder) {
        Object toReturn = "[";
        String[] valueArray = BytesToStringHelper.getStringShortArray(value, byteOrder);
        for (int i = 0; i < valueArray.length; ++i) {
            toReturn = (String)toReturn + valueArray[i];
            if (i == valueArray.length - 1) continue;
            toReturn = (String)toReturn + ",";
        }
        toReturn = (String)toReturn + "]";
        return toReturn;
    }

    public static String toShortString(byte[] value, ByteOrder byteOrder) {
        return Integer.toString(BytesToStringHelper.getInteger(value, byteOrder));
    }

    public static int getInteger(byte[] value, ByteOrder byteOrder) {
        return ByteBuffer.wrap(value).order(byteOrder).getShort() & 0xFFFF;
    }

    public static String toString(byte[] value) {
        return new String(value).replaceAll("\\u0000", "");
    }

    public static String toTypedString(Class<?> type, byte[] value, ByteOrder byteOrder) {
        if (type == byte[].class) {
            return BytesToStringHelper.toByteArrayString(value);
        }
        if (type == Byte.TYPE) {
            return BytesToStringHelper.toByteString(value);
        }
        if (type == Float.TYPE) {
            return BytesToStringHelper.toFloatString(value, byteOrder);
        }
        if (type == int[].class) {
            return BytesToStringHelper.toIntArrayString(value, byteOrder);
        }
        if (type == Integer.TYPE) {
            return BytesToStringHelper.toIntString(value, byteOrder);
        }
        if (type == Long.TYPE) {
            return BytesToStringHelper.toLongString(value, byteOrder);
        }
        if (type == short[].class) {
            return BytesToStringHelper.toShortArrayString(value, byteOrder);
        }
        if (type == Short.TYPE) {
            return BytesToStringHelper.toShortString(value, byteOrder);
        }
        if (type == String.class) {
            return BytesToStringHelper.toString(value);
        }
        return "INVALID TYPE";
    }

    private static Boolean isValidString(byte[] value, ByteOrder byteOrder) {
        CharsetDecoder d = Charset.forName("US-ASCII").newDecoder();
        try {
            CharBuffer r = d.decode(ByteBuffer.wrap(value).order(byteOrder));
            r.toString();
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }

    private static String getHexString(byte[] value, ByteOrder byteOrder) {
        char[] hexChars = new char[value.length * 2];
        for (int j = 0; j < value.length; ++j) {
            int v = value[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return "HEX: " + new String(hexChars);
    }

    public static Boolean isNull(byte[] value, Class<?> type) {
        byte searchValue = -1;
        if (type.equals(String.class)) {
            searchValue = 0;
        }
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == searchValue) continue;
            return false;
        }
        return true;
    }

    private static Boolean isValidShort(Integer s) {
        return s >= Short.MIN_VALUE && s <= Short.MAX_VALUE;
    }

    private static Boolean isValidInteger(Long i) {
        return i >= Integer.MIN_VALUE && i <= Integer.MAX_VALUE;
    }

    private static Boolean isValidIntegerArray(Long[] la) {
        for (int i = 0; i < la.length; ++i) {
            if (BytesToStringHelper.isValidInteger(la[i]).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private static Boolean isValidShortArray(Integer[] la) {
        for (int i = 0; i < la.length; ++i) {
            if (BytesToStringHelper.isValidShort(la[i]).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static String toStandardizedTypedString(Class<?> type, byte[] value, ByteOrder byteOrder) {
        if (BytesToStringHelper.isNull(value, type).booleanValue()) {
            return "NULL";
        }
        if (type == byte[].class) {
            return BytesToStringHelper.toByteArrayString(value);
        }
        if (type == Byte.TYPE) {
            return BytesToStringHelper.toByteString(value);
        }
        if (type == Float.TYPE) {
            Float f = BytesToStringHelper.getFloat(value, byteOrder);
            return f.floatValue() >= 0.0f ? BytesToStringHelper.toFloatString(value, byteOrder) : BytesToStringHelper.getHexString(value, byteOrder);
        }
        if (type == int[].class) {
            Long[] la = BytesToStringHelper.getIntArray(value, byteOrder);
            return BytesToStringHelper.isValidIntegerArray(la) != false ? BytesToStringHelper.toIntArrayString(value, byteOrder) : BytesToStringHelper.getHexString(value, byteOrder);
        }
        if (type == Integer.TYPE) {
            Long l = BytesToStringHelper.getLong(value, byteOrder);
            return BytesToStringHelper.isValidInteger(l) != false ? BytesToStringHelper.toIntString(value, byteOrder) : BytesToStringHelper.getHexString(value, byteOrder);
        }
        if (type == Long.TYPE) {
            Long l = BytesToStringHelper.getLong(value, byteOrder);
            return l >= 0L ? BytesToStringHelper.toLongString(value, byteOrder) : BytesToStringHelper.getHexString(value, byteOrder);
        }
        if (type == short[].class) {
            Integer[] la = BytesToStringHelper.getShortArray(value, byteOrder);
            return BytesToStringHelper.isValidShortArray(la) != false ? BytesToStringHelper.toShortArrayString(value, byteOrder) : BytesToStringHelper.getHexString(value, byteOrder);
        }
        if (type == Short.TYPE) {
            Integer s = BytesToStringHelper.getInteger(value, byteOrder);
            return BytesToStringHelper.isValidShort(s) != false ? BytesToStringHelper.toShortString(value, byteOrder) : BytesToStringHelper.getHexString(value, byteOrder);
        }
        if (type == String.class) {
            if (BytesToStringHelper.isValidString(value, byteOrder).booleanValue()) {
                return BytesToStringHelper.toString(value);
            }
            return BytesToStringHelper.getHexString(value, byteOrder);
        }
        return "INVALID TYPE";
    }
}

