/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;
import org.kordamp.ikonli.materialdesign.MaterialDesign;

public class RuleSetModalController {
    public static RuleSetModalController getInstance() {
        return ControllerHolder.INSTANCE;
    }

    private RuleSetModalController() {
    }

    public void showRuleSetsDialog() {
        Alert ruleSetsDialog = new Alert(Alert.AlertType.INFORMATION, "", new ButtonType[]{ButtonType.OK});
        ruleSetsDialog.initModality(Modality.APPLICATION_MODAL);
        ruleSetsDialog.initOwner((Window)Main.getPrimaryStage());
        ruleSetsDialog.setResizable(true);
        ruleSetsDialog.setGraphic(null);
        ruleSetsDialog.setTitle("Rule Sets");
        ruleSetsDialog.setHeaderText(null);
        ruleSetsDialog.setContentText("Toggle rule sets");
        List<CheckBox> checkBoxes = this.createRuleSetCheckboxes();
        if (checkBoxes.size() > 0) {
            GridPane grid = new GridPane();
            grid.setHgap(20.0);
            grid.setVgap(20.0);
            grid.setPadding(new Insets(20.0, 50.0, 20.0, 20.0));
            int rowIndex = 0;
            for (CheckBox cb : checkBoxes) {
                Text sectionHead = new Text(cb.getId());
                sectionHead.setStyle("fx-font-weight: bold");
                grid.add((Node)sectionHead, 0, rowIndex);
                grid.add((Node)cb, 1, rowIndex);
                ++rowIndex;
            }
            ruleSetsDialog.getDialogPane().setContent((Node)grid);
        } else {
            ruleSetsDialog.setContentText("No files in workspace.");
        }
        ruleSetsDialog.initOwner((Window)Main.getPrimaryStage());
        ruleSetsDialog.showAndWait();
        if (ruleSetsDialog.getResult() == ButtonType.OK) {
            ruleSetsDialog.close();
        }
    }

    private List<CheckBox> createRuleSetCheckboxes() {
        ArrayList<CheckBox> cbList = new ArrayList<CheckBox>();
        HashSet<ValidationRuleSetEnum> currentRules = ControllerMediatorDPX.getInstance().getCurrentRuleSets();
        String alertTextStyles = "-fx-font-size: 14px; -fx-font-weight: bold; -fx-text-fill: black; -fx-fill: black;";
        CheckBox smpteCheckbox = new CheckBox("SMPTE-C");
        smpteCheckbox.setStyle("-fx-font-size: 14px; -fx-font-weight: bold; -fx-text-fill: black; -fx-fill: black;");
        FontIcon icon2 = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_BOX);
        icon2.getStyleClass().add((Object)"smpte-c-warning");
        icon2.setIconSize(18);
        smpteCheckbox.setGraphic((Node)icon2);
        if (currentRules.contains((Object)ValidationRuleSetEnum.SMPTE_C)) {
            smpteCheckbox.setSelected(true);
        } else {
            smpteCheckbox.setSelected(false);
        }
        smpteCheckbox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(this){

            public void changed(ObservableValue<? extends Boolean> obs, Boolean ov, Boolean nv) {
                ControllerMediatorDPX.getInstance().toggleRuleSet(ValidationRuleSetEnum.SMPTE_C);
                ControllerMediatorDPX.getInstance().resetValidationRuleIndicators();
            }
        });
        cbList.add(smpteCheckbox);
        CheckBox fadgiSRCheckbox = new CheckBox("FADGI-SR");
        fadgiSRCheckbox.setStyle("-fx-font-size: 14px; -fx-font-weight: bold; -fx-text-fill: black; -fx-fill: black;");
        FontIcon icon3 = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_OCTAGON);
        icon3.getStyleClass().add((Object)"fadgi-sr-warning");
        icon3.setIconSize(18);
        fadgiSRCheckbox.setGraphic((Node)icon3);
        if (currentRules.contains((Object)ValidationRuleSetEnum.FADGI_SR)) {
            fadgiSRCheckbox.setSelected(true);
        } else {
            fadgiSRCheckbox.setSelected(false);
        }
        fadgiSRCheckbox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(this){

            public void changed(ObservableValue<? extends Boolean> obs, Boolean ov, Boolean nv) {
                ControllerMediatorDPX.getInstance().toggleRuleSet(ValidationRuleSetEnum.FADGI_SR);
                ControllerMediatorDPX.getInstance().resetValidationRuleIndicators();
            }
        });
        cbList.add(fadgiSRCheckbox);
        CheckBox fadgiRCheckbox = new CheckBox("FADGI-R");
        fadgiRCheckbox.setStyle("-fx-font-size: 14px; -fx-font-weight: bold; -fx-text-fill: black; -fx-fill: black;");
        FontIcon icon4 = new FontIcon((Ikon)FontAwesomeSolid.EXCLAMATION_TRIANGLE);
        icon4.getStyleClass().add((Object)"fadgi-r-warning");
        icon4.setIconSize(16);
        fadgiRCheckbox.setGraphic((Node)icon4);
        if (currentRules.contains((Object)ValidationRuleSetEnum.FADGI_R)) {
            fadgiRCheckbox.setSelected(true);
        } else {
            fadgiRCheckbox.setSelected(false);
        }
        fadgiRCheckbox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(this){

            public void changed(ObservableValue<? extends Boolean> obs, Boolean ov, Boolean nv) {
                ControllerMediatorDPX.getInstance().toggleRuleSet(ValidationRuleSetEnum.FADGI_R);
                ControllerMediatorDPX.getInstance().resetValidationRuleIndicators();
            }
        });
        cbList.add(fadgiRCheckbox);
        CheckBox fadgiOCheckbox = new CheckBox("FADGI-O");
        fadgiOCheckbox.setStyle("-fx-font-size: 14px; -fx-font-weight: bold; -fx-text-fill: black; -fx-fill: black;");
        FontIcon icon5 = new FontIcon((Ikon)MaterialDesign.MDI_ALERT_CIRCLE);
        icon5.getStyleClass().add((Object)"fadgi-o-warning");
        icon5.setIconSize(18);
        fadgiOCheckbox.setGraphic((Node)icon5);
        if (currentRules.contains((Object)ValidationRuleSetEnum.FADGI_O)) {
            fadgiOCheckbox.setSelected(true);
        } else {
            fadgiOCheckbox.setSelected(false);
        }
        fadgiOCheckbox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(this){

            public void changed(ObservableValue<? extends Boolean> obs, Boolean ov, Boolean nv) {
                ControllerMediatorDPX.getInstance().toggleRuleSet(ValidationRuleSetEnum.FADGI_O);
                ControllerMediatorDPX.getInstance().resetValidationRuleIndicators();
            }
        });
        cbList.add(fadgiOCheckbox);
        return cbList;
    }

    private static class ControllerHolder {
        private static final RuleSetModalController INSTANCE = new RuleSetModalController();

        private ControllerHolder() {
        }
    }
}

