/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.ASCIIField;
import com.portalmedia.embarc.gui.AccessibleAlertHelper;
import com.portalmedia.embarc.gui.DataFieldInfoAlert;
import com.portalmedia.embarc.gui.DropDownField;
import com.portalmedia.embarc.gui.IEditorField;
import com.portalmedia.embarc.gui.LabelField;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.RFC5646LanguageTags;
import com.portalmedia.embarc.gui.model.MXFSelectedFilesSummary;
import com.portalmedia.embarc.gui.mxf.ControllerMediatorMXF;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import com.portalmedia.embarc.parser.StringMetadataColumn;
import com.portalmedia.embarc.parser.mxf.AudioTrackLayoutValues;
import com.portalmedia.embarc.parser.mxf.DeviceSetHelper;
import com.portalmedia.embarc.parser.mxf.IdentifierSetHelper;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import com.portalmedia.embarc.parser.mxf.MXFColumnHelpText;
import com.portalmedia.embarc.parser.mxf.MXFSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.scene.AccessibleRole;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.model.impl.AS07CoreDMSDeviceObjectsImpl;
import tv.amwa.maj.model.impl.AS07DMSIdentifierSetImpl;

public class CoreMXFController
extends AnchorPane {
    @FXML
    private Label sectionLabel;
    @FXML
    private Label selectedFilesLabel;
    @FXML
    private VBox editableFieldsVBox;
    @FXML
    private Text editingSummary;
    @FXML
    private Button applyChangesButton;
    @FXML
    private Button discardChangesButton;
    private HashSet<IEditorField> fields;
    private IntegerProperty editedFieldsCount = new SimpleIntegerProperty(0);

    public CoreMXFController() {
        ControllerMediatorMXF.getInstance().registerCoreMXFController(this);
        this.fields = new HashSet();
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("CoreMXFView.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.editedFieldsCount.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> obs, Number ov, Number nv) {
                String[] numFiles = CoreMXFController.this.selectedFilesLabel.getText().split(" ");
                if (nv.intValue() == 0) {
                    CoreMXFController.this.editingSummary.setText("0 edited fields");
                    return;
                }
                String filesString = " files";
                if ("1".equals(numFiles[0])) {
                    filesString = " file";
                }
                String text = nv.intValue() + (nv.intValue() == 1 ? " edit in " : " edits in ") + numFiles[0] + filesString;
                CoreMXFController.this.editingSummary.setText(text);
            }
        });
        this.applyChangesButton.setOnAction(e -> {
            if (this.editedFieldsCount.get() == 0) {
                this.showAlert("", "There are no edits to apply.");
                return;
            }
            LinkedHashMap<MXFColumn, MetadataColumnDef> changedValsNew = new LinkedHashMap<MXFColumn, MetadataColumnDef>();
            for (IEditorField field : this.fields) {
                if (!field.valueChanged()) continue;
                changedValsNew.put(field.getMXFColumn(), new StringMetadataColumn(field.getMXFColumn(), field.getValue()));
            }
            ControllerMediatorMXF.getInstance().updateChangedValues(changedValsNew);
        });
        this.discardChangesButton.setOnAction(e -> {
            if (this.editedFieldsCount.get() == 0) {
                this.showAlert("", "There are no edits to discard.");
            } else {
                this.showConfirmation("Are you sure?", "Press OK to discard current changes. Press cancel to keep changes.");
            }
        });
    }

    public void setTitle(String title) {
        this.sectionLabel.setText(title);
    }

    private void calculateEditedFields() {
        int count = 0;
        for (IEditorField field : this.fields) {
            if (!field.valueChanged()) continue;
            ++count;
        }
        this.editedFieldsCount.set(count);
    }

    private void setNumberOfSelectedFiles(int num) {
        this.selectedFilesLabel.setText(Integer.toString(num) + " file" + (num > 1 ? "s " : " ") + "selected");
    }

    public void setSection(boolean resetValues) {
        MXFSelectedFilesSummary summary;
        if (resetValues) {
            for (IEditorField field : this.fields) {
                field.resetValueChanged();
            }
            this.editableFieldsVBox.getChildren().clear();
            this.fields.clear();
        }
        if ((summary = ControllerMediatorMXF.getInstance().getSelectedFilesSummary()).getFilesAreMissingAS07CoreDMSFramework()) {
            // empty if block
        }
        for (MXFColumn col : MXFColumn.values()) {
            RFC5646LanguageTags langTags;
            Object vals;
            if (col.getSection() != MXFSection.CORE) continue;
            if (col == MXFColumn.AS_07_Core_DMS_Identifiers) {
                this.createIdentifiersDisplay(summary, col);
                continue;
            }
            if (col == MXFColumn.AS_07_Core_DMS_Devices) {
                this.createDevicesDisplay(summary, col);
                continue;
            }
            if (col == MXFColumn.AS_07_Core_DMS_ShimName) {
                vals = new HashMap<String, String>();
                ((HashMap)vals).put("RDD 48 Baseband Shim", "RDD 48 Baseband Shim");
                ((HashMap)vals).put("", "");
                this.setDropDownField(col, summary, ((HashMap)vals).values());
                continue;
            }
            if (col == MXFColumn.AS_07_Core_DMS_Captions) {
                vals = new HashMap();
                ((HashMap)vals).put("Y", "Y");
                ((HashMap)vals).put("N", "N");
                this.setDropDownField(col, summary, ((HashMap)vals).values());
                continue;
            }
            if (col == MXFColumn.AS_07_Core_DMS_AudioTrackPrimaryLanguage) {
                langTags = new RFC5646LanguageTags();
                this.setDropDownField(col, summary, langTags.getTreeMap().values());
                continue;
            }
            if (col == MXFColumn.AS_07_Core_DMS_AudioTrackSecondaryLanguage) {
                langTags = new RFC5646LanguageTags();
                this.setDropDownField(col, summary, langTags.getTreeMap().values());
                continue;
            }
            if (col == MXFColumn.AS_07_Core_DMS_AudioTrackLayout) {
                vals = new AudioTrackLayoutValues();
                Collection<String> strVals = ((AudioTrackLayoutValues)vals).getDescriptions();
                LinkedHashSet<String> set = new LinkedHashSet<String>(strVals);
                this.setDropDownField(col, summary, set);
                continue;
            }
            ASCIIField field = new ASCIIField();
            field.setMXFColumn(col);
            field.setVisible(true);
            Object label = col.getDisplayName();
            if (col.isRequired()) {
                label = (String)label + " *";
            }
            field.setLabel((String)label, MXFColumnHelpText.getInstance().getHelpText(col), "black");
            MetadataColumnDef columnDef = summary.getCoreData().get(col);
            if (columnDef != null && columnDef.getCurrentValue() != null) {
                field.setValue(columnDef.getCurrentValue());
            } else {
                field.setValue("");
            }
            field.setEditable(col.getEditable());
            field.managedProperty().bind((ObservableValue)field.visibleProperty());
            field.setPopoutIcon();
            field.setMXFMissingRequiredFieldRules();
            field.setMaxHeight(50.0);
            field.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> obs, String ov, String nv) {
                    CoreMXFController.this.calculateEditedFields();
                }
            });
            this.fields.add(field);
            AnchorPane.setLeftAnchor((Node)field, (Double)0.0);
            AnchorPane.setRightAnchor((Node)field, (Double)0.0);
            this.editableFieldsVBox.getChildren().add((Object)field);
        }
        this.setNumberOfSelectedFiles(summary.getFileCount());
        this.calculateEditedFields();
    }

    private void setDropDownField(MXFColumn col, MXFSelectedFilesSummary summary, Collection<String> strVals) {
        DropDownField dropDownField = new DropDownField();
        dropDownField.setComboBoxValues(strVals);
        dropDownField.setEditable(false);
        dropDownField.setMXFColumn(col);
        dropDownField.setVisible(true);
        Object label = col.getDisplayName();
        if (col.isRequired()) {
            label = (String)label + " *";
        }
        dropDownField.setLabel((String)label, MXFColumnHelpText.getInstance().getHelpText(col), "black");
        MetadataColumnDef columnDef = summary.getCoreData().get(col);
        if (columnDef != null) {
            dropDownField.setValue(columnDef.getCurrentValue());
        } else {
            dropDownField.setValue("");
        }
        dropDownField.managedProperty().bind((ObservableValue)dropDownField.visibleProperty());
        dropDownField.getComboBoxField().getSelectionModel().selectedItemProperty().addListener((ops, ov, nv) -> this.calculateEditedFields());
        this.fields.add(dropDownField);
        AnchorPane.setLeftAnchor((Node)dropDownField, (Double)0.0);
        AnchorPane.setRightAnchor((Node)dropDownField, (Double)0.0);
        this.editableFieldsVBox.getChildren().add((Object)dropDownField);
    }

    private void createDevicesDisplay(MXFSelectedFilesSummary summary, MXFColumn col) {
        DeviceSetHelper deviceSetHelper = new DeviceSetHelper();
        ArrayList<AS07CoreDMSDeviceObjectsImpl> devices = deviceSetHelper.createDeviceListFromString(summary.getCoreData().get(col).getCurrentValue());
        Object label = "Devices";
        if (col.isRequired()) {
            label = (String)label + " *";
        }
        HBox hbox = new HBox();
        HBox labelIconHbox = new HBox();
        labelIconHbox.setSpacing(5.0);
        Label devicesLabel = new Label((String)label);
        devicesLabel.setStyle("-fx-text-fill: black;");
        HBox iconHbox = new HBox();
        labelIconHbox.getChildren().addAll((Object[])new Node[]{devicesLabel, iconHbox});
        FontIcon infoIcon = new FontIcon();
        infoIcon.setIconCode((Ikon)FontAwesomeSolid.INFO_CIRCLE);
        infoIcon.getStyleClass().add((Object)"popout-icon");
        infoIcon.setIconSize(12);
        iconHbox.idProperty().set((Object)"editorTextFieldLabelInfoIcon");
        iconHbox.setFocusTraversable(true);
        iconHbox.getChildren().add((Object)infoIcon);
        iconHbox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.SPACE) {
                DataFieldInfoAlert.showFieldInfoAlert("Devices", MXFColumnHelpText.getInstance().getHelpText(col));
            }
        });
        iconHbox.setOnMouseClicked(event -> DataFieldInfoAlert.showFieldInfoAlert("Devices", MXFColumnHelpText.getInstance().getHelpText(col)));
        iconHbox.setAccessibleRole(AccessibleRole.BUTTON);
        iconHbox.setAccessibleText("Open modal with Devices specification.");
        hbox.getChildren().addAll((Object[])new Node[]{labelIconHbox});
        labelIconHbox.setPrefWidth(285.0);
        labelIconHbox.setMaxWidth(285.0);
        labelIconHbox.setMinWidth(100.0);
        this.editableFieldsVBox.getChildren().add((Object)hbox);
        VBox vbox = new VBox();
        vbox.setSpacing(5.0);
        hbox.getChildren().add((Object)vbox);
        LabelField field = new LabelField();
        field.setMXFColumn(col);
        field.setValue(summary.getCoreData().get(col).getCurrentValue());
        this.fields.add(field);
        if (devices.size() == 0) {
            Label noDeviceLabel = new Label("No Devices");
            noDeviceLabel.setStyle("-fx-text-fill: black;");
            vbox.getChildren().add((Object)noDeviceLabel);
            Label newDeviceLabel = this.createNewDeviceLabel(devices, field);
            newDeviceLabel.setFocusTraversable(true);
            vbox.getChildren().add((Object)newDeviceLabel);
            return;
        }
        for (int i = 0; i < devices.size(); ++i) {
            AS07CoreDMSDeviceObjectsImpl device = devices.get(i);
            String manu = "";
            String type = "";
            try {
                manu = device.getManufacturer();
            }
            catch (PropertyNotPresentException propertyNotPresentException) {
                // empty catch block
            }
            try {
                type = device.getDeviceType();
            }
            catch (PropertyNotPresentException propertyNotPresentException) {
                // empty catch block
            }
            Label deviceLabel = new Label(manu + " " + type);
            deviceLabel.setStyle("-fx-text-fill: black;");
            deviceLabel.setPrefWidth(306.0);
            deviceLabel.setMaxWidth(306.0);
            deviceLabel.setMinWidth(100.0);
            deviceLabel.setFocusTraversable(true);
            HBox iconBox = new HBox();
            FontIcon popoutIcon = new FontIcon((Ikon)FontAwesomeSolid.EXTERNAL_LINK_ALT);
            popoutIcon.setIconSize(16);
            popoutIcon.getStyleClass().add((Object)"popout-icon");
            popoutIcon.setVisible(true);
            iconBox.setAccessibleText("Open modal to edit or delete " + deviceLabel.getText() + " device");
            iconBox.setAccessibleRole(AccessibleRole.BUTTON);
            iconBox.getChildren().add((Object)popoutIcon);
            iconBox.setFocusTraversable(true);
            iconBox.idProperty().set((Object)"popoutIconContainer");
            HBox labelPopoutHbox = new HBox();
            labelPopoutHbox.getChildren().addAll((Object[])new Node[]{deviceLabel, iconBox});
            vbox.getChildren().add((Object)labelPopoutHbox);
            iconBox.setOnKeyPressed(e -> {
                if (e.getCode() == KeyCode.SPACE) {
                    this.devicesPopout(device, devices, field, deviceSetHelper);
                }
            });
            iconBox.setOnMouseClicked(e -> this.devicesPopout(device, devices, field, deviceSetHelper));
        }
        Label newDeviceLabel = this.createNewDeviceLabel(devices, field);
        newDeviceLabel.setFocusTraversable(true);
        vbox.getChildren().add((Object)newDeviceLabel);
    }

    private Label createNewDeviceLabel(ArrayList<AS07CoreDMSDeviceObjectsImpl> devices, LabelField field) {
        Label newDeviceLabel = new Label("Add New Device");
        newDeviceLabel.setAccessibleRole(AccessibleRole.BUTTON);
        FontIcon plusCircle = new FontIcon((Ikon)FontAwesomeSolid.PLUS_CIRCLE);
        plusCircle.getStyleClass().add((Object)"popout-icon");
        newDeviceLabel.setGraphic((Node)plusCircle);
        newDeviceLabel.setOnKeyPressed(e -> {
            if (e.getCode() == KeyCode.SPACE) {
                this.newDevice(devices, field);
            }
        });
        newDeviceLabel.setOnMouseClicked(e -> this.newDevice(devices, field));
        newDeviceLabel.setStyle("-fx-text-fill: black;");
        return newDeviceLabel;
    }

    private void createIdentifiersDisplay(MXFSelectedFilesSummary summary, MXFColumn col) {
        IdentifierSetHelper idSetHelper = new IdentifierSetHelper();
        ArrayList<AS07DMSIdentifierSetImpl> identifiers = idSetHelper.createIdentifierListFromString(summary.getCoreData().get(col).getCurrentValue());
        Object label = "Identifiers";
        if (col.isRequired()) {
            label = (String)label + " *";
        }
        HBox hbox = new HBox();
        HBox labelIconHbox = new HBox();
        labelIconHbox.setSpacing(5.0);
        Label identifierLabel = new Label((String)label);
        identifierLabel.setStyle("-fx-text-fill: black;");
        HBox iconHbox = new HBox();
        labelIconHbox.getChildren().addAll((Object[])new Node[]{identifierLabel, iconHbox});
        FontIcon infoIcon = new FontIcon();
        infoIcon.setIconCode((Ikon)FontAwesomeSolid.INFO_CIRCLE);
        infoIcon.getStyleClass().add((Object)"popout-icon");
        infoIcon.setIconSize(12);
        iconHbox.idProperty().set((Object)"editorTextFieldLabelInfoIcon");
        iconHbox.setFocusTraversable(true);
        iconHbox.getChildren().add((Object)infoIcon);
        iconHbox.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.SPACE) {
                DataFieldInfoAlert.showFieldInfoAlert("Identifiers", MXFColumnHelpText.getInstance().getHelpText(col));
            }
        });
        iconHbox.setOnMouseClicked(event -> DataFieldInfoAlert.showFieldInfoAlert("Identifiers", MXFColumnHelpText.getInstance().getHelpText(col)));
        iconHbox.setAccessibleRole(AccessibleRole.BUTTON);
        iconHbox.setAccessibleText("Open modal with Identifiers specification.");
        hbox.getChildren().addAll((Object[])new Node[]{labelIconHbox});
        labelIconHbox.setPrefWidth(285.0);
        labelIconHbox.setMaxWidth(285.0);
        labelIconHbox.setMinWidth(100.0);
        this.editableFieldsVBox.getChildren().add((Object)hbox);
        VBox vbox = new VBox();
        vbox.setSpacing(5.0);
        hbox.getChildren().add((Object)vbox);
        LabelField field = new LabelField();
        field.setMXFColumn(col);
        field.setValue(summary.getCoreData().get(col).getCurrentValue());
        this.fields.add(field);
        if (identifiers.size() == 0) {
            Label noIdentLabel = new Label("No Identifiers");
            noIdentLabel.setStyle("-fx-text-fill: black;");
            vbox.getChildren().add((Object)noIdentLabel);
            Label newIdentifierLabel = this.createNewIdentifierLabel(identifiers, field);
            newIdentifierLabel.setFocusTraversable(true);
            vbox.getChildren().add((Object)newIdentifierLabel);
            return;
        }
        for (int i = 0; i < identifiers.size(); ++i) {
            try {
                AS07DMSIdentifierSetImpl id = identifiers.get(i);
                String idValue = id.getIdentifierValue();
                String idRole = id.getIdentifierRole();
                Label idLabel = new Label(idValue + " (" + idRole + ")");
                idLabel.setStyle("-fx-text-fill: black;");
                idLabel.setPrefWidth(306.0);
                idLabel.setMaxWidth(306.0);
                idLabel.setFocusTraversable(true);
                HBox iconBox = new HBox();
                FontIcon popoutIcon = new FontIcon((Ikon)FontAwesomeSolid.EXTERNAL_LINK_ALT);
                popoutIcon.setIconSize(16);
                popoutIcon.getStyleClass().add((Object)"popout-icon");
                iconBox.setAccessibleText("Open modal to edit or delete " + idLabel.getText() + " identifier");
                iconBox.setAccessibleRole(AccessibleRole.BUTTON);
                iconBox.setFocusTraversable(true);
                iconBox.getChildren().add((Object)popoutIcon);
                iconBox.idProperty().set((Object)"popoutIconContainer");
                HBox labelPopoutHbox = new HBox();
                labelPopoutHbox.getChildren().addAll((Object[])new Node[]{idLabel, iconBox});
                vbox.getChildren().add((Object)labelPopoutHbox);
                iconBox.setOnKeyPressed(e -> {
                    if (e.getCode() != KeyCode.SPACE) {
                        return;
                    }
                    this.identifierPopout(id, identifiers, field, idSetHelper);
                });
                iconBox.setOnMouseClicked(e -> this.identifierPopout(id, identifiers, field, idSetHelper));
                continue;
            }
            catch (PropertyNotPresentException e2) {
                System.out.println("Property not found exception in createIdentifiersDisplay");
            }
        }
        Label newIdentifierLabel = this.createNewIdentifierLabel(identifiers, field);
        newIdentifierLabel.setFocusTraversable(true);
        vbox.getChildren().add((Object)newIdentifierLabel);
    }

    private Label createNewIdentifierLabel(ArrayList<AS07DMSIdentifierSetImpl> identifiers, LabelField field) {
        Label newIdentifierLabel = new Label("Add New Identifier");
        newIdentifierLabel.setAccessibleRole(AccessibleRole.BUTTON);
        FontIcon plusCircle = new FontIcon((Ikon)FontAwesomeSolid.PLUS_CIRCLE);
        plusCircle.getStyleClass().add((Object)"popout-icon");
        newIdentifierLabel.setGraphic((Node)plusCircle);
        newIdentifierLabel.setOnKeyPressed(e -> {
            if (e.getCode() != KeyCode.SPACE) {
                return;
            }
            this.newIdentifier(identifiers, field);
        });
        newIdentifierLabel.setOnMouseClicked(e -> this.newIdentifier(identifiers, field));
        newIdentifierLabel.setStyle("-fx-text-fill: black;");
        return newIdentifierLabel;
    }

    private Alert createIdDevicePopup(String title) {
        Alert alert = new Alert(Alert.AlertType.NONE);
        alert.setTitle(title);
        alert.setHeaderText(null);
        alert.setContentText(null);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        Object[] buttonList = new ButtonType[]{ButtonType.APPLY, ButtonType.CLOSE};
        alert.getButtonTypes().setAll(buttonList);
        return alert;
    }

    private TextArea createTextArea(String value) {
        TextArea textArea = new TextArea(value);
        textArea.setEditable(true);
        textArea.setWrapText(true);
        textArea.setMaxWidth(550.0);
        textArea.setPrefWidth(550.0);
        textArea.setPrefHeight(50.0);
        textArea.setMinHeight(50.0);
        return textArea;
    }

    private Label createLabel(String name) {
        Label label = new Label(name);
        label.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        return label;
    }

    private Tooltip createTooltip(String text) {
        Tooltip tt = new Tooltip(text);
        tt.setStyle("-fx-text-fill: white; -fx-font-size: 12px");
        tt.setPrefWidth(500.0);
        tt.setWrapText(true);
        tt.setAutoHide(false);
        return tt;
    }

    private void showAlert(String modalTitle, String alertText) {
        Alert alert = AccessibleAlertHelper.CreateAccessibleAlert(modalTitle, Alert.AlertType.NONE, alertText, ButtonType.CLOSE);
        alert.setHeaderText(null);
        alert.setContentText(null);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        DialogPane dialogPane = alert.getDialogPane();
        alert.getDialogPane().lookupButton(ButtonType.CLOSE).setAccessibleHelp(alertText);
        dialogPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"alertDialog");
        alert.showAndWait();
        if (alert.getResult() == ButtonType.CLOSE) {
            alert.close();
        }
    }

    private void showConfirmation(String modalTitle, String confirmationText) {
        Alert alert = AccessibleAlertHelper.CreateAccessibleAlert(modalTitle, Alert.AlertType.CONFIRMATION, confirmationText, ButtonType.CANCEL, ButtonType.OK);
        alert.setHeaderText(null);
        alert.setContentText(null);
        alert.initModality(Modality.APPLICATION_MODAL);
        alert.initOwner((Window)Main.getPrimaryStage());
        DialogPane dialogPane = alert.getDialogPane();
        alert.getDialogPane().lookupButton(ButtonType.OK).setAccessibleHelp(confirmationText);
        dialogPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/com/portalmedia/embarc/gui/application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"alertDialog");
        alert.showAndWait();
        if (alert.getResult() == ButtonType.CANCEL) {
            alert.close();
        } else if (alert.getResult() == ButtonType.OK) {
            this.setSection(true);
        }
    }

    private void identifierPopout(final AS07DMSIdentifierSetImpl id, final ArrayList<AS07DMSIdentifierSetImpl> identifiers, final LabelField field, final IdentifierSetHelper idSetHelper) {
        final Alert alert = this.createIdDevicePopup("Edit " + id.getIdentifierValue() + " (" + id.getIdentifierRole() + ")");
        Label typeLabel = this.createLabel("Identifier Type");
        TextArea typeTextArea = this.createTextArea(id.getIdentifierType());
        typeLabel.setTooltip(this.createTooltip("Identifier Type\n\nControlled vocabulary string value identifying the type of identifier: UUID - UUID encoded as a URN according to IETF RFC 4122; UMID - Unique Material Identifier (UMID) defined by SMPTE ST 330:2004, represented as a URN per ST 2029:2009; UL \u2013 Universal Label as defined by SMPTE ST 298:2009, represented as a URN per ST 2029:2009; Other \u2013A value not included in the controlled list, including archive specific values."));
        Label roleLabel = this.createLabel("Identifier Role");
        TextArea roleTextArea = this.createTextArea(id.getIdentifierRole());
        roleLabel.setTooltip(this.createTooltip("Identifier Role\n\nControlled vocabulary string value identifying the role of identifier: Main (universally unique primary identifier for the entire RDD 48 file) Additional (additional, possibly local, identifier for the entire RDD 48 file. Additional identifiers are not required to be universally unique) GSP (universally unique identifier for GSP payload)"));
        Label valueLabel = this.createLabel("Identifier Value");
        TextArea valueTextArea = this.createTextArea(id.getIdentifierValue());
        valueLabel.setTooltip(this.createTooltip("Identifier Value\n\nIdentifier value."));
        Label commentLabel = this.createLabel("Identifier Comment");
        TextArea commentTextArea = this.createTextArea(id.getIdentifierComment());
        commentLabel.setTooltip(this.createTooltip("Identifier Comment\n\nIdentifier comment."));
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)typeLabel, 0, 0);
        expContent.add((Node)typeTextArea, 0, 1);
        expContent.add((Node)roleLabel, 0, 2);
        expContent.add((Node)roleTextArea, 0, 3);
        expContent.add((Node)valueLabel, 0, 4);
        expContent.add((Node)valueTextArea, 0, 5);
        expContent.add((Node)commentLabel, 0, 6);
        expContent.add((Node)commentTextArea, 0, 7);
        expContent.add((Node)new Label(""), 0, 8);
        Button deleteButton = new Button("Delete Identifier");
        deleteButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                identifiers.remove(id);
                field.setValue(idSetHelper.identifiersToString(identifiers));
                field.setValueChanged();
                CoreMXFController.this.calculateEditedFields();
                alert.close();
            }
        });
        expContent.add((Node)deleteButton, 0, 9);
        alert.getDialogPane().setContent((Node)expContent);
        alert.showAndWait();
        if (alert.getResult() == ButtonType.APPLY) {
            id.setIdentifierType(typeTextArea.getText());
            id.setIdentifierRole(roleTextArea.getText());
            id.setIdentifierValue(valueTextArea.getText());
            id.setIdentifierComment(commentTextArea.getText());
            field.setValue(idSetHelper.identifiersToString(identifiers));
            field.setValueChanged();
            this.calculateEditedFields();
            alert.close();
        } else if (alert.getResult() == ButtonType.CLOSE) {
            alert.close();
        }
    }

    private void newIdentifier(ArrayList<AS07DMSIdentifierSetImpl> identifiers, LabelField field) {
        Alert popup = this.createIdDevicePopup("Add Identifier");
        Label typeLabel = this.createLabel("Identifier Type");
        TextArea typeTextArea = this.createTextArea("");
        typeLabel.setTooltip(this.createTooltip("Identifier Type\n\nControlled vocabulary string value identifying the type of identifier: UUID - UUID encoded as a URN according to IETF RFC 4122; UMID - Unique Material Identifier (UMID) defined by SMPTE ST 330:2004, represented as a URN per ST 2029:2009; UL \u2013 Universal Label as defined by SMPTE ST 298:2009, represented as a URN per ST 2029:2009; Other \u2013A value not included in the controlled list, including archive specific values."));
        Label roleLabel = this.createLabel("Identifier Role");
        TextArea roleTextArea = this.createTextArea("");
        roleLabel.setTooltip(this.createTooltip("Identifier Role\n\nControlled vocabulary string value identifying the role of identifier: Main (universally unique primary identifier for the entire RDD 48 file) Additional (additional, possibly local, identifier for the entire RDD 48 file. Additional identifiers are not required to be universally unique) GSP (universally unique identifier for GSP payload)"));
        Label valueLabel = this.createLabel("Identifier Value");
        TextArea valueTextArea = this.createTextArea("");
        valueLabel.setTooltip(this.createTooltip("Identifier Value\n\nIdentifier value."));
        Label commentLabel = this.createLabel("Identifier Comment");
        TextArea commentTextArea = this.createTextArea("");
        commentLabel.setTooltip(this.createTooltip("Identifier Comment\n\nIdentifier comment."));
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)typeLabel, 0, 0);
        expContent.add((Node)typeTextArea, 0, 1);
        expContent.add((Node)roleLabel, 0, 2);
        expContent.add((Node)roleTextArea, 0, 3);
        expContent.add((Node)valueLabel, 0, 4);
        expContent.add((Node)valueTextArea, 0, 5);
        expContent.add((Node)commentLabel, 0, 6);
        expContent.add((Node)commentTextArea, 0, 7);
        popup.getDialogPane().setContent((Node)expContent);
        popup.showAndWait();
        if (popup.getResult() == ButtonType.APPLY) {
            AS07DMSIdentifierSetImpl newIdSet = new AS07DMSIdentifierSetImpl();
            newIdSet.setIdentifierType(typeTextArea.getText());
            newIdSet.setIdentifierRole(roleTextArea.getText());
            newIdSet.setIdentifierValue(valueTextArea.getText());
            newIdSet.setIdentifierComment(commentTextArea.getText());
            identifiers.add(newIdSet);
            IdentifierSetHelper idSetHelper = new IdentifierSetHelper();
            field.setValue(idSetHelper.identifiersToString(identifiers));
            field.setValueChanged();
            this.calculateEditedFields();
            popup.close();
        } else if (popup.getResult() == ButtonType.CLOSE) {
            popup.close();
        }
    }

    private void devicesPopout(final AS07CoreDMSDeviceObjectsImpl device, final ArrayList<AS07CoreDMSDeviceObjectsImpl> devices, final LabelField field, final DeviceSetHelper deviceSetHelper) {
        final Alert alert = this.createIdDevicePopup("Edit Device");
        Label deviceTypeLabel = this.createLabel("Device Type");
        String type = "";
        try {
            type = device.getDeviceType();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        TextArea deviceTypeTextArea = this.createTextArea(type);
        deviceTypeLabel.setTooltip(this.createTooltip("Device Type\n\nThe kind of device used to capture or create the content (as either a commonly known name or as a locally defined name; e.g., Radio-camera)"));
        Label manufacturerLabel = this.createLabel("Manufacturer");
        String manu = "";
        try {
            manu = device.getManufacturer();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        TextArea manufacturerTextArea = this.createTextArea(manu);
        manufacturerLabel.setTooltip(this.createTooltip("Manufacturer\n\nThe manufacturer or maker of the device"));
        Label modelLabel = this.createLabel("Model");
        String model = "";
        try {
            model = device.getModel();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        TextArea modelTextArea = this.createTextArea(model);
        modelLabel.setTooltip(this.createTooltip("Model\n\nIdentifies the device model used in capturing or generating the essence."));
        Label serialNumberLabel = this.createLabel("Serial Number");
        String serial = "";
        try {
            serial = device.getSerialNumber();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        TextArea serialNumberTextArea = this.createTextArea(serial);
        serialNumberLabel.setTooltip(this.createTooltip("Serial Number\n\nAlphanumeric serial number identifying the individual device"));
        Label usageDescriptionLabel = this.createLabel("Usage Description");
        String usage = "";
        try {
            usage = device.getUsageDescription();
        }
        catch (PropertyNotPresentException propertyNotPresentException) {
            // empty catch block
        }
        TextArea usageDescriptionTextArea = this.createTextArea(usage);
        usageDescriptionLabel.setTooltip(this.createTooltip("UsageDescription\n\nFree text description of the function or use of the device in the production of a specific content item"));
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)deviceTypeLabel, 0, 0);
        expContent.add((Node)deviceTypeTextArea, 0, 1);
        expContent.add((Node)manufacturerLabel, 0, 2);
        expContent.add((Node)manufacturerTextArea, 0, 3);
        expContent.add((Node)modelLabel, 0, 4);
        expContent.add((Node)modelTextArea, 0, 5);
        expContent.add((Node)serialNumberLabel, 0, 6);
        expContent.add((Node)serialNumberTextArea, 0, 7);
        expContent.add((Node)usageDescriptionLabel, 0, 8);
        expContent.add((Node)usageDescriptionTextArea, 0, 9);
        expContent.add((Node)new Label(""), 0, 10);
        Button deleteButton = new Button("Delete Device");
        deleteButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                devices.remove(device);
                field.setValue(deviceSetHelper.devicesToString(devices));
                field.setValueChanged();
                CoreMXFController.this.calculateEditedFields();
                alert.close();
            }
        });
        expContent.add((Node)deleteButton, 0, 11);
        alert.getDialogPane().setContent((Node)expContent);
        alert.showAndWait();
        if (alert.getResult() == ButtonType.APPLY) {
            device.setDeviceType(deviceTypeTextArea.getText());
            device.setManufacturer(manufacturerTextArea.getText());
            device.setModel(modelTextArea.getText());
            device.setSerialNumber(serialNumberTextArea.getText());
            device.setUsageDescription(usageDescriptionTextArea.getText());
            field.setValue(deviceSetHelper.devicesToString(devices));
            field.setValueChanged();
            this.calculateEditedFields();
            alert.close();
        } else if (alert.getResult() == ButtonType.CLOSE) {
            alert.close();
        }
    }

    private void newDevice(ArrayList<AS07CoreDMSDeviceObjectsImpl> devices, LabelField field) {
        Alert popup = this.createIdDevicePopup("Add New Device");
        Label deviceTypeLabel = this.createLabel("Device Type");
        TextArea deviceTypeTextArea = this.createTextArea("");
        deviceTypeLabel.setTooltip(this.createTooltip("Device Type\n\nThe kind of device used to capture or create the content (as either a commonly known name or as a locally defined name; e.g., Radio-camera)"));
        Label manufacturerLabel = this.createLabel("Manufacturer");
        TextArea manufacturerTextArea = this.createTextArea("");
        manufacturerLabel.setTooltip(this.createTooltip("Manufacturer\n\nThe manufacturer or maker of the device"));
        Label modelLabel = this.createLabel("Model");
        TextArea modelTextArea = this.createTextArea("");
        modelLabel.setTooltip(this.createTooltip("Model\n\nIdentifies the device model used in capturing or generating the essence."));
        Label serialNumberLabel = this.createLabel("Serial Number");
        TextArea serialNumberTextArea = this.createTextArea("");
        serialNumberLabel.setTooltip(this.createTooltip("Serial Number\n\nAlphanumeric serial number identifying the individual device"));
        Label usageDescriptionLabel = this.createLabel("Usage Description");
        TextArea usageDescriptionTextArea = this.createTextArea("");
        usageDescriptionLabel.setTooltip(this.createTooltip("UsageDescription\n\nFree text description of the function or use of the device in the production of a specific content item"));
        GridPane expContent = new GridPane();
        expContent.setMaxWidth(Double.MAX_VALUE);
        expContent.add((Node)deviceTypeLabel, 0, 0);
        expContent.add((Node)deviceTypeTextArea, 0, 1);
        expContent.add((Node)manufacturerLabel, 0, 2);
        expContent.add((Node)manufacturerTextArea, 0, 3);
        expContent.add((Node)modelLabel, 0, 4);
        expContent.add((Node)modelTextArea, 0, 5);
        expContent.add((Node)serialNumberLabel, 0, 6);
        expContent.add((Node)serialNumberTextArea, 0, 7);
        expContent.add((Node)usageDescriptionLabel, 0, 8);
        expContent.add((Node)usageDescriptionTextArea, 0, 9);
        popup.getDialogPane().setContent((Node)expContent);
        popup.showAndWait();
        if (popup.getResult() == ButtonType.APPLY) {
            AS07CoreDMSDeviceObjectsImpl newDevice = new AS07CoreDMSDeviceObjectsImpl();
            newDevice.setDeviceType(deviceTypeTextArea.getText());
            newDevice.setManufacturer(manufacturerTextArea.getText());
            newDevice.setModel(modelTextArea.getText());
            newDevice.setSerialNumber(serialNumberTextArea.getText());
            newDevice.setUsageDescription(usageDescriptionTextArea.getText());
            devices.add(newDevice);
            DeviceSetHelper deviceSetHelper = new DeviceSetHelper();
            field.setValue(deviceSetHelper.devicesToString(devices));
            field.setValueChanged();
            this.calculateEditedFields();
            popup.close();
        } else if (popup.getResult() == ButtonType.CLOSE) {
            popup.close();
        }
    }
}

