/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import com.portalmedia.embarc.gui.Main;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Separator;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Window;

public class ProgressDialog {
    private final Alert dialogAlert;
    private final ProgressIndicator progressIndicator = new ProgressIndicator();
    private Node processCount;
    private final VBox vbox;

    public ProgressDialog() {
        this.dialogAlert = new Alert(Alert.AlertType.NONE);
        this.dialogAlert.initOwner((Window)Main.getPrimaryStage());
        this.dialogAlert.setTitle("Processing Files");
        Pane progressPane = new Pane();
        HBox progressHBox = new HBox();
        this.progressIndicator.setProgress(-1.0);
        this.progressIndicator.setVisible(true);
        this.vbox = new VBox();
        progressPane.getChildren().add((Object)this.progressIndicator);
        progressHBox.getChildren().add((Object)progressPane);
        progressHBox.setAlignment(Pos.CENTER);
        progressHBox.setPadding(new Insets(0.0, 0.0, 20.0, 0.0));
        this.vbox.getChildren().add((Object)progressHBox);
        this.vbox.setAlignment(Pos.TOP_CENTER);
        this.vbox.setSpacing(10.0);
        this.dialogAlert.getDialogPane().setPrefSize(300.0, 300.0);
        this.dialogAlert.getDialogPane().setPadding(new Insets(40.0, 10.0, 10.0, 0.0));
        this.dialogAlert.getDialogPane().setContent((Node)this.vbox);
    }

    public void activateProgressBar(Task<?> task) {
        this.progressIndicator.progressProperty().bind((ObservableValue)task.progressProperty());
        this.dialogAlert.show();
    }

    public void cancelProgressBar() {
        if (this.progressIndicator.progressProperty().isBound()) {
            this.progressIndicator.progressProperty().unbind();
        }
    }

    public Alert getDialogAlert() {
        return this.dialogAlert;
    }

    public void setCountLabel(Node processText) {
        this.processCount = processText;
        this.vbox.getChildren().add((Object)this.processCount);
    }

    public void showCloseButton() {
        this.dialogAlert.getDialogPane().getButtonTypes().add((Object)ButtonType.CLOSE);
    }

    public void showLabels(List<Text> labels) {
        for (int i = 0; i < labels.size(); ++i) {
            this.vbox.getChildren().add((Object)((Node)labels.get(i)));
        }
    }

    public void showExceptions(Map<String, Exception> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        Separator spacer = new Separator();
        this.vbox.getChildren().add((Object)spacer);
        String titleStr = "";
        titleStr = exceptions.size() > 1 ? "Errors have occurred. See details below." : "An error has occurred. See details below.";
        Text title = new Text(titleStr);
        title.setTextAlignment(TextAlignment.CENTER);
        this.vbox.getChildren().add((Object)title);
        TextArea textArea = new TextArea();
        for (Map.Entry<String, Exception> kv : exceptions.entrySet()) {
            String prev = textArea.getText();
            String curr = kv.getKey() + "\n" + kv.getValue().toString();
            if (!prev.isEmpty()) {
                textArea.setText(prev + "\n\n" + curr);
                continue;
            }
            textArea.setText(curr);
        }
        this.vbox.getChildren().add((Object)textArea);
        Text part1 = new Text("If errors persist, please open an issue here:\n");
        part1.setTextAlignment(TextAlignment.CENTER);
        part1.setLineSpacing(-10.0);
        this.vbox.getChildren().add((Object)part1);
        final Hyperlink part2 = new Hyperlink("https://github.com/LibraryOfCongress/embARC/issues");
        part2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                try {
                    URI uri = new URI(part2.getText());
                    ProgressDialog.this.openUrl(uri);
                }
                catch (URISyntaxException e) {
                    System.out.println("URISyntaxException Error");
                }
            }
        });
        this.vbox.getChildren().add((Object)part2);
        Text part3 = new Text("\nor contact Kate Murray at kmur@loc.gov.");
        part3.setTextAlignment(TextAlignment.CENTER);
        part3.setLineSpacing(-10.0);
        this.vbox.getChildren().add((Object)part3);
        this.dialogAlert.setResizable(true);
        this.dialogAlert.setWidth(400.0);
        this.dialogAlert.setHeight(500.0);
        this.dialogAlert.getDialogPane().setPrefSize(400.0, 500.0);
        this.dialogAlert.setResizable(false);
    }

    private void openUrl(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException e) {
            System.out.println("openUrl Error");
        }
    }
}

