/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.model.AS07TimecodeLabelSubdescriptor;
import com.portalmedia.embarc.gui.model.MXFSelectedFilesSummary;
import com.portalmedia.embarc.gui.mxf.ControllerMediatorMXF;
import com.portalmedia.embarc.gui.mxf.MXFPictureEncodingMap;
import com.portalmedia.embarc.gui.mxf.MXFSoundEncodingMap;
import com.portalmedia.embarc.parser.mxf.MXFFileDescriptorResult;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tv.amwa.maj.enumeration.AlphaTransparencyType;
import tv.amwa.maj.enumeration.ColorSitingType;
import tv.amwa.maj.enumeration.ElectroSpatialFormulation;
import tv.amwa.maj.enumeration.FieldNumber;
import tv.amwa.maj.enumeration.SignalStandardType;
import tv.amwa.maj.exception.PropertyNotPresentException;
import tv.amwa.maj.model.CodecDefinition;
import tv.amwa.maj.model.ContainerDefinition;
import tv.amwa.maj.model.SubDescriptor;
import tv.amwa.maj.model.impl.AS07DateTimeDescriptorImpl;
import tv.amwa.maj.model.impl.AncillaryPacketsDescriptorImpl;
import tv.amwa.maj.model.impl.CDCIDescriptorImpl;
import tv.amwa.maj.model.impl.TimedTextDescriptorImpl;
import tv.amwa.maj.model.impl.WAVEPCMDescriptorImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.Rational;

public class DescriptorMXFController
extends AnchorPane {
    @FXML
    private Label sectionLabel;
    @FXML
    private Label selectedFilesLabel;
    @FXML
    private Accordion descriptorsAccordion;
    @FXML
    private TitledPane pictureTitledPane;
    @FXML
    private TitledPane soundTitledPane;
    @FXML
    private TitledPane otherTitledPane;
    @FXML
    private VBox pictureVBox;
    @FXML
    private VBox soundVBox;
    @FXML
    private VBox otherVBox;
    private String pnp = "PROPERTY NOT PRESENT";

    public DescriptorMXFController() {
        ControllerMediatorMXF.getInstance().registerDescriptorMXFController(this);
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("DescriptorMXF.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        MXFSelectedFilesSummary summary = ControllerMediatorMXF.getInstance().getSelectedFilesSummary();
        this.setFileDescriptors(summary);
        this.setNumberOfSelectedFiles(summary.getFileCount());
        this.descriptorsAccordion.setExpandedPane(this.pictureTitledPane);
    }

    private void setNumberOfSelectedFiles(int num) {
        this.selectedFilesLabel.setText(Integer.toString(num) + " file" + (num == 1 ? " " : "s ") + "selected");
    }

    public void setTitle(String title) {
        this.sectionLabel.setText(title);
    }

    private void setFileDescriptors(MXFSelectedFilesSummary summary) {
        MXFFileDescriptorResult descriptors = summary.getFileDescriptors();
        if (!Objects.isNull(descriptors)) {
            this.setPictureDescriptors(descriptors);
            this.setSoundDescriptors(descriptors);
            this.setOtherDescriptors(descriptors);
        } else {
            Label label = new Label();
            int fileCount = summary.getFileCount();
            if (fileCount == 0) {
                label.setText("No files selected, select a file to view descriptors.");
            } else if (fileCount > 1) {
                label.setText("Multiple files selected, please select only one file.");
            }
        }
    }

    private void setPictureDescriptors(MXFFileDescriptorResult descriptors) {
        List<CDCIDescriptorImpl> cdciDescriptors = descriptors.getCDCIDescriptor();
        int index = 1;
        if (cdciDescriptors.size() > 0) {
            for (CDCIDescriptorImpl cdci : cdciDescriptors) {
                VBox card = this.createCDCICard(cdci, index);
                this.pictureVBox.getChildren().add((Object)card);
                ++index;
            }
        } else {
            VBox noPicturePane = new VBox();
            noPicturePane.getChildren().add((Object)new Text("No Picture Descriptors Present"));
            this.pictureVBox.getChildren().add((Object)noPicturePane);
        }
        this.pictureTitledPane.setText("Picture Descriptors (" + (index - 1) + ")");
        this.pictureVBox.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(this){

            public void handle(MouseEvent event) {
                event.consume();
            }
        });
    }

    private void setSoundDescriptors(MXFFileDescriptorResult descriptors) {
        List<WAVEPCMDescriptorImpl> wavePCMDescriptors = descriptors.getWavePCMDescriptors();
        int index = 1;
        if (wavePCMDescriptors.size() > 0) {
            for (WAVEPCMDescriptorImpl wave : wavePCMDescriptors) {
                VBox card = this.createWaveCard(wave, index);
                this.soundVBox.getChildren().add((Object)card);
                ++index;
            }
        } else {
            BorderPane noWavePane = new BorderPane();
            noWavePane.getChildren().add((Object)new Text("No Sound Descriptors Present"));
            this.soundVBox.getChildren().add((Object)noWavePane);
        }
        this.soundTitledPane.setText("Sound Descriptors (" + (index - 1) + ")");
        this.soundVBox.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(this){

            public void handle(MouseEvent event) {
                event.consume();
            }
        });
    }

    private void setOtherDescriptors(MXFFileDescriptorResult descriptors) {
        List<AncillaryPacketsDescriptorImpl> ancillaryDescriptors = descriptors.getAncillaryPacketsDescriptors();
        List<TimedTextDescriptorImpl> timedTextDescriptors = descriptors.getTimedTextDescriptor();
        List<AS07DateTimeDescriptorImpl> dateTimeDescriptors = descriptors.getAS07DateTimeDescriptor();
        int totalOtherDescriptors = ancillaryDescriptors.size() + dateTimeDescriptors.size() + timedTextDescriptors.size();
        int index = 1;
        if (totalOtherDescriptors > 0) {
            VBox card;
            for (AS07DateTimeDescriptorImpl dateTime : dateTimeDescriptors) {
                card = this.createDateTimeCard(dateTime, index);
                this.otherVBox.getChildren().add((Object)card);
                ++index;
            }
            for (AncillaryPacketsDescriptorImpl ancillary : ancillaryDescriptors) {
                card = this.createAncillaryCard(ancillary, index);
                this.otherVBox.getChildren().add((Object)card);
                ++index;
            }
            for (TimedTextDescriptorImpl timedText : timedTextDescriptors) {
                card = this.createTimedTextCard(timedText, index);
                this.otherVBox.getChildren().add((Object)card);
                ++index;
            }
        } else {
            BorderPane noOtherPane = new BorderPane();
            noOtherPane.getChildren().add((Object)new Text("No Other Descriptors Present"));
            this.otherVBox.getChildren().add((Object)noOtherPane);
        }
        this.otherTitledPane.setText("Other Descriptors (" + (index - 1) + ")");
        this.otherVBox.addEventFilter(MouseEvent.MOUSE_PRESSED, (EventHandler)new EventHandler<MouseEvent>(this){

            public void handle(MouseEvent event) {
                event.consume();
            }
        });
    }

    private VBox createCDCICard(CDCIDescriptorImpl cdci, int index) {
        VBox vbox = new VBox();
        Label cardTitle = new Label("CDCI Descriptor");
        cardTitle.setFocusTraversable(true);
        cardTitle.setStyle("-fx-font-weight: bold; -fx-font-size: 14.0;");
        vbox.getChildren().add((Object)cardTitle);
        BorderPane filePane = new BorderPane();
        Label filePaneTitle = new Label("File Descriptors");
        filePaneTitle.setUnderline(true);
        filePaneTitle.setFocusTraversable(true);
        filePaneTitle.setStyle("-fx-font-size: 13.0;");
        GridPane fileGridPane = new GridPane();
        this.populateCDCIFileDescriptorsGrid(fileGridPane, cdci);
        filePane.setTop((Node)filePaneTitle);
        filePane.setCenter((Node)fileGridPane);
        filePane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)filePane);
        BorderPane pictureEssencePane = new BorderPane();
        Label pictureEssenceTitle = new Label("Picture Essence Descriptors");
        pictureEssenceTitle.setUnderline(true);
        pictureEssenceTitle.setFocusTraversable(true);
        pictureEssenceTitle.setStyle("-fx-font-size: 13.0;");
        GridPane pictureEssenceGridPane = new GridPane();
        this.populateCDCIPictureEssenceGrid(pictureEssenceGridPane, cdci);
        pictureEssencePane.setTop((Node)pictureEssenceTitle);
        pictureEssencePane.setCenter((Node)pictureEssenceGridPane);
        pictureEssencePane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)pictureEssencePane);
        BorderPane cdciPane = new BorderPane();
        Label cdciTitle = new Label("CDCI Descriptors");
        cdciTitle.setUnderline(true);
        cdciTitle.setFocusTraversable(true);
        cdciTitle.setStyle("-fx-font-size: 13.0;");
        GridPane cdciGridPane = new GridPane();
        this.populateCDCIGrid(cdciGridPane, cdci);
        cdciPane.setTop((Node)cdciTitle);
        cdciPane.setCenter((Node)cdciGridPane);
        cdciPane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)cdciPane);
        BorderPane calculatedPane = new BorderPane();
        Label calculatedTitle = new Label("Calculated");
        calculatedTitle.setUnderline(true);
        calculatedTitle.setFocusTraversable(true);
        calculatedTitle.setStyle("-fx-font-size: 13.0;");
        GridPane calculatedGridPane = new GridPane();
        this.populateCDCICalculatedGrid(calculatedGridPane, cdci);
        calculatedPane.setTop((Node)calculatedTitle);
        calculatedPane.setCenter((Node)calculatedGridPane);
        calculatedPane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)calculatedPane);
        return vbox;
    }

    private void populateCDCIFileDescriptorsGrid(GridPane gp, CDCIDescriptorImpl cdci) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Instance UID *"), 1, row);
        try {
            AUID instanceUID = cdci.getOriginalAUID();
            gp.add((Node)this.getValueLabel(String.valueOf(instanceUID), "Instance UID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Instance UID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Generation UID"), 1, ++row);
        try {
            AUID generation = cdci.getLinkedGenerationID();
            gp.add((Node)this.getValueLabel(String.valueOf(generation), "Generation UID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Generation UID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Linked Track ID"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getLinkedTrackID(), "Linked Track ID"), 2, row);
        ++row;
        try {
            gp.add((Node)this.getKeyLabel("Essence Length"), 1, row);
            gp.add((Node)this.getValueLabel("" + cdci.getEssenceLength(), "Essence Length"), 2, row);
            ++row;
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Essence Length"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Sample Rate *"), 1, row);
        gp.add((Node)this.getValueLabel(cdci.getSampleRateString(), "Sample Rate"), 2, row);
        gp.add((Node)this.getKeyLabel("Container Duration"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getEssenceLength(), "Container Duration"), 2, row);
        ++row;
    }

    private void populateCDCIPictureEssenceGrid(GridPane gp, CDCIDescriptorImpl cdci) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Signal Standard"), 1, row);
        try {
            SignalStandardType signalStandard = cdci.getSignalStandard();
            gp.add((Node)this.getValueLabel(String.valueOf(signalStandard), "Signal Standard"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Signal Standard"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Picture Encoding"), 1, ++row);
        try {
            String picEncodingStr = cdci.getPictureCompression().toString();
            String stripped = picEncodingStr.replace("urn:smpte:ul:", "").toUpperCase();
            HashMap<String, String> picEncodingMap = new MXFPictureEncodingMap().getMap();
            String value = picEncodingMap.get(stripped);
            if (value == null || "".equals(value)) {
                value = picEncodingStr;
                gp.add((Node)this.getValueLabel(value, "Picture Encoding"), 2, row);
            } else {
                gp.add((Node)this.getValueLabel(value, "Picture Encoding"), 2, row);
                gp.add((Node)this.getValueLabel("", "Picture Encoding"), 1, ++row);
                gp.add((Node)this.getValueLabel("(" + stripped + ")", "Picture Encoding"), 2, row);
            }
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Picture Encoding"), 2, row);
        }
        catch (Exception ex) {
            System.out.println("Error getting crc32");
        }
        gp.add((Node)this.getKeyLabel("Stored Height"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getStoredHeight(), "Stored Height"), 2, row);
        gp.add((Node)this.getKeyLabel("Stored Width"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getStoredWidth(), "Stored Width"), 2, row);
        gp.add((Node)this.getKeyLabel("Sampled Height"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getSampledHeight(), "Sampled Height"), 2, row);
        gp.add((Node)this.getKeyLabel("Sampled Width"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getSampledWidth(), "Sampled Width"), 2, row);
        gp.add((Node)this.getKeyLabel("Sampled X Offset"), 1, ++row);
        try {
            int sampledXOffset = cdci.getSampledXOffset();
            gp.add((Node)this.getValueLabel("" + sampledXOffset, "Sampled X Offset"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Sampled X Offset"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Sampled Y Offset"), 1, ++row);
        try {
            int sampledYOffset = cdci.getSampledYOffset();
            gp.add((Node)this.getValueLabel("" + sampledYOffset, "Sampled Y Offset"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Sampled Y Offset"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Display Height"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getDisplayHeight(), "Display Height"), 2, row);
        gp.add((Node)this.getKeyLabel("Display Width"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getDisplayWidth(), "Display Width"), 2, row);
        gp.add((Node)this.getKeyLabel("Display X Offset"), 1, ++row);
        try {
            int displayXOffset = cdci.getDisplayXOffset();
            gp.add((Node)this.getValueLabel("" + displayXOffset, "Display X Offset"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Display X Offset"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Display Y Offset"), 1, ++row);
        try {
            int displayYOffset = cdci.getDisplayYOffset();
            gp.add((Node)this.getValueLabel("" + displayYOffset, "Display Y Offset"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Display Y Offset"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Frame Layout"), 1, ++row);
        gp.add((Node)this.getValueLabel(String.valueOf(cdci.getFrameLayout()), "Frame Layout"), 2, row);
        ++row;
        Object videoLineMap = "";
        int[] arr = cdci.getVideoLineMap();
        if (arr != null && arr.length > 0) {
            for (int i = 0; i < arr.length; ++i) {
                videoLineMap = (String)videoLineMap + arr[i];
                if (i >= arr.length - 1) continue;
                videoLineMap = (String)videoLineMap + ", ";
            }
        }
        gp.add((Node)this.getKeyLabel("Video Line Map"), 1, row);
        gp.add((Node)this.getValueLabel((String)videoLineMap, "Video Line Map"), 2, row);
        gp.add((Node)this.getKeyLabel("Image Aspect Ratio"), 1, ++row);
        gp.add((Node)this.getValueLabel(cdci.getImageAspectRatioString(), "Image Aspect Ratio"), 2, row);
        gp.add((Node)this.getKeyLabel("Alpha Transparency"), 1, ++row);
        try {
            AlphaTransparencyType alphaTransparency = cdci.getAlphaTransparency();
            gp.add((Node)this.getValueLabel(String.valueOf(alphaTransparency), "Alpha Transparency"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Alpha Transparency"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Image Alignment Offset"), 1, ++row);
        try {
            int alignmentFactor = cdci.getImageAlignmentFactor();
            gp.add((Node)this.getValueLabel("" + alignmentFactor, "Image Alignment Offset"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Image Alignment Offset"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Image Start Offset"), 1, ++row);
        try {
            int imageStartOffset = cdci.getImageStartOffset();
            gp.add((Node)this.getValueLabel("" + imageStartOffset, "Image Start Offset"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Image Start Offset"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Image End Offset"), 1, ++row);
        try {
            int imageEndOffset = cdci.getImageEndOffset();
            gp.add((Node)this.getValueLabel("" + imageEndOffset, "Image End Offset"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Image End Offset"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Field Dominance"), 1, ++row);
        try {
            FieldNumber fieldDominance = cdci.getFieldDominance();
            gp.add((Node)this.getValueLabel("" + fieldDominance.value(), "Field Dominance"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Field Dominance"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Display F2 Offset"), 1, ++row);
        try {
            int displayOffset = cdci.getDisplayF2Offset();
            gp.add((Node)this.getValueLabel("" + displayOffset, "Display F2 Offset"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Display F2 Offset"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Stored F2 Offset"), 1, ++row);
        try {
            int storedOffset = cdci.getStoredF2Offset();
            gp.add((Node)this.getValueLabel("" + storedOffset, "Stored F2 Offset"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Stored F2 Offset"), 2, row);
        }
        ++row;
    }

    private void populateCDCIGrid(GridPane gp, CDCIDescriptorImpl cdci) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Active Format Descriptor"), 1, row);
        try {
            byte activeFormatDescriptor = cdci.getActiveFormatDescriptor();
            gp.add((Node)this.getValueLabel("" + activeFormatDescriptor, "Active Format Descriptor"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Active Format Descriptor"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Alpha Sample Depth"), 1, ++row);
        try {
            int alphaSampleDepth = cdci.getAlphaSampleDepth();
            gp.add((Node)this.getValueLabel("" + alphaSampleDepth, "Alpha Sample Depth"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Alpha Sample Depth"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Black Reference Level"), 1, ++row);
        try {
            int blackRefLevel = cdci.getBlackRefLevel();
            gp.add((Node)this.getValueLabel("" + blackRefLevel, "Black Reference Level"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Black Reference Level"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Color Range"), 1, ++row);
        try {
            int colorRange = cdci.getColorRange();
            gp.add((Node)this.getValueLabel("" + colorRange, "Color Range"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Color Range"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Color Siting"), 1, ++row);
        try {
            ColorSitingType colorSiting = cdci.getColorSiting();
            gp.add((Node)this.getValueLabel(String.valueOf(colorSiting), "Color Siting"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Color Siting"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Component Depth"), 1, ++row);
        try {
            int componentDepth = cdci.getComponentDepth();
            gp.add((Node)this.getValueLabel("" + componentDepth, "Component Depth"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Component Depth"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Horizontal Subsampling"), 1, ++row);
        try {
            int horizontalSubsampling = cdci.getHorizontalSubsampling();
            gp.add((Node)this.getValueLabel("" + horizontalSubsampling, "Horizontal Subsampling"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Horizontal Subsampling"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Padding Bits"), 1, ++row);
        try {
            short paddingBits = cdci.getPaddingBits();
            gp.add((Node)this.getValueLabel("" + paddingBits, "Padding Bits"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Padding Bits"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Reversed Byte Order"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getReversedByteOrder(), "Reversed Byte Order"), 2, row);
        gp.add((Node)this.getKeyLabel("Vertical Subsampling"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getVerticalSubsampling(), "Vertical Subsampling"), 2, row);
        gp.add((Node)this.getKeyLabel("White Reference Level"), 1, ++row);
        try {
            int whiteRefLevel = cdci.getWhiteRefLevel();
            gp.add((Node)this.getValueLabel("" + whiteRefLevel, "White Reference Level"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "White Reference Level"), 2, row);
        }
        ++row;
    }

    private void populateCDCIFFV1Grid(GridPane gp, CDCIDescriptorImpl cdci) {
        boolean row = false;
        gp.setStyle("-fx-background-color: transparent;");
    }

    private void populateCDCICalculatedGrid(GridPane gp, CDCIDescriptorImpl cdci) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Duration (seconds)"), 1, row);
        try {
            long essenceLength = cdci.getEssenceLength();
            Rational sampleRate = cdci.getSampleRate();
            gp.add((Node)this.getValueLabel("" + (double)essenceLength / sampleRate.doubleValue(), "Duration (seconds)"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel("N/A", "Duration (seconds)"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Samples Per Second"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + cdci.getSampleRate().doubleValue(), "Samples Per Second"), 2, row);
    }

    private VBox createWaveCard(WAVEPCMDescriptorImpl wave, int index) {
        VBox vbox = new VBox();
        Label cardTitle = new Label("WAVE Descriptor");
        cardTitle.setFocusTraversable(true);
        cardTitle.setStyle("-fx-font-weight: bold; -fx-font-size: 14.0;");
        vbox.getChildren().add((Object)cardTitle);
        BorderPane filePane = new BorderPane();
        Label filePaneTitle = new Label("File Descriptors");
        filePaneTitle.setUnderline(true);
        filePaneTitle.setFocusTraversable(true);
        filePaneTitle.setStyle("-fx-font-size: 13.0;");
        GridPane fileGridPane = new GridPane();
        this.populateWaveFileDescriptorsGrid(fileGridPane, wave);
        filePane.setTop((Node)filePaneTitle);
        filePane.setCenter((Node)fileGridPane);
        filePane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)filePane);
        BorderPane soundPane = new BorderPane();
        Label soundTitle = new Label("Sound Descriptors");
        soundTitle.setUnderline(true);
        soundTitle.setFocusTraversable(true);
        soundTitle.setStyle("-fx-font-size: 13.0;");
        GridPane soundGridPane = new GridPane();
        this.populateWaveSoundGrid(soundGridPane, wave);
        soundPane.setTop((Node)soundTitle);
        soundPane.setCenter((Node)soundGridPane);
        soundPane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)soundPane);
        BorderPane wavePane = new BorderPane();
        Label waveTitle = new Label("Wave Descriptors");
        waveTitle.setUnderline(true);
        waveTitle.setFocusTraversable(true);
        waveTitle.setStyle("-fx-font-size: 13.0;");
        GridPane waveGridPane = new GridPane();
        this.populateWaveGrid(waveGridPane, wave);
        wavePane.setTop((Node)waveTitle);
        wavePane.setCenter((Node)waveGridPane);
        wavePane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)wavePane);
        return vbox;
    }

    private void populateWaveFileDescriptorsGrid(GridPane gp, WAVEPCMDescriptorImpl wave) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Instance UID"), 1, row);
        try {
            AUID instanceUID = wave.getOriginalAUID();
            gp.add((Node)this.getValueLabel(String.valueOf(instanceUID), "Instance UID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Instance UID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Generation UID"), 1, ++row);
        try {
            AUID generation = wave.getLinkedGenerationID();
            gp.add((Node)this.getValueLabel(String.valueOf(generation), "Generation UID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Generation UID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Linked Track ID"), 1, ++row);
        try {
            int linkedTrackID = wave.getLinkedTrackID();
            gp.add((Node)this.getValueLabel("" + linkedTrackID, "Linked Track ID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Linked Track ID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Sample Rate *"), 1, ++row);
        gp.add((Node)this.getValueLabel(wave.getSampleRateString(), "Sample Rate"), 2, row);
        gp.add((Node)this.getKeyLabel("Container Duration"), 1, ++row);
        try {
            long essenceLength = wave.getEssenceLength();
            gp.add((Node)this.getValueLabel("" + essenceLength, "Container Duration"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Container Duration"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Codec"), 1, ++row);
        try {
            ContainerDefinition containerFormat = wave.getContainerFormat();
            gp.add((Node)this.getValueLabel(containerFormat.getDescription(), "Codec"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Codec"), 2, row);
        }
        ++row;
    }

    private void populateWaveSoundGrid(GridPane gp, WAVEPCMDescriptorImpl wave) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Audio Sample Rate"), 1, row);
        gp.add((Node)this.getValueLabel(wave.getAudioSampleRateString(), "Audio Sample Rate"), 2, row);
        gp.add((Node)this.getKeyLabel("Channel Count"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + wave.getChannelCount(), "Channel Count"), 2, row);
        gp.add((Node)this.getKeyLabel("Sound Encoding"), 1, ++row);
        try {
            String soundEncodingStr = wave.getSoundCompression().toString();
            String stripped = soundEncodingStr.replace("urn:smpte:ul:", "").toUpperCase();
            HashMap<String, String> soundEncodingMap = new MXFSoundEncodingMap().getMap();
            String value = soundEncodingMap.get(stripped);
            if (value == null || "".equals(value)) {
                value = soundEncodingStr;
                gp.add((Node)this.getValueLabel(value, "Sound Encoding"), 2, row);
            } else {
                gp.add((Node)this.getValueLabel(value, "Sound Encoding"), 2, row);
                gp.add((Node)this.getValueLabel("", "Sound Encoding"), 1, ++row);
                gp.add((Node)this.getValueLabel("(" + stripped + ")", "Sound Encoding"), 2, row);
            }
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Sound Encoding"), 2, row);
        }
        catch (Exception ex) {
            System.out.println("Error adding sound encoding");
        }
        gp.add((Node)this.getKeyLabel("Bit Depth"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + wave.getQuantizationBits(), "Bit Depth"), 2, row);
        gp.add((Node)this.getKeyLabel("Locked *"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + wave.getLocked(), "Locked"), 2, row);
        gp.add((Node)this.getKeyLabel("Audio Reference Level"), 1, ++row);
        try {
            byte audioRefLevel = wave.getAudioReferenceLevel();
            gp.add((Node)this.getValueLabel("" + audioRefLevel, "Audio Reference Level"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Audio Reference Level"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Electro-Spatial Formulation"), 1, ++row);
        try {
            ElectroSpatialFormulation electroForm = wave.getElectrospatialFormulation();
            gp.add((Node)this.getValueLabel(String.valueOf(electroForm), "Electro-Spatial Formulation"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Electro-Spatial Formulation"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Dial Norm"), 1, ++row);
        try {
            byte dialNorm = wave.getDialNorm();
            gp.add((Node)this.getValueLabel("" + dialNorm, "Dial Norm"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Dial Norm"), 2, row);
        }
        ++row;
    }

    private void populateWaveGrid(GridPane gp, WAVEPCMDescriptorImpl wave) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Average Bytes Per Second"), 1, row);
        gp.add((Node)this.getValueLabel("" + wave.getAverageBytesPerSecond(), "Average Bytes Per Second"), 2, row);
        gp.add((Node)this.getKeyLabel("Block Align"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + wave.getBlockAlign(), "Block Align"), 2, row);
    }

    private VBox createDateTimeCard(AS07DateTimeDescriptorImpl dateTime, int index) {
        VBox vbox = new VBox();
        Label cardTitle = new Label("AS07 DateTime Descriptor");
        cardTitle.setFocusTraversable(true);
        cardTitle.setStyle("-fx-font-weight: bold; -fx-font-size: 14.0;");
        vbox.getChildren().add((Object)cardTitle);
        BorderPane filePane = new BorderPane();
        Label filePaneTitle = new Label("File Descriptors");
        filePaneTitle.setUnderline(true);
        filePaneTitle.setFocusTraversable(true);
        filePaneTitle.setStyle("-fx-font-size: 13.0;");
        GridPane fileGridPane = new GridPane();
        this.populateDateTimeFileDescriptorsGrid(fileGridPane, dateTime);
        filePane.setTop((Node)filePaneTitle);
        filePane.setCenter((Node)fileGridPane);
        filePane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)filePane);
        BorderPane dateTimePane = new BorderPane();
        Label dateTimeTitle = new Label("DateTime Descriptors");
        dateTimeTitle.setUnderline(true);
        dateTimeTitle.setFocusTraversable(true);
        dateTimeTitle.setStyle("-fx-font-size: 13.0;");
        GridPane dateTimeGridPane = new GridPane();
        this.populateDateTimeDescriptorGrid(dateTimeGridPane, dateTime);
        dateTimePane.setTop((Node)dateTimeTitle);
        dateTimePane.setCenter((Node)dateTimeGridPane);
        dateTimePane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)dateTimePane);
        BorderPane dateTimeSubdescriptorsPane = new BorderPane();
        Label dateTimeSubdescriptorsTitle = new Label("DateTime Subdescriptors");
        dateTimeSubdescriptorsTitle.setUnderline(true);
        dateTimeSubdescriptorsTitle.setFocusTraversable(true);
        dateTimeSubdescriptorsTitle.setStyle("-fx-font-size: 13.0;");
        GridPane dateTimeSubdescriptorsGridPane = new GridPane();
        this.populateDateTimeSubdescriptorsGrid(dateTimeSubdescriptorsGridPane, dateTime);
        dateTimeSubdescriptorsPane.setTop((Node)dateTimeSubdescriptorsTitle);
        dateTimeSubdescriptorsPane.setCenter((Node)dateTimeSubdescriptorsGridPane);
        dateTimeSubdescriptorsPane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)dateTimeSubdescriptorsPane);
        return vbox;
    }

    private void populateDateTimeFileDescriptorsGrid(GridPane gp, AS07DateTimeDescriptorImpl dateTime) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Instance UID *"), 1, row);
        try {
            AUID originalAUID = dateTime.getOriginalAUID();
            gp.add((Node)this.getValueLabel(String.valueOf(originalAUID), "Instance UID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Instance UID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Generation UID"), 1, ++row);
        try {
            AUID linkedGenerationID = dateTime.getLinkedGenerationID();
            gp.add((Node)this.getValueLabel(String.valueOf(linkedGenerationID), "Generation UID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Generation UID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Linked Track ID"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + dateTime.getLinkedTrackID(), "Linked Track ID"), 2, row);
        gp.add((Node)this.getKeyLabel("Sample Rate *"), 1, ++row);
        gp.add((Node)this.getValueLabel(dateTime.getSampleRateString(), "Sample Rate"), 2, row);
        gp.add((Node)this.getKeyLabel("Container Duration"), 1, ++row);
        try {
            long essenceLength = dateTime.getEssenceLength();
            gp.add((Node)this.getValueLabel("" + essenceLength, "Container Duration"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Container Duration"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Codec"), 1, ++row);
        try {
            ContainerDefinition containerFormat = dateTime.getContainerFormat();
            gp.add((Node)this.getValueLabel(String.valueOf(containerFormat), "Codec"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Codec"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Locators"), 1, ++row);
        try {
            List locators = dateTime.getLocators();
            gp.add((Node)this.getValueLabel(String.valueOf(locators), "Locators"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Locators"), 2, row);
        }
        ++row;
    }

    private void populateDateTimeDescriptorGrid(GridPane gp, AS07DateTimeDescriptorImpl dateTime) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("DateTime Rate"), 1, row);
        gp.add((Node)this.getValueLabel(String.valueOf(dateTime.getDateTimeRate()), "DateTime Rate"), 2, row);
        gp.add((Node)this.getKeyLabel("DateTime Drop Frame"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + dateTime.getDateTimeDropFrame(), "DateTime Drop Frame"), 2, row);
        gp.add((Node)this.getKeyLabel("DateTime Embedded"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + dateTime.getDateTimeEmbedded(), "DateTime Embedded"), 2, row);
        gp.add((Node)this.getKeyLabel("DateTime Kind *"), 1, ++row);
        gp.add((Node)this.getValueLabel(String.valueOf(dateTime.getDateTimeKind()), "DateTime Kind"), 2, row);
        ++row;
    }

    private void populateDateTimeSubdescriptorsGrid(GridPane gp, AS07DateTimeDescriptorImpl dateTime) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        if (dateTime.getSubDescriptors().size() == 0) {
            return;
        }
        for (SubDescriptor sub : dateTime.getSubDescriptors()) {
            AS07TimecodeLabelSubdescriptor parsedSub = this.parseDateTimeSubDescriptor(sub.toString());
            if (parsedSub == null) continue;
            gp.add((Node)this.getKeyLabel("DateTime Symbol *"), 1, row);
            gp.add((Node)this.getValueLabel(parsedSub.getDateTimeSymbol(), "DateTime Symbol"), 2, row);
            gp.add((Node)this.getKeyLabel("DateTime Essence Track ID"), 1, ++row);
            gp.add((Node)this.getValueLabel(parsedSub.getDateTimeEssenceTrackID(), "DateTime Essence Track ID"), 2, row);
            ++row;
        }
    }

    private VBox createAncillaryCard(AncillaryPacketsDescriptorImpl ancillary, int index) {
        VBox vbox = new VBox();
        Label cardTitle = new Label("Ancillary Packets Descriptor (ANC)");
        cardTitle.setFocusTraversable(true);
        cardTitle.setStyle("-fx-font-weight: bold; -fx-font-size: 14.0;");
        vbox.getChildren().add((Object)cardTitle);
        BorderPane filePane = new BorderPane();
        Label filePaneTitle = new Label("File Descriptors");
        filePaneTitle.setUnderline(true);
        filePaneTitle.setFocusTraversable(true);
        filePaneTitle.setStyle("-fx-font-size: 13.0;");
        GridPane fileGridPane = new GridPane();
        this.populateAncillaryFileDescriptorsGrid(fileGridPane, ancillary);
        filePane.setTop((Node)filePaneTitle);
        filePane.setCenter((Node)fileGridPane);
        filePane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)filePane);
        BorderPane ancillaryPane = new BorderPane();
        Label ancillaryTitle = new Label("Generic Data Essence Descriptor");
        ancillaryTitle.setUnderline(true);
        ancillaryTitle.setFocusTraversable(true);
        ancillaryTitle.setStyle("-fx-font-size: 13.0;");
        GridPane ancillaryGridPane = new GridPane();
        this.populateAncillaryDescriptorGrid(ancillaryGridPane, ancillary);
        ancillaryPane.setTop((Node)ancillaryTitle);
        ancillaryPane.setCenter((Node)ancillaryGridPane);
        ancillaryPane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)ancillaryPane);
        return vbox;
    }

    private void populateAncillaryFileDescriptorsGrid(GridPane gp, AncillaryPacketsDescriptorImpl ancillary) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Instance UID *"), 1, row);
        try {
            AUID originalAUID = ancillary.getOriginalAUID();
            gp.add((Node)this.getValueLabel(String.valueOf(originalAUID), "Instance UID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Instance UID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Generation UID"), 1, ++row);
        try {
            AUID generationID = ancillary.getLinkedGenerationID();
            gp.add((Node)this.getValueLabel(String.valueOf(generationID), "Generation UID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Generation UID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Linked Track ID"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + ancillary.getLinkedTrackID(), "Linked Track ID"), 2, row);
        gp.add((Node)this.getKeyLabel("Sample Rate *"), 1, ++row);
        gp.add((Node)this.getValueLabel(String.valueOf(ancillary.getSampleRate()), "Sample Rate"), 2, row);
        gp.add((Node)this.getKeyLabel("Container Duration"), 1, ++row);
        try {
            long essenceLength = ancillary.getEssenceLength();
            gp.add((Node)this.getValueLabel("" + essenceLength, "Container Duration"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Container Duration"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Codec"), 1, ++row);
        try {
            CodecDefinition codec = ancillary.getCodec();
            gp.add((Node)this.getValueLabel(String.valueOf(codec), "Codec"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Codec"), 2, row);
        }
        ++row;
    }

    private void populateAncillaryDescriptorGrid(GridPane gp, AncillaryPacketsDescriptorImpl ancillary) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Data Essence Coding"), 1, row);
        gp.add((Node)this.getValueLabel(this.pnp, "Data Essence Coding"), 2, row);
    }

    private VBox createTimedTextCard(TimedTextDescriptorImpl timedText, int index) {
        VBox vbox = new VBox();
        Label cardTitle = new Label("Timed Text Descriptor");
        cardTitle.setFocusTraversable(true);
        cardTitle.setStyle("-fx-font-weight: bold; -fx-font-size: 14.0;");
        vbox.getChildren().add((Object)cardTitle);
        BorderPane filePane = new BorderPane();
        Label filePaneTitle = new Label("File Descriptors");
        filePaneTitle.setUnderline(true);
        filePaneTitle.setFocusTraversable(true);
        filePaneTitle.setStyle("-fx-font-size: 13.0;");
        GridPane fileGridPane = new GridPane();
        this.populateTimedTextFileDescriptorsGrid(fileGridPane, timedText);
        filePane.setTop((Node)filePaneTitle);
        filePane.setCenter((Node)fileGridPane);
        filePane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)filePane);
        BorderPane timedTextPane = new BorderPane();
        Label timedTextTitle = new Label("Timed Text Descriptors");
        timedTextTitle.setUnderline(true);
        timedTextTitle.setFocusTraversable(true);
        timedTextTitle.setStyle("-fx-font-size: 13.0;");
        GridPane timedTextGridPane = new GridPane();
        this.populateTimedTextGrid(timedTextGridPane, timedText);
        timedTextPane.setTop((Node)timedTextTitle);
        timedTextPane.setCenter((Node)timedTextGridPane);
        timedTextPane.setPadding(new Insets(0.0, 0.0, 10.0, 5.0));
        vbox.getChildren().add((Object)timedTextPane);
        return vbox;
    }

    private void populateTimedTextFileDescriptorsGrid(GridPane gp, TimedTextDescriptorImpl timedText) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Instance UID *"), 1, row);
        try {
            AUID originalAUID = timedText.getOriginalAUID();
            gp.add((Node)this.getValueLabel(String.valueOf(originalAUID), "Instance UID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Instance UID"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Generation UID"), 1, ++row);
        gp.add((Node)this.getValueLabel(String.valueOf(timedText.getLinkedGenerationID()), "Generation UID"), 2, row);
        gp.add((Node)this.getKeyLabel("Linked Track ID"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + timedText.getLinkedTrackID(), "Linked Track ID"), 2, row);
        gp.add((Node)this.getKeyLabel("Sample Rate *"), 1, ++row);
        gp.add((Node)this.getValueLabel(String.valueOf(timedText.getSampleRate()), "Sample Rate"), 2, row);
        gp.add((Node)this.getKeyLabel("Container Duration"), 1, ++row);
        gp.add((Node)this.getValueLabel("" + timedText.getEssenceLength(), "Container Duration"), 2, row);
        gp.add((Node)this.getKeyLabel("Codec"), 1, ++row);
        try {
            ContainerDefinition containerFormat = timedText.getContainerFormat();
            gp.add((Node)this.getValueLabel(containerFormat.getDescription(), "Codec"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Codec"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Locators"), 1, ++row);
        try {
            List locators = timedText.getLocators();
            gp.add((Node)this.getValueLabel(String.valueOf(locators), "Locators"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Locators"), 2, row);
        }
        ++row;
    }

    private void populateTimedTextGrid(GridPane gp, TimedTextDescriptorImpl timedText) {
        int row = 0;
        gp.setStyle("-fx-background-color: transparent;");
        gp.add((Node)this.getKeyLabel("Text Encoding Format"), 1, row);
        try {
            String ucsEncoding = timedText.getUcsEncoding();
            gp.add((Node)this.getValueLabel(ucsEncoding, "Text Encoding Format"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Text Encoding Format"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Namespace URI"), 1, ++row);
        try {
            String namespaceURI = timedText.getNamespaceURI();
            gp.add((Node)this.getValueLabel(namespaceURI, "Namespace URI"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Namespace URI"), 2, row);
        }
        gp.add((Node)this.getKeyLabel("Resource ID"), 1, ++row);
        try {
            AUID resourceID = timedText.getResourceId();
            gp.add((Node)this.getValueLabel(String.valueOf(resourceID), "Resource ID"), 2, row);
        }
        catch (PropertyNotPresentException e) {
            gp.add((Node)this.getValueLabel(this.pnp, "Resource ID"), 2, row);
        }
        ++row;
    }

    private Label getKeyLabel(String key) {
        Label label = new Label(key);
        label.setPrefWidth(200.0);
        label.setPadding(new Insets(2.0, 0.0, 2.0, 5.0));
        label.setMaxHeight(Double.MAX_VALUE);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setAlignment(Pos.TOP_LEFT);
        return label;
    }

    private Label getValueLabel(String value, String key) {
        Label label = new Label(value);
        label.setPrefWidth(400.0);
        label.setPadding(new Insets(2.0, 0.0, 2.0, 5.0));
        label.setMaxHeight(Double.MAX_VALUE);
        label.setMaxWidth(Double.MAX_VALUE);
        label.setAlignment(Pos.TOP_LEFT);
        label.setFocusTraversable(true);
        label.setAccessibleText(key + " is " + value);
        return label;
    }

    private AS07TimecodeLabelSubdescriptor parseDateTimeSubDescriptor(String sub) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AS07TimecodeLabelSubdescriptor.class});
            Unmarshaller u = jaxbContext.createUnmarshaller();
            String d = sub.replace("aaf:", "");
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(new InputSource(new StringReader(d)));
            AS07TimecodeLabelSubdescriptor subdescriptor = (AS07TimecodeLabelSubdescriptor)u.unmarshal((org.w3c.dom.Node)document);
            return subdescriptor;
        }
        catch (JAXBException e) {
            System.out.println("Error parsing date time subdescriptor");
        }
        catch (ParserConfigurationException e) {
            System.out.println("Error parsing date time subdescriptor");
        }
        catch (SAXException e) {
            System.out.println("Error parsing date time subdescriptor");
        }
        catch (IOException e) {
            System.out.println("Error parsing date time subdescriptor");
        }
        return null;
    }
}

