/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.dpx.EditorForm;
import com.portalmedia.embarc.gui.dpx.GeneralForm;
import com.portalmedia.embarc.gui.dpx.WriteFilesModalController;
import com.portalmedia.embarc.gui.dpx.WriteFilesView;
import com.portalmedia.embarc.parser.SectionDef;
import java.net.URL;
import java.util.Collection;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;

public class MetadataEditorController
implements Initializable {
    @FXML
    private AnchorPane metadataEditorContainer;
    @FXML
    private AnchorPane editorContentSwapPane;
    @FXML
    private AnchorPane editorPane;
    @FXML
    private Tab editableTab;
    @FXML
    private Tab nonEditableTab;
    @FXML
    private Button writeFilesButton;
    @FXML
    private ImageView fadgiLogoImageView;
    private EditorForm editorFormPane;
    private GeneralForm generalFormPane;

    public void initialize(URL location, ResourceBundle resources) {
        ControllerMediatorDPX.getInstance().registerMetadataEditorController(this);
        this.fadgiLogoImageView.setFocusTraversable(true);
        this.fadgiLogoImageView.setAccessibleText("FADGI logo. F A D G I stands for Federal Agencies Digital Guidelines Initiative.");
        ControllerMediatorDPX.getInstance().isEditingProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue o, Object ov, Object nv) {
                if (MetadataEditorController.this.editorFormPane == null) {
                    return;
                }
                MetadataEditorController.this.writeFilesButton.setDisable(((Boolean)nv).booleanValue());
            }
        });
        this.writeFilesButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(this){

            public void handle(ActionEvent e) {
                WriteFilesModalController.getInstance().showWriteFilesDialog();
            }
        });
        this.writeFilesButton.setGraphicTextGap(20.0);
    }

    public void refreshValidation() {
        if (this.editorFormPane != null) {
            this.editorFormPane.refreshValidation();
        }
    }

    public void resetEditControl(SectionDef section) {
        this.editorContentSwapPane.getChildren().removeAll((Collection)this.editorContentSwapPane.getChildren());
        this.setWriteControl(section);
    }

    public void setEditControl(SectionDef section) {
        this.editorFormPane = new EditorForm();
        if (this.generalFormPane != null) {
            this.generalFormPane.setVisible(false);
        }
        this.editorFormPane.setVisible(true);
        if (this.editorContentSwapPane.getChildren().size() > 0) {
            this.editorContentSwapPane.getChildren().removeAll((Collection)this.editorContentSwapPane.getChildren());
        }
        this.editorFormPane.setSection(section, false);
        this.editorFormPane.setTitle(section.getDisplayName());
        this.editorFormPane.setMaxWidth(Double.MAX_VALUE);
        AnchorPane.setTopAnchor((Node)this.editorFormPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.editorFormPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.editorFormPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.editorFormPane, (Double)0.0);
        this.editorContentSwapPane.getChildren().setAll((Object[])new Node[]{this.editorFormPane});
    }

    public void setGeneralControl() {
        this.generalFormPane = new GeneralForm();
        this.generalFormPane.setVisible(true);
        if (this.editorFormPane != null) {
            this.editorFormPane.setVisible(false);
        }
        if (this.editorContentSwapPane.getChildren().size() > 0) {
            this.editorContentSwapPane.getChildren().removeAll((Collection)this.editorContentSwapPane.getChildren());
        }
        this.generalFormPane.setTitle("General Information");
        this.generalFormPane.setMaxWidth(Double.MAX_VALUE);
        AnchorPane.setTopAnchor((Node)this.generalFormPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.generalFormPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.generalFormPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.generalFormPane, (Double)0.0);
        this.editorContentSwapPane.getChildren().setAll((Object[])new Node[]{this.generalFormPane});
    }

    public void setWriteControl(SectionDef section) {
        WriteFilesView pane1 = new WriteFilesView();
        pane1.setMaxWidth(Double.MAX_VALUE);
        pane1.setMessage(section);
        AnchorPane.setTopAnchor((Node)pane1, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)pane1, (Double)0.0);
        AnchorPane.setRightAnchor((Node)pane1, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)pane1, (Double)0.0);
        this.editorContentSwapPane.getChildren().setAll((Object[])new Node[]{pane1});
    }
}

