/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import org.controlsfx.control.textfield.CustomTextField;

public class FloatInputControl
extends CustomTextField {
    public void replaceSelection(String text) {
        String oldValue = this.getText();
        if (this.validate(text)) {
            if (text.toLowerCase().indexOf("e") > 0) {
                try {
                    Float i = Float.valueOf(Float.parseFloat(text));
                    super.replaceSelection(String.valueOf(i));
                }
                catch (NumberFormatException ex) {
                    super.replaceSelection(text);
                }
            } else {
                super.replaceSelection(text);
            }
            String newText = super.getText();
            if (!this.validate(newText)) {
                super.setText(oldValue);
            }
        }
    }

    public void replaceText(int start, int end, String text) {
        String oldValue = this.getText();
        if (this.validate(text)) {
            if (text.toLowerCase().indexOf("e") > 0) {
                try {
                    Float i = Float.valueOf(Float.parseFloat(text));
                    super.replaceText(start, end, String.valueOf(i));
                }
                catch (NumberFormatException ex) {
                    super.replaceText(start, end, text);
                }
            } else {
                super.replaceText(start, end, text);
            }
            String newText = super.getText();
            if (!this.validate(newText)) {
                super.setText(oldValue);
            }
        }
    }

    private boolean validate(String text) {
        if (text.length() == 0) {
            return true;
        }
        if (text.length() == 1 && ".".equals(text)) {
            return true;
        }
        try {
            Float i = Float.valueOf(Float.parseFloat(text));
            if (i.floatValue() >= 0.0f) {
                return true;
            }
        }
        catch (NumberFormatException exception) {
            System.out.println("NumberFormatException Error");
        }
        return false;
    }
}

