/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.dpx;

import com.portalmedia.embarc.gui.model.DPXMetadataColumnViewModel;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.DPXColumnValidationRules;
import java.util.LinkedList;
import java.util.List;

public class DPXMetadataColumnViewModelList {
    private static DPXMetadataColumnViewModelList instance = null;
    private List<DPXMetadataColumnViewModel> columns;

    public static DPXMetadataColumnViewModelList getInstance() {
        if (instance == null) {
            instance = new DPXMetadataColumnViewModelList();
        }
        return instance;
    }

    private DPXMetadataColumnViewModelList() {
        this.buildDPXColumns();
    }

    private void buildDPXColumns() {
        this.columns = new LinkedList<DPXMetadataColumnViewModel>();
        DPXColumnValidationRules rules = DPXColumnValidationRules.getInstance();
        for (DPXColumn c : DPXColumn.values()) {
            DPXMetadataColumnViewModel mcvm = new DPXMetadataColumnViewModel();
            mcvm.setLength(c.getLength());
            mcvm.setHasSubsection(c.hasSubsection());
            mcvm.setValidationRules(rules.getRuleSet(c));
            mcvm.setColumn(c);
            this.columns.add(mcvm);
        }
    }

    public List<DPXMetadataColumnViewModel> getColumns() {
        return this.columns;
    }
}

