/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.report;

import com.portalmedia.embarc.gui.helper.DPXFileListHelper;
import com.portalmedia.embarc.gui.helper.RowNumberManager;
import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.report.CSVUtils;
import com.portalmedia.embarc.report.HashReportValue;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javafx.scene.control.TableView;

public class DPXReportService {
    public static void WriteImageHashCsv(List<HashReportValue> values, String csvFile) throws IOException {
        try (FileWriter writer = new FileWriter(csvFile);){
            CSVUtils.writeLine(writer, Arrays.asList("FileName", "Original CRC-32C", "New CRC-32C", "Match"));
            for (HashReportValue hrv : values) {
                String newHash;
                String match = "FALSE";
                String orgHash = hrv.getOriginalHash();
                if (orgHash.equals(newHash = hrv.getNewHash())) {
                    match = "TRUE";
                }
                CSVUtils.writeLine(writer, Arrays.asList(hrv.getFileName(), orgHash, newHash, match));
            }
            writer.flush();
            writer.close();
        }
    }

    public static void WriteImageHashCsv(TableView<DPXFileInformationViewModel> table, String csvFile) throws IOException {
        try (FileWriter writer = new FileWriter(csvFile);){
            CSVUtils.writeLine(writer, Arrays.asList("RowNum", "FileName", "CRC-32C"));
            int lastRowNum = 1;
            for (DPXFileInformationViewModel fivm : table.getItems()) {
                if (fivm == null) continue;
                int rowNum = RowNumberManager.getRowNum(fivm.getId());
                if (rowNum == 0) {
                    rowNum = ++lastRowNum;
                } else {
                    lastRowNum = rowNum;
                }
                String name = fivm.getProp("name");
                String path = fivm.getProp("path");
                int start = Integer.parseInt(fivm.getProp(DPXColumn.OFFSET_TO_IMAGE_DATA));
                byte[] imageData = DPXFileListHelper.getBytesFromFile(path, start);
                String hash = DPXFileListHelper.getCrc32Hash(imageData);
                CSVUtils.writeLine(writer, Arrays.asList(String.valueOf(rowNum), name, hash));
            }
            writer.flush();
            writer.close();
        }
    }

    public static void WriteValidationCsv(TableView<DPXFileInformationViewModel> table, String csvFile) throws IOException {
        try (FileWriter writer = new FileWriter(csvFile);){
            CSVUtils.writeLine(writer, Arrays.asList("RowNum", "FileName", "Section", "Subsection", "Column", "RuleSet", "Error"));
            int lastRowNum = 1;
            for (DPXFileInformationViewModel fivm : table.getItems()) {
                int rowNum = RowNumberManager.getRowNum(fivm.getId());
                if (rowNum == 0) {
                    rowNum = ++lastRowNum;
                } else {
                    lastRowNum = rowNum;
                }
                String name = fivm.getProp("name");
                HashMap<ColumnDef, HashMap<ValidationRuleSetEnum, List<IValidationRule>>> invalidRules = fivm.getInvalidRuleSets();
                if (invalidRules.size() <= 0) continue;
                for (ColumnDef column : invalidRules.keySet()) {
                    for (ValidationRuleSetEnum ruleSet : invalidRules.get(column).keySet()) {
                        for (IValidationRule rule : invalidRules.get(column).get((Object)ruleSet)) {
                            CSVUtils.writeLine(writer, Arrays.asList(String.valueOf(rowNum), name, column.getSection().getDisplayName(), column.hasSubsection() ? column.getSubsection().getDisplayName() : "", column.getDisplayName(), ruleSet.toString(), rule.getRule()), ',', '\"');
                        }
                    }
                }
            }
            writer.flush();
            writer.close();
        }
    }
}

