/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class BinaryFileReader
implements AutoCloseable {
    private InputStream inputStream;
    public long fileSizeBytes;
    public long bytesRead;
    public ByteOrder byteOrder;

    public BinaryFileReader(String inputFilePath) throws FileNotFoundException {
        this.Initialize(inputFilePath);
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }

    public BinaryFileReader(String inputFilePath, ByteOrder inputByteOrder) throws FileNotFoundException {
        this.Initialize(inputFilePath);
        this.byteOrder = inputByteOrder;
    }

    public void SetByteOrder(ByteOrder inputByteOrder) {
        this.byteOrder = inputByteOrder;
    }

    private void Initialize(String inputFilePath) throws FileNotFoundException {
        this.inputStream = new FileInputStream(inputFilePath);
        this.fileSizeBytes = new File(inputFilePath).length();
        this.bytesRead = 0L;
    }

    public void skip(int position) {
        try {
            this.inputStream.skip(position);
        }
        catch (IOException e) {
            System.out.println("Error skipping to " + position);
        }
    }

    @Override
    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing inputstream");
        }
    }

    public boolean hasMoreData() {
        return this.bytesRead < this.fileSizeBytes;
    }

    public boolean canRead(int length) {
        return this.bytesRead + (long)length < this.fileSizeBytes;
    }

    public String readAscii(int length) {
        try {
            byte[] bytes = this.readBytes(length);
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.order(this.byteOrder);
            byte[] destBytes = new byte[length];
            bb.get(destBytes);
            return new String(destBytes, "UTF-8");
        }
        catch (IOException e) {
            System.out.println("Error reading ascii");
            return "";
        }
    }

    public short readInt16() {
        try {
            byte[] bytes = this.readBytes(2);
            return ByteBuffer.wrap(bytes).order(this.byteOrder).getShort();
        }
        catch (IOException e) {
            System.out.println("Error reading int16");
            return -1;
        }
    }

    public byte readInt8() {
        try {
            byte[] bytes = this.readBytes(1);
            return bytes[0];
        }
        catch (IOException e) {
            System.out.println("Error reading int8");
            return -1;
        }
    }

    public int readInt32() {
        try {
            int length = 4;
            byte[] bytes = this.readBytes(length);
            return ByteBuffer.wrap(bytes).order(this.byteOrder).getInt();
        }
        catch (IOException e) {
            System.out.println("Error reading int32");
            return -1;
        }
    }

    public float readFloat32() {
        try {
            int length = 4;
            byte[] bytes = this.readBytes(length);
            return ByteBuffer.wrap(bytes).order(this.byteOrder).getFloat();
        }
        catch (IOException e) {
            System.out.println("Error reading float32");
            return -1.0f;
        }
    }

    public long readInt64() {
        try {
            int length = 8;
            byte[] bytes = this.readBytes(length);
            return ByteBuffer.wrap(bytes).order(this.byteOrder).getLong();
        }
        catch (IOException e) {
            System.out.println("Error reading int64");
            return -1L;
        }
    }

    public Date readDate(String format, int length) {
        String dateString = this.readAscii(length);
        if (dateString.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.ENGLISH);
        Date date = null;
        try {
            date = dateFormat.parse(dateString);
        }
        catch (ParseException e) {
            System.out.println("Error reading date");
        }
        return date;
    }

    public byte[] readBytes(int length) throws IOException {
        byte[] bytes = new byte[length];
        for (int bp = 0; bp < length; ++bp) {
            bytes[bp] = (byte)this.inputStream.read();
            ++this.bytesRead;
        }
        return bytes;
    }

    public long getCurrentPosition() {
        return this.bytesRead;
    }
}

