/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.model;

import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashSet;

public class DatabaseSummary {
    private static HashSet<Integer> files = new HashSet();
    private static HashSet<Integer> smptecViolations = new HashSet();
    private static HashSet<Integer> fadgioViolations = new HashSet();
    private static HashSet<Integer> fadgirViolations = new HashSet();
    private static HashSet<Integer> fadgisrViolations = new HashSet();

    public static void addFile(DPXFileInformationViewModel fileInformation) {
        HashSet<ValidationRuleSetEnum> violations = fileInformation.getInvalidRuleSetList();
        int id = fileInformation.getId();
        files.add(id);
        for (ValidationRuleSetEnum rule : violations) {
            if (rule == ValidationRuleSetEnum.SMPTE_C) {
                smptecViolations.add(id);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_O) {
                fadgioViolations.add(id);
                continue;
            }
            if (rule == ValidationRuleSetEnum.FADGI_R) {
                fadgirViolations.add(id);
                continue;
            }
            if (rule != ValidationRuleSetEnum.FADGI_SR) continue;
            fadgisrViolations.add(id);
        }
    }

    public static void deleteAll() {
        files.clear();
        smptecViolations.clear();
        fadgioViolations.clear();
        fadgirViolations.clear();
        fadgisrViolations.clear();
    }

    public static int getErrorCount(ValidationRuleSetEnum ruleSet) {
        if (ruleSet == ValidationRuleSetEnum.SMPTE_C) {
            return smptecViolations.size();
        }
        if (ruleSet == ValidationRuleSetEnum.FADGI_O) {
            return fadgioViolations.size();
        }
        if (ruleSet == ValidationRuleSetEnum.FADGI_R) {
            return fadgirViolations.size();
        }
        if (ruleSet == ValidationRuleSetEnum.FADGI_SR) {
            return fadgisrViolations.size();
        }
        return 0;
    }

    public static int getFileCount() {
        return files.size();
    }

    public static void removeFile(DPXFileInformationViewModel fileInformation) {
        int id = fileInformation.getId();
        files.remove(id);
        smptecViolations.remove(id);
        fadgioViolations.remove(id);
        fadgirViolations.remove(id);
        fadgisrViolations.remove(id);
    }

    public static void updateFile(DPXFileInformationViewModel fileInformation) {
        DatabaseSummary.removeFile(fileInformation);
        DatabaseSummary.addFile(fileInformation);
    }
}

