/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser;

import com.portalmedia.embarc.parser.BinaryFileReader;
import com.portalmedia.embarc.parser.FileFormat;
import com.portalmedia.embarc.parser.mxf.MXFFileFormats;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.tika.Tika;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypes;

public class FileFormatDetection {
    private static List<String> validMxfFiles = new ArrayList<String>(){
        {
            this.add("fmt/200");
            this.add("fmt/783");
            this.add("fmt/790");
        }
    };
    private static List<String> validMxfOperationalPatterns = new ArrayList<String>(){
        {
            this.add("060e2b34.04010101.0d010201.01010000");
            this.add("060e2b34.04010101.0d010201.01010100");
            this.add("060e2b34.04010101.0d010201.01010300");
            this.add("060e2b34.04010101.0d010201.01010500");
            this.add("060e2b34.04010101.0d010201.01010700");
            this.add("060e2b34.04010101.0d010201.01010900");
            this.add("060e2b34.04010101.0d010201.01010b00");
            this.add("060e2b34.04010101.0d010201.01010d00");
            this.add("060e2b34.04010101.0d010201.01010f00");
            this.add("060e2b34.04010101.0d010201.01020000");
            this.add("060e2b34.04010101.0d010201.01020100");
            this.add("060e2b34.04010101.0d010201.01020300");
            this.add("060e2b34.04010101.0d010201.01020500");
            this.add("060e2b34.04010101.0d010201.01020700");
            this.add("060e2b34.04010101.0d010201.01020900");
            this.add("060e2b34.04010101.0d010201.01020b00");
            this.add("060e2b34.04010101.0d010201.01020d00");
            this.add("060e2b34.04010101.0d010201.01020f00");
            this.add("060e2b34.04010101.0d010201.03030000");
            this.add("060e2b34.04010101.0d010201.03030100");
            this.add("060e2b34.04010101.0d010201.03030110");
            this.add("060e2b34.04010101.0d010201.03030300");
            this.add("060e2b34.04010101.0d010201.03030310");
            this.add("060e2b34.04010101.0d010201.03030500");
            this.add("060e2b34.04010101.0d010201.03030510");
            this.add("060e2b34.04010101.0d010201.03030700");
            this.add("060e2b34.04010101.0d010201.03030710");
            this.add("060e2b34.04010101.0d010201.03030900");
            this.add("060e2b34.04010101.0d010201.03030910");
            this.add("060e2b34.04010101.0d010201.03030b00");
            this.add("060e2b34.04010101.0d010201.03030b10");
            this.add("060e2b34.04010101.0d010201.03030d00");
            this.add("060e2b34.04010101.0d010201.03030d10");
            this.add("060e2b34.04010101.0d010201.03030f00");
            this.add("060e2b34.04010101.0d010201.03030f10");
        }
    };

    public static FileFormat getFileFormat(String file) {
        if (FileFormatDetection.isDPX(file)) {
            return FileFormat.DPX;
        }
        if (FileFormatDetection.isMXF(file)) {
            return FileFormat.MXF;
        }
        return FileFormat.OTHER;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDPX(String file) {
        try (BinaryFileReader f = new BinaryFileReader(file);){
            String firstFourBytes = f.readAscii(4);
            f.skip(4);
            String nextSequence = f.readAscii(4);
            if (firstFourBytes.equals("SDPX") && nextSequence.matches("[vV][1-9][.][0-9]")) {
                boolean bl = true;
                return bl;
            }
            if (!firstFourBytes.equals("XPDS")) return false;
            if (!nextSequence.matches("[vV][1-9][.][0-9]")) return false;
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found checking is dpx");
        }
        return false;
    }

    public static boolean isMXF(String file) {
        List<Object> droidFormats = new ArrayList();
        try {
            droidFormats = MXFFileFormats.getInstance().getFormatMatches(file);
        }
        catch (Exception e) {
            return false;
        }
        for (String string : droidFormats) {
            if (!validMxfFiles.contains(string)) continue;
            return true;
        }
        return false;
    }

    public static String getExtension(ByteBuffer buffer) throws Exception {
        Tika t = new Tika();
        String type = t.detect(buffer.array());
        MimeTypes allTypes = MimeTypes.getDefaultMimeTypes();
        MimeType mime = allTypes.forName(type);
        String ext = mime.getExtension();
        return ext;
    }

    public static boolean validMxfOperationalPattern(String operationalPattern) {
        operationalPattern = operationalPattern.replace("urn:smpte:ul:", "");
        return validMxfOperationalPatterns.contains(operationalPattern);
    }
}

