/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.model;

import com.portalmedia.embarc.gui.mxf.MXFProfileULMap;
import com.portalmedia.embarc.parser.MetadataColumnDef;
import com.portalmedia.embarc.parser.mxf.MXFColumn;
import com.portalmedia.embarc.parser.mxf.MXFFileDescriptorResult;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MXFFileInformationViewModel {
    private int id;
    private boolean edited = false;
    private LinkedHashMap<String, String> properties;
    private HashMap<MXFColumn, MetadataColumnDef> coreData = new LinkedHashMap<MXFColumn, MetadataColumnDef>();
    private HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> tdElements;
    private HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> bdElements;
    private MXFFileDescriptorResult fileDescriptors;

    public MXFFileInformationViewModel(String name, String path, String uuid) {
        this.properties = new LinkedHashMap();
        this.tdElements = new HashMap();
        this.bdElements = new HashMap();
        this.setProp("name", name);
        this.setProp("path", path);
        this.setProp("uuid", uuid);
    }

    public void setId(int id) {
        this.id = id;
        this.setProp("id", String.valueOf(id));
    }

    public int getId() {
        return this.id;
    }

    public void setProp(MXFColumn key, String value) {
        String columnName = key.getDisplayName() + key.getSectionDisplayName();
        if (value == null) {
            return;
        }
        this.properties.put(columnName, value);
    }

    public String getProp(MXFColumn column) {
        String columnName = column.getDisplayName() + column.getSectionDisplayName();
        String c = this.properties.get(columnName);
        if (c == null) {
            return "";
        }
        return c;
    }

    public void setProp(String columnName, String value) {
        this.properties.put(columnName, value);
    }

    public String getProp(String columnName) {
        if ("profile".equals(columnName)) {
            return this.mapProfileToControlledList(this.properties.get(columnName));
        }
        return this.properties.get(columnName);
    }

    public void setProperties(LinkedHashMap<String, String> properties) {
        this.properties = properties;
    }

    public HashMap<String, String> getProperties() {
        return this.properties;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }

    public boolean getEdited() {
        return this.edited;
    }

    public void setTDElement(String key, LinkedHashMap<MXFColumn, MetadataColumnDef> value) {
        this.tdElements.put(key, value);
    }

    public void setBDElement(String key, LinkedHashMap<MXFColumn, MetadataColumnDef> value) {
        this.bdElements.put(key, value);
    }

    public LinkedHashMap<MXFColumn, MetadataColumnDef> getTDElement(String key) {
        return this.tdElements.get(key);
    }

    public LinkedHashMap<MXFColumn, MetadataColumnDef> getBDElement(String key) {
        return this.bdElements.get(key);
    }

    public HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> getAllTDElements() {
        return this.tdElements;
    }

    public HashMap<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> getAllBDElements() {
        return this.bdElements;
    }

    public String getBDElementProperty(int index, MXFColumn col) {
        int entryIndex = 0;
        String key = "";
        for (Map.Entry<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> entry : this.bdElements.entrySet()) {
            if (entryIndex == index) {
                key = entry.getKey();
            }
            ++entryIndex;
        }
        LinkedHashMap<MXFColumn, MetadataColumnDef> map = this.bdElements.get(key);
        if (map == null) {
            return "";
        }
        MetadataColumnDef currentCol = map.get(col);
        if (currentCol == null) {
            return "";
        }
        return currentCol.getCurrentValue();
    }

    public String getTDElementProperty(int index, MXFColumn col) {
        int entryIndex = 0;
        String key = "";
        for (Map.Entry<String, LinkedHashMap<MXFColumn, MetadataColumnDef>> entry : this.tdElements.entrySet()) {
            if (entryIndex == index) {
                key = entry.getKey();
            }
            ++entryIndex;
        }
        LinkedHashMap<MXFColumn, MetadataColumnDef> map = this.tdElements.get(key);
        if (map == null) {
            return "";
        }
        MetadataColumnDef currentCol = map.get(col);
        if (currentCol == null) {
            return "";
        }
        return currentCol.getCurrentValue();
    }

    public int getTDElementCount() {
        return this.tdElements.size();
    }

    public int getBDElementCount() {
        return this.bdElements.size();
    }

    public void setFileDescriptors(MXFFileDescriptorResult fileDescriptorResult) {
        this.fileDescriptors = fileDescriptorResult;
    }

    public MXFFileDescriptorResult getFileDescriptors() {
        return this.fileDescriptors;
    }

    public HashMap<MXFColumn, MetadataColumnDef> getCoreData() {
        return this.coreData;
    }

    public void setCoreData(HashMap<MXFColumn, MetadataColumnDef> coreData) {
        this.coreData = coreData;
    }

    private String mapProfileToControlledList(String profileUl) {
        String stripped = profileUl.replace("urn:smpte:ul:", "");
        HashMap<String, String> profileULMap = new MXFProfileULMap().getMap();
        Object val = profileULMap.get(stripped);
        if (val == null || "".equals(val)) {
            return profileUl;
        }
        val = (String)val + "\n(" + profileUl + ")";
        return val;
    }
}

