/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui;

import com.portalmedia.embarc.gui.ErrorDialog;
import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.ProgressDialog;
import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.helper.DPXFileListHelper;
import com.portalmedia.embarc.gui.helper.MXFFileList;
import com.portalmedia.embarc.gui.mxf.ControllerMediatorMXF;
import com.portalmedia.embarc.parser.FileFormat;
import com.portalmedia.embarc.parser.FileFormatDetection;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.input.DragEvent;
import javafx.scene.text.Text;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;

public class FileProcessController {
    ProgressDialog progressDialog;
    List<String> validFileList = new ArrayList<String>();
    List<String> notValidFileList = new ArrayList<String>();
    List<String> validFileFailures = new ArrayList<String>();
    int totalItemsCount;
    FileFormat fileFormat = FileFormat.OTHER;
    private static final Logger LOGGER = Logger.getLogger(Main.class.getClass().getName());

    public static FileProcessController getInstance() {
        return ControllerHolder.INSTANCE;
    }

    private FileProcessController() {
    }

    public void chooseFile(Stage stage) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle("Select a file");
        List files = fileChooser.showOpenMultipleDialog((Window)stage);
        if (files != null && !files.isEmpty()) {
            this.totalItemsCount = files.size();
            this.processFiles(files, null);
        }
    }

    public void chooseDirectory(Stage stage) {
        DirectoryChooser fileChooser = new DirectoryChooser();
        fileChooser.setTitle("Select a Directory");
        File file = fileChooser.showDialog((Window)stage);
        if (file != null) {
            this.totalItemsCount = this.countFiles(file);
            ArrayList<File> files = new ArrayList<File>();
            files.add(file);
            this.processFiles(files, null);
        }
    }

    public void processFiles(List<File> files, DragEvent event) {
        LOGGER.info("Begin processFiles, file count: " + files.size());
        this.progressDialog = new ProgressDialog();
        if (!this.validFileFormat(files).booleanValue()) {
            return;
        }
        this.totalItemsCount = files.size();
        Task<Void> task = this.createProcessFilesTask(files);
        Label filesToProcess = new Label("Total items found: " + this.totalItemsCount);
        filesToProcess.setStyle("-fx-text-fill: black;");
        FontIcon question = new FontIcon((Ikon)FontAwesomeSolid.QUESTION_CIRCLE);
        filesToProcess.setTooltip(new Tooltip("This count includes all folders and hidden files"));
        filesToProcess.setGraphic((Node)question);
        this.progressDialog.setCountLabel((Node)filesToProcess);
        this.progressDialog.activateProgressBar(task);
        DialogPane dialogPane = this.progressDialog.getDialogAlert().getDialogPane();
        dialogPane.getStylesheets().add((Object)this.getClass().getResource("application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"alertDialog");
        this.progressDialog.getDialogAlert().show();
        this.progressDialog.getDialogAlert().setOnCloseRequest(e -> {
            if (task.isRunning()) {
                task.cancel();
                if (this.validFileList.size() > 0) {
                    this.validFileList.removeAll(this.validFileList);
                    this.notValidFileList.removeAll(this.notValidFileList);
                    this.validFileFailures.removeAll(this.validFileFailures);
                    if (this.fileFormat == FileFormat.DPX) {
                        ControllerMediatorDPX.getInstance().refetchFileList();
                    } else if (this.fileFormat == FileFormat.MXF) {
                        MXFFileList.getInstance().clearList();
                    }
                }
            }
        });
        new Thread((Runnable)task).start();
        task.setOnSucceeded(e -> this.handleTaskResult(event));
        task.setOnFailed(e -> this.handleTaskResult(event));
    }

    private void handleTaskResult(DragEvent event) {
        if (this.validFileFailures.size() > 0) {
            for (String f : this.validFileFailures) {
                this.validFileList.remove(f);
            }
        }
        ArrayList<Text> labels = new ArrayList<Text>();
        int total = this.validFileList.size() + this.validFileFailures.size() + this.notValidFileList.size();
        labels.add(new Text(String.valueOf((Object)this.fileFormat) + " Successes: " + this.validFileList.size()));
        labels.add(new Text(String.valueOf((Object)this.fileFormat) + " Failures: " + this.validFileFailures.size()));
        labels.add(new Text("Non-" + String.valueOf((Object)this.fileFormat) + " Ignored: " + this.notValidFileList.size()));
        Text totalProcessed = new Text("Total Files Processed: " + total);
        labels.add(totalProcessed);
        this.progressDialog.showLabels(labels);
        this.progressDialog.showCloseButton();
        this.validFileList.clear();
        this.notValidFileList.clear();
        this.validFileFailures.clear();
        if (this.fileFormat == FileFormat.DPX) {
            ControllerMediatorDPX.getInstance().refetchFileList();
        } else if (this.fileFormat == FileFormat.MXF) {
            ControllerMediatorMXF.getInstance().setFileList();
        }
        if (event != null) {
            event.consume();
        }
    }

    private List<File> getAllFilesInPath(String file, List<File> fileList) {
        Path folder = Paths.get(file, new String[0]);
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            fileList.add(new File(file));
        } else {
            ArrayList<Path> pathsToProcess = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(folder);){
                for (Path filePath : stream) {
                    if (Files.isHidden(filePath)) continue;
                    pathsToProcess.add(filePath);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, ex.toString(), ex);
            }
            for (Path filePath : pathsToProcess) {
                if (Files.isDirectory(filePath, new LinkOption[0])) {
                    LOGGER.log(Level.WARNING, "Checking file path " + String.valueOf(filePath));
                    this.getAllFilesInPath(filePath.toString(), fileList);
                    continue;
                }
                File newFile = new File(filePath.toString());
                fileList.add(newFile);
            }
        }
        return fileList;
    }

    private Boolean validFileFormat(List<File> files) {
        ErrorDialog errorDialog;
        ArrayList<File> fileList = new ArrayList<File>();
        for (File f : files) {
            this.getAllFilesInPath(f.toString(), fileList);
        }
        Boolean foundMXF = false;
        Boolean foundDPX = false;
        for (File file : fileList) {
            Boolean isDPX = FileFormatDetection.isDPX(file.getAbsolutePath());
            if (isDPX.booleanValue()) {
                foundDPX = true;
                continue;
            }
            Boolean isMXF = FileFormatDetection.isMXF(file.getAbsolutePath());
            if (!isMXF.booleanValue()) continue;
            foundMXF = true;
        }
        if (!foundMXF.booleanValue() && !foundDPX.booleanValue()) {
            errorDialog = new ErrorDialog("No DPX nor MXF files were found. Please import either DPX or MXF files.");
            errorDialog.getDialogStage().show();
            return false;
        }
        if (foundMXF.booleanValue() && foundDPX.booleanValue()) {
            errorDialog = new ErrorDialog("Both DPX and MXF files were found. Please import either DPX or MXF files.");
            errorDialog.getDialogStage().show();
            return false;
        }
        if (foundDPX.booleanValue()) {
            this.fileFormat = FileFormat.DPX;
            Main.showMainStageDPX(true);
        }
        if (foundMXF.booleanValue()) {
            this.fileFormat = FileFormat.MXF;
            Main.showMainStageMXF(true);
        }
        return true;
    }

    private Task<Void> createProcessFilesTask(final List<File> files) {
        Task<Void> task = new Task<Void>(){

            public Void call() {
                System.currentTimeMillis();
                for (File f : files) {
                    FileProcessController.this.getDirectoryContents(f.getAbsolutePath());
                }
                int count = 0;
                int totalValidFiles = FileProcessController.this.validFileList.size();
                LOGGER.info("Total DPX/MXF Files: " + totalValidFiles);
                int increment = 1;
                if (totalValidFiles > 10000) {
                    increment = 50;
                } else if (totalValidFiles > 5000) {
                    increment = 25;
                } else if (totalValidFiles > 1000) {
                    increment = 10;
                }
                int totalFiles = totalValidFiles + FileProcessController.this.notValidFileList.size();
                double processed = 0.0;
                try {
                    for (String f : FileProcessController.this.validFileList) {
                        if (!this.isCancelled()) {
                            boolean success;
                            if (FileProcessController.this.fileFormat == FileFormat.DPX) {
                                success = DPXFileListHelper.addFileToDatabase(f);
                                ++count;
                                if (!success) {
                                    LOGGER.info("Error while adding " + String.valueOf((Object)FileProcessController.this.fileFormat) + " file to DB.");
                                    System.out.println("Error while adding " + String.valueOf((Object)FileProcessController.this.fileFormat) + " file to DB.");
                                    FileProcessController.this.validFileFailures.add(f);
                                }
                                LOGGER.info("Finished adding " + count + ": " + f);
                                if (count == totalFiles || count % increment == 0) {
                                    processed = count * 100 / totalFiles;
                                    this.updateProgress(processed, 100.0);
                                }
                            }
                            if (FileProcessController.this.fileFormat != FileFormat.MXF) continue;
                            success = MXFFileList.getInstance().addFileToList(f);
                            ++count;
                            if (!success) {
                                System.out.println("Error while adding " + String.valueOf((Object)FileProcessController.this.fileFormat) + " file to list.");
                                FileProcessController.this.validFileFailures.add(f);
                            }
                            if (count != totalFiles && count % increment != 0) continue;
                            processed = count * 100 / totalFiles;
                            this.updateProgress(processed, 100.0);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.SEVERE, ex.toString(), ex);
                }
                processed = (count += FileProcessController.this.notValidFileList.size()) * 100 / totalFiles;
                this.updateProgress(processed, 100.0);
                return null;
            }
        };
        return task;
    }

    private void getDirectoryContents(String dir) {
        Path folder = Paths.get(dir, new String[0]);
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            this.checkFileType(folder.toAbsolutePath().toString());
        } else {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(folder);){
                for (Path filePath : stream) {
                    if (Files.isHidden(filePath)) continue;
                    if (Files.isDirectory(filePath, new LinkOption[0])) {
                        this.getDirectoryContents(filePath.toAbsolutePath().toString());
                        continue;
                    }
                    this.checkFileType(filePath.toAbsolutePath().toString());
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.SEVERE, ex.toString(), ex);
            }
        }
    }

    private void checkFileType(String f) {
        if (this.fileFormat == FileFormat.DPX) {
            if (FileFormatDetection.getFileFormat(f) == FileFormat.DPX) {
                this.validFileList.add(f);
            } else {
                this.notValidFileList.add(f);
            }
            return;
        }
        if (this.fileFormat == FileFormat.MXF) {
            if (FileFormatDetection.getFileFormat(f) == FileFormat.MXF) {
                this.validFileList.add(f);
            } else {
                this.notValidFileList.add(f);
            }
            return;
        }
    }

    public int countFiles(File directory) {
        int count = 0;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    ++count;
                }
                if (!file.isDirectory()) continue;
                count += this.countFiles(file);
            }
        }
        return count;
    }

    private static class ControllerHolder {
        private static final FileProcessController INSTANCE = new FileProcessController();

        private ControllerHolder() {
        }
    }
}

