/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.validation;

import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.validation.DPXFileNameMatchesRule;
import com.portalmedia.embarc.validation.DPXImageBitDepthRule;
import com.portalmedia.embarc.validation.DPXImageColorimetricSpecificationRule;
import com.portalmedia.embarc.validation.DPXImageDataSignRule;
import com.portalmedia.embarc.validation.DPXImageDescriptorRule;
import com.portalmedia.embarc.validation.DPXImageEncodingRule;
import com.portalmedia.embarc.validation.DPXImageOffsetToImageDataRule;
import com.portalmedia.embarc.validation.DPXImagePackingRule;
import com.portalmedia.embarc.validation.DPXImageTransferCharacteristicRule;
import com.portalmedia.embarc.validation.IFileValidationRule;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class DPXFileValidationRules {
    private static DPXFileValidationRules instance = null;
    private List<IFileValidationRule> rules;

    public static DPXFileValidationRules getInstance() {
        if (instance == null) {
            instance = new DPXFileValidationRules();
        }
        return instance;
    }

    private DPXFileValidationRules() {
        this.BuildRuleSet();
    }

    private void BuildRuleSet() {
        this.rules = new LinkedList<IFileValidationRule>();
        this.rules.add(new DPXFileNameMatchesRule());
        this.rules.add(new DPXImageBitDepthRule(DPXColumn.BIT_DEPTH_1, 1));
        this.rules.add(new DPXImageBitDepthRule(DPXColumn.BIT_DEPTH_2, 2));
        this.rules.add(new DPXImageBitDepthRule(DPXColumn.BIT_DEPTH_3, 3));
        this.rules.add(new DPXImageBitDepthRule(DPXColumn.BIT_DEPTH_4, 4));
        this.rules.add(new DPXImageBitDepthRule(DPXColumn.BIT_DEPTH_5, 5));
        this.rules.add(new DPXImageBitDepthRule(DPXColumn.BIT_DEPTH_6, 6));
        this.rules.add(new DPXImageBitDepthRule(DPXColumn.BIT_DEPTH_7, 7));
        this.rules.add(new DPXImageBitDepthRule(DPXColumn.BIT_DEPTH_8, 8));
        this.rules.add(new DPXImageColorimetricSpecificationRule(DPXColumn.COLORIMETRIC_SPECIFICATION_1, 1));
        this.rules.add(new DPXImageColorimetricSpecificationRule(DPXColumn.COLORIMETRIC_SPECIFICATION_2, 2));
        this.rules.add(new DPXImageColorimetricSpecificationRule(DPXColumn.COLORIMETRIC_SPECIFICATION_3, 3));
        this.rules.add(new DPXImageColorimetricSpecificationRule(DPXColumn.COLORIMETRIC_SPECIFICATION_4, 4));
        this.rules.add(new DPXImageColorimetricSpecificationRule(DPXColumn.COLORIMETRIC_SPECIFICATION_5, 5));
        this.rules.add(new DPXImageColorimetricSpecificationRule(DPXColumn.COLORIMETRIC_SPECIFICATION_6, 6));
        this.rules.add(new DPXImageColorimetricSpecificationRule(DPXColumn.COLORIMETRIC_SPECIFICATION_7, 7));
        this.rules.add(new DPXImageColorimetricSpecificationRule(DPXColumn.COLORIMETRIC_SPECIFICATION_8, 8));
        this.rules.add(new DPXImageDataSignRule(DPXColumn.DATA_SIGN_1, 1));
        this.rules.add(new DPXImageDataSignRule(DPXColumn.DATA_SIGN_2, 2));
        this.rules.add(new DPXImageDataSignRule(DPXColumn.DATA_SIGN_3, 3));
        this.rules.add(new DPXImageDataSignRule(DPXColumn.DATA_SIGN_4, 4));
        this.rules.add(new DPXImageDataSignRule(DPXColumn.DATA_SIGN_5, 5));
        this.rules.add(new DPXImageDataSignRule(DPXColumn.DATA_SIGN_6, 6));
        this.rules.add(new DPXImageDataSignRule(DPXColumn.DATA_SIGN_7, 7));
        this.rules.add(new DPXImageDataSignRule(DPXColumn.DATA_SIGN_8, 8));
        this.rules.add(new DPXImageDescriptorRule(DPXColumn.DESCRIPTOR_1, 1));
        this.rules.add(new DPXImageDescriptorRule(DPXColumn.DESCRIPTOR_2, 2));
        this.rules.add(new DPXImageDescriptorRule(DPXColumn.DESCRIPTOR_3, 3));
        this.rules.add(new DPXImageDescriptorRule(DPXColumn.DESCRIPTOR_4, 4));
        this.rules.add(new DPXImageDescriptorRule(DPXColumn.DESCRIPTOR_5, 5));
        this.rules.add(new DPXImageDescriptorRule(DPXColumn.DESCRIPTOR_6, 6));
        this.rules.add(new DPXImageDescriptorRule(DPXColumn.DESCRIPTOR_7, 7));
        this.rules.add(new DPXImageDescriptorRule(DPXColumn.DESCRIPTOR_8, 8));
        this.rules.add(new DPXImageEncodingRule(DPXColumn.ENCODING_1, 1));
        this.rules.add(new DPXImageEncodingRule(DPXColumn.ENCODING_2, 2));
        this.rules.add(new DPXImageEncodingRule(DPXColumn.ENCODING_3, 3));
        this.rules.add(new DPXImageEncodingRule(DPXColumn.ENCODING_4, 4));
        this.rules.add(new DPXImageEncodingRule(DPXColumn.ENCODING_5, 5));
        this.rules.add(new DPXImageEncodingRule(DPXColumn.ENCODING_6, 6));
        this.rules.add(new DPXImageEncodingRule(DPXColumn.ENCODING_7, 7));
        this.rules.add(new DPXImageEncodingRule(DPXColumn.ENCODING_8, 8));
        this.rules.add(new DPXImageOffsetToImageDataRule(DPXColumn.OFFSET_TO_DATA_1, 1));
        this.rules.add(new DPXImageOffsetToImageDataRule(DPXColumn.OFFSET_TO_DATA_2, 2));
        this.rules.add(new DPXImageOffsetToImageDataRule(DPXColumn.OFFSET_TO_DATA_3, 3));
        this.rules.add(new DPXImageOffsetToImageDataRule(DPXColumn.OFFSET_TO_DATA_4, 4));
        this.rules.add(new DPXImageOffsetToImageDataRule(DPXColumn.OFFSET_TO_DATA_5, 5));
        this.rules.add(new DPXImageOffsetToImageDataRule(DPXColumn.OFFSET_TO_DATA_6, 6));
        this.rules.add(new DPXImageOffsetToImageDataRule(DPXColumn.OFFSET_TO_DATA_7, 7));
        this.rules.add(new DPXImageOffsetToImageDataRule(DPXColumn.OFFSET_TO_DATA_8, 8));
        this.rules.add(new DPXImagePackingRule(DPXColumn.PACKING_1, 1));
        this.rules.add(new DPXImagePackingRule(DPXColumn.PACKING_2, 2));
        this.rules.add(new DPXImagePackingRule(DPXColumn.PACKING_3, 3));
        this.rules.add(new DPXImagePackingRule(DPXColumn.PACKING_4, 4));
        this.rules.add(new DPXImagePackingRule(DPXColumn.PACKING_5, 5));
        this.rules.add(new DPXImagePackingRule(DPXColumn.PACKING_6, 6));
        this.rules.add(new DPXImagePackingRule(DPXColumn.PACKING_7, 7));
        this.rules.add(new DPXImagePackingRule(DPXColumn.PACKING_8, 8));
        this.rules.add(new DPXImageTransferCharacteristicRule(DPXColumn.TRANSFER_CHARACTERISTIC_1, 1));
        this.rules.add(new DPXImageTransferCharacteristicRule(DPXColumn.TRANSFER_CHARACTERISTIC_2, 2));
        this.rules.add(new DPXImageTransferCharacteristicRule(DPXColumn.TRANSFER_CHARACTERISTIC_3, 3));
        this.rules.add(new DPXImageTransferCharacteristicRule(DPXColumn.TRANSFER_CHARACTERISTIC_4, 4));
        this.rules.add(new DPXImageTransferCharacteristicRule(DPXColumn.TRANSFER_CHARACTERISTIC_5, 5));
        this.rules.add(new DPXImageTransferCharacteristicRule(DPXColumn.TRANSFER_CHARACTERISTIC_6, 6));
        this.rules.add(new DPXImageTransferCharacteristicRule(DPXColumn.TRANSFER_CHARACTERISTIC_7, 7));
        this.rules.add(new DPXImageTransferCharacteristicRule(DPXColumn.TRANSFER_CHARACTERISTIC_8, 8));
    }

    public HashSet<IFileValidationRule> getColumnRules(ColumnDef column) {
        HashSet<IFileValidationRule> toReturn = new HashSet<IFileValidationRule>();
        for (IFileValidationRule rule : this.rules) {
            if (rule.getTargetColumn() != column) continue;
            toReturn.add(rule);
        }
        return toReturn;
    }

    public List<IFileValidationRule> getRules() {
        return this.rules;
    }
}

