/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.mxf;

import java.security.SecureRandom;
import tv.amwa.maj.enumeration.ProductReleaseType;
import tv.amwa.maj.model.Identification;
import tv.amwa.maj.model.impl.IdentificationImpl;
import tv.amwa.maj.record.AUID;
import tv.amwa.maj.record.ProductVersion;
import tv.amwa.maj.record.TimeStamp;
import tv.amwa.maj.record.impl.AUIDImpl;
import tv.amwa.maj.record.impl.ProductVersionImpl;
import tv.amwa.maj.record.impl.TimeStampImpl;

public class EmbARCIdentification {
    private static EmbARCIdentification instance = null;
    public IdentificationImpl identification;
    private String applicationName = "embARC";
    private String supplierName = "Federal Agencies Digital Guidelines Initiative";
    private short majorVersion = 1;
    private short minorVersion = 1;
    private short tertiaryVersion = 1;
    private short patchVersion = 0;
    private ProductReleaseType releaseType = ProductReleaseType.Released;

    private EmbARCIdentification() {
        this.identification = new IdentificationImpl();
        ProductVersionImpl version = new ProductVersionImpl(this.majorVersion, this.minorVersion, this.tertiaryVersion, this.patchVersion, this.releaseType);
        this.identification.setApplicationVersion((ProductVersion)version);
        SecureRandom rand = new SecureRandom();
        int data1 = rand.nextInt();
        short data2 = (short)rand.nextInt(Short.MAX_VALUE);
        short data3 = (short)rand.nextInt(Short.MAX_VALUE);
        byte[] data4 = new byte[8];
        rand.nextBytes(data4);
        AUIDImpl auid = new AUIDImpl(data1, data2, data3, data4);
        this.identification.setLinkedGenerationID((AUID)auid);
        this.identification.setApplicationName(this.applicationName);
        this.identification.setApplicationPlatform(System.getProperty("os.name"));
        this.identification.setApplicationSupplierName(this.supplierName);
        this.identification.setApplicationVersion((ProductVersion)version);
        String versionString = this.majorVersion + "." + this.minorVersion + "." + this.tertiaryVersion + "." + this.patchVersion;
        this.identification.setApplicationVersionString(versionString);
        this.identification.setToolkitVersionString(versionString);
        TimeStampImpl time = new TimeStampImpl();
        this.identification.setFileModificationDate((TimeStamp)time);
        this.identification.setGenerationID((AUID)auid);
        this.identification.setApplicationProductID((AUID)auid);
    }

    public Identification getIdentification() {
        return this.identification;
    }

    public static EmbARCIdentification getInstance() {
        if (instance == null) {
            instance = new EmbARCIdentification();
        }
        return instance;
    }
}

