/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.model;

import com.portalmedia.embarc.parser.ColumnDef;
import com.portalmedia.embarc.validation.IValidationRule;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;

public class DPXMetadataColumnViewModel {
    private final IntegerProperty length = new SimpleIntegerProperty();
    private final StringProperty sectionDisplayName = new SimpleStringProperty();
    private Boolean hasSubsection;
    private ColumnDef column;
    private HashMap<ValidationRuleSetEnum, List<IValidationRule>> validationRules;

    public DPXMetadataColumnViewModel() {
        this.setHasSubsection(false);
    }

    public ColumnDef getColumn() {
        return this.column;
    }

    public final String getDisplayName() {
        return this.column.getDisplayName();
    }

    public Boolean getHasSubsection() {
        return this.hasSubsection;
    }

    public final Integer getLength() {
        return this.lengthProperty().get();
    }

    public final String getSectionDisplayName() {
        return this.column.getSectionDisplayName();
    }

    public String getSubsectionName() {
        return this.column.getSubsection().getDisplayName();
    }

    public boolean isEditable() {
        return this.column.getEditable();
    }

    public boolean isValid(ValidationRuleSetEnum ruleType, String value) {
        List<IValidationRule> rules = this.validationRules.get((Object)ruleType);
        if (rules != null) {
            for (IValidationRule rule : rules) {
                if (rule.isValid(value)) continue;
                return false;
            }
        }
        return true;
    }

    public final IntegerProperty lengthProperty() {
        return this.length;
    }

    public final StringProperty sectionDisplayNameProperty() {
        return this.sectionDisplayName;
    }

    public void setColumn(ColumnDef column) {
        this.column = column;
    }

    public void setHasSubsection(Boolean hasSubsection) {
        this.hasSubsection = hasSubsection;
    }

    public final void setLength(Integer length) {
        this.lengthProperty().set(length.intValue());
    }

    public void setValidationRules(HashMap<ValidationRuleSetEnum, List<IValidationRule>> validationRules) {
        this.validationRules = validationRules;
    }
}

