/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.database;

import com.portalmedia.embarc.database.NitriteConnection;
import com.portalmedia.embarc.validation.ValidationRuleSetEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dizitart.no2.FindOptions;
import org.dizitart.no2.SortOrder;
import org.dizitart.no2.exceptions.NitriteException;
import org.dizitart.no2.objects.Cursor;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.ObjectRepository;
import org.dizitart.no2.objects.filters.ObjectFilters;

public class DBService<T> {
    ObjectRepository<T> repo;

    public DBService(Class<T> typeParameterClass) {
        this.repo = NitriteConnection.getRepository(typeParameterClass);
    }

    public Boolean add(T value) {
        boolean result = false;
        try {
            this.repo.insert(value, new Object[0]);
            result = true;
        }
        catch (NitriteException ex) {
            System.out.println("DBService.add failed with exception: " + String.valueOf((Object)ex));
            return false;
        }
        catch (Exception ex) {
            System.out.println("DBService.add failed with exception: " + String.valueOf(ex));
            return false;
        }
        return result;
    }

    public void closeDB() {
        System.out.println("DBService.closeDB");
        try {
            if (!this.repo.isDropped()) {
                this.repo.close();
            }
        }
        catch (NitriteException ex) {
            System.out.println("DBService.close failed with exception: " + String.valueOf((Object)ex));
        }
    }

    public Boolean delete(int id) {
        boolean result = false;
        try {
            this.repo.remove(ObjectFilters.eq((String)"id", (Object)id));
            result = true;
        }
        catch (NitriteException ex) {
            System.out.println("DBService.delete failed with exception: " + String.valueOf((Object)ex));
            return false;
        }
        return result;
    }

    public Boolean deleteAll() {
        boolean result = false;
        try {
            this.repo.drop();
            this.repo = NitriteConnection.getRepository(this.repo.getType());
            result = true;
        }
        catch (NitriteException ex) {
            System.out.println("DBService.deleteAll failed with exception: " + String.valueOf((Object)ex));
            return false;
        }
        return result;
    }

    public void dropCollection() {
        try {
            if (!this.repo.isDropped() && !this.repo.isClosed()) {
                this.repo.drop();
            }
        }
        catch (NitriteException ex) {
            System.out.println("DBService.drop failed with exception: " + String.valueOf((Object)ex));
        }
    }

    public T get(int id) {
        Object item = null;
        try {
            item = this.repo.find(ObjectFilters.eq((String)"id", (Object)id)).firstOrDefault();
        }
        catch (NitriteException ex) {
            System.out.println("DBService.get failed with exception: " + String.valueOf((Object)ex));
        }
        return (T)item;
    }

    public List<T> get(int offset, int size, String sortCol, boolean sortAsc) {
        System.out.println(sortCol + ":" + sortAsc);
        SortOrder sortOrder = sortAsc ? SortOrder.Ascending : SortOrder.Descending;
        ArrayList itemList = new ArrayList();
        try {
            FindOptions.sort((String)sortCol, (SortOrder)sortOrder);
            Cursor results = this.repo.find(FindOptions.limit((int)offset, (int)size));
            for (Object item : results) {
                itemList.add(item);
            }
        }
        catch (NitriteException ex) {
            System.out.println("DBService.getAll failed with exception: " + String.valueOf((Object)ex));
        }
        return itemList;
    }

    public List<T> getAll() {
        ArrayList itemList = new ArrayList();
        try {
            Cursor results = this.repo.find();
            for (Object item : results) {
                itemList.add(item);
            }
        }
        catch (NitriteException ex) {
            System.out.println("DBService.getAll failed with exception: " + String.valueOf((Object)ex));
        }
        return itemList;
    }

    public Cursor<T> getAllCursors() {
        try {
            return this.repo.find();
        }
        catch (NitriteException ex) {
            System.out.println("DBService.getAll failed with exception: " + String.valueOf((Object)ex));
            return null;
        }
    }

    public Cursor<T> getEditedCursors() {
        try {
            return this.repo.find(ObjectFilters.eq((String)"edited", (Object)true));
        }
        catch (NitriteException ex) {
            System.out.println("DBService.getAll failed with exception: " + String.valueOf((Object)ex));
            return null;
        }
    }

    public int getErrorCount(Set<ValidationRuleSetEnum> rules) {
        if (rules != null && rules.size() > 0) {
            ArrayList<ObjectFilter> filters = new ArrayList<ObjectFilter>();
            for (ValidationRuleSetEnum r : rules) {
                if (r == ValidationRuleSetEnum.SMPTE_C) {
                    filters.add(ObjectFilters.eq((String)"smptecError", (Object)true));
                    continue;
                }
                if (r == ValidationRuleSetEnum.FADGI_O) {
                    filters.add(ObjectFilters.eq((String)"fadgioError", (Object)true));
                    continue;
                }
                if (r == ValidationRuleSetEnum.FADGI_R) {
                    filters.add(ObjectFilters.eq((String)"fadgirError", (Object)true));
                    continue;
                }
                if (r != ValidationRuleSetEnum.FADGI_SR) continue;
                filters.add(ObjectFilters.eq((String)"fadgisrError", (Object)true));
            }
            ObjectFilter f = (ObjectFilter)filters.get(0);
            for (int i = 1; i < filters.size(); ++i) {
                f = ObjectFilters.or((ObjectFilter[])new ObjectFilter[]{f, (ObjectFilter)filters.get(i)});
            }
            try {
                Cursor results = this.repo.find(f);
                return results.totalCount();
            }
            catch (NitriteException ex) {
                System.out.println("DBService.getAll failed with exception: " + String.valueOf((Object)ex));
            }
        }
        return 0;
    }

    public List<T> getErrors(int offset, int size, Set<ValidationRuleSetEnum> rules, String sortCol, boolean sortAsc) {
        System.out.println(sortCol + ":" + sortAsc);
        SortOrder sortOrder = sortAsc ? SortOrder.Ascending : SortOrder.Descending;
        ArrayList itemList = new ArrayList();
        if (rules.size() > 0) {
            ArrayList<ObjectFilter> filters = new ArrayList<ObjectFilter>();
            for (ValidationRuleSetEnum r : rules) {
                if (r == ValidationRuleSetEnum.SMPTE_C) {
                    filters.add(ObjectFilters.eq((String)"smptecError", (Object)true));
                    continue;
                }
                if (r == ValidationRuleSetEnum.FADGI_O) {
                    filters.add(ObjectFilters.eq((String)"fadgioError", (Object)true));
                    continue;
                }
                if (r == ValidationRuleSetEnum.FADGI_R) {
                    filters.add(ObjectFilters.eq((String)"fadgirError", (Object)true));
                    continue;
                }
                if (r != ValidationRuleSetEnum.FADGI_SR) continue;
                filters.add(ObjectFilters.eq((String)"fadgisrError", (Object)true));
            }
            ObjectFilter f = (ObjectFilter)filters.get(0);
            for (int i = 1; i < filters.size(); ++i) {
                f = ObjectFilters.or((ObjectFilter[])new ObjectFilter[]{f, (ObjectFilter)filters.get(i)});
            }
            try {
                FindOptions.sort((String)sortCol, (SortOrder)sortOrder);
                Cursor results = this.repo.find(f, FindOptions.limit((int)offset, (int)size));
                for (Object item : results) {
                    itemList.add(item);
                }
            }
            catch (NitriteException ex) {
                System.out.println("DBService.getAll failed with exception: " + String.valueOf((Object)ex));
            }
        }
        return itemList;
    }

    public long getSize() {
        return this.repo.size();
    }

    public void update(T file) {
        try {
            this.repo.update(file);
        }
        catch (NitriteException ex) {
            System.out.println("DBService.update failed with exception: " + String.valueOf((Object)ex));
        }
    }
}

