/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.parser.dpx;

import com.portalmedia.embarc.gui.model.DPXFileInformationViewModel;
import com.portalmedia.embarc.parser.dpx.DPXColumn;
import com.portalmedia.embarc.parser.dpx.DPXSequenceError;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;

public class DPXBatchProcessor {
    public static List<DPXSequenceError> getSequenceErrorList(ObservableList<DPXFileInformationViewModel> dpxFileList, boolean allErrors) {
        LinkedList<DPXSequenceError> result = new LinkedList<DPXSequenceError>();
        boolean firstLap = true;
        boolean fileNameSeqValid = true;
        boolean imageFileNameSeqValid = true;
        boolean sourceImageFileNameSeqValid = true;
        boolean framePositionInSeqValid = true;
        String prevFileNameSeq = "";
        String prevImageFileNameSeq = "";
        String prevSourceImageFileNameSeq = "";
        String prevFramePosition = "";
        for (DPXFileInformationViewModel fileInfo : dpxFileList) {
            String dpxName = fileInfo.getProp("name");
            if (fileNameSeqValid || allErrors) {
                String currFileNameSeq = DPXBatchProcessor.getSequenceNumFromFileName(dpxName);
                if (!DPXBatchProcessor.isSequential(prevFileNameSeq, currFileNameSeq, firstLap)) {
                    fileNameSeqValid = false;
                    result.add(new DPXSequenceError(dpxName, "Filename", "Break in Sequence", currFileNameSeq + " is not in sequence with " + prevFileNameSeq));
                }
                if (!DPXBatchProcessor.isUnique(prevFileNameSeq, currFileNameSeq, firstLap)) {
                    fileNameSeqValid = false;
                    result.add(new DPXSequenceError(dpxName, "Filename", "Duplicates in Sequence", currFileNameSeq + " is duplicated"));
                }
                prevFileNameSeq = currFileNameSeq;
            }
            String imageFileName = fileInfo.getProp(DPXColumn.IMAGE_FILE_NAME);
            if (imageFileNameSeqValid || allErrors) {
                String currImageFileNameSeq = DPXBatchProcessor.getSequenceNumFromFileName(imageFileName);
                if (!DPXBatchProcessor.isSequential(prevImageFileNameSeq, currImageFileNameSeq, firstLap)) {
                    imageFileNameSeqValid = false;
                    result.add(new DPXSequenceError(dpxName, DPXColumn.IMAGE_FILE_NAME.getDisplayName(), "Break in Sequence", currImageFileNameSeq + " is not in sequence with " + prevImageFileNameSeq));
                }
                if (!DPXBatchProcessor.isUnique(prevImageFileNameSeq, currImageFileNameSeq, firstLap)) {
                    imageFileNameSeqValid = false;
                    result.add(new DPXSequenceError(dpxName, DPXColumn.IMAGE_FILE_NAME.getDisplayName(), "Duplicates in Sequence", currImageFileNameSeq + " is duplicated"));
                }
                prevImageFileNameSeq = currImageFileNameSeq;
            }
            String sourceImageFileName = fileInfo.getProp(DPXColumn.SOURCE_IMAGE_FILENAME);
            if (sourceImageFileNameSeqValid || allErrors) {
                String currSourceImageFileNameSeq = DPXBatchProcessor.getSequenceNumFromFileName(sourceImageFileName);
                if (!DPXBatchProcessor.isSequential(prevSourceImageFileNameSeq, currSourceImageFileNameSeq, firstLap)) {
                    sourceImageFileNameSeqValid = false;
                    result.add(new DPXSequenceError(dpxName, DPXColumn.SOURCE_IMAGE_FILENAME.getDisplayName(), "Break in Sequence", currSourceImageFileNameSeq + " is not in sequence with " + prevSourceImageFileNameSeq));
                }
                if (!DPXBatchProcessor.isUnique(prevSourceImageFileNameSeq, currSourceImageFileNameSeq, firstLap)) {
                    sourceImageFileNameSeqValid = false;
                    result.add(new DPXSequenceError(dpxName, DPXColumn.SOURCE_IMAGE_FILENAME.getDisplayName(), "Duplicates in Sequence", currSourceImageFileNameSeq + " is duplicated"));
                }
                prevSourceImageFileNameSeq = currSourceImageFileNameSeq;
            }
            String framePositionInSequence = fileInfo.getProp(DPXColumn.FRAME_POSITION_IN_SEQUENCE);
            if (framePositionInSeqValid || allErrors) {
                String currFramePosition = framePositionInSequence;
                if (!DPXBatchProcessor.isSequential(prevFramePosition, currFramePosition, firstLap)) {
                    framePositionInSeqValid = false;
                    result.add(new DPXSequenceError(dpxName, DPXColumn.FRAME_POSITION_IN_SEQUENCE.getDisplayName(), "Break in Sequence", currFramePosition + " is not in sequence with " + prevFramePosition));
                }
                if (!DPXBatchProcessor.isUnique(prevFramePosition, currFramePosition, firstLap)) {
                    framePositionInSeqValid = false;
                    result.add(new DPXSequenceError(dpxName, DPXColumn.FRAME_POSITION_IN_SEQUENCE.getDisplayName(), "Duplicates in Sequence", currFramePosition + " is duplicated"));
                }
                prevFramePosition = currFramePosition;
            }
            if (!firstLap) continue;
            firstLap = false;
        }
        return result;
    }

    private static String getSequenceNumFromFileName(String fileName) {
        Character c;
        String f = fileName.split(".dpx")[0];
        Object seq = "";
        for (int i = f.length() - 1; i >= 0 && Character.isDigit((c = Character.valueOf(f.charAt(i))).charValue()); --i) {
            seq = (String)seq + c;
        }
        return new StringBuilder((String)seq).reverse().toString();
    }

    private static boolean isSequential(String a, String b, boolean firstLap) {
        if (firstLap) {
            return true;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        return Integer.parseInt(a) + 1 == Integer.parseInt(b);
    }

    private static boolean isUnique(String a, String b, boolean firstLap) {
        if (firstLap) {
            return true;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return true;
        }
        return Integer.parseInt(a) != Integer.parseInt(b);
    }
}

