/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.mxf;

import com.portalmedia.embarc.gui.helper.MXFFileList;
import com.portalmedia.embarc.gui.model.MXFSelectedFilesSummary;
import com.portalmedia.embarc.gui.mxf.ControllerMediatorMXF;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.AccessibleRole;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;

public class SessionSummaryController
implements Initializable {
    @FXML
    private Label totalFilesLabel;
    @FXML
    private Label filesSelectedLabel;
    @FXML
    private Label selectAllFilesLabel;
    @FXML
    private Label deselectAllFilesLabel;
    @FXML
    private Label removeSelectedFilesLabel;

    public void initialize(URL location, ResourceBundle resources) {
        ControllerMediatorMXF.getInstance().registerSessionSummaryController(this);
        this.removeSelectedFilesLabel.setVisible(false);
        this.totalFilesLabel.setAccessibleText("Total number of files imported.");
        this.totalFilesLabel.setFocusTraversable(true);
        this.filesSelectedLabel.setAccessibleText("Total number of files currently selected.");
        this.filesSelectedLabel.setFocusTraversable(true);
        this.selectAllFilesLabel.setAccessibleText("Select all files.");
        this.selectAllFilesLabel.setAccessibleRole(AccessibleRole.BUTTON);
        this.selectAllFilesLabel.setFocusTraversable(true);
        this.selectAllFilesLabel.getStyleClass().add((Object)"hover-hand");
        this.selectAllFilesLabel.setOnMouseClicked(event -> ControllerMediatorMXF.getInstance().selectAllFiles());
        this.selectAllFilesLabel.setOnKeyPressed(event -> {
            if (event.getCode() != KeyCode.SPACE) {
                return;
            }
            ControllerMediatorMXF.getInstance().selectAllFiles();
        });
        this.deselectAllFilesLabel.setAccessibleText("Deselect all files.");
        this.deselectAllFilesLabel.setAccessibleRole(AccessibleRole.BUTTON);
        this.deselectAllFilesLabel.setFocusTraversable(true);
        this.deselectAllFilesLabel.getStyleClass().add((Object)"hover-hand");
        this.deselectAllFilesLabel.setOnMouseClicked(event -> ControllerMediatorMXF.getInstance().deselectAllFiles());
        this.deselectAllFilesLabel.setOnKeyPressed(event -> {
            if (event.getCode() != KeyCode.SPACE) {
                return;
            }
            ControllerMediatorMXF.getInstance().deselectAllFiles();
        });
        this.removeSelectedFilesLabel.setAccessibleText("Remove all selected files.");
        this.removeSelectedFilesLabel.setAccessibleRole(AccessibleRole.BUTTON);
        this.removeSelectedFilesLabel.setFocusTraversable(true);
        this.removeSelectedFilesLabel.getStyleClass().add((Object)"hover-hand");
        this.removeSelectedFilesLabel.setOnMouseClicked(event -> ControllerMediatorMXF.getInstance().deleteSelectedFiles());
        this.removeSelectedFilesLabel.setOnKeyPressed(event -> {
            if (event.getCode() != KeyCode.SPACE) {
                return;
            }
            ControllerMediatorMXF.getInstance().deleteSelectedFiles();
        });
        this.setFiles();
    }

    public <T> void setFiles() {
        MXFFileList.getInstance();
        long size = MXFFileList.getList().size();
        if (size >= 1L) {
            String text = Long.toString(size) + " file" + (size == 1L ? " " : "s ") + "imported";
            this.totalFilesLabel.setText(text);
            this.totalFilesLabel.setAccessibleText(text);
            this.selectAllFilesLabel.setVisible(true);
            this.deselectAllFilesLabel.setVisible(true);
        } else {
            this.totalFilesLabel.setText(Long.toString(size) + " files imported");
            this.totalFilesLabel.setAccessibleText(Long.toString(size) + " files imported");
            this.selectAllFilesLabel.setVisible(false);
            this.deselectAllFilesLabel.setVisible(false);
        }
    }

    public <T> void setSelectedFileList(MXFSelectedFilesSummary list) {
        long size = list.getFileCount();
        if (size >= 1L) {
            String text = Long.toString(size) + " file" + (size == 1L ? " " : "s ") + "selected";
            this.filesSelectedLabel.setText(text);
            this.filesSelectedLabel.setAccessibleText(text);
            this.deselectAllFilesLabel.setVisible(true);
            this.removeSelectedFilesLabel.setVisible(true);
        } else {
            this.filesSelectedLabel.setText(Long.toString(size) + " files selected");
            this.filesSelectedLabel.setAccessibleText(Long.toString(size) + " files selected");
            this.selectAllFilesLabel.setVisible(true);
            this.deselectAllFilesLabel.setVisible(false);
            this.removeSelectedFilesLabel.setVisible(false);
        }
    }
}

