/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.dpx.ControllerMediatorDPX;
import com.portalmedia.embarc.gui.model.SelectedFilesSummary;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import org.apache.log4j.Logger;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;

public class GeneralForm
extends AnchorPane {
    @FXML
    private Label sectionLabel;
    @FXML
    private Label selectedFilesLabel;
    @FXML
    private AnchorPane generalInfo;
    String filePathString;
    final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());

    public GeneralForm() {
        FXMLLoader fxmlLoader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("GeneralForm.fxml"));
        fxmlLoader.setController((Object)this);
        fxmlLoader.setRoot((Object)this);
        try {
            fxmlLoader.load();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        SelectedFilesSummary summary = ControllerMediatorDPX.getInstance().getSelectedFilesSummary();
        this.setNumberOfSelectedFiles(summary.getFileCount());
        HBox gridBox = new HBox();
        gridBox.setPadding(new Insets(10.0, 0.0, 0.0, 10.0));
        GridPane grid = new GridPane();
        gridBox.getChildren().add((Object)grid);
        grid.setAlignment(Pos.CENTER);
        grid.setHgap(15.0);
        grid.setVgap(15.0);
        this.generalInfo.getChildren().add((Object)gridBox);
        Label fileNameText = new Label(summary.getFileName());
        fileNameText.setFocusTraversable(false);
        grid.add((Node)fileNameText, 1, 0);
        Label fileNameLabel = new Label("Filename ");
        fileNameLabel.setStyle("-fx-font-size: 12.0");
        fileNameLabel.setAccessibleText("File name is " + fileNameText.getText());
        fileNameLabel.setFocusTraversable(true);
        grid.add((Node)fileNameLabel, 0, 0);
        this.filePathString = summary.getFilePath();
        Label filePathText = new Label(this.filePathString);
        filePathText.setFocusTraversable(false);
        grid.add((Node)filePathText, 1, 1);
        Label filePath = new Label("File Path ");
        filePath.setStyle("-fx-font-size: 12.0");
        filePath.setAccessibleText("File path is " + this.filePathString);
        filePath.setFocusTraversable(true);
        grid.add((Node)filePath, 0, 1);
        if (this.filePathString != null && !this.filePathString.equals("{multiple values}")) {
            Label viewImage = new Label("View Image ");
            viewImage.setStyle("-fx-font-size: 12.0");
            viewImage.setAccessibleText("View image");
            viewImage.setFocusTraversable(false);
            grid.add((Node)viewImage, 0, 2);
            FontIcon viewImageIcon = new FontIcon();
            viewImageIcon.setIconCode((Ikon)FontAwesomeSolid.EXTERNAL_LINK_ALT);
            viewImageIcon.setAccessibleText("Select to open image viewer");
            Button b = new Button();
            b.setStyle("-fx-text-fill: black; -fx-base: #E5E5E5;");
            b.setGraphic((Node)viewImageIcon);
            b.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    GeneralForm.this.showDiaglog();
                }
            });
            grid.add((Node)b, 1, 2);
        }
    }

    public void setTitle(String title) {
        this.sectionLabel.setText(title);
        this.sectionLabel.setAccessibleText(title);
        this.sectionLabel.setFocusTraversable(true);
    }

    public void showDiaglog() {
        block21: {
            try {
                String os = System.getProperty("os.name");
                if (os != null && os.startsWith("Mac")) {
                    Set<PosixFilePermission> perms;
                    Path tempPath = Files.createTempFile("ffplay", "", new FileAttribute[0]);
                    try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/ffplay_mac");){
                        Files.copy(in, tempPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    PosixFileAttributeView view = Files.getFileAttributeView(tempPath, PosixFileAttributeView.class, new LinkOption[0]);
                    if (view != null && (perms = view.readAttributes().permissions()).add(PosixFilePermission.OWNER_EXECUTE)) {
                        view.setPermissions(perms);
                    }
                    List<String> params = Arrays.asList(tempPath.toString(), this.filePathString, "-x", "500", "-y", "500");
                    ProcessBuilder b = new ProcessBuilder(params);
                    this.logger.error((Object)"Starting show image mac");
                    try {
                        Process p = b.start();
                        p.getOutputStream().close();
                    }
                    catch (IOException e) {
                        this.logger.error((Object)e.getStackTrace());
                    }
                    break block21;
                }
                Path tempPath = Files.createTempFile("ffplay", "exe", new FileAttribute[0]);
                try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/resources/ffplay_win.exe");){
                    Files.copy(in, tempPath, StandardCopyOption.REPLACE_EXISTING);
                }
                List<String> params = Arrays.asList(tempPath.toString(), this.filePathString, "-x", "500", "-y", "500");
                ProcessBuilder b = new ProcessBuilder(params);
                try {
                    Process p = b.start();
                    p.getOutputStream().close();
                }
                catch (IOException e) {
                    System.out.println("Error displaying DPX sequence");
                }
            }
            catch (IOException e1) {
                System.out.println("Error displaying DPX sequence final");
            }
        }
    }

    private void setNumberOfSelectedFiles(int num) {
        this.selectedFilesLabel.setText(Integer.toString(num) + " file" + (num > 1 ? "s " : " ") + "selected");
        this.selectedFilesLabel.setFocusTraversable(true);
    }
}

