/*
 * Decompiled with CFR 0.152.
 */
package com.portalmedia.embarc.gui.dpx;

import com.portalmedia.embarc.gui.Main;
import com.portalmedia.embarc.gui.dpx.WriteFilesDialog;
import com.portalmedia.embarc.gui.helper.CleanInputPathHelper;
import com.portalmedia.embarc.system.UserPreferencesService;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.fontawesome5.FontAwesomeSolid;
import org.kordamp.ikonli.javafx.FontIcon;

public class WriteFilesModalController {
    public static WriteFilesModalController getInstance() {
        return ControllerHolder.INSTANCE;
    }

    private WriteFilesModalController() {
    }

    public void showWriteFilesDialog() {
        UserPreferencesService userPreferences = new UserPreferencesService();
        ChoiceDialog dialog = new ChoiceDialog();
        FontIcon icon = new FontIcon((Ikon)FontAwesomeSolid.DOWNLOAD);
        icon.getStyleClass().add((Object)"write-files-icon");
        icon.setIconSize(20);
        dialog.setGraphic((Node)icon);
        dialog.getDialogPane().setPrefSize(525.0, 320.0);
        dialog.setTitle("Write Files");
        dialog.setHeaderText("Write Files to Disk");
        dialog.initOwner((Window)Main.getPrimaryStage());
        ButtonType loginButtonType = new ButtonType("Close", ButtonBar.ButtonData.CANCEL_CLOSE);
        ButtonType writeFilesButtonType = new ButtonType("Write Files", ButtonBar.ButtonData.OK_DONE);
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{loginButtonType, writeFilesButtonType});
        dialog.setResultConverter(type -> {
            ButtonBar.ButtonData data = type == null ? null : type.getButtonData();
            return data;
        });
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(20.0, 10.0, 10.0, 10.0));
        CheckBox writeEditedCb = new CheckBox("Write only edited files");
        writeEditedCb.setSelected(userPreferences.getWriteOnlyEditedFiles());
        CheckBox reportCb = new CheckBox("Create an image data checksum report");
        reportCb.setSelected(userPreferences.getSaveImageChecksums());
        CheckBox saveAsCb = new CheckBox("Save Files to a separate directory");
        saveAsCb.setSelected(userPreferences.getSaveToSeparateDirectory());
        String reportDir = userPreferences.getImageChecksumValidationReportPath();
        String cleanHomePath = CleanInputPathHelper.cleanString(System.getProperty("user.home"));
        if (reportDir == null || reportDir.isEmpty()) {
            reportDir = cleanHomePath;
        }
        final Label reportPath = new Label(reportDir + "/ImageDataChecksumComparisonReport_" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date()) + ".csv");
        final Button selectReportPathButton = new Button();
        selectReportPathButton.setText("Save Checksums To...");
        selectReportPathButton.setPrefWidth(250.0);
        selectReportPathButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                FileChooser fileChooser = new FileChooser();
                String cleanHomePath = CleanInputPathHelper.cleanString(System.getProperty("user.home"));
                fileChooser.setInitialDirectory(new File(cleanHomePath));
                fileChooser.setInitialFileName("ChecksumReport_" + new SimpleDateFormat("yyyyMMddHHmm").format(new Date()) + ".csv");
                fileChooser.setTitle("Select a file");
                File file = fileChooser.showSaveDialog(null);
                if (file != null) {
                    reportPath.setText(file.getAbsolutePath());
                }
            }
        });
        String outputDir = userPreferences.getSaveToPath();
        if (outputDir == null || outputDir.isEmpty()) {
            outputDir = cleanHomePath;
        }
        final Label writeFilesPath = new Label(outputDir);
        final Button chooseOutputDirButton = new Button();
        chooseOutputDirButton.setText("Save Files To...");
        chooseOutputDirButton.setPrefWidth(250.0);
        chooseOutputDirButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                DirectoryChooser dirChooser = new DirectoryChooser();
                String cleanHomePath = CleanInputPathHelper.cleanString(System.getProperty("user.home"));
                dirChooser.setInitialDirectory(new File(cleanHomePath));
                dirChooser.setTitle("Select a directory");
                File dir = dirChooser.showDialog(null);
                if (dir != null) {
                    writeFilesPath.setText(dir.getAbsolutePath());
                }
            }
        });
        selectReportPathButton.setDisable(!reportCb.isSelected());
        chooseOutputDirButton.setDisable(!saveAsCb.isSelected());
        reportPath.setDisable(true);
        writeFilesPath.setDisable(true);
        reportCb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                selectReportPathButton.setDisable(newValue == false);
                reportPath.setDisable(newValue == false);
            }
        });
        saveAsCb.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                chooseOutputDirButton.setDisable(newValue == false);
                writeFilesPath.setDisable(newValue == false);
            }
        });
        grid.add((Node)writeEditedCb, 0, 0, 2, 1);
        grid.add((Node)reportCb, 0, 1, 2, 1);
        grid.add((Node)selectReportPathButton, 0, 2);
        grid.add((Node)reportPath, 1, 2);
        grid.add((Node)saveAsCb, 0, 3, 2, 1);
        grid.add((Node)chooseOutputDirButton, 0, 4);
        grid.add((Node)writeFilesPath, 1, 4);
        dialog.getDialogPane().setContent((Node)grid);
        Optional result = dialog.showAndWait();
        if (result.isPresent() && result.get() == ButtonBar.ButtonData.OK_DONE) {
            userPreferences.setSaveImageChecksums(reportCb.isSelected());
            userPreferences.setWriteOnlyEditedFiles(writeEditedCb.isSelected());
            userPreferences.setSaveToSeparateDirectory(saveAsCb.isSelected());
            if (reportCb.isSelected()) {
                File p = new File(reportPath.getText());
                String newReportDir = p.getParent();
                userPreferences.setImageChecksumValidationReportPath(newReportDir);
            }
            if (saveAsCb.isSelected()) {
                String newOutputDir = writeFilesPath.getText();
                userPreferences.setSaveToPath(newOutputDir);
            }
            String tmpWriteFilesPath = saveAsCb.isSelected() ? writeFilesPath.getText() : "";
            String tmpReportPath = reportCb.isSelected() ? reportPath.getText() : "";
            WriteFilesDialog d = new WriteFilesDialog(tmpWriteFilesPath, tmpReportPath, writeEditedCb.isSelected());
            d.initOwner((Window)Main.getPrimaryStage());
        }
    }

    private static class ControllerHolder {
        private static final WriteFilesModalController INSTANCE = new WriteFilesModalController();

        private ControllerHolder() {
        }
    }
}

